using System;
using System.Collections.Generic;
using System.Text;
using SIPPBXv3;

namespace CSGateway
{
    public class Class1 : ISIPPBXPluginClient
    {
        private string m_strName;
        private string m_strType;

        private ISIPPBXPluginHost m_Host;

        public Class1()
        {
            m_strName = "A Simple Gateway Plugin";
            m_strType = "Gateway"; //"CallOffered", "CallRinging", or "CallDialing", "CallConnected", "CallIdle", or "Gateway"
        }

        public string Name
        {
            get { return m_strName; }
            set { m_strName = value; }
        }

        public string Type
        {
            get { return m_strType; }
            set { m_strType = value; }
        }

        public ISIPPBXPluginHost Host
        {
            get { return m_Host; }
            set
            {
                m_Host = value;
            }
        }

        public void Start()
        {
            //get the caller and callee number
            string sCaller = Host.PBX_Channel.sCaller;
            string sCallee = Host.PBX_Channel.sCallee;
            //string sDestAddr = Host.PBX_Channel.sDestAddr;
            //string sViaAddr = Host.PBX_Channel.sViaAddr;
            string sFromIP = Host.PBX_Channel.sFromIP;
            ushort nFromPort = Host.PBX_Channel.nFromPort;

            //channel index
            int ch = Host.PBX_Channel.index;

            Host.PBX_Channel.byPassDialPlan = true; //no longer try to match a dialplan for this call
            
            //call time
            //Host.Channel.call_start_time;
            //Host.Channel.call_end_time;

            //write CDR here


            Host.WriteLog("Gateway plugin Channel " + ch.ToString() + " got a new call from IP " + sFromIP + ":" + nFromPort.ToString() + " " + sCaller + " => " + sCallee);

            string newSIPServerIP = "192.168.1.102";
            int maxSec = 0;
            string recordingFileName = "c:\\temp\\GatewayRecording-" + DateTime.Now.ToString("yyyyMMddHHmmss") + "-" + (new Random()).Next(1000, 9999).ToString() + ".wav";

            Host.WriteLog("Gateway plugin forwarding call to " + newSIPServerIP);
            Host.ToSIPServer(newSIPServerIP, 5060, sCaller, sCallee, recordingFileName, ref maxSec);
            
        }

        public void Done()
        {
            Host.WriteLog("Gateway plugin done");
        }

        #region ICloneable Members

        public Class1 Clone()
        {
            Class1 client = new Class1();
            client.Name = Name;
            client.Type = Type;
            return client;
        }

        object ICloneable.Clone()
        {
            return Clone();
        }

        #endregion

    }
}
