using System;
using System.Collections.Generic;
using System.Text;
using SIPPBXv3;
using System.Windows.Forms;

namespace MyPBXPlugin1
{
    public class MySIPPBXPluginClient : ISIPPBXPluginClient
    {
        public const string RESULT_DISCONNECTED = "Disconnected";
        public const string RESULT_ERROR = "Error";

        private string m_strName;
        private string m_strType;

        private ISIPPBXPluginHost m_Host;

        public MySIPPBXPluginClient()
        {
            m_strName = "CSharpSample";
            m_strType = "IVRMenu";
        }
        
        public string Name
        {
            get{return m_strName;}
            set{m_strName=value;}
        }

        public string Type
        {
            get{return m_strType;}
            set{m_strType=value;}
        }
 
        public ISIPPBXPluginHost Host
        {
            get{return m_Host;}
            set
            {
                m_Host=value;
            }
        }

        public void Start()
        {
            //get the caller and callee number
            string caller_addr = Host.Channel.caller_num;
            string callee_addr = Host.Channel.callee_num;

            string caller_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_addr);
            string callee_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, callee_addr);

            //if it is a job of auto dialer task for human/answer machine detection,
            //use the following code to access detection result:
            /*
            if (Host.PBX_Channel.call_job != null)
            {
                switch (Host.PBX_Channel.call_job.DetectResult)
                {
                    case 0: // = Answering Machine
                        break;
                    case 1: // Human voice
                        break;
                    case 2: // = Fax
                        break;
                    case -1: // silence (no voice at all)
                        break;
                    case -2: // detected voice, but unknown
                        break;
                    case -3: // = unknown
                        break;
                }
            }*/


            //There are twenty shared objects you can access and save object non-related to channel
            //Index from 0-19. for example, the last one is GetUserObj(19)
            object obj = Host.GetUserObj(0);

            //Index from 0-19. for example, the last one is SetUserObj(19, object)
            Host.SetUserObj(0, caller_addr);

            //There are also twenty shared objects associated channel
            //you use channel index and object index to access them
            //Get this channel's first object
            obj = Host.GetChanUserObj(Host.PBX_Channel.index, 0);

            //Set this channel's first object
            Host.SetChanUserObj(Host.PBX_Channel.index, 0, caller_num);

            //Get channel 2's first object
            Host.GetChanUserObj(2, 0);

            //Set channel 2's first object
            Host.SetChanUserObj(2, 0, new int());


            string audio_fn1 = Application.StartupPath + "\\audio\\Please-enter-extension-number.wav";
            Host.WriteLog("Start to excute! Step 1 -> DisplayMenu Demo(please enter 4 digits extension number)");
            string sDTMF = Host.DisplayMenu(audio_fn1, 4, "#", 15000, true);

            Host.WriteLog("Display Menu Returned " + sDTMF);

            if (sDTMF == RESULT_DISCONNECTED || sDTMF == RESULT_ERROR)
            {
                //call is disconnected or got error
                return;
            }

            //you can save your result into DB, or according to user's selection,
            //do something
            string audio_fn2 = Application.StartupPath + "\\audio\\Please-leave-your-message-after-beep.wav";
            Host.WriteLog("Step 2 -> PlayAudio Demo - WavFile:" + audio_fn2);

            sDTMF = Host.PlayAudio(audio_fn2, 0, "", 0);

            Host.WriteLog("PlayAudio returned " + sDTMF);

            if (sDTMF == RESULT_DISCONNECTED || sDTMF == RESULT_ERROR)
            {
                //call is disconnected or got error
                return;
            }

            Host.WriteLog("Step 3: -> RecordAudio Demo(Record to c:\\recording.wav, press # key to stop recording)");

            sDTMF = Host.RecordAudio("c:\\recording-" + Host.Channel.ch_index.ToString() + ".wav", 0, "#", 0);

            Host.WriteLog("RecordAudio returned " + sDTMF);

            if (sDTMF == RESULT_DISCONNECTED || sDTMF == RESULT_ERROR)
            {
                //call is disconnected or got error
                return;
            }

            Host.WriteLog("Step 4: -> DetectDTMF Demo(Detecting DTMFs, please enter two digits)");

            sDTMF = Host.DetectDTMF(2, "#", 10000);

            Host.WriteLog("DetectDTMF returned " + sDTMF);

            if (sDTMF == RESULT_DISCONNECTED || sDTMF == RESULT_ERROR)
            {
                //call is disconnected or got error
                return;
            }

            Host.WriteLog("Reached End!");
 
        }

        public void Done()
        {
            Host.WriteLog("Done! Disconnected the call.");

            //only if you want the call ends after running the this plugin
            Host.HangUp();

            //otherwise you can use one of Host's To function to route the call
            //Host.ToExtension("110");
            //Host.ToIVRMenu("Another IVR Menu Name set already in PBX");
            //Host.ToMonitorGroup("Monitor Group Name");
            //Host.ToHuntGroup("ACD group name", false);
            //Host.ToRingGroup("Ring Group Name");
            //Host.ToVoiceMailBox("Extension Name");
            //Host.ToConferenceRoom("conference room name");
            //Host.ToPlugin("Another plugin's name");

            //to another outside number
            //Host.ToNumber("<sip:123@192.168.1.100>", null);
            //Host.ToNumber("<sip:6781992@callcentric.com>", null);
            //or
            //SIPAccount acct1;
            //acct1.DisplayName = "any";
            //acct1.UserName = "1234";
            //acct1.DomainServer = "sip.callwithus.com";
            //acct1.ProxyServer = "sip.callwithus.com";
            //acct1.AuthName = "1234";
            //acct1.Password = "xxxxx";
            //Host.ToNumber("655112", acct1);

            //Host.Channel.pEnv.Send_Transfer(Host.Channel.ch_index, "<sip:0116@192.168.1.177>");

        }

        #region ICloneable Members

        public MySIPPBXPluginClient Clone()
        {
            MySIPPBXPluginClient client = new MySIPPBXPluginClient();
            client.Name = Name;
            client.Type = Type;
            return client;
        }

        object ICloneable.Clone()
        {
            return Clone();
        }

        #endregion

    }
}
