using System;
using System.Collections.Generic;
using System.Text;
using SIPPBXv3;

namespace MyPBXPluginRoutine
{
    public class MySIPPBXPluginClient : ISIPPBXPluginClient
    {
        private string m_strName;
        private string m_strType;

        private ISIPPBXPluginHost m_Host;

        public MySIPPBXPluginClient()
        {
            m_strName = "Routine Plugin Demo";
            m_strType = "Routine";
        }

        public string Name
        {
            get { return m_strName; }
            set { m_strName = value; }
        }

        public string Type
        {
            get { return m_strType; }
            set { m_strType = value; }
        }

        public ISIPPBXPluginHost Host
        {
            get { return m_Host; }
            set
            {
                m_Host = value;
            }
        }

        public void Start()
        {
            //running every second
            //Host.WriteLog("Run every second!");

            /*

            //you can use pbx to change the data of PBX
            SIPPBXBase pbx = Host.PBXBase;

            //go through all extensions to find out 101
            SIPPBXExten extn = null;

            for (int i = 0; i < pbx.sip_exten.Count; i++)
            {
                if (pbx.sip_exten[i].UserName == "101")
                {
                    extn = pbx.sip_exten[i];
                    break;
                }
            }

            //auto set ACD agent login at extension 101
            if (extn != null)
            {
                for (int i = 0; i < pbx.sip_agents.Count; i++)
                {
                    pbx.sip_agents[i].Login(extn);
                }
            }
             */

            //or use startPBX and stopPBX function to restart the PBX when condition meets
            //if(Need Restart)
            //{Host.StopPBX();
            //Host.StartPBX();}
        }

        public void Done()
        {
        }

        #region ICloneable Members

        public MySIPPBXPluginClient Clone()
        {
            MySIPPBXPluginClient client = new MySIPPBXPluginClient();
            client.Name = Name;
            client.Type = Type;
            return client;
        }

        object ICloneable.Clone()
        {
            return Clone();
        }

        #endregion
    }
}
