using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ACDAgentEdit : Form
    {
        public SIPPBXAgent agent;

        public ACDAgentEdit()
        {
            InitializeComponent();
            agent = null;
        }

        private void ACDAgentEdit_Load(object sender, EventArgs e)
        {
            tbName.Text = agent.Name;
            tbCode.Text = agent.Code;
            if (agent.Code != "") //editing
                tbCode.Enabled = false;
            tbPassword.Text = agent.Password;
            cbCallRecord.Checked = agent.RecordCall;
            tbSkillLevel.Text = agent.SkillLevel.ToString();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            agent.Name = tbName.Text;
            agent.Code = tbCode.Text;
            agent.Password = tbPassword.Text;
            agent.RecordCall = cbCallRecord.Checked;
            try
            {
                agent.SkillLevel = Convert.ToInt16(tbSkillLevel.Text);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                return;
            }

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}