using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ACDHuntGroupAdd : Form
    {
        public SIPPBXACDHuntGroup hg;
        public SIPPBX pbx;
        public ACDHuntGroupList parent_dlg;
        public VoiceMailBox vmb;
        public int cur_agent_type;

        public ACDHuntGroupAdd()
        {
            InitializeComponent();
            hg = null;
            vmb = null;
            cur_agent_type = 0;
        }

        private void ACDHuntGroupAdd_Load(object sender, EventArgs e)
        {
            cbType.Items.Add("Linear");
            cbType.Items.Add("Circular");
            cbType.Items.Add("Most Idle");
            cbType.Items.Add("Most Skill");

            if (hg != null)
            {
                this.Text = "Edit Hunt Group";

                tbName.Text = hg.hgName;
                tbName.Enabled = false;

                cbType.SelectedIndex = hg.hgType;

                for(int i=0; i<hg.agents.Count; i++)
                    lbAgents.Items.Add(hg.agents[i]);

                cur_agent_type = hg.agentType;
                if (hg.agentType == 0) //extensions
                {
                    rbExtenType.Checked = true;
                    rbAgentType.Checked = false;
                    rbACDType.Checked = false;
                    for (int i = 0; i < pbx.sip_exten.Count; i++)
                        lbExtens.Items.Add(pbx.sip_exten[i].UserName);
                }
                else if (hg.agentType == 1)//agents login at extension
                {
                    rbExtenType.Checked = false;
                    rbAgentType.Checked = true;
                    rbACDType.Checked = false;
                    for (int i = 0; i < pbx.sip_agents.Count; i++)
                        lbExtens.Items.Add(pbx.sip_agents[i].Code);
                }
                else if (hg.agentType == 2) //agents login at ACD
                {
                    rbExtenType.Checked = false;
                    rbAgentType.Checked = false;
                    rbACDType.Checked = true;
                    for (int i = 0; i < pbx.sip_agents.Count; i++)
                        lbExtens.Items.Add(pbx.sip_agents[i].Code);
                }

                if (hg.playMOH)
                {
                    cbPlayMOH.Checked = true;
                    tbMOHDir.Enabled = true;
                    btnBrowse.Enabled = true;
                    if (hg.mohDir.Length > 0)
                        tbMOHDir.Text = hg.mohDir;
                    else
                        tbMOHDir.Text = pbx.moh_dir;
                }
                else
                {
                    cbPlayMOH.Checked = false;
                    tbMOHDir.Enabled = false;
                    btnBrowse.Enabled = false;
                }

                vmb = hg.vmb;
                if (vmb != null)
                {
                    cbEnableVMB.Checked = true;
                    tbVMBDTMF.Enabled = true;
                    tbVMBDTMF.Text = hg.vmbDTMF;
                    btnVMBSettings.Enabled = true;
                }
                else
                {
                    cbEnableVMB.Checked = false;
                    tbVMBDTMF.Enabled = false;
                    btnVMBSettings.Enabled = false;
                }

                tbDPDTMF.Text = hg.dpDTMF;

                tbWaitTimeout.Text = hg.waitTimeout.ToString();

                if (hg.waitTimeoutTo.Length > 0)
                {
                    rbTimeoutToVMB.Checked = false;
                    rbTimeoutToDP.Checked = true;
                }
                else
                {
                    rbTimeoutToVMB.Checked = true;
                    rbTimeoutToDP.Checked = false;
                }

                SIPPBXWinUtil.AddInboundDialplanIntoComboBox(pbx, cbToDialplan, hg.dpName);

                tbMaxNumCalls.Text = hg.maxNumOfCalls.ToString();

                if (hg.callForwardingType == 0) //ACD group
                {
                    rbCFACD.Checked = true;
                    rbCFDP.Checked = false;
                    SIPPBXWinUtil.AddHuntgroupsIntoComboBox(pbx, cbCFACD, hg.callForwardingPlan);
                    SIPPBXWinUtil.AddInboundDialplanIntoComboBox(pbx, cbCFDP, "");
                }
                else
                {
                    rbCFACD.Checked = false;
                    rbCFDP.Checked = true;
                    SIPPBXWinUtil.AddHuntgroupsIntoComboBox(pbx, cbCFACD, "");
                    SIPPBXWinUtil.AddInboundDialplanIntoComboBox(pbx, cbCFDP, hg.callForwardingPlan);
                }

                cbPromptQueuePosition.Checked = hg.promptQueuePosition;
            }
            else
            {
                this.Text = "Add Hunt Group";
                cbType.SelectedIndex = 0;

                rbExtenType.Checked = true;
                rbAgentType.Checked = false;
                rbACDType.Checked = false;
                for (int i = 0; i < pbx.sip_exten.Count; i++)
                    lbExtens.Items.Add(pbx.sip_exten[i].UserName);

                cbPlayMOH.Checked = false;
                tbMOHDir.Enabled = false;
                btnBrowse.Enabled = false;

                cbEnableVMB.Checked = false;
                tbVMBDTMF.Enabled = false;
                btnVMBSettings.Enabled = false;

                tbWaitTimeout.Text = "0";

                rbTimeoutToVMB.Checked = true;
                rbTimeoutToDP.Checked = false;

                SIPPBXWinUtil.AddInboundDialplanIntoComboBox(pbx, cbToDialplan, "");

                tbMaxNumCalls.Text = "0";
                SIPPBXWinUtil.AddInboundDialplanIntoComboBox(pbx, cbCFDP, "");
                SIPPBXWinUtil.AddHuntgroupsIntoComboBox(pbx, cbCFACD, "");

                rbCFACD.Checked = true;
                rbCFDP.Checked = false;

                cbPromptQueuePosition.Checked = false;
            }


        }

        private void btnAddIn_Click(object sender, EventArgs e)
        {
            if (lbExtens.SelectedIndex >= 0)
            {
                string agent_name = "";
                if(cur_agent_type == 0)
                    agent_name = pbx.sip_exten[lbExtens.SelectedIndex].UserName;
                else
                    agent_name = pbx.sip_agents[lbExtens.SelectedIndex].Code;
                for (int i = 0; i < lbAgents.Items.Count; i++)
                {
                    if (lbAgents.Items[i].ToString() == agent_name)
                    {
                        MessageBox.Show("Extension is already in the agent list.", "Error");
                        return;
                    }
                }
                lbAgents.Items.Add(agent_name);
            }
            else
            {
                MessageBox.Show("You must select an extension from right list!", "Error");
            }

        }

        private void btnMoveOut_Click(object sender, EventArgs e)
        {
            if (lbAgents.SelectedIndex >= 0)
            {
                lbAgents.Items.RemoveAt(lbAgents.SelectedIndex);
            }
            else
            {
                MessageBox.Show("You must select an agent from left list!", "Error");
            }
        }

        private void btOK_Click(object sender, EventArgs e)
        {
            bool bAdd = false;

            if (hg == null)
            {
                hg = new SIPPBXACDHuntGroup();
                hg.bUseGroupName = pbx.use_gpname_as_dispname;
                pbx.sip_huntgroups.Add(hg);
                bAdd = true;
            }

            hg.hgName = tbName.Text;
            hg.hgType = cbType.SelectedIndex;

            hg.playMOH = cbPlayMOH.Checked;
            if (hg.playMOH)
                hg.mohDir = tbMOHDir.Text;
            else
                hg.mohDir = "";

            if (rbAgentType.Checked)
            {
                hg.agentType = 1;
            }
            else if (rbExtenType.Checked)
            {
                hg.agentType = 0;
            }
            else if(rbACDType.Checked)
            {
                hg.agentType = 2;
            }
            hg.agents.Clear();
            for (int i = 0; i < lbAgents.Items.Count; i++)
                hg.agents.Add(lbAgents.Items[i].ToString());

            if (cbEnableVMB.Checked)
            {
                hg.vmbDTMF = tbVMBDTMF.Text;
                hg.vmb = vmb;
            }
            else
            {
                hg.vmbDTMF = "";
                hg.vmb = null;
            }

            hg.dpDTMF = tbDPDTMF.Text;
            hg.dpName = cbToDialplan.Text;

            hg.waitTimeout = Convert.ToInt32(tbWaitTimeout.Text);
            hg.waitTimeoutTo = rbTimeoutToDP.Checked ? cbToDialplan.Text : "";

            hg.maxNumOfCalls = Convert.ToInt32(tbMaxNumCalls.Text);
            if (rbCFACD.Checked == true)
            {
                hg.callForwardingType = 0;
                hg.callForwardingPlan = cbCFACD.Text;
            }
            else
            {
                hg.callForwardingType = 1;
                hg.callForwardingPlan = cbCFDP.Text;
            }

            hg.promptQueuePosition = cbPromptQueuePosition.Checked;

            DialogResult = DialogResult.OK;

            Close();

            parent_dlg.ShowHuntGroupList();

            if (bAdd)
            {
                if (!SIPPBXCFGDB.AddACDConfigToDB(hg, null, pbx, null, pbx.db_set, PBXMainForm.log))
                    MessageBox.Show("Cannot add this new Hunt Group into DB!");
            }
            else
            {
                if (!SIPPBXCFGDB.UpdateACDConfigInDB(hg, null, pbx, null, pbx.db_set, PBXMainForm.log))
                    MessageBox.Show("Cannot update this new Hunt Group into DB!");
            }
        }

        private void btCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void cbPlayMOH_CheckedChanged(object sender, EventArgs e)
        {
            if (cbPlayMOH.Checked)
            {
                tbMOHDir.Enabled = true;
                btnBrowse.Enabled = true;
                tbMOHDir.Text = pbx.moh_dir;
            }
            else
            {
                tbMOHDir.Enabled = false;
                btnBrowse.Enabled = false;
            }
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowser myBrowser = new FolderBrowser();
            myBrowser.Title = "Choose a music folder";
            myBrowser.Flags = BrowseFlags.BIF_NEWDIALOGSTYLE |
                              BrowseFlags.BIF_STATUSTEXT |
                              BrowseFlags.BIF_EDITBOX; ;
            DialogResult res = myBrowser.ShowDialog();
            if (res == DialogResult.OK)
            {
                tbMOHDir.Text = myBrowser.DirectoryPath;
            }
        }

        private void cbEnableVMB_CheckedChanged(object sender, EventArgs e)
        {
            if (cbEnableVMB.Checked)
            {
                if (vmb == null)
                    vmb = new VoiceMailBox();
                tbVMBDTMF.Enabled = true;
                if(hg != null)
                    tbVMBDTMF.Text = hg.vmbDTMF;
                btnVMBSettings.Enabled = true;
            }
            else
            {
                vmb = null;
                tbVMBDTMF.Enabled = false;
                btnVMBSettings.Enabled = false;
            }
        }

        private void btnVMBSettings_Click(object sender, EventArgs e)
        {
            if (vmb == null)
                vmb = new VoiceMailBox();

            VoiceMailBoxEdit dlg = new VoiceMailBoxEdit();
            dlg.vmb = vmb;
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }

        private void rbExtenType_CheckedChanged(object sender, EventArgs e)
        {
            if (cur_agent_type != 0)
            {
                lbAgents.Enabled = true;
                lbExtens.Enabled = true;
                cur_agent_type = 0;
                lbAgents.Items.Clear();
                lbExtens.Items.Clear();
                for (int i = 0; i < pbx.sip_exten.Count; i++)
                    lbExtens.Items.Add(pbx.sip_exten[i].UserName);
            }
        }

        private void rbAgentType_CheckedChanged(object sender, EventArgs e)
        {
            if (cur_agent_type != 1)
            {
                lbAgents.Enabled = true;
                lbExtens.Enabled = true;

                cur_agent_type = 1;
                lbAgents.Items.Clear();
                lbExtens.Items.Clear();
                for (int i = 0; i < pbx.sip_agents.Count; i++)
                    lbExtens.Items.Add(pbx.sip_agents[i].Code);
            }
        }

        private void rbACDType_CheckedChanged(object sender, EventArgs e)
        {
            if (cur_agent_type != 2)
            {
                cur_agent_type = 2;
                lbAgents.Items.Clear();
                lbExtens.Items.Clear();
                for (int i = 0; i < pbx.sip_agents.Count; i++)
                    lbExtens.Items.Add(pbx.sip_agents[i].Code);

                lbAgents.Enabled = false;
                lbExtens.Enabled = false;
            }
        }



    }
}