﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class CallBackList : Form
    {
        public SIPPBX pbx;

        public CallBackList()
        {
            InitializeComponent();
        }

        private void CallBackList_Load(object sender, EventArgs e)
        {
            //MessageBox.Show("CallBackList_Load " + "Callback count" + pbx.call_backlist.Count.ToString());
            lvCallBackList.Columns.Clear();
            lvCallBackList.Columns.Add("Caller", 120, HorizontalAlignment.Left);
            lvCallBackList.Columns.Add("Callee", 120, HorizontalAlignment.Left);
            lvCallBackList.Columns.Add("Dialplan", 120, HorizontalAlignment.Left);
            lvCallBackList.Columns.Add("SIP Account", 120, HorizontalAlignment.Left);
            cbEnable.Checked = pbx.callback_enabled;

            ShowCallBackList();
        }

        public void ShowCallBackList()
        {
            lvCallBackList.Items.Clear();

            //MessageBox.Show("Callback count" + pbx.call_backlist.Count.ToString());

            for (int i = 0; i < pbx.call_backlist.Count; i++)
            {
                //MessageBox.Show("Here show call_blacklist");
                ListViewItem aItem = new ListViewItem(pbx.call_backlist[i].Caller);
                aItem.SubItems.Add(pbx.call_backlist[i].Callee);
                aItem.SubItems.Add(pbx.call_backlist[i].DialPlan);
                aItem.SubItems.Add(pbx.call_backlist[i].ExtraAttr);
                lvCallBackList.Items.Add(aItem);
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            CallBack cb = new CallBack();
            CallBackEdit dlg = new CallBackEdit();
            dlg.pbx = pbx;
            dlg.cb = cb;

            int maxID = 1;
            for (int i = 0; i < pbx.call_backlist.Count; i++)
            {
                if (pbx.call_backlist[i].ID >= maxID)
                {
                    maxID = pbx.call_backlist[i].ID + 1;
                }
            }

            cb.ID = maxID;

            if (dlg.ShowDialog() == DialogResult.OK)
            {
                if (SIPPBXCFGDB.AddCallBackToDB(cb, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.call_backlist.Add(cb);
                    ShowCallBackList();
                }
                else
                {
                    MessageBox.Show("Cannot add call back rule into DB.", "Error");
                }

            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lvCallBackList.SelectedIndices.Count > 0)
            {
                int idx = lvCallBackList.SelectedIndices[0];

                CallBackEdit dlg = new CallBackEdit();
                dlg.pbx = pbx;
                dlg.cb = pbx.call_backlist[idx];

                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (!SIPPBXCFGDB.UpdateCallBackInDB(dlg.cb, null, pbx, null, pbx.db_set, PBXMainForm.log))
                    {
                        MessageBox.Show("Cannot update the call black in DB.", "Error");
                    }
                    ShowCallBackList();
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvCallBackList.SelectedIndices.Count > 0)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                //ACDAgentEdit dlg = new ACDAgentEdit();
                if (SIPPBXCFGDB.RemoveCallBackFromDB(pbx.call_backlist[lvCallBackList.SelectedIndices[0]], null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.call_backlist.RemoveAt(lvCallBackList.SelectedIndices[0]);
                    ShowCallBackList();
                }
                else
                {
                    MessageBox.Show("Cannot remove the item from DB.", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (cbEnable.Checked != pbx.callback_enabled)
            {
                pbx.callback_enabled = cbEnable.Checked;
                SIPPBXCFGDB.UpdateCallLimitAndBlackListToDB(null, pbx, null, pbx.db_set, PBXMainForm.log);
            }

            Close();
        }
    }
}
