using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ConferoomList : Form
    {
        public SIPPBX pbx;

        public ConferoomList()
        {
            InitializeComponent();
        }

        private void ConferoomList_Load(object sender, EventArgs e)
        {
            lvConferooms.Columns.Clear();
            lvConferooms.Columns.Add("Name", 120, HorizontalAlignment.Left);

            ShowConferooms();

            //btnEdit.Enabled = false;
        }

        public void ShowConferooms()
        {
            lvConferooms.Items.Clear();

            for (int i = 0; i < pbx.sip_conferooms.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_conferooms[i].conf_name);
                lvConferooms.Items.Add(aItem);
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            SIPConferRoom room = new SIPConferRoom();
            ConferoomEdit dlg = new ConferoomEdit();
            dlg.room = room;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                if (SIPPBXCFGDB.AddConferRoomToDB(room, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_conferooms.Add(room);
                    ShowConferooms();
                }
                else
                {
                    MessageBox.Show("Cannot add conference room into DB table!", "Error");
                }
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lvConferooms.SelectedIndices.Count > 0)
            {
                int idx = lvConferooms.SelectedIndices[0];
                SIPConferRoom room = pbx.sip_conferooms[idx];
                ConferoomEdit dlg = new ConferoomEdit();
                dlg.room = room;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
					if (SIPPBXCFGDB.UpdateConferRoomInDB(room, null, pbx, null, pbx.db_set, PBXMainForm.log))
					{
					}
					else
					{
						MessageBox.Show("Cannot update conference room into DB table!", "Error");
					}					
                    ShowConferooms();
                }
            }
            else
            {
                MessageBox.Show("Please select a conference room first!", "Error");
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvConferooms.SelectedIndices.Count > 0)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                int idx = lvConferooms.SelectedIndices[0];
                SIPConferRoom room = pbx.sip_conferooms[idx];

                if (SIPPBXCFGDB.RemoveConferRoomFromDB(room, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_conferooms.RemoveAt(idx);
                    ShowConferooms();
                }
                else
                {
                    MessageBox.Show("Cannot delete conference room from DB table!", "Error");
                }
/*
                if (room.conf_handle != 0)
                {
                    for (int j = 0; j < room.conf_chans.Count; j++)
                    {
                        env.SetChanInConf((uint)room.conf_handle, room.conf_chans[j].index, 0);
                    }
                    room.conf_chans.Clear();
                    env.DestroyConf((uint)room.conf_handle);
                    room.conf_handle = 0;
                }
 */
            }
            else
            {
                MessageBox.Show("Please select a conference room first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }



    }
}
