using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ExtenAdd : Form
    {
        public int exten_index;
        public SIPPBX pbx;
        public ExtenEdit parent_form;
        public VoiceMailBox vmb;

        public ExtenAdd()
        {
            InitializeComponent();
            exten_index = -1;
            vmb = null;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void AddBtn_Click(object sender, EventArgs e)
        {
            SIPPBXExten exten;

            if (textExten.Text.Trim().Length == 0)
            {
                MessageBox.Show("Extension must has an unique number!", "Error");
                return;
            }

            if (exten_index == -1)
            {
                if (pbx.getExtensionByName(textExten.Text) != null)
                {
                    MessageBox.Show("Same name extension already exists");
                    return;
                }

                exten = new SIPPBXExten();
                exten.UserName = textExten.Text;
                exten.RealName = textUserName.Text;
                exten.Password = textPassword.Text;
                exten.Email = textEmail.Text;
                exten.RecordCall = cbCallRecord.Checked;
                exten.bAcceptOtherID = cbForwardOrgID.Checked;

                if (cbExtenType.SelectedIndex == 0)
                {
                    exten.PriorityLevel = 1;
                    if (rbACDAnswerRegistered.Checked)
                        exten.ACDCallMethod = 1;
                    else
                        exten.ACDCallMethod = 2;
                }
                else if (cbExtenType.SelectedIndex == 1)
                {
                    exten.PriorityLevel = 8;
                    if (rbACDAnswerRegistered.Checked)
                        exten.ACDCallMethod = 1;
                    else
                        exten.ACDCallMethod = 2;
                }
                else if (cbExtenType.SelectedIndex == 2)
                {
                    exten.PriorityLevel = 16;
                    exten.VirtualExtenDestAddr = tbVirtualExtenContact.Text;
                }
                if (vmb != null)
                    vmb.vmbExten = exten;
                exten.vmb = vmb;

                if (rbThisVMB.Checked)
                    exten.CallForwardingPlan = "";
                else
                    exten.CallForwardingPlan = cbDialplans.Text;

                exten.RestSeconds = Convert.ToInt32(tbCallInterval.Text);

                exten.AuthType = cbAuthType.SelectedIndex;
                exten.bOnlyAgentLogin = cbAgentMustLogin.Checked;
                exten.bMultipleCalls = cbMultipleCalls.Checked;

                exten.AlternativePhoneNumber = tbOutboundCallerID.Text.Trim();

                if(cbAlwaysForward.Checked)
                    exten.RingTimeoutSec = -1;
                else
                    exten.RingTimeoutSec = Convert.ToInt32(tbRingTimeout.Text);

                exten.PinCode = tbPin.Text;

                try
                {
                    exten.RegMaxExp = Convert.ToUInt32(tbMaxRegExpSec.Text);
                }
                catch (Exception)
                {
                    exten.RegMaxExp = 0;
                }

                exten.UseSRTP = cbSRTP.Checked ? 1 : 0;

                if (!SIPPBXCFGDB.AddExtensionToDB(exten, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    MessageBox.Show("Cannot add the extension into DB!", "Error");
                    return;
                }

                pbx.sip_exten.Add(exten);

                /* no need to sort, as for Node ID, we get text to find extension.
                pbx.sip_exten.Sort(delegate(SIPPBXExten a, SIPPBXExten b)
                                   {
                                       return string.Compare(a.UserName, b.UserName);
                                   });*/

            }
            else
            {
                exten = pbx.sip_exten[exten_index];
                exten.UserName = textExten.Text;
                exten.RealName = textUserName.Text;
                exten.Password = textPassword.Text;
                exten.Email = textEmail.Text;
                exten.RecordCall = cbCallRecord.Checked;
                exten.bAcceptOtherID = cbForwardOrgID.Checked;
                if (cbExtenType.SelectedIndex == 0)
                {
                    exten.PriorityLevel = 1;
                    if (rbACDAnswerRegistered.Checked)
                        exten.ACDCallMethod = 1;
                    else
                        exten.ACDCallMethod = 2;

                }
                else if (cbExtenType.SelectedIndex == 1)
                {
                    exten.PriorityLevel = 8;
                    if (rbACDAnswerRegistered.Checked)
                        exten.ACDCallMethod = 1;
                    else
                        exten.ACDCallMethod = 2;
                }
                else if (cbExtenType.SelectedIndex == 2)
                {
                    exten.PriorityLevel = 16;
                    exten.VirtualExtenDestAddr = tbVirtualExtenContact.Text;
                }
                if (vmb != null)
                    vmb.vmbExten = exten;
                exten.vmb = vmb;

                if (cbAlwaysForward.Checked)
                    exten.RingTimeoutSec = -1;
                else
                    exten.RingTimeoutSec = Convert.ToInt32(tbRingTimeout.Text);

                if (rbThisVMB.Checked)
                    exten.CallForwardingPlan = "";
                else
                    exten.CallForwardingPlan = cbDialplans.Text;

                exten.RestSeconds = Convert.ToInt32(tbCallInterval.Text);

                exten.AuthType = cbAuthType.SelectedIndex;
                exten.bOnlyAgentLogin = cbAgentMustLogin.Checked;
                exten.bMultipleCalls = cbMultipleCalls.Checked;

                exten.AlternativePhoneNumber = tbOutboundCallerID.Text.Trim();

                exten.PinCode = tbPin.Text;

                try
                {
                    exten.RegMaxExp = Convert.ToUInt32(tbMaxRegExpSec.Text);
                }
                catch (Exception)
                {
                    exten.RegMaxExp = 0;
                }

                exten.UseSRTP = cbSRTP.Checked ? 1 : 0;

                if (!SIPPBXCFGDB.UpdateExtensionInDB(exten, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    MessageBox.Show("Cannot update the extension in DB!", "Error");
                    return;
                }
            }

            Close();

            parent_form.ShowExtensions();
        }

        private void ExtenAdd_Load(object sender, EventArgs e)
        {
            cbExtenType.Items.Add("Normal");
            cbExtenType.Items.Add("Supervisor");
            cbExtenType.Items.Add("Virtual");

            cbAuthType.Items.Add("Proxy");
            cbAuthType.Items.Add("WWW");
            cbAuthType.Items.Add("None");
            
            rbACDAnswer6000.Text = "Once connected with pbx special number("+pbx.acd_number+")";

            if (exten_index != -1)
            {
                Text = "Edit an extension";

                SIPPBXExten exten = pbx.sip_exten[exten_index];
                textExten.Text = exten.UserName;
                textExten.Enabled = false;
                textUserName.Text = exten.RealName;
                textPassword.Text = exten.Password;
                textEmail.Text = exten.Email;
                vmb = exten.vmb;
                if (vmb != null)
                    if (vmb.vmbExten == null) 
                        vmb.vmbExten = exten;
                cbCallRecord.Checked = exten.RecordCall;
                cbForwardOrgID.Checked = exten.bAcceptOtherID;
                tbCallInterval.Text = exten.RestSeconds.ToString();

                tbOutboundCallerID.Text = exten.AlternativePhoneNumber;

                if (exten.CallForwardingPlan.Length > 0)
                {
                    rbThisVMB.Checked = false;
                    rbDialplan.Checked = true;
                    cbDialplans.Enabled = true;
                    SIPPBXWinUtil.AddInboundDialplanIntoComboBox(pbx, cbDialplans, exten.CallForwardingPlan);
                }
                else
                {
                    rbThisVMB.Checked = true;
                    rbDialplan.Checked = false;
                    cbDialplans.Enabled = false;
                }

                if (vmb != null)
                {
                    cbVoiceMailBox.Checked = true;
                    btnVoiceMailBox.Enabled = true;
                }
                else
                {
                    cbVoiceMailBox.Checked = false;
                    btnVoiceMailBox.Enabled = false;
                }

                if (exten.IsNormalExten()) //normal
                {
                    cbExtenType.SelectedIndex = 0;
                    tbVirtualExtenContact.Enabled = false;
                    rbACDAnswer6000.Enabled = true;
                    rbACDAnswerRegistered.Enabled = true;
                    if (exten.ACDCallMethod == 1)
                    {
                        rbACDAnswerRegistered.Checked = true;
                        rbACDAnswer6000.Checked = false;
                    }
                    else
                    {
                        rbACDAnswerRegistered.Checked = false;
                        rbACDAnswer6000.Checked = true;
                    }

                    cbAuthType.Enabled = true;
                    cbAuthType.SelectedIndex = exten.AuthType;
                }
                else if (exten.IsSupervisorExten()) //supervisor
                {
                    cbExtenType.SelectedIndex = 1;
                    tbVirtualExtenContact.Enabled = false;
                    rbACDAnswer6000.Enabled = true;
                    rbACDAnswerRegistered.Enabled = true;
                    if (exten.ACDCallMethod == 1)
                    {
                        rbACDAnswerRegistered.Checked = true;
                        rbACDAnswer6000.Checked = false;
                    }
                    else
                    {
                        rbACDAnswerRegistered.Checked = false;
                        rbACDAnswer6000.Checked = true;
                    }
                    cbAuthType.Enabled = true;
                    cbAuthType.SelectedIndex = exten.AuthType;
                }
                else if (exten.IsVirtualExten()) //virtual extension
                {
                    cbExtenType.SelectedIndex = 2;
                    tbVirtualExtenContact.Enabled = true;
                    tbVirtualExtenContact.Text = exten.VirtualExtenDestAddr;
                    rbACDAnswer6000.Enabled = false;
                    rbACDAnswerRegistered.Enabled = false;
                    cbAuthType.Enabled = false;
                    cbAuthType.SelectedIndex = exten.AuthType;
                }

                cbAgentMustLogin.Checked = exten.bOnlyAgentLogin;
                cbMultipleCalls.Checked = exten.bMultipleCalls;

                if (exten.RingTimeoutSec >= 0)
                {
                    cbAlwaysForward.Checked = false;
                    tbRingTimeout.Enabled = true;
                    tbRingTimeout.Text = exten.RingTimeoutSec.ToString();
                }
                else
                {
                    cbAlwaysForward.Checked = true;
                    tbRingTimeout.Enabled = false;
                }

                tbPin.Text = exten.PinCode;
                tbMaxRegExpSec.Text = exten.RegMaxExp.ToString();

                cbSRTP.Checked = exten.UseSRTP == 1;
            }
            else
            {
                cbExtenType.SelectedIndex = 0;
                tbVirtualExtenContact.Enabled = false;
                rbACDAnswer6000.Enabled = true;
                rbACDAnswerRegistered.Enabled = true;
                rbACDAnswerRegistered.Checked = true;
                rbACDAnswer6000.Checked = false;
                cbCallRecord.Checked = false;
                cbForwardOrgID.Checked = false;

                tbRingTimeout.Text = "20";
                rbThisVMB.Checked = true;
                rbDialplan.Checked = false;
                cbDialplans.Enabled = false;
                tbCallInterval.Text = "0";
                cbAuthType.SelectedIndex = 0;

                cbAgentMustLogin.Checked = false;

                cbAlwaysForward.Checked = false;

                tbOutboundCallerID.Text = "";

                tbPin.Text = "";
                tbMaxRegExpSec.Text = "0";

                cbSRTP.Checked = false;

            }

        }

        private void cbExtenType_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cbExtenType.SelectedIndex == 2)
            {
                textPassword.Enabled = false;
                textEmail.Enabled = false;
                tbVirtualExtenContact.Enabled = true;
                rbACDAnswer6000.Enabled = false;
                rbACDAnswerRegistered.Enabled = false;

                cbAuthType.Enabled = false;
                cbAuthType.SelectedIndex = 0;
            }
            else
            {
                textPassword.Enabled = true;
                textEmail.Enabled = true;
                tbVirtualExtenContact.Enabled = false;
                rbACDAnswer6000.Enabled = true;
                rbACDAnswerRegistered.Enabled = true;

                cbAuthType.Enabled = true;
                cbAuthType.SelectedIndex = 0;
            }
        }

        private void cbVoiceMailBox_CheckedChanged(object sender, EventArgs e)
        {
            if (cbVoiceMailBox.Checked)
            {
                btnVoiceMailBox.Enabled = true;
                if (vmb == null)
                {
                    vmb = new VoiceMailBox();
                    vmb.vmbEmailAddr = textEmail.Text;
                    if(exten_index != -1)
                        vmb.vmbExten = pbx.sip_exten[exten_index];
                }
            }
            else
            {
                btnVoiceMailBox.Enabled = false;
                vmb = null;
            }
        }

        private void btnVoiceMailBox_Click(object sender, EventArgs e)
        {
            VoiceMailBoxEdit dlg = new VoiceMailBoxEdit();
            if (vmb == null)
            {
                vmb = new VoiceMailBox();
                vmb.vmbEmailAddr = textEmail.Text;
                if (exten_index != -1)
                    vmb.vmbExten = pbx.sip_exten[exten_index];
            }
            dlg.vmb = vmb;
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
            }
        }

        private void rbThisVMB_CheckedChanged(object sender, EventArgs e)
        {
            if (!rbThisVMB.Checked)
            {
                rbDialplan.Checked = true;
                cbDialplans.Enabled = true;
                SIPPBXWinUtil.AddInboundDialplanIntoComboBox(pbx, cbDialplans, "");
            }
            else
            {
                rbDialplan.Checked = false;
                cbDialplans.Enabled = false;
            }

        }

        private void rbDialplan_CheckedChanged(object sender, EventArgs e)
        {
            if (rbDialplan.Checked)
            {
                rbThisVMB.Checked = false;
                cbDialplans.Enabled = true;
                SIPPBXWinUtil.AddInboundDialplanIntoComboBox(pbx, cbDialplans, "");
            }
            else
            {
                rbThisVMB.Checked = true;
                cbDialplans.Enabled = false;
            }

        }

        private void cbAlwaysForward_CheckedChanged(object sender, EventArgs e)
        {
            if (cbAlwaysForward.Checked)
            {
                tbRingTimeout.Enabled = false;
            }
            else
            {
                tbRingTimeout.Enabled = true;
                tbRingTimeout.Text = "20";
            }
        }

    }
}