using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ExtenEdit : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public ExtenEdit()
        {
            InitializeComponent();
        }

        public void ShowExtensions()
        {
            ExtenList.Items.Clear();

            for (int i = 0; i < pbx.sip_exten.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_exten[i].UserName);
                aItem.SubItems.Add(pbx.sip_exten[i].RealName);
                aItem.SubItems.Add(pbx.sip_exten[i].Email);
                //aItem.SubItems.Add(pbx.sip_exten[i].ContactAddr);
                ExtenList.Items.Add(aItem);
            }

            //ExtenList.Refresh();
        }

        private void AddButton_Click(object sender, EventArgs e)
        {
            if (pbx.bFreeVersion)
            {
/*
                if (pbx.sip_exten.Count >= 4)
                {
                    MessageBox.Show("Free version only allows 4 extensions.", "Error");
                    return;
                }
 */
            }

            ExtenAdd exten_add_dlg = new ExtenAdd();

            exten_add_dlg.pbx = pbx;
            exten_add_dlg.parent_form = this;

            exten_add_dlg.ShowDialog();
        }

        private void ExtenEdit_Load(object sender, EventArgs e)
        {
            // Create columns for the items and subitems.
            ExtenList.Columns.Add("Extension", 120, HorizontalAlignment.Left);
            ExtenList.Columns.Add("Name", 120, HorizontalAlignment.Left);
            ExtenList.Columns.Add("Email", 120, HorizontalAlignment.Left);
            //ExtenList.Columns.Add("Contact", 120, HorizontalAlignment.Center);

            ShowExtensions();
        }

        private void OkButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void DeleteButton_Click(object sender, EventArgs e)
        {
            if (ExtenList.SelectedIndices.Count >= 1)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                if (SIPPBXCFGDB.RemoveExtensionFromDB(pbx.sip_exten[ExtenList.SelectedIndices[0]], null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_exten.RemoveAt(ExtenList.SelectedIndices[0]);
                    ExtenList.Items.RemoveAt(ExtenList.SelectedIndices[0]);
                }
                else
                {
                    MessageBox.Show("Couldn't delete extension from DB!", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an extension first!", "Error");
            }
        }

        private void EditButton_Click(object sender, EventArgs e)
        {
            if (ExtenList.SelectedIndices.Count > 0)
            {
                ExtenAdd exten_add_dlg = new ExtenAdd();

                exten_add_dlg.pbx = pbx;
                exten_add_dlg.parent_form = this;

                exten_add_dlg.Text = "Edit Extension";
                exten_add_dlg.AddBtn.Text = "Update Extension";
                exten_add_dlg.exten_index = ExtenList.SelectedIndices[0];

                exten_add_dlg.ShowDialog();
            }
            else
            {
                MessageBox.Show("Please select an extension first!", "Error");
            }
        }
    }
}