using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class IVRMenuList : Form
    {
        public SIPPBX pbx;

        public IVRMenuList()
        {
            InitializeComponent();
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            DialPlanAutoAttendForm dlg = new DialPlanAutoAttendForm();
            dlg.pbx = pbx;
            dlg.ivr = new SIPPBXIVR();
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                //check if the agent code is unique
                bool bFound = false;
                for (int i = 0; i < pbx.sip_ivrs.Count; i++)
                {
                    if (pbx.sip_ivrs[i].name == dlg.ivr.name)
                    {
                        bFound = true;
                        break;
                    }
                }
                if (!bFound)
                {
                    if (SIPPBXCFGDB.AddIVRToDB(dlg.ivr, null, pbx, null, pbx.db_set, PBXMainForm.log))
                    {
                        pbx.sip_ivrs.Add(dlg.ivr);
                        ShowIVRMenuList();
                    }
                    else
                    {
                        MessageBox.Show("Cannot add the IVR menu into DB.", "Error");
                    }
                }
                else
                {
                    MessageBox.Show("IVR name " + dlg.ivr.name + " already exists in list.", "Error");
                }

            }
        }

        private void IVRMenuList_Load(object sender, EventArgs e)
        {
            lvIVRMenus.Columns.Clear();
            lvIVRMenus.Columns.Add("Name", 120, HorizontalAlignment.Left);
            lvIVRMenus.Columns.Add("Sound File", 240, HorizontalAlignment.Left);
            lvIVRMenus.Columns.Add("DTMF Accept", 240, HorizontalAlignment.Left);

            ShowIVRMenuList();
        }

        public void ShowIVRMenuList()
        {
            lvIVRMenus.Items.Clear();

            for (int i = 0; i < pbx.sip_ivrs.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_ivrs[i].name);
                aItem.SubItems.Add(pbx.sip_ivrs[i].sound_file);
                string sDTMFs = "";
                if (pbx.sip_ivrs[i].dtmfs != null)
                {
                    for (int j = 0; j < pbx.sip_ivrs[i].dtmfs.Count; j++)
                    {
                        sDTMFs += pbx.sip_ivrs[i].dtmfs[j].DTMFStr;
                        if (j != pbx.sip_ivrs[i].dtmfs.Count - 1)
                            sDTMFs += ",";
                    }
                }
                aItem.SubItems.Add(sDTMFs);
                lvIVRMenus.Items.Add(aItem);
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lvIVRMenus.SelectedIndices.Count > 0)
            {
                int idx = lvIVRMenus.SelectedIndices[0];
                DialPlanAutoAttendForm dlg = new DialPlanAutoAttendForm();
                dlg.pbx = pbx;
                dlg.ivr = pbx.sip_ivrs[idx];
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (!SIPPBXCFGDB.UpdateIVRInDB(pbx.sip_ivrs[idx], null, pbx, null, pbx.db_set, PBXMainForm.log))
                    {
                        MessageBox.Show("Cannot update the IVR menu in DB!", "Error");
                    }
                    ShowIVRMenuList();
                }
            }
            else
            {
                MessageBox.Show("Please select an IVR menu first!", "Error");
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvIVRMenus.SelectedIndices.Count > 0)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                if (SIPPBXCFGDB.RemoveIVRFromDB(pbx.sip_ivrs[lvIVRMenus.SelectedIndices[0]], null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_ivrs.RemoveAt(lvIVRMenus.SelectedIndices[0]);
                    ShowIVRMenuList();
                }
                else
                {
                    MessageBox.Show("Cannot delete the IVR menu from DB.", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an IVR menu first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }

    }
}