﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class OpenAIAgentList : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public OpenAIAgentList()
        {
            InitializeComponent();
        }

        private void OpenAIAgentList_Load(object sender, EventArgs e)
        {
            // Create columns for the items and subitems.
            OpenAIAgentListViewer.Columns.Add("Agent Name", 120, HorizontalAlignment.Left);
            OpenAIAgentListViewer.Columns.Add("API Key", 120, HorizontalAlignment.Left);

            ShowOpenAIAgents();
        }

        public void ShowOpenAIAgents()
        {
            OpenAIAgentListViewer.Items.Clear();

            for (int i = 0; i < pbx.openai_nodes.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.openai_nodes[i].NodeName);
                aItem.SubItems.Add(pbx.openai_nodes[i].APIKey);

                OpenAIAgentListViewer.Items.Add(aItem);
            }

        }

        private void AddButton_Click(object sender, EventArgs e)
        {
            OpenAIAgentEdit agent_add_dlg = new OpenAIAgentEdit();

            agent_add_dlg.pbx = pbx;
            agent_add_dlg.parent_form = this;

            agent_add_dlg.Text = "Add OpenAI Agent";
            agent_add_dlg.AddBtn.Text = "Add Agent";

            agent_add_dlg.ShowDialog();
        }

        private void EditButton_Click(object sender, EventArgs e)
        {
            if (OpenAIAgentListViewer.SelectedIndices.Count > 0)
            {
                OpenAIAgentEdit agent_add_dlg = new OpenAIAgentEdit();

                agent_add_dlg.pbx = pbx;
                agent_add_dlg.parent_form = this;

                agent_add_dlg.Text = "Edit OpenAI Agent";
                agent_add_dlg.AddBtn.Text = "Update Agent";

                agent_add_dlg.agent_index = OpenAIAgentListViewer.SelectedIndices[0];

                agent_add_dlg.ShowDialog();
            }
            else
            {
                MessageBox.Show("Please select an agent first!", "Error");
            }
        }

        private void DeleteButton_Click(object sender, EventArgs e)
        {
            if (OpenAIAgentListViewer.SelectedIndices.Count >= 1)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                if (SIPPBXCFGDB.RemoveOpenAINodeFromDB(pbx.openai_nodes[OpenAIAgentListViewer.SelectedIndices[0]], null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.openai_nodes.RemoveAt(OpenAIAgentListViewer.SelectedIndices[0]);
                    OpenAIAgentListViewer.Items.RemoveAt(OpenAIAgentListViewer.SelectedIndices[0]);
                }
                else
                {
                    MessageBox.Show("Couldn't delete the openai agent from DB!", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an openai agent first!", "Error");
            }
        }

        private void OkButton_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
