﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class PagingGroupList : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public PagingGroupList()
        {
            InitializeComponent();
        }

        private void PagingGroupList_Load(object sender, EventArgs e)
        {
            lvPagingGroups.Columns.Clear();
            lvPagingGroups.Columns.Add("Name", 120, HorizontalAlignment.Left);
            lvPagingGroups.Columns.Add("Destinations", 240, HorizontalAlignment.Left);

            ShowPagingGroupList();
        }

        public void ShowPagingGroupList()
        {
            lvPagingGroups.Items.Clear();
            for (int i = 0; i < pbx.sip_paginggroups.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_paginggroups[i].gpName);

                string sDests = "";
                for (int j = 0; j < pbx.sip_paginggroups[i].destList.Count; j++)
                    sDests += pbx.sip_paginggroups[i].destList[j].DestAddr + ";";

                aItem.SubItems.Add(sDests);
                lvPagingGroups.Items.Add(aItem);
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            SIPPBXPagingGroup pg = new SIPPBXPagingGroup();
            pg.bUseGroupName = false;

            PagingGroupEdit dlg = new PagingGroupEdit();
            dlg.pg = pg;
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                if (SIPPBXCFGDB.AddPagingGroupToDB(pg, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_paginggroups.Add(pg);
                    ShowPagingGroupList();
                }
                else
                {
                    MessageBox.Show("Cannot add the paging group into DB!", "Error");
                }
            }

        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            SIPPBXPagingGroup pg;
            if (lvPagingGroups.SelectedIndices.Count >= 1)
            {
                pg = pbx.sip_paginggroups[lvPagingGroups.SelectedIndices[0]];
                PagingGroupEdit dlg = new PagingGroupEdit();
                dlg.pbx = pbx;
                dlg.pg = pg;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (SIPPBXCFGDB.UpdatePagingGroupInDB(pg, null, pbx, null, pbx.db_set, PBXMainForm.log))
                    {
                    }
                    else
                    {
                        MessageBox.Show("Cannot update the paging group into DB!", "Error");
                    }
                }

                ShowPagingGroupList();
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnDel_Click(object sender, EventArgs e)
        {
            if (lvPagingGroups.SelectedIndices.Count >= 1)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                if (SIPPBXCFGDB.RemovePagingGroupFromDB(pbx.sip_paginggroups[lvPagingGroups.SelectedIndices[0]], null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_paginggroups.RemoveAt(lvPagingGroups.SelectedIndices[0]);
                    lvPagingGroups.Items.RemoveAt(lvPagingGroups.SelectedIndices[0]);
                }
                else
                {
                    MessageBox.Show("Cannot remove the paging group from DB!", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Close();
        }


    }
}
