using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class RingDestEdit : Form
    {
        public SIPPBX pbx;
        public SIPPBXDest dest;
        public bool ringTimeout;
        public bool isPagingExten;

        public RingDestEdit()
        {
            InitializeComponent();
            dest = null;
            ringTimeout = true;
            isPagingExten = false;
        }

        public void DestTypeSelected(int destType)
        {
            if (destType == 0)
            {
                rbDestExten.Checked = true;
                lbDest.Text = "Please specify an extension number: \nFor example: 101, 102, 601,..";

                cbDestAddr.Items.Clear();
                cbDestAddr.Text = "";
                for (int i = 0; i < pbx.sip_exten.Count; i++)
                {
                    cbDestAddr.Items.Add(pbx.sip_exten[i].UserName);
                }
            }
            else if (destType == 1)
            {
                rbDestOutbound.Checked = true;
                lbDest.Text = "Please specify an outbound number: \nYou can use your outbound dialplan rule, for example, if you have defined 9* outbound, then you can give 95412210578 to call outside number 5412210578.";
                cbDestAddr.Items.Clear();
                cbDestAddr.Text = "";
            }
            else if (destType == 2)
            {
                rbSIPAddr.Checked = true;
                lbDest.Text = "Please specify a full SIP address: \nSample: <sip:1234@abc.com>, <sip:456@10.98.1.10>,...";
                cbDestAddr.Items.Clear();
                cbDestAddr.Text = "";
            }
            else if (destType == 3)
            {
                rbACDAgent.Checked = true;
                lbDest.Text = "Please specify a ACD agent code: \nSample: 3001, 25400";
                cbDestAddr.Items.Clear();
                cbDestAddr.Text = "";
                for (int i = 0; i < pbx.sip_agents.Count; i++)
                {
                    cbDestAddr.Items.Add(pbx.sip_agents[i].Code);
                }
            }
        }

        private void RingDestEdit_Load(object sender, EventArgs e)
        {
            DestTypeSelected(dest.DestType);
            cbDestAddr.Text = dest.DestAddr;
            if (ringTimeout)
            {
                tbRingTimeout.Text = dest.RingTimeout.ToString();
            }
            else
            {
                tbRingTimeout.Enabled = false;
            }

            if (isPagingExten)
            {
                rbDestOutbound.Enabled = false;
                rbSIPAddr.Enabled = false;
                rbACDAgent.Enabled = false;
                rbDestExten.Checked = true;
                tbRingTimeout.Enabled = false;
            }

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (rbDestExten.Checked)
                dest.DestType = 0;

            if (rbDestOutbound.Checked)
                dest.DestType = 1;

            if (rbSIPAddr.Checked)
                dest.DestType = 2;

            if (rbACDAgent.Checked)
                dest.DestType = 3;

            dest.DestAddr = cbDestAddr.Text;

            if (tbRingTimeout.Text.Length > 0)
            {
                try
                {
                    dest.RingTimeout = Convert.ToInt32(tbRingTimeout.Text);
                }
                catch (Exception ex1)
                {
                    MessageBox.Show(ex1.ToString());
                    return;
                }
            }

            DialogResult = DialogResult.OK;

            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void rbDestExten_CheckedChanged(object sender, EventArgs e)
        {
            if (rbDestExten.Checked)
            {
                DestTypeSelected(0);
            }
        }

        private void rbDestOutbound_CheckedChanged(object sender, EventArgs e)
        {
            if (rbDestOutbound.Checked)
            {
                DestTypeSelected(1);
            }
        }

        private void rbSIPAddr_CheckedChanged(object sender, EventArgs e)
        {
            if (rbSIPAddr.Checked)
            {
                DestTypeSelected(2);
            }
        }

        private void rbACDAgent_CheckedChanged(object sender, EventArgs e)
        {
            if (rbACDAgent.Checked)
            {
                DestTypeSelected(3);
            }
        }
    }
}