using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class SIPProxySiteEdit : Form
    {
        public SIPPBX pbx;

        public SIPProxySiteEdit()
        {
            InitializeComponent();
        }

        private void SIPProxySiteEdit_Load(object sender, EventArgs e)
        {
            SIPProxySite asipsite = pbx.sip_proxy_sites[0];
            textDomainList.Text = asipsite.domainList;
            cbMapSIPAddr.Checked = asipsite.mapSIPAddr;
            cbOptionPingExten.Checked = asipsite.optionPingExten;
        }

        private void BtnOK_Click(object sender, EventArgs e)
        {
            SIPProxySite asipsite = pbx.sip_proxy_sites[0];
            asipsite.domainList = textDomainList.Text;
            asipsite.mapSIPAddr = cbMapSIPAddr.Checked;
            asipsite.optionPingExten = cbOptionPingExten.Checked;

            DialogResult = DialogResult.OK;

            Close();

            MessageBox.Show("You need to restart this PBX to make the change effective!", "Error");
        }

        private void BtnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }


    }
}