using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class SelectMemberForm : Form
    {
        public SIPPBX pbx;
        public PBXMemberList ml;

        public SelectMemberForm()
        {
            InitializeComponent();
        }

        private void SelectMemberForm_Load(object sender, EventArgs e)
        {
            cbMemberType.Items.Add("Extension");
            cbMemberType.Items.Add("Agent");
            cbMemberType.SelectedIndex = ml.mb_type;


        }

        private void cbMemberType_SelectedIndexChanged(object sender, EventArgs e)
        {
            clbMembers.Items.Clear();

            if (cbMemberType.SelectedIndex == 0)
            {
                for (int i = 0; i < pbx.sip_exten.Count; i++)
                {
                    string extn = pbx.sip_exten[i].UserName;
                    bool found = false;
                    for (int j = 0; j < ml.members.Count; j++)
                    {
                        if (ml.members[j] == extn)
                        {
                            found = true;
                            break;
                        }
                    }
                    clbMembers.Items.Add(extn, found);
                }
            }
            else
            {
                for (int i = 0; i < pbx.sip_agents.Count; i++)
                {
                    string agent = pbx.sip_agents[i].Code;
                    bool found = false;
                    for (int j = 0; j < ml.members.Count; j++)
                    {
                        if (ml.members[j] == agent)
                        {
                            found = true;
                            break;
                        }
                    }
                    clbMembers.Items.Add(agent, found);
                }
            }

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            ml.mb_type = cbMemberType.SelectedIndex;
            ml.members.Clear();
            for (int i = 0; i < clbMembers.CheckedItems.Count; i++)
            {
                ml.members.Add((string)clbMembers.CheckedItems[i]);
            }

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}