﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SIPPBXGUI
{
    public partial class UserEdit : Form
    {
        public UserAcct act;

        public UserEdit()
        {
            InitializeComponent();
            act = null;
        }

        private void UserEdit_Load(object sender, EventArgs e)
        {
            tbUserName.Text = act.userName;
            tbPassword.Text = act.passWord;

            if (act.permit == 0)
                rbAdmin.Checked = true;
            else if (act.permit == 1)
                rbUser.Checked = true;
            else if (act.permit == 2)
                rbViewer.Checked = true;
            else
                rbAdmin.Checked = true;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (tbUserName.Text.Trim().Length == 0)
            {
                MessageBox.Show("UserName can't be null");
                return;
            }
            if (tbPassword.Text.Trim().Length == 0)
            {
                MessageBox.Show("Password can't be null");
                return;
            }

            act.userName = tbUserName.Text;
            act.passWord = tbPassword.Text;
            if (rbAdmin.Checked)
                act.permit = 0;
            else if (rbUser.Checked)
                act.permit = 1;
            else if (rbViewer.Checked)
                act.permit = 2;

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}
