/*////////////////////////////////////////////////////////////////////////////////////
//
//Copyright (c) 2007-2020 by PC Best Networks, Inc.   All rights reserved
//
*/////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpACD : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXACDHuntGroup _hg;
        public SIPPBXChan _chan;
        public string _moh_dir;
        public GTOpAudioPlay _op_prompt_pos;
        public GTOpACDMusicOnHold _op_moh;
        public GTOpDTMFDetect _op_dtmf_detect;
        public GTOpACDSelect _op_acd_select;
        public GTOpACDCallTransfer _op_call_transfer;
        public GTOpCallConnect _op_call_connect;
        public bool _set_front;

        public GTOpACD(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXACDHuntGroup hg, string moh_dir, bool set_front)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _hg = hg;
            _moh_dir = moh_dir;
            _op_moh = null;
            _op_dtmf_detect = null;
            _op_call_transfer = null;
            _op_call_connect = null;
            _set_front = set_front;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpACD::start()########################====>>");

            _op_moh = new GTOpACDMusicOnHold(this, _env, _chan, _chan.DTMFBuf, _hg, _moh_dir);
            _op_moh.perform();

            _op_acd_select = new GTOpACDSelect(this, _env, _chan, _chan.DTMFBuf, _hg, _set_front, 0, null);
            _op_acd_select.perform();
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            _env.LOG_Trace(4, "GTOpACD::done()");

            if (opAsync == _op_prompt_pos)
            {
                _op_moh = new GTOpACDMusicOnHold(this, _env, _chan, _chan.DTMFBuf, _hg, _moh_dir);
                _op_moh.perform();

                _op_acd_select.resumeFromPromptQueuePostion();
            }
            else if (opAsync == _op_moh && result == GTOpAsync.ResultCode.OP_RESULT_ABORTED)
            {
                //should be impossible, but if playing queue position, this one may be reached.
                opAsync.LogoutText(1, "GTOpACD::done moh: playing queue position! on channel " + _chan.index.ToString());
                int idx = _hg.calls.IndexOf(this) + 1;

                _env.LOG_Trace(4, "GTOpACD::done call queue position " + idx.ToString());

                if (idx >= 1)
                {

                    List<string> audio_files = new List<string>();
                    audio_files.Add(_env.pbx.acd_agent_prompt9);
                    SIPPBXWinUtil.AddNumberToVoiceList(_env.pbx, audio_files, idx);
                    _op_prompt_pos = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                    _op_prompt_pos.perform();
                    _env.LOG_Trace(4, "GTOpACD::done _op_prompt_pos.perform() called");
                }
                else
                    _op_acd_select.resumeFromPromptQueuePostion();
            }
            else if (opAsync == _op_acd_select)
            {
                opAsync.LogoutText(4, "GTOpACD::done(_op_acd_select) on channel " + _chan.index.ToString());
            }
            else if (opAsync == _op_call_transfer)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS && _op_call_transfer.trans_succeed)
                {
                    //because the call transfer class doesn't hungup on caller
                    //this makes the caller to relocate calls possibly
                    //but here we just hungup on caller.
                    /*
                    if (_pbx.IsPBXChanInParkingSlot(_chan) == null)
                        _env.Send_HungUp(_chan.index);
                     */
                    _chan.call_reached_agent = true;
                    _op_call_transfer.trans_chan.call_reached_agent = true;
                    _op_call_transfer.trans_chan.acd_queue = _hg;
                    _op_call_transfer.trans_chan.acd_cdr_saved = false;
                    _op_call_transfer.trans_chan.in_queue_time = _chan.in_queue_time;
                    _op_call_transfer.trans_chan.out_queue_time = _chan.out_queue_time; // = DateTime.Now;
                    _op_call_transfer.trans_chan.acd_to_extn = _chan.acd_to_extn;

                    opAsync.LogoutText(4, "GTOpACD::done(_op_call_transfer) succeed on channel " + _chan.index.ToString());
                }
                else
                {
                    if (_env.IsChanConnected(_chan.index))
                    {
                        //caller is still online, and check if the callee's problem,
                        //of it does, then we may need to redistribute the call
                        //start again
                        opAsync.LogoutText(4, "GTOpACD::done(_op_call_transfer) restart GTOpACDSelect on channel " + _chan.index.ToString());
                        //if(_hg.hgType == 0) //linear
                        _op_acd_select = new GTOpACDSelect(this, _env, _chan, _chan.DTMFBuf, _hg, true, _op_acd_select._linear_idx, _op_acd_select._exp_list);
                        //else
                            //_op_acd_select = new GTOpACDSelect(this, _env, _chan, _chan.DTMFBuf, _hg, true, 0);

                        _op_acd_select.perform();
                    }
                    else
                    {
                        opAsync.LogoutText(4, "GTOpACD::done(_op_call_transfer) failed not connected anymore on channel " + _chan.index.ToString());
                    }
                }
            }
            else if (opAsync == _op_call_connect)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    //call already hanguped by caller
                    _chan.call_reached_agent = true;
                    _op_call_connect.trans_chan.call_reached_agent = true;
                    _op_call_connect.trans_chan.acd_queue = _hg;
                    _op_call_transfer.trans_chan.acd_cdr_saved = false;
                    _op_call_transfer.trans_chan.in_queue_time = _chan.in_queue_time;
                    _op_call_transfer.trans_chan.out_queue_time = _chan.out_queue_time; // = DateTime.Now;
                    _op_call_transfer.trans_chan.acd_to_extn = _chan.acd_to_extn;
                    opAsync.LogoutText(4, "GTOpACD::done(_op_call_connect) succeed on channel " + _chan.index.ToString());
                }
                else
                {
                    //start again
                    opAsync.LogoutText(4, "GTOpACD::done(_op_call_connect) restart GTOpACDSelect on channel " + _chan.index.ToString());
                    //if (_hg.hgType == 0) //linear
                        _op_acd_select = new GTOpACDSelect(this, _env, _chan, _chan.DTMFBuf, _hg, true, _op_acd_select._linear_idx, _op_acd_select._exp_list);
                    //else
                        //_op_acd_select = new GTOpACDSelect(this, _env, _chan, _chan.DTMFBuf, _hg, true, 0);

                    _op_acd_select.perform();
                }
            }
        }

    }
}
