/*////////////////////////////////////////////////////////////////////////////////////
//
//Copyright (c) 2007-2020 by PC Best Networks, Inc.   All rights reserved
//
*/////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpACDMusicOnHold : GTOpAsync 
    {
        public SIPPBXACDHuntGroup _hg;
        public string _moh_dir;

        public GTOpACDMusicOnHold(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, SIPPBXACDHuntGroup hg, string moh_dir)
            :base(ac, env, pbx_chan, dtmfStr)
        {
            _hg = hg;
            _moh_dir = moh_dir;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpACDMusicOnHold!");
            if(_hg.playMOH)
                getEnv().Send_StartMusicOnHold(getPBXChan().index, _hg.mohDir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH?1:0, 0);
        }

        public override void abort()
        {
            base.abort();

            LogoutText(4, "Abort asyncronized step - GTOpACDMusicOnHold!");

            _bAborting = true;

            if (_hg.playMOH) 
                getEnv().Send_StopMusicOnHold(getPBXChan().index);
        }

        public override void On_RecvAudioPlayDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvAudioPlayDone(ch, doneReason, dtmfBuffer);

            if (ch != getPBXChan().index)
                return;

            switch (doneReason)
            {
                case 0: //GT_AUDIO_DONE_DTMF_TIMEOUT
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_TIMEOUT, 0);
                    break;
                case 1: //GT_AUDIO_DONE_DTMF_MAX_DIGITS
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 1);
                    break;
                case 2: //GT_AUDIO_DONE_DTMF_DIGIT_DETECTED
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 2);
                    break;
                case 3: //GT_AUDIO_DONE_PLAY
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 3);
                    break;
                case 5: //GT_AUDIO_DONE_FORCED_STOP
                    if (isAborting())
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                    else
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 5);
                    break;
            }
        }
    }
}
