using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpCallTransfer : GTOpAsync 
    {
        public string caller_num;
        public string callee_num;
        public SIPAccount sip_acct;

        public SIPPBXChan trans_chan;
        public int ring_seconds;
        public bool trans_succeed;
        public bool played_ringback_tone;
        public bool wait_for_ringback_tone_done;

        public int transfering_chan_index;
        public SIPPBXChan transfering_wait_chan;
        public bool transfering_chan_got_idle_evt;
        public string transfering_addr;
        public string transfering_replaces_callid;
        public SIPPBXChan transfering_replaces_chan;

        public bool disc_trans_chan;
        public bool disc_main_chan;
        public SIPPBXChan monitor_chan;

        public int disc_code;
        public string disc_desc;

        public CallLimit _cl;

        public DateTime callConnectedTime;
        public DateTime callDisconnectedTime;

        public string audio_recording_fn;

//        public SIPPBXExten trans_org_extn;
//        public SIPPBXExten trans_to_extn;

        public GTOpCallTransfer(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, SIPPBXChan pbx_chan1, string callee, string caller, int ringSeconds, SIPAccount acct)
            : base(ac, env, pbx_chan, dtmfStr)
        {
            callee_num = callee;
            caller_num = caller;
            sip_acct = acct;
            
            trans_chan = pbx_chan1;
            trans_chan.sip_acct = acct;

            ring_seconds = ringSeconds;
            trans_succeed = false;
            played_ringback_tone = false;
            wait_for_ringback_tone_done = false;

            transfering_chan_index = -1;
            transfering_wait_chan = null;
            transfering_chan_got_idle_evt = false;
            transfering_addr = "";
            transfering_replaces_callid = "";
            transfering_replaces_chan = null;

            disc_trans_chan = true;
            disc_main_chan = false;
            monitor_chan = null;

            disc_code = 0;
            disc_desc = "";

            audio_recording_fn = "";

            _cl = null;

            callConnectedTime = callDisconnectedTime = DateTime.Now;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpCallTransfer!");

            if(ring_seconds < 0)
            {
                //ring timeout
                LogoutText(4, "Ring seconds < 0. Always forward! Aborting GTOpCallTransfer ......");
                setHwCode(1);
                abort();
                return;
            }

            getPBXChan().link_chan = trans_chan;
            trans_chan.link_chan = getPBXChan();

            getPBXChan().link_dtmf = "";
            trans_chan.link_dtmf = "";

            //GTAPIASM.GTAPIChan chan = getEnv().GetChannel(getPBXChan().index);

            SIPPBXWinUtil.SetChanAudioCodec(trans_chan.link_exten, _env, _env.pbx, trans_chan, getPBXChan());

            if (sip_acct != null)
            {
                if (_env.pbx.sip_set.bForwardPAssertedIdentity)
                {
                    string sPAssertedIdentity = getEnv().GetPAssertedIdentity(getPBXChan().index);
                    if (sPAssertedIdentity.Length > 0)
                        getEnv().SetPAssertedIdentity(trans_chan.index, sPAssertedIdentity);
                }

                if (_env.pbx.sip_set.doExtenProxy && getPBXChan().link_exten != null && trans_chan.link_exten != null)
                {
                    getEnv().Send_ProxyConnect(getPBXChan().index, trans_chan.index);
                }

                getEnv().pbx.MakeOutboundCall(getEnv(), trans_chan.index, callee_num, caller_num, sip_acct);
            }
            else
            {
                if (_env.pbx.sip_set.doExtenProxy && getPBXChan().link_exten != null && trans_chan.link_exten != null)
                {
                    getEnv().Send_ProxyConnect(getPBXChan().index, trans_chan.index);
                }

                getEnv().pbx.MakeExtensionCall(getEnv(), trans_chan.index, callee_num, caller_num, trans_chan.link_exten);
            }

            //June 08, 2014
            //We will have to do duplex connect after call INVITE is made out, because in this case, 
            //the remote SIP address has been already smartly choosed. 
            if (_env.pbx.sip_set.doExtenProxy && getPBXChan().link_exten != null && trans_chan.link_exten != null)
            {
            }
            else
            {
                if (_env.pbx.sip_set.doRTPRelay && _cl == null)
                    getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                else
                    getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
            }

        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting transfer in GTOpCallTransfer::abort");

                if (played_ringback_tone)
                    //getEnv().Send_StopAudio(getPBXChan().index);
                    getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                //BUG fix here:
                //As for aborting case, ringed timeout on destionation
                //We should disconnect trans_chan first always
                //No matter what value disc_trans_chan is
                //if(disc_trans_chan)
                    getEnv().DisconnectCall(trans_chan.index, 0, "", "PBX: aborting in CallTransfer");
                //else
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);

            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public override void On_RecvConnected(int ch)
        {
            base.On_RecvConnected(ch);

            //getEnv().LOG_Trace(1, "GTOpCallTransfer::On_RecvConnected started.");

            if (transfering_chan_index >= 0 && ch == transfering_chan_index)
            {
                //prevent unexpected disconnecting calls
                getEnv().StopTimer(ch);

                if (played_ringback_tone)
                    //getEnv().Send_StopAudio(getPBXChan().index);
                    getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                //transfering is done
                _pbxChan = transfering_wait_chan;
                trans_chan = getEnv().pbx.chan_list[transfering_chan_index];

                getPBXChan().link_chan = trans_chan;
                trans_chan.link_chan = getPBXChan();

                bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                if (b1 || b2)
                {
                    //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                }
                else
                {
                    if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay && _cl == null)
                        getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                    else
                        getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                }

                getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                //start DTMF detection for call parking
                if (getPBXChan().link_exten != null)
                {
                    getPBXChan().link_dtmf = "";
                    getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                }
                if (trans_chan.link_exten != null)
                {
                    trans_chan.link_dtmf = "";
                    getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                }

                //not sure if calllimit applys in this call second-transfering case.
                //just comment out for now.
                /*
                if (_cl != null)
                {
                    if (_cl.Seconds > 0 && _cl.Seconds <= 180)
                    {
                        _env.pbx.PlayCallLimitSound(getPBXChan().index, trans_chan.index);
                    }
                    else if (_cl.Seconds > 180)
                    {
                        _env.StartTimer(getPBXChan().index, (_cl.Seconds - 180) * 1000);
                    }
                    else //<= 0
                    {
                        //impossible because it is checked before going inside here
                    }
                }*/

                transfering_chan_index = -1;
                transfering_wait_chan = null;
                transfering_chan_got_idle_evt = false;
                transfering_addr = "";
                transfering_replaces_callid = "";
                transfering_replaces_chan = null;

                callConnectedTime = callDisconnectedTime = DateTime.Now;

                return;
            }


            if (ch == trans_chan.index)
            {
                //getEnv().LOG_Trace(1, "GTOpCallTransfer::On_RecvConnected ch == trans_chan.index");

                getEnv().StopTimer(ch);

                if (played_ringback_tone)
                    //getEnv().Send_StopAudio(getPBXChan().index);
                    getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                if (getEnv().IsChanConnected(getPBXChan().index))
                {
                    /*//already did RTPDuplexConnect when starting
                    if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay && _cl == null)
                        getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                    else
                        getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    */

                    bool b1 = getPBXChan().Record(getEnv(), trans_chan, audio_recording_fn);
                    bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                    if (b1 || b2)
                    {
                        //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }
                    else //if(played_ringback_tone)
                    {
                        if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay && _cl == null)
                            getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                        else
                            getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }
                    trans_succeed = true;

                    //start DTMF detection for call parking
                    if (getPBXChan().link_exten != null)
                    {
                        getPBXChan().link_dtmf = "";
                        getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                    }
                    if (trans_chan.link_exten != null)
                    {
                        trans_chan.link_dtmf = "";
                        getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                    }

                    if (_cl != null)
                    {
                        if (_cl.Seconds > 0 && _cl.Seconds <= 180)
                        {
                            _env.pbx.playCallLimitSound(_env, getPBXChan().index, trans_chan.index);
                            _env.StartTimer(getPBXChan().index, Convert.ToUInt32(_cl.Seconds * 1000));
                        }
                        else if (_cl.Seconds > 180)
                        {
                            _env.StartTimer(getPBXChan().index, Convert.ToUInt32((_cl.Seconds - 180) * 1000));
                        }
                        else //<= 0
                        {
                            //impossible because it is checked before going inside here
                        }
                    }
                }
                else
                {
                    SIPPBXWinUtil.SetChanAudioCodec(_pbxChan.link_exten, _env, _env.pbx, _pbxChan, trans_chan);
                    _env.Send_Answer(_pbxChan.index);
                }

                callConnectedTime = callDisconnectedTime = DateTime.Now;
            }
            else if (ch == _pbxChan.index)
            {
                /*//already did RTPDuplexConnect when starting
                    if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay && _cl == null)
                        getEnv().Send_RTPDuplexConnect(ch, trans_chan.index);
                    else
                        getEnv().Send_DuplexConnect(ch, trans_chan.index);
                */
                //getEnv().LOG_Trace(1, "GTOpCallTransfer::On_RecvConnected ch == _pbxChan.index");

                //prevent unexpected disconnecting calls
                getEnv().StopTimer(ch);

                bool b1 = getPBXChan().Record(getEnv(), trans_chan, audio_recording_fn);
                bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                if (b1 || b2)
                {
                    //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                }
                else //if (played_ringback_tone)
                {
                    if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay && _cl == null)
                        getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                    else
                        getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                }

                trans_succeed = true;

                //start DTMF detection for call parking
                if (getPBXChan().link_exten != null)
                {
                    getPBXChan().link_dtmf = "";
                    getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                }
                if (trans_chan.link_exten != null)
                {
                    trans_chan.link_dtmf = "";
                    getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                }

                if (_cl != null)
                {
                    if (_cl.Seconds > 0 && _cl.Seconds <= 180)
                    {
                        _env.pbx.playCallLimitSound(_env, getPBXChan().index, trans_chan.index);
                        _env.StartTimer(getPBXChan().index, Convert.ToUInt32(_cl.Seconds * 1000));
                    }
                    else if (_cl.Seconds > 180)
                    {
                        _env.StartTimer(getPBXChan().index, Convert.ToUInt32((_cl.Seconds - 180) * 1000));
                    }
                    else //<= 0
                    {
                        //impossible because it is checked before going inside here
                    }
                }

                callConnectedTime = callDisconnectedTime = DateTime.Now;
            }
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (monitor_chan != null)
            {
                if (monitor_chan.index == ch)
                {
                    monitor_chan = null;
                    if (trans_succeed)
                    {
                    }
                    else
                    {
                        if (played_ringback_tone)
                        {
                            //getEnv().Send_StopAudio(getPBXChan().index);
                            getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                        }
                        getEnv().DisconnectCall(getPBXChan().index, code, desc, "PBX: call transfer failed in On_RecvIdle of CallTransfer");
                        getEnv().DisconnectCall(trans_chan.index, code, desc, "PBX: call transfer failed in On_RecvIdle of CallTransfer");

                        fireDone(ResultCode.OP_RESULT_ABORTED, 0);
                    }
                    return;
                }
            }

            if (transfering_chan_index >= 0 && ch == transfering_chan_index)
            {
                //prevent unexpected disconnecting calls
                getEnv().StopTimer(ch);

                if (transfering_replaces_callid.Length > 0 &&
                    transfering_replaces_chan != null)
                {
                    if (_env.IsChanConnected(transfering_replaces_chan.index))
                    {
                        _pbxChan = transfering_wait_chan;
                        trans_chan = transfering_replaces_chan;

                        getPBXChan().link_chan = trans_chan;
                        trans_chan.link_chan = getPBXChan();

                        bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                        bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                        if (b1 || b2)
                        {
                            //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                        }
                        else
                        {
                            if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay && _cl == null)
                                getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                            else
                                getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                        }

                        getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                        //start DTMF detection for call parking
                        if (getPBXChan().link_exten != null)
                        {
                            getPBXChan().link_dtmf = "";
                            getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                        }
                        if (trans_chan.link_exten != null)
                        {
                            trans_chan.link_dtmf = "";
                            getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                        }

                        transfering_chan_index = -1;
                        transfering_wait_chan = null;
                        transfering_chan_got_idle_evt = false;
                        transfering_addr = "";
                        transfering_replaces_callid = "";
                        transfering_replaces_chan = null;

 //                       trans_org_extn = null;
 //                       trans_to_extn = null;

                        return;
                    }


                    trans_chan = transfering_replaces_chan;
                    transfering_chan_index = trans_chan.index;
                    transfering_wait_chan = _pbxChan;
                    transfering_chan_got_idle_evt = true;
                    transfering_replaces_callid = "";
                    transfering_replaces_chan = null;

                    if (_env.pbx.sip_set.doRTPRelay && _cl == null)
                        _env.Send_RTPDuplexConnect(_pbxChan.index, trans_chan.index);
                    else
                        _env.Send_DuplexConnect(_pbxChan.index, trans_chan.index);

                    return;
                }

                SIPPBXExten extn = getEnv().pbx.getExtensionBySIPAddr(transfering_addr);
                if (extn == null)
                {
                    string logInfo = "GTOpCallTransfer => Transfering to address " + transfering_addr + " is not an extension of local PBX! Call Transfering Failed!";
                    LogoutText(3, logInfo);
                    getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: " + logInfo);
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    transfering_chan_index = -1;
                    transfering_wait_chan = null;
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = "";
                    transfering_replaces_callid = "";
                    transfering_replaces_chan = null;

                    return;
                }

                VoiceMailBox vmb = extn.vmb;

                if (!transfering_chan_got_idle_evt)
                {
                    GTAPIASM.GTAPIChan api_chan = getEnv().GetChannel(transfering_wait_chan.index);

                    //doing nothing, wait until next call
                    transfering_chan_got_idle_evt = true;

                    if (transfering_wait_chan.async_op_compound == null)
                    {
                        //2020-09-30 just in case it is the main channel which has GTOpCallTransfer got transferred(Hang up)
                        getEnv().Send_StopAudioEx(transfering_wait_chan.index, 1, "");
                        transfering_wait_chan.async_op_compound = new GTOpDialExten(getEnv().pbx, getEnv(), transfering_wait_chan, null, extn);
                        transfering_wait_chan.async_op_compound.start();
                        return;
                    }

                    //2013/06/20, better choose another free channel rather than transfering_chan_index,
                    //because transfering_chan_index is last call's channel, and its call_connected is changed after calling
                    //pbx's MakeExtensionCall
                    SIPPBXChan ch_tmp = _env.pbx.SeizeChannelForOutbound(_env, transfering_chan_index);

                    if (ch_tmp != null)
                    {
                        transfering_chan_index = ch_tmp.index;
                        ch_tmp.ResetAll(transfering_wait_chan.unique_call_id, transfering_wait_chan.call_dir, getEnv().pbx, extn);
                        ch_tmp.link_exten = extn;

                        ch_tmp.link_chan = transfering_wait_chan;
                        transfering_wait_chan.link_chan = ch_tmp;
                    }
                    else
                    {
                        string logInfo = "GTOpCallTransfer => Transfering to address " + transfering_addr + " Failed because there is no free channel to call out!";
                        LogoutText(3, logInfo);
                        getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: " + logInfo);
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                        transfering_chan_index = -1;
                        transfering_wait_chan = null;
                        transfering_chan_got_idle_evt = false;
                        transfering_addr = "";
                        transfering_replaces_callid = "";
                        transfering_replaces_chan = null;

                        return;
                    }

                    string sCaller;
                    string sCallee;

                    sCaller = SIPPBXWinUtil.BuildCallerID(api_chan, "");

                    if (extn.IsRegistered() && ch_tmp != null)
                    {
                        sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, getEnv().pbx.chan_list[transfering_wait_chan.index]);

                        //changed according to settings
                        SIPPBXWinUtil.SetChanAudioCodec(extn, _env, _env.pbx, _env.pbx.chan_list[transfering_chan_index], transfering_wait_chan);

                        getEnv().pbx.SetExtenCallingState(extn, getEnv(), 10);
                        getEnv().pbx.MakeExtensionCall(getEnv(), transfering_chan_index, sCallee, sCaller, extn);

                        //make call out first, so on transfering channel, it will get right RTP address for calling
                        //then make rtp duplex.
                        if (_env.pbx.sip_set.doRTPRelay && _cl == null)
                            getEnv().Send_RTPDuplexConnect(transfering_wait_chan.index, transfering_chan_index);
                        else
                            getEnv().Send_DuplexConnect(transfering_wait_chan.index, transfering_chan_index);
                    }
                    else
                    {
                        if (vmb != null)
                        {
                            transfering_wait_chan.async_op_compound = new GTOpVMB(getEnv().pbx, getEnv(), transfering_wait_chan, vmb);
                            transfering_wait_chan.async_op_compound.start();
                        }
                        else
                        {
                            getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: On_RecvIdle of CallTransfer VMB is null");
                            fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                        }

                        transfering_chan_index = -1;
                        transfering_wait_chan = null;
                        transfering_chan_got_idle_evt = false;
                        transfering_addr = "";
                        transfering_replaces_callid = "";
                        transfering_replaces_chan = null;
                    }
                }
                else
                {
                    //transfering failed
                    //should check if the extension has voice mail box
                    //if it does, asking leave message.
                    if (vmb != null)
                    {
                        transfering_wait_chan.async_op_compound = new GTOpVMB(getEnv().pbx, getEnv(), transfering_wait_chan, vmb);
                        transfering_wait_chan.async_op_compound.start();
                    }
                    else
                    {
                        getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: On_RecvIdle of CallTransfer VMB is null 1");
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    }

                    transfering_chan_index = -1;
                    transfering_wait_chan = null;
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = "";
                    transfering_replaces_callid = "";
                    transfering_replaces_chan = null;
                }
                return;
            }

            if (trans_succeed)
            {
                if (ch == trans_chan.index)
                {
                    callDisconnectedTime = DateTime.Now;

                    getEnv().StopTimer(ch);

                    SIPPBXParkingSlot ps = getEnv().pbx.IsPBXChanInParkingSlot(getPBXChan());

                    if (ps != null)
                    {
                        //in parking slot right now
                        /*
                        if (ps.playMOH)
                            getEnv().Send_StartMusicOnHold(getPBXChan().index, ps.mohDir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH?1:0, 0);
                         */
                        getPBXChan().async_op_compound = new GTOpCallPark(_env.pbx, _env, _pbxChan, ps);
                        getPBXChan().async_op_compound.start();
                    }
                    else
                    {
                        if (disc_main_chan && getEnv().IsChanConnected(getPBXChan().index))
                        {
                            getEnv().DisconnectCall(getPBXChan().index, 0, "", "PBX: transfer call succeed in On_RecvIdle of CallTransfer");
                            return;
                        }
                    }

                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                }
                else if (ch == getPBXChan().index)
                {
                    callDisconnectedTime = DateTime.Now;

                    getEnv().StopTimer(ch);

                    SIPPBXParkingSlot ps = getEnv().pbx.IsPBXChanInParkingSlot(trans_chan);

                    if (ps != null)
                    {
                        //in parking slot right now
                        /*
                        if (ps.playMOH)
                            getEnv().Send_StartMusicOnHold(trans_chan.index, ps.mohDir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH?1:0, 0);
                         */
                        trans_chan.async_op_compound = new GTOpCallPark(_env.pbx, _env, trans_chan, ps);
                        trans_chan.async_op_compound.start();

                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    }
                    else
                    {
                        if (disc_trans_chan && getEnv().IsChanConnected(trans_chan.index))
                            getEnv().DisconnectCall(trans_chan.index, 0, "", "PBX: transfer call succeed in On_RecvIdle of CallTransfer");

                        //else
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    }
                }
            }
            else
            {
                disc_code = code;
                disc_desc = desc;

                if (ch == trans_chan.index)
                {
                    getEnv().StopTimer(ch);

                    if (disc_main_chan && getEnv().IsChanConnected(getPBXChan().index))
                    {
                        getEnv().DisconnectCall(getPBXChan().index, code, desc, "PBX: transfer call succeed in On_RecvIdle of CallTransfer");
                        return;
                    }

                    if (_bAborting)
                    {
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                        return;
                    }

                    if (played_ringback_tone)
                    {
                        //getEnv().Send_StopAudio(getPBXChan().index);
                        getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                        wait_for_ringback_tone_done = true;
                    }
                    else
                    {
                        if (disc_code == 300 || disc_code == 301 || disc_code == 302 || disc_code == 305)
                        {
                            int addr_idx = disc_desc.IndexOf("<sip:");
                            if (addr_idx > 0)
                            {
                                trans_chan.link_exten = null;
                                trans_chan.sip_acct = sip_acct = null;

                                callee_num = disc_desc.Substring(addr_idx);

                                trans_succeed = false;
                                played_ringback_tone = false;
                                wait_for_ringback_tone_done = false;

                                transfering_chan_index = -1;
                                transfering_wait_chan = null;
                                transfering_chan_got_idle_evt = false;
                                transfering_addr = "";
                                transfering_replaces_callid = "";
                                transfering_replaces_chan = null;

                                disc_trans_chan = true;
                                disc_main_chan = false;
                                monitor_chan = null;

                                disc_code = 0;
                                disc_desc = "";

                                audio_recording_fn = "";

                                _cl = null;

                                callConnectedTime = callDisconnectedTime = DateTime.Now;

                                beginOp();
                            }
                            else
                            {
                                fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, disc_code);
                            }
                        }
                        else
                        {
                            //not sure here why not directly use disc_code, or disc_desc
                            fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, getEnv().GetChanLastMsgCode(ch));
                        }
                    }
                }
                else if (ch == getPBXChan().index)
                {
                    if (getEnv().IsChanConnected(trans_chan.index))	
						getEnv().DisconnectCall(trans_chan.index, code, desc, "PBX: transfer call failed in On_RecvIdle of CallTransfer");
                    getEnv().StopTimer(ch);
                    abort();
                }
            }


        }

        public override void On_RecvAudioPlayDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvAudioPlayDone(ch, doneReason, dtmfBuffer);

            if (played_ringback_tone && wait_for_ringback_tone_done)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, getEnv().GetChanLastMsgCode(ch));
            }
        }

        public override void On_RecvSessionProgress(int ch)
        {
            base.On_RecvSessionProgress(ch);

            if (ch == trans_chan.index)
            {
                if (ring_seconds > 0)
                    getEnv().StartTimer(ch, Convert.ToUInt32(ring_seconds) * 1000);
            }
        }

        public override void On_RecvRinging(int ch)
        {
            base.On_RecvRinging(ch);

            if (ch == trans_chan.index)
            {
                if (!getEnv().IsChanConnected(getPBXChan().index))
                {
                    if (getPBXChan().link_exten == null && _env.pbx.pbx_sys_set.bPlayRingbackTone)
                    {
                        getEnv().Send_SessionProgress(getPBXChan().index, _env.pbx.pbx_ringback_tone);
                        played_ringback_tone = true;
                    }
                    else
                    {
                        getEnv().Send_Ring(getPBXChan().index);
                        played_ringback_tone = false;
                    }
                }
                else
                {
                    //should some kind of play ring tone.
                    if (_env.pbx.sip_set.doRTPRelay && _cl == null)
                    {
                        getEnv().Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                        getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }
                    getEnv().Send_PlayAudio(getPBXChan().index, getEnv().pbx.pbx_ringback_tone, 0, "", 0, 0);
                    played_ringback_tone = true;
                }

                if(ring_seconds > 0)
                    getEnv().StartTimer(ch, Convert.ToUInt32(ring_seconds) * 1000);
            }
        }

        public override void On_RecvDialing(int ch, string sCaller, string sCallee)
        {
            base.On_RecvDialing(ch, sCaller, sCallee);

            if (transfering_chan_index >= 0 && ch == transfering_chan_index)
            {
                getEnv().pbx.chan_list[ch].link_chan = transfering_wait_chan;
                //cannot use callee to get extension because callee may be the original callee number
                //getEnv().pbx.chan_list[ch].link_exten = getEnv().pbx.getExtensionBySIPAddr(sCallee);
                getEnv().pbx.chan_list[ch].async_op_compound = new GTOpAsyncCompound(); //a null compound, doing nothing in connected event
                transfering_wait_chan.link_chan = getEnv().pbx.chan_list[ch];
            }
        }

        public override void On_RecvError(int ch, int errCode)
        {
            base.On_RecvError(ch, errCode);
            if (ch == getPBXChan().index || ch == trans_chan.index)
            {
                if (errCode != 100042 && errCode != 100043 && errCode != 100018)
                /*some how in LOC. log, we receive these two errors for previous calling of GTOpACDMusicOnHold!
                Ignore this two errors will fix this issue:
                  [2012-05-25 16:31:18] Stop playing audio in On_RecvDTMFKeyUp
                  [2012-05-25 16:31:18] Start perform asyncronized step - GTOpACDMusicOnHold!
                  [2012-05-25 16:31:18] GTOpACDSelect::GTOpACDSelect 0
                  [2012-05-25 16:31:18] Start perform asyncronized step - GTOpACDSelect!
                  [2012-05-25 16:31:18] GTOpACDSelect --> Call[0] is on channel 0
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] Call status changed! GT_CALL_IDLE ---> GT_CALL_RESERVED
                  [2012-05-25 16:31:18] Start perform asyncronized step - GTOpCallTransfer!
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] CGTSIPAPICC::SetAudioCodec 0
                  [2012-05-25 16:31:18] NetTCPServerSideSocket - get tcp message[StopAudioEx CH 0|CODE 1|DESC 
                StartMusicOnHold CH 0|File C:\Program Files (x86)\PCBest Networks\SIP PBX v3\moh\|Random 0|MaxTime 0
                StopMusicOnHold CH 0
                RTPDuplexConnect CH1 0|CH2 4
                MakeEx CH 4|Caller "0839484046 " <sip:0473056836@210.245.15.19>|Callee <sip:0908407321@210.245.15.19>|AuthName 0473056836|AuthPassword sdfsdf
                ] from 127.0.0.1:1322
                X [2012-05-25 16:31:18] [B:0,S:0,C0,CH0] Trying to stop playing audio when it is not playing!
                  [2012-05-25 16:31:18] JB Statistic: Delivered 97.79, Late  0.00, Missing  0.00, Delay  2.34
                  [2012-05-25 16:31:18] [B:0,S:0,C0,CH0] RTP session stopped successfully!
                  [2012-05-25 16:31:18] Switch Group 5196b50 opened
                  [2012-05-25 16:31:18] Added switch group item: (null):19200(src 118.69.239.245:16994) [DTMF:101]
                  [2012-05-25 16:31:18] Switch group item SSRC changed to 578962692
                  [2012-05-25 16:31:18] Added switch group item: (null):19216(src :0) [DTMF:101]
                  [2012-05-25 16:31:18] Switch group item SSRC changed to 2495687041
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] Using user profile: 0473056836,0473056836,210.245.15.19,210.245.15.19,3600
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] DTMF payload changed to 101
                  [2012-05-25 16:31:18] Switch group item DTMF changed to 101
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] SendSIPRequestMsg 210.245.15.19:5060
                  [2012-05-25 16:31:18] Dialog Count(in sending):2
                  [2012-05-25 16:31:18] Send to 210.245.15.19:5060 
                691 Bytes Data:
                [INVITE sip:0908407321@210.245.15.19 SIP/2.0
                ......

                ]
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] Call status changed! GT_CALL_RESERVED ---> GT_CALL_DIALING
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] Calling <sip:0908407321@210.245.15.19>(uri:sip:0908407321@210.245.15.19) ...
                  [2012-05-25 16:31:18] Sending out 691 bytes! 210.245.15.19:5060

                  [2012-05-25 16:31:18] NetTCPClientSideSocket - get tcp message[Error CH 0|Reason 100042
                Error CH 0|Reason 100043
                Dialing CH 4|Caller "0839484046 " <sip:0473056836@210.245.15.19>|Callee <sip:0908407321@210.245.15.19>
                ] from 127.0.0.1:8922
                */
                {
                    if (!trans_succeed)
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, errCode);
                }
            }
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (ch == trans_chan.index)
            {
                //ring timeout
                setHwCode(1);
                //abort();
                //2012-06-27. Found a possible syncronized issue.
                //when disconnecting on dialing channel, the caller channel may be in offered status
                //fire result back will leads hanging up on dest channel and answer on caller channel happens same time
                //for RTP switch, it may cause caller channel RTP doesn't start when caller channel got connected

                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting transfer in GTOpCallTransfer::On_Timer");

                if (played_ringback_tone)
                    //getEnv().Send_StopAudio(getPBXChan().index);
                    getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                getEnv().DisconnectCall(trans_chan.index, 0, "", "PBX: ring timeout in On_Timer of CallTransfer");
            }
            else if (ch == getPBXChan().index && _cl != null)
            {
                //GTAPIASM.GTAPIChan api_chan1 = _env.GetChannel(trans_chan.index);
                //TimeSpan tsp = DateTime.Now - api_chan1.call_start_time;
                TimeSpan tsp = DateTime.Now - callConnectedTime;
                if (tsp.TotalSeconds >= _cl.Seconds - 3)
                {
                    //getEnv().DisconnectCall(getPBXChan().index, 0, "", "PBX: call limit is reached.");
                    getEnv().DisconnectCall(trans_chan.index, 0, "", "PBX: call limit is reached.");
                }
                else
                {
                    _env.pbx.playCallLimitSound(_env, getPBXChan().index, trans_chan.index);
                    _env.StartTimer(getPBXChan().index, 180000); //3 minutes left 
                }
            }
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);

            if (ch == trans_chan.index && trans_chan.link_exten != null)
            {
                trans_chan.link_dtmf += Convert.ToChar(keyValue);

                string logInfo = "GTOpCallTransfer::On_RecvDTMFKeyUp trans_chan.link_dtmf " + trans_chan.link_dtmf;
                LogoutText(3, logInfo);

                SIPPBXParkingSlot ps = getEnv().pbx.getParkingSlot(trans_chan.link_dtmf);
                if (ps != null)
                {
                    ps.pbxChan = getPBXChan();

                    //record parking slot in IVR keys:
                    string sCallPark = "CallPark:" + trans_chan.link_exten.UserName + "->" + ps.psDTMF + ";";
                    getPBXChan().ivrKeys += sCallPark;
                    trans_chan.ivrKeys += sCallPark;

                    getEnv().DisconnectCall(trans_chan.index, 0, "", "PBX: call parked in On_RecvDTMFKeyUp of CallTransfer");
                    getPBXChan().link_chan = null;
                    trans_chan.link_chan = null;
                    //fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);

                    return;
                }

                if (getEnv().pbx.isTrunkHookFlashCode(trans_chan.link_dtmf))
                {
                    getEnv().Send_PlayDTMFStr(_pbxChan.index, "X");
                    trans_chan.link_dtmf = "";
                    return;
                }

                if (trans_chan.link_dtmf.EndsWith(getEnv().pbx.blindtrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.consulttrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.trunk_blindtrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.trunk_consulttrans_code))
                {
                    logInfo = "GTOpCallTransfer::On_RecvDTMFKeyUp transfer code detected!";
                    LogoutText(3, logInfo);
                    _env.Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                }

                SIPPBXExten extn = getEnv().pbx.isBlindTransfer(trans_chan.link_dtmf);
                if (extn != null)
                {
                    LogoutText(4, "Blind transfer call to " + extn.UserName + " " + extn.IsRegistered().ToString() + " " + extn.InCalling.ToString());
                    trans_chan.async_op_compound = null;
                    getPBXChan().async_op_compound = new GTOpCallTransBlind(_env.pbx, _env, _pbxChan, trans_chan, extn);
                    getPBXChan().async_op_compound.start();
                    return;
                }

                extn = getEnv().pbx.isConsultTransfer(trans_chan.link_dtmf);
                if (extn != null)
                {
                    LogoutText(4, "Consult transfer call to " + extn.UserName + " " + extn.IsRegistered().ToString() + " " + extn.InCalling.ToString());
                    trans_chan.async_op_compound = null;
                    getPBXChan().async_op_compound = new GTOpCallTransConsult(_env.pbx, _env, _pbxChan, trans_chan, extn);
                    getPBXChan().async_op_compound.start();
                    return;
                }

                string sTrunkNum = getEnv().pbx.isTrunkBlindTransferCode(trans_chan.link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    LogoutText(4, "Trunk transfer call to " + sTrunkNum);

                    GTAPIASM.GTAPIChan apiChan = getEnv().GetChannel(_pbxChan.index);

                    string sRefID;
                    if (apiChan.originate)
                        sRefID = apiChan.callee_num;
                    else
                        sRefID = apiChan.caller_num;

                    string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sRefID);
                    string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, sRefID);

                    if (!apiChan.originate && !SIPPBXWinUtil.IsValidIPAddress(domainName))
                    {
                        domainName = _pbxChan.sFromIP;
                        if (_pbxChan.nFromPort != 5060 && _pbxChan.nFromPort != 0)
                            portName = _pbxChan.nFromPort.ToString();
                        else
                            portName = "";
                    }

                    if (portName.Length > 0)
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ":" + portName + ">";
                    else
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ">";
                    getEnv().Send_Transfer(_pbxChan.index, sTrunkNum);

                    trans_chan.link_dtmf = "";
                    return;
                }

                sTrunkNum = getEnv().pbx.isTrunkConsultTransferCode(trans_chan.link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    LogoutText(4, "Trunk Consult transfer call to " + sTrunkNum);
                    GTOpCallTransConsultTrunk transConsultTrunk = new GTOpCallTransConsultTrunk(_env.pbx, _env, _pbxChan, trans_chan, sTrunkNum);
                    _pbxChan.async_op_compound = transConsultTrunk;
                    _pbxChan.async_op_compound.start();
                    trans_chan.link_dtmf = "";
                    trans_chan.async_op_compound = null;
                    return;
                }

                SIPPBXDialPlanWrap wrap = getEnv().pbx.isDialplanTransfer(getEnv(), trans_chan, trans_chan.link_exten.UserName, trans_chan.link_exten);
                if (wrap != null)
                {
                    LogoutText(4, "GTOpCallTranswer 1: Transfer call to dialplan " + wrap.dp.planName);

                    if (wrap.trans_type == 2 && wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        trans_chan.async_op_compound = null;
                        getPBXChan().async_op_compound = new GTOpCallTransConsultDP(_env.pbx, _env, _pbxChan, trans_chan, wrap.dp, wrap.called_id);
                        getPBXChan().async_op_compound.start();
                        return;
                    }

                    LogoutText(4, "Disconnect channel " + trans_chan.index.ToString());
                    _env.DisconnectCall(trans_chan.index, 0, "", "PBX: call transfered to dialplan in On_RecvDTMFKeyUp of CallTransfer");

                    _pbxChan.dp = wrap.dp;
                    if (wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        LogoutText(4, "Run  CALL_DIR_OUTBOUND diaplan " + wrap.dp.planName);
                        GTOpOutbound outbound = new GTOpOutbound(_env.pbx, _env, _pbxChan, wrap.dp);
                        outbound._check_caller_extn = false;
                        outbound._called_id = wrap.called_id;
                        _pbxChan.async_op_compound = outbound;
                        _pbxChan.async_op_compound.start();
                    }
                    else
                    {
                        LogoutText(4, "DoDialPlan " + wrap.dp.planName);
                        _env.DoDialPlan(_pbxChan.index, _pbxChan, null, null);
                    }

                    return;
                }
            }
            else if (ch == getPBXChan().index && getPBXChan().link_exten != null)
            {
                getPBXChan().link_dtmf += Convert.ToChar(keyValue);

                string logInfo = "GTOpCallTransfer::On_RecvDTMFKeyUp getPBXChan().link_dtmf " + trans_chan.link_dtmf;
                LogoutText(3, logInfo);

                if (getPBXChan().link_dtmf.Length >= _env.pbx.magic_cancel_code.Length)
                {
                    if(getPBXChan().link_dtmf.Substring(getPBXChan().link_dtmf.Length - _env.pbx.magic_cancel_code.Length) == _env.pbx.magic_cancel_code)
                    {
                        _env.DisconnectCall(trans_chan.index, 0, "", "PBX: reached magic cancel code in On_RecvDTMFKeyUp of CallTransfer");
                    }
                }

                SIPPBXParkingSlot ps = getEnv().pbx.getParkingSlot(getPBXChan().link_dtmf);
                if (ps != null)
                {
                    ps.pbxChan = trans_chan;

                    //record parking slot in IVR keys:
                    string sCallPark = "CallPark:" + getPBXChan().link_exten.UserName + "->" + ps.psDTMF + ";";
                    getPBXChan().ivrKeys += sCallPark;
                    trans_chan.ivrKeys += sCallPark;

                    getEnv().DisconnectCall(getPBXChan().index, 0, "", "PBX: call parked in On_RecvDTMFKeyUp of CallTransfer 1");
                    getPBXChan().link_chan = null;
                    trans_chan.link_chan = null;
                    //fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    return;
                }

                if (getEnv().pbx.isTrunkHookFlashCode(_pbxChan.link_dtmf))
                {
                    getEnv().Send_PlayDTMFStr(trans_chan.index, "X");
                    _pbxChan.link_dtmf = "";
                    return;
                }

                if (getPBXChan().link_dtmf.EndsWith(getEnv().pbx.blindtrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.consulttrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.trunk_blindtrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.trunk_consulttrans_code))
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                }

                SIPPBXExten extn = getEnv().pbx.isBlindTransfer(getPBXChan().link_dtmf);
                if (extn != null)
                {
                    getPBXChan().async_op_compound = null;
                    trans_chan.async_op_compound = new GTOpCallTransBlind(_env.pbx, _env, trans_chan, _pbxChan, extn);
                    trans_chan.async_op_compound.start();
                    return;
                }

                extn = getEnv().pbx.isConsultTransfer(getPBXChan().link_dtmf);
                if (extn != null)
                {
                    getPBXChan().async_op_compound = null;
                    trans_chan.async_op_compound = new GTOpCallTransConsult(_env.pbx, _env, trans_chan, _pbxChan, extn);
                    trans_chan.async_op_compound.start();
                    return;
                }

                string sTrunkNum = getEnv().pbx.isTrunkBlindTransferCode(getPBXChan().link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTAPIASM.GTAPIChan apiChan = getEnv().GetChannel(trans_chan.index);

                    string sRefID;
                    if (apiChan.originate)
                        sRefID = apiChan.callee_num;
                    else
                        sRefID = apiChan.caller_num;

                    string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sRefID);
                    string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, sRefID);

                    if (!apiChan.originate && !SIPPBXWinUtil.IsValidIPAddress(domainName))
                    {
                        domainName = trans_chan.sFromIP;
                        if (trans_chan.nFromPort != 5060 && trans_chan.nFromPort != 0)
                            portName = trans_chan.nFromPort.ToString();
                        else
                            portName = "";
                    }

                    if (portName.Length > 0)
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ":" + portName + ">";
                    else
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ">";
                    getEnv().Send_Transfer(trans_chan.index, sTrunkNum);

                    getPBXChan().link_dtmf = "";
                    return;
                }

                sTrunkNum = getEnv().pbx.isTrunkConsultTransferCode(getPBXChan().link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTOpCallTransConsultTrunk transConsultTrunk = new GTOpCallTransConsultTrunk(_env.pbx, _env, trans_chan, _pbxChan, sTrunkNum);
                    trans_chan.async_op_compound = transConsultTrunk;
                    trans_chan.async_op_compound.start();
                    getPBXChan().link_dtmf = "";
                    getPBXChan().async_op_compound = null;
                    return;

                }

                SIPPBXDialPlanWrap wrap = getEnv().pbx.isDialplanTransfer(getEnv(), _pbxChan, _pbxChan.link_exten.UserName, _pbxChan.link_exten);
                if (wrap != null)
                {
                    LogoutText(4, "GTOpCallTranswer 2: Transfer call to dialplan " + wrap.dp.planName);

                    if (wrap.trans_type == 2 && wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        getPBXChan().async_op_compound = null;
                        trans_chan.async_op_compound = new GTOpCallTransConsultDP(_env.pbx, _env, trans_chan, _pbxChan, wrap.dp, wrap.called_id);
                        trans_chan.async_op_compound.start();
                        return;
                    }

                    //_env.Send_DuplexDisconnect(_pbxChan.index, trans_chan.index);

                    _env.DisconnectCall(_pbxChan.index, 0, "", "PBX: call transfered to dialplan in On_RecvDTMFKeyUp of CallTransfer");

                    trans_chan.dp = wrap.dp;
                    if (wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        GTOpOutbound outbound = new GTOpOutbound(_env.pbx, _env, trans_chan, wrap.dp);
                        outbound._check_caller_extn = false;
                        outbound._called_id = wrap.called_id;
                        trans_chan.async_op_compound = outbound;
                        trans_chan.async_op_compound.start();
                    }
                    else
                    {
                        _env.DoDialPlan(trans_chan.index, trans_chan, null, null);
                    }

                    getPBXChan().async_op_compound = null;
                    return;
                }
            }
        }

        public override void On_RecvHolding(int ch, int hold_on)
        {
            base.On_RecvHolding(ch, hold_on);

            GTAPIASM.GTAPIChan APIChan = _env.GetChannel(getPBXChan().index);
            GTAPIASM.GTAPIChan APIChanTrans = _env.GetChannel(trans_chan.index);

            if (ch == trans_chan.index && hold_on == 1 && APIChanTrans.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED)
            {
                _env.Send_Hold(getPBXChan().index);
            }
            else if (ch == trans_chan.index && hold_on == 0 && APIChan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING)
            {
                _env.Send_Hold(getPBXChan().index);
            }
            else if (ch == getPBXChan().index && hold_on == 1 && APIChan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED)
            {
                _env.Send_Hold(trans_chan.index);
            }
            else if (ch == getPBXChan().index && hold_on == 0 && APIChanTrans.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING)
            {
                _env.Send_Hold(trans_chan.index);
            }

            /*
            if (ch == trans_chan.index)
            {
                if (!_env.IsChanConnected(getPBXChan().index)) return;


                if (hold_on == 1)
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, ch);
                    _env.Send_StartMusicOnHold(getPBXChan().index, _env.pbx.moh_dir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);
                }
                else
                {
                    _env.Send_StopMusicOnHold(getPBXChan().index);

                    bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                    bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                    if (b1 || b2)
                    {
                        //There is already code for duplexconnect in record function.
                        //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }
                    else
                    {
                        if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay && _cl == null)
                            getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                        else
                            getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }

                }
            }
            else if (ch == getPBXChan().index)
            {
                if (!_env.IsChanConnected(trans_chan.index)) return;

                if (hold_on == 1)
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                    _env.Send_StartMusicOnHold(trans_chan.index, _env.pbx.moh_dir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);
                }
                else
                {
                    _env.Send_StopMusicOnHold(trans_chan.index);

                    bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                    bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                    if (b1 || b2)
                    {
                        //There is already code for duplexconnect in record function.
                        //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }
                    else
                    {
                        if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay && _cl == null)
                            getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                        else
                            getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }

                }
            }*/
        }

        public override void On_RecvTransfering(int ch, string sAddr, string sReplaceCallID, string sReplaceFromTag, string sReplaceToTag)
        {
            base.On_RecvTransfering(ch, sAddr, sReplaceCallID, sReplaceFromTag, sReplaceToTag);

            if (ch == getPBXChan().index && getPBXChan().link_exten != null)
            {
                _env.LOG_Trace(4, "GTOpCallTransfer::On_RecvTransfering : " + ch.ToString() + " " + sAddr + " " + sReplaceCallID);

                //trans_to_extn = getEnv().pbx.getExtensionBySIPAddr(sAddr);

                //if (trans_to_extn != null)
                {
                    //trans_org_extn = trans_chan.link_exten;
                    transfering_chan_index = ch;
                    transfering_wait_chan = trans_chan;
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = sAddr;
                    transfering_replaces_callid = sReplaceCallID;
                    transfering_replaces_chan = null;

                    if (transfering_replaces_callid.Length > 0)
                    {
                        //attended transfer
                        //there must be already another leg for replacing
                        //do duplexdisconnect first for this call
                        _env.Send_DuplexDisconnect(trans_chan.index, ch);

                        for (int i = 0; i < _env.GetChannelCount(); i++)
                        {
                            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(i);
                            string sCallID = _env.GetChanCallID(i);
                            if (sCallID.Length == 0)
                                continue;

                            _env.LOG_Trace(4, "Channel-" + i.ToString() + " CallID: " + sCallID);

                            string sCallID1;
                            int at_idx = sCallID.IndexOf('@');
                            if (at_idx >= 0)
                            {
                                sCallID1 = sCallID.Substring(0, at_idx);
                            }
                            else
                            {
                                sCallID1 = sCallID;
                            }
                            _env.LOG_Trace(4, "Channel-" + i.ToString() + " CallID1: " + sCallID1);

                            if (api_chan.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE && sReplaceCallID.IndexOf(sCallID1) == 0)
                            {
                                transfering_replaces_chan = _env.pbx.chan_list[i].link_chan;

                                if (transfering_replaces_chan != null)
                                {
                                    _env.Send_DuplexDisconnect(i, transfering_replaces_chan.index);

                                    if (_env.IsChanConnected(transfering_replaces_chan.index))
                                    {
                                        /*
                                        trans_chan.transferred = true;
                                        transfering_wait_chan.transferred = true;
                                        transfering_replaces_chan.transferred = true;

                                        _pbxChan = transfering_wait_chan;
                                        trans_chan = transfering_replaces_chan;*/

                                        //trans_chan.link_exten = getEnv().pbx.getExtensionBySIPAddr(transfering_addr);
                                        /* //In the following case, refer to address is <<sip:GTAPISIPUA-CH1@192.168.1.30:5060?...>, and actually it is calling into an extension. PBX already associated this channel into extension number. SO DO NOT SET
[2011-06-27 11:37:12] 192.168.1.20:5200 -> 192.168.1.30:5060 
750 Bytes Data:
[REFER sip:GTAPISIPUA-CH4@192.168.1.30:5060 SIP/2.0
From: <sip:9492005085@192.168.1.20>;tag=b0a77e8-0-1450-50022-2cf8c-5110fb25-2cf8c
To: <sip:9494598476@199.117.79.180:5060>;tag=1871619718198955447
Call-ID: vg4352l1309199786l12698855l4528lrx
CSeq: 1 REFER
Via: SIP/2.0/UDP 192.168.1.20:5200;branch=z9hG4bK-2cfba-afb716f-72cd93a4
Refer-To: <sip:GTAPISIPUA-CH1@192.168.1.30:5060?Replaces=b0b9c98-0-1450-50022-2cf96-1b05e9d4-2cf96Bto-tagD2735011501694121724Bfrom-tagDb0a7978-0-1450-50022-2cf96-2695c03a-2cf96>
Referred-By: <sip:9492005085@192.168.1.20>
Max-Forwards: 70
Supported: replaces
Contact: <sip:9492005085@192.168.1.20>
Allow: INVITE, CANCEL, ACK, BYE, OPTIONS, INFO, REFER, NOTIFY
Allow-Events: refer
Content-Length: 0
]
                                         */

                                        /*
                                        getPBXChan().link_chan = trans_chan;
                                        trans_chan.link_chan = getPBXChan();

                                        bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                                        bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                                        if (b1 || b2)
                                        {
                                            //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                                        }
                                        else
                                        {
                                            if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                                                getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                                            else
                                                getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                                        }

                                        //if one of the channel is in hold status
                                        //pbx is playing moh now on it
                                        //in this case, we have to stop music.
                                        getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                                        getEnv().Send_StopAudioEx(trans_chan.index, 1, "");


                                        //start DTMF detection for call parking
                                        if (getPBXChan().link_exten != null)
                                        {
                                            getPBXChan().link_dtmf = "";
                                            getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                                        }
                                        if (trans_chan.link_exten != null)
                                        {
                                            trans_chan.link_dtmf = "";
                                            getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                                        }

                                        //trans_org_extn = null;
                                        //trans_to_extn = null;
                                         */

                                        //here trans_chan == transfering_wait_chan 
                                        //getEnv().Send_StopAudioEx(transfering_wait_chan.index, 1, "");
                                        //GTOpCallBridge's member GTOpCallConnect.beginOp will call Send_StopAudioEx on trans_chan

                                        trans_chan.async_op_compound = new GTOpCallBridge(_env.pbx, getEnv(), trans_chan, transfering_replaces_chan);
                                        trans_chan.async_op_compound.start();

                                        getPBXChan().async_op_compound = null;
                                        getPBXChan().link_chan = null;

                                        trans_chan.link_chan = transfering_replaces_chan;
                                        transfering_replaces_chan.link_chan = trans_chan;


                                        transfering_chan_index = -1;
                                        transfering_wait_chan = null;
                                        transfering_chan_got_idle_evt = false;
                                        transfering_addr = "";
                                        transfering_replaces_callid = "";
                                        transfering_replaces_chan = null;

                                    }
                                    else
                                    {
                                        //in the case the transfering_replaces_chan is still in ringing..

                                        //here trans_chan == transfering_wait_chan 
                                        //getEnv().Send_StopAudioEx(transfering_wait_chan.index, 1, "");
                                        //GTOpCallBridge's member GTOpCallConnect.beginOp will call Send_StopAudioEx on trans_chan

                                        trans_chan.async_op_compound = new GTOpCallBridge(_env.pbx, getEnv(), trans_chan, transfering_replaces_chan);
                                        trans_chan.async_op_compound.start();

                                        getPBXChan().async_op_compound = null;
                                        getPBXChan().link_chan = null;

                                        trans_chan.link_chan = transfering_replaces_chan;
                                        transfering_replaces_chan.link_chan = trans_chan;
                                    }
                                }

                                _env.pbx.chan_list[i].link_chan = null;
                                _env.pbx.chan_list[i].async_op_compound = null;

                                _env.DisconnectCall(i, 0, "", "PBX: call transfering in GTOpCallTransfer a");
                                break;
                            }
                        }
                    }

                    getEnv().DisconnectCall(ch, 0, "", "PBX: call transfering in GTOpCallTransfer b");
                }

            }
            else if (ch == trans_chan.index /*&& trans_chan.link_exten != null*/)
            {
                _env.LOG_Trace(4, "GTOpCallTransfer::On_RecvTransfering : " + ch.ToString() + " " + sAddr + " " + sReplaceCallID);

//                trans_to_extn = getEnv().pbx.getExtensionBySIPAddr(sAddr);

 //               if (trans_to_extn != null)
                {
 //                   trans_org_extn = trans_chan.link_exten;
                    transfering_chan_index = ch;
                    transfering_wait_chan = getPBXChan();
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = sAddr;
                    transfering_replaces_callid = sReplaceCallID;
                    transfering_replaces_chan = null;

                    if (transfering_replaces_callid.Length > 0)
                    {
                        //attended transfer
                        //there must be already another leg for replacing
                        //do duplexdisconnect first for this call
                        _env.Send_DuplexDisconnect(getPBXChan().index, ch);

                        for (int i = 0; i < _env.GetChannelCount(); i++)
                        {
                            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(i);
                            string sCallID = _env.GetChanCallID(i);
                            if (sCallID.Length == 0)
                                continue;

                            _env.LOG_Trace(4, "Channel-" + i.ToString() + " CallID: " + sCallID);

                            string sCallID1;
                            int at_idx = sCallID.IndexOf('@');
                            if (at_idx >= 0)
                            {
                                sCallID1 = sCallID.Substring(0, at_idx);
                            }
                            else
                            {
                                sCallID1 = sCallID;
                            }
                            _env.LOG_Trace(4, "Channel-" + i.ToString() + " CallID1: " + sCallID1);

                            if (api_chan.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE && sReplaceCallID.IndexOf(sCallID1) == 0)
                            {
                                transfering_replaces_chan = _env.pbx.chan_list[i].link_chan;

                                if (transfering_replaces_chan != null)
                                {
                                    _env.Send_DuplexDisconnect(i, transfering_replaces_chan.index);

                                    if (_env.IsChanConnected(transfering_replaces_chan.index))
                                    {
                                        trans_chan.transferred = true;
                                        transfering_wait_chan.transferred = true;
                                        transfering_replaces_chan.transferred = true;

                                        _pbxChan = transfering_wait_chan;
                                        trans_chan = transfering_replaces_chan;
                                        //trans_chan.link_exten = getEnv().pbx.getExtensionBySIPAddr(transfering_addr);
                                        /* //In the following case, refer to address is <<sip:GTAPISIPUA-CH1@192.168.1.30:5060?...>, and actually it is calling into an extension. PBX already associated this channel into extension number. SO DO NOT SET
[2011-06-27 11:37:12] 192.168.1.20:5200 -> 192.168.1.30:5060 
750 Bytes Data:
[REFER sip:GTAPISIPUA-CH4@192.168.1.30:5060 SIP/2.0
From: <sip:9492005085@192.168.1.20>;tag=b0a77e8-0-1450-50022-2cf8c-5110fb25-2cf8c
To: <sip:9494598476@199.117.79.180:5060>;tag=1871619718198955447
Call-ID: vg4352l1309199786l12698855l4528lrx
CSeq: 1 REFER
Via: SIP/2.0/UDP 192.168.1.20:5200;branch=z9hG4bK-2cfba-afb716f-72cd93a4
Refer-To: <sip:GTAPISIPUA-CH1@192.168.1.30:5060?Replaces=b0b9c98-0-1450-50022-2cf96-1b05e9d4-2cf96Bto-tagD2735011501694121724Bfrom-tagDb0a7978-0-1450-50022-2cf96-2695c03a-2cf96>
Referred-By: <sip:9492005085@192.168.1.20>
Max-Forwards: 70
Supported: replaces
Contact: <sip:9492005085@192.168.1.20>
Allow: INVITE, CANCEL, ACK, BYE, OPTIONS, INFO, REFER, NOTIFY
Allow-Events: refer
Content-Length: 0
]
                                         */


                                        getPBXChan().link_chan = trans_chan;
                                        trans_chan.link_chan = getPBXChan();

                                        _env.Send_StopMusicOnHold(getPBXChan().index);
                                        _env.Send_StopMusicOnHold(trans_chan.index);

                                        bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                                        bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                                        if (b1 || b2)
                                        {
                                            //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                                        }
                                        else
                                        {
                                            if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay && _cl == null)
                                                getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                                            else
                                                getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                                        }

                                        //if one of the channel is in hold status
                                        //pbx is playing moh now on it
                                        //in this case, we have to stop music.
                                        getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                                        getEnv().Send_StopAudioEx(trans_chan.index, 1, "");

                                        //start DTMF detection for call parking
                                        if (getPBXChan().link_exten != null)
                                        {
                                            getPBXChan().link_dtmf = "";
                                            getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                                        }
                                        if (trans_chan.link_exten != null)
                                        {
                                            trans_chan.link_dtmf = "";
                                            getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                                        }

                                        transfering_chan_index = -1;
                                        transfering_wait_chan = null;
                                        transfering_chan_got_idle_evt = false;
                                        transfering_addr = "";
                                        transfering_replaces_callid = "";
                                        transfering_replaces_chan = null;

                                        //trans_org_extn = null;
                                        //trans_to_extn = null;

                                    }
                                    else
                                    {
                                        //in the case the transfering_replaces_chan is still in ringing..
                                        //getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                                        //GTOpCallBridge's member GTOpCallConnect.beginOp will call Send_StopAudioEx on getPBXChan()

                                        getPBXChan().async_op_compound = new GTOpCallBridge(_env.pbx, getEnv(), getPBXChan(), transfering_replaces_chan);
                                        getPBXChan().async_op_compound.start();

                                        getPBXChan().link_chan = transfering_replaces_chan;
                                        transfering_replaces_chan.link_chan = getPBXChan();
                                    }
                                }


                                _env.pbx.chan_list[i].link_chan = null;
                                _env.pbx.chan_list[i].async_op_compound = null;
                                _env.DisconnectCall(i, 0, "", "PBX: call disconnect in On_RecvTransfering of CallTransfer c");

                                break;
                            }
                        }
                    }

                    getEnv().DisconnectCall(ch, 0, "", "PBX: call disconnect in On_RecvTransfering of CallTransfer d");
                }
            }
            //only deal with inbound call transfering right now
/*
            else if (ch == getPBXChan().index && getPBXChan().link_exten != null)
            {
                transfering_chan_index = ch;
                transfering_wait_chan = trans_chan;
                transfering_chan_got_idle_evt = false;
                transfering_addr = sAddr;
                getPBXChan().link_exten = null;
                getEnv().Send_HungUp(ch);
            }
 */
        }
    }

    //differences between GTOpACDCallTransfer and GTOpCallTransfer
    //1. no Send_RTPDuplexConnect in beginOp
    //2. added StopMusicOnHold on original chanel
    //3. no send_answer to the first channel when second channel connected
    public class GTOpACDCallTransfer : GTOpAsync 
    {
        public string caller_num;
        public string callee_num;
        public SIPAccount sip_acct;

        public SIPPBXChan trans_chan;
        public int ring_seconds;
        public bool trans_succeed;
        public SIPPBXACDHuntGroup hunt_group;

        public int transfering_chan_index;
        public SIPPBXChan transfering_wait_chan;
        public bool transfering_chan_got_idle_evt;
        public string transfering_addr;
        public string transfering_replaces_callid;
        public SIPPBXChan transfering_replaces_chan;

        //public SIPPBXExten trans_org_extn;
        //public SIPPBXExten trans_to_extn;

        public int disc_code;
        public string disc_desc;

        public GTOpACDCallTransfer(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, SIPPBXChan pbx_chan1, string callee, string caller, int ringSeconds, SIPPBXACDHuntGroup hg, SIPAccount acct)
            : base(ac, env, pbx_chan, dtmfStr)
        {
            callee_num = callee;
            caller_num = caller;
            sip_acct = acct;

            trans_chan = pbx_chan1;
            trans_chan.sip_acct = acct;

            ring_seconds = ringSeconds;
            trans_succeed = false;
            hunt_group = hg;

            transfering_chan_index = -1;
            transfering_wait_chan = null;
            transfering_chan_got_idle_evt = false;
            transfering_addr = "";
            transfering_replaces_callid = "";
            transfering_replaces_chan = null;

            //trans_org_extn = null;
            //trans_to_extn = null;

            disc_code = 0;
            disc_desc = "";
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpACDCallTransfer!");

            if (ring_seconds < 0)
            {
                //ring timeout
                LogoutText(4, "Ring seconds < 0. Always forward! Aborting GTOpACDCallTransfer ......");
                setHwCode(1);
                abort();
                return;
            }

            getPBXChan().link_chan = trans_chan;
            trans_chan.link_chan = getPBXChan();

            getPBXChan().link_dtmf = "";
            trans_chan.link_dtmf = "";

            if (sip_acct != null)
            {
                if (_env.pbx.sip_set.bForwardPAssertedIdentity)
                {
                    string sPAssertedIdentity = getEnv().GetPAssertedIdentity(getPBXChan().index);
                    if (sPAssertedIdentity.Length > 0)
                        getEnv().SetPAssertedIdentity(trans_chan.index, sPAssertedIdentity);
                }

                if (_env.pbx.sip_set.doExtenProxy && getPBXChan().link_exten != null && trans_chan.link_exten != null)
                {
                    getEnv().Send_ProxyConnect(getPBXChan().index, trans_chan.index);
                }

                getEnv().pbx.MakeOutboundCall(getEnv(), trans_chan.index, callee_num, caller_num, sip_acct);
            }
            else
            {
                if (_env.pbx.sip_set.doExtenProxy && getPBXChan().link_exten != null && trans_chan.link_exten != null)
                {
                    getEnv().Send_ProxyConnect(getPBXChan().index, trans_chan.index);
                }

                getEnv().pbx.MakeExtensionCall(getEnv(), trans_chan.index, callee_num, caller_num, trans_chan.link_exten);
            }
        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting transfer in GTOpACDCallTransfer::abort");
                getEnv().DisconnectCall(trans_chan.index, 0, "", "PBX: Aborting transfer in GTOpACDCallTransfer::abort");
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public override void On_RecvConnected(int ch)
        {
            base.On_RecvConnected(ch);

            if (transfering_chan_index >= 0 && ch == transfering_chan_index)
            {
                //prevent unexpected disconnecting calls
                getEnv().StopTimer(ch);

                //transfering is done
                _pbxChan = transfering_wait_chan;
                trans_chan = getEnv().pbx.chan_list[transfering_chan_index];

                getPBXChan().link_chan = trans_chan;
                trans_chan.link_chan = getPBXChan();

                bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                if (b1 || b2)
                {
                    //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                }
                else
                {
                    if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                        getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                    else
                        getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                }

                getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                //start DTMF detection for call parking
                if (getPBXChan().link_exten != null)
                {
                    getPBXChan().link_dtmf = "";
                    getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                }
                if (trans_chan.link_exten != null)
                {
                    trans_chan.link_dtmf = "";
                    getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                }

                transfering_chan_index = -1;
                transfering_wait_chan = null;
                transfering_chan_got_idle_evt = false;
                transfering_addr = "";
                transfering_replaces_callid = "";
                transfering_replaces_chan = null;

                //trans_org_extn = null;
                //trans_to_extn = null;

                return;
            }

            if (ch == trans_chan.index)
            {
                getEnv().StopTimer(ch);

                if (hunt_group != null)
                {
                    if (hunt_group.playMOH)
                        getEnv().Send_StopMusicOnHold(getPBXChan().index);
                    else
                        //getEnv().Send_StopAudio(getPBXChan().index);
                        getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                }
                else
                    getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                if (b1 || b2)
                {
                    //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                }
                else
                {
                    if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(ch) && _env.pbx.sip_set.doRTPRelay)
                        getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                    else
                        getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                }
                trans_succeed = true;

                _pbxChan.call_reached_agent = true;
                trans_chan.call_reached_agent = true;
                trans_chan.acd_queue = _pbxChan.acd_queue;
                trans_chan.acd_cdr_saved = false;
                trans_chan.in_queue_time = _pbxChan.in_queue_time;
                trans_chan.out_queue_time = _pbxChan.out_queue_time;
                trans_chan.acd_to_extn = _pbxChan.acd_to_extn;

                //start DTMF detection for call parking
                if (getPBXChan().link_exten != null)
                {
                    getPBXChan().link_dtmf = "";
                    getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                }
                if (trans_chan.link_exten != null)
                {
                    trans_chan.link_dtmf = "";
                    getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                }
            }
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (transfering_chan_index >= 0 && ch == transfering_chan_index)
            {
                //prevent unexpected disconnecting calls
                getEnv().StopTimer(ch);

                if (transfering_replaces_callid.Length > 0 &&
                    transfering_replaces_chan != null)
                {

                    if (_env.IsChanConnected(transfering_replaces_chan.index))
                    {
                        _pbxChan = transfering_wait_chan;
                        trans_chan = transfering_replaces_chan;

                        getPBXChan().link_chan = trans_chan;
                        trans_chan.link_chan = getPBXChan();

                        bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                        bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                        if (b1 || b2)
                        {
                            //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                        }
                        else
                        {
                            if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                                getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                            else
                                getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                        }

                        getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                        //start DTMF detection for call parking
                        if (getPBXChan().link_exten != null)
                        {
                            getPBXChan().link_dtmf = "";
                            getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                        }
                        if (trans_chan.link_exten != null)
                        {
                            trans_chan.link_dtmf = "";
                            getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                        }

                        transfering_chan_index = -1;
                        transfering_wait_chan = null;
                        transfering_chan_got_idle_evt = false;
                        transfering_addr = "";
                        transfering_replaces_callid = "";
                        transfering_replaces_chan = null;

                        //trans_org_extn = null;
                        //trans_to_extn = null;

                        return;
                    }


                    trans_chan = transfering_replaces_chan;
                    transfering_chan_index = trans_chan.index;
                    transfering_wait_chan = _pbxChan;
                    transfering_chan_got_idle_evt = true;
                    transfering_replaces_callid = "";
                    transfering_replaces_chan = null;

                    if (_env.pbx.sip_set.doRTPRelay)
                        _env.Send_RTPDuplexConnect(_pbxChan.index, trans_chan.index);
                    else
                        _env.Send_DuplexConnect(_pbxChan.index, trans_chan.index);

                    return;
                }

                SIPPBXExten extn = getEnv().pbx.getExtensionBySIPAddr(transfering_addr);
                if (extn == null)
                {
                    string logInfo = "GTOpACDCallTransfer => Transfering to address " + transfering_addr + " is not an extension of local PBX! Call Transfering Failed!";
                    LogoutText(3, logInfo);

                    getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: " + logInfo);
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    transfering_chan_index = -1;
                    transfering_wait_chan = null;
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = "";
                    transfering_replaces_callid = "";
                    transfering_replaces_chan = null;

                    //trans_org_extn = null;
                    //trans_to_extn = null;
                    return;
                }

                VoiceMailBox vmb = extn.vmb;

                if (!transfering_chan_got_idle_evt)
                {
                    GTAPIASM.GTAPIChan api_chan = getEnv().GetChannel(transfering_wait_chan.index);

                    //doing nothing, wait until next call
                    transfering_chan_got_idle_evt = true;

                    //2013/06/20, better choose another free channel rather than transfering_chan_index,
                    //because transfering_chan_index is last call's channel, and its call_connected is changed after calling
                    //pbx's MakeExtensionCall
                    SIPPBXChan ch_tmp = _env.pbx.SeizeChannelForOutbound(_env, transfering_chan_index);

                    if (ch_tmp != null)
                    {
                        transfering_chan_index = ch_tmp.index;
                        ch_tmp.ResetAll(transfering_wait_chan.unique_call_id, transfering_wait_chan.call_dir, getEnv().pbx, extn);
                        ch_tmp.link_exten = extn;

                        ch_tmp.link_chan = transfering_wait_chan;
                        transfering_wait_chan.link_chan = ch_tmp;
                    }

                    string sCaller;
                    string sCallee;

                    if(hunt_group.bUseGroupName)
                        sCaller = SIPPBXWinUtil.BuildCallerID(api_chan, hunt_group.hgName);
                    else
                        sCaller = SIPPBXWinUtil.BuildCallerID(api_chan, "");

                    if (extn.IsRegistered() && ch_tmp != null)
                    {
                        sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, getEnv().pbx.chan_list[transfering_wait_chan.index]);

                        //changed according to settings
                        SIPPBXWinUtil.SetChanAudioCodec(extn, _env, _env.pbx, _env.pbx.chan_list[transfering_chan_index], transfering_wait_chan);

                        getEnv().pbx.SetExtenCallingState(extn, getEnv(), 10);
                        getEnv().pbx.MakeExtensionCall(getEnv(), transfering_chan_index, sCallee, sCaller, extn);

                        //make the call out first, so the transfering channel can get right RTP addresss
                        //then RTPDuplex is more safe.
                        /*
                        if (_env.IsChanConnected(transfering_wait_chan.index))
                        {
                            getEnv().Send_DuplexConnect(transfering_wait_chan.index, transfering_chan_index);
                        }
                        else*/
                        {
                            if (_env.pbx.sip_set.doRTPRelay)
                                getEnv().Send_RTPDuplexConnect(transfering_wait_chan.index, transfering_chan_index);
                            else
                                getEnv().Send_DuplexConnect(transfering_wait_chan.index, transfering_chan_index);
                        }
                    }
                    else
                    {
                        if (vmb != null)
                        {
                            transfering_wait_chan.async_op_compound = new GTOpVMB(getEnv().pbx, getEnv(), transfering_wait_chan, vmb);
                            transfering_wait_chan.async_op_compound.start();
                        }
                        else
                        {
                            getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: vmb is null in OpACDCallTransfer");
                            fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                        }


                        transfering_chan_index = -1;
                        transfering_wait_chan = null;
                        transfering_chan_got_idle_evt = false;
                        transfering_addr = "";
                        transfering_replaces_callid = "";
                        transfering_replaces_chan = null;

                        //trans_org_extn = null;
                        //trans_to_extn = null;
                    }
                }
                else
                {
                    //transfering failed
                    //should check if the extension has voice mail box
                    //if it does, asking leave message.
                    if (vmb != null)
                    {
                        transfering_wait_chan.async_op_compound = new GTOpVMB(getEnv().pbx, getEnv(), transfering_wait_chan, vmb);
                        transfering_wait_chan.async_op_compound.start();
                    }
                    else
                    {
                        getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: vmb is null in OpACDCallTransfer 1");
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    }

                    transfering_chan_index = -1;
                    transfering_wait_chan = null;
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = "";
                    transfering_replaces_callid = "";
                    transfering_replaces_chan = null;

                    //trans_org_extn = null;
                    //trans_to_extn = null;
                }
                return;
            }

            if (trans_succeed)
            {
                if (ch == trans_chan.index)
                {
                    getEnv().StopTimer(ch);

                    SIPPBXParkingSlot ps = getEnv().pbx.IsPBXChanInParkingSlot(getPBXChan());

                    if (ps != null)
                    {
                        /*
                        if (ps.playMOH)
                            getEnv().Send_StartMusicOnHold(getPBXChan().index, ps.mohDir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH?1:0, 0);
                         */
                        getPBXChan().async_op_compound = new GTOpCallPark(_env.pbx, _env, _pbxChan, ps);
                        getPBXChan().async_op_compound.start();
                    }
                    else
                    {
                        getEnv().DisconnectCall(getPBXChan().index, 0, "", "PBX: call is done successfully in On_RecvIdle of OpACDCallTransfer");
                    }

                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                }
                else if (ch == getPBXChan().index)
                {
                    getEnv().StopTimer(ch);

                    SIPPBXParkingSlot ps = getEnv().pbx.IsPBXChanInParkingSlot(trans_chan);

                    if (ps != null)
                    {
                        /*
                        if (ps.playMOH)
                            getEnv().Send_StartMusicOnHold(trans_chan.index, ps.mohDir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH?1:0, 0);
                         */
                        trans_chan.async_op_compound = new GTOpCallPark(_env.pbx, _env, trans_chan, ps);
                        trans_chan.async_op_compound.start();
                    }
                    else
                    {
                        getEnv().DisconnectCall(trans_chan.index, 0, "", "PBX: call is done successfully in On_RecvIdle in OpACDCallTransfer 1");
                    }

                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                }
            }
            else
            {
                disc_code = code;
                disc_desc = desc;
                if (ch == trans_chan.index)
                {
                    getEnv().StopTimer(ch);

                    //not sure here why not directly use disc_code, or disc_desc
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, getEnv().GetChanLastMsgCode(ch));
                }
                else if (ch == getPBXChan().index)
                {
                    if (getEnv().IsChanConnected(trans_chan.index))
                        getEnv().DisconnectCall(trans_chan.index, code, desc, "PBX: other side disconnected, so disconnect this call in On_RecvIdle of OpACDCallTransfer");				
                    getEnv().StopTimer(ch);
                    abort();
                }
            }
        }

        public override void On_RecvSessionProgress(int ch)
        {
            base.On_RecvSessionProgress(ch);

            if (ch == trans_chan.index)
            {
                if (ring_seconds > 0)
                    getEnv().StartTimer(ch, Convert.ToUInt32(ring_seconds) * 1000);
            }
        }

        public override void On_RecvRinging(int ch)
        {
            base.On_RecvRinging(ch);

            if (ch == trans_chan.index)
            {
                if (!getEnv().IsChanConnected(getPBXChan().index))
                {
                    if (getPBXChan().link_exten == null && _env.pbx.pbx_sys_set.bPlayRingbackTone)
                    {
                        getEnv().Send_SessionProgress(getPBXChan().index, _env.pbx.pbx_ringback_tone);
                    }
                    else
                        getEnv().Send_Ring(getPBXChan().index);
                }
                //for ACD call transfer. we don't play ring tone at caller end
                //because the call may come back to ACD group again, if the agent reject
/*
                else
                {
                    //should some kind of play ring tone.
                    if (hunt_group.playMOH)
                        getEnv().Send_StopMusicOnHold(getPBXChan().index);

                    //getEnv().Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                    //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    getEnv().Send_PlayAudio(getPBXChan().index, getEnv().pbx.pbx_ringback_tone, 0, "", 0, 0);
                }
*/
                if(ring_seconds > 0)
                    getEnv().StartTimer(ch, Convert.ToUInt32(ring_seconds) * 1000);
            }
        }

        public override void On_RecvDialing(int ch, string sCaller, string sCallee)
        {
            base.On_RecvDialing(ch, sCaller, sCallee);

            if (transfering_chan_index >= 0 && ch == transfering_chan_index)
            {
                getEnv().pbx.chan_list[ch].link_chan = transfering_wait_chan;
                //cannot use callee to get extension because callee may be the original callee number
                //getEnv().pbx.chan_list[ch].link_exten = getEnv().pbx.getExtensionBySIPAddr(sCallee);
                getEnv().pbx.chan_list[ch].async_op_compound = new GTOpAsyncCompound(); //a null compound, doing nothing in connected event
                transfering_wait_chan.link_chan = getEnv().pbx.chan_list[ch];
            }
        }

        public override void On_RecvError(int ch, int errCode)
        {
            base.On_RecvError(ch, errCode);
            if (ch == getPBXChan().index || ch == trans_chan.index)
            {
                if (errCode != 100042 && errCode != 100043)
                /*some how in LOC. log, we receive these two errors for previous calling of GTOpACDMusicOnHold!
                Ignore this two errors will fix this issue:
                  [2012-05-25 16:31:18] Stop playing audio in On_RecvDTMFKeyUp
                  [2012-05-25 16:31:18] Start perform asyncronized step - GTOpACDMusicOnHold!
                  [2012-05-25 16:31:18] GTOpACDSelect::GTOpACDSelect 0
                  [2012-05-25 16:31:18] Start perform asyncronized step - GTOpACDSelect!
                  [2012-05-25 16:31:18] GTOpACDSelect --> Call[0] is on channel 0
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] Call status changed! GT_CALL_IDLE ---> GT_CALL_RESERVED
                  [2012-05-25 16:31:18] Start perform asyncronized step - GTOpCallTransfer!
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] CGTSIPAPICC::SetAudioCodec 0
                  [2012-05-25 16:31:18] NetTCPServerSideSocket - get tcp message[StopAudioEx CH 0|CODE 1|DESC 
                StartMusicOnHold CH 0|File C:\Program Files (x86)\PCBest Networks\SIP PBX v3\moh\|Random 0|MaxTime 0
                StopMusicOnHold CH 0
                RTPDuplexConnect CH1 0|CH2 4
                MakeEx CH 4|Caller "0839484046 " <sip:0473056836@210.245.15.19>|Callee <sip:0908407321@210.245.15.19>|AuthName 0473056836|AuthPassword sdfsdf
                ] from 127.0.0.1:1322
                X [2012-05-25 16:31:18] [B:0,S:0,C0,CH0] Trying to stop playing audio when it is not playing!
                  [2012-05-25 16:31:18] JB Statistic: Delivered 97.79, Late  0.00, Missing  0.00, Delay  2.34
                  [2012-05-25 16:31:18] [B:0,S:0,C0,CH0] RTP session stopped successfully!
                  [2012-05-25 16:31:18] Switch Group 5196b50 opened
                  [2012-05-25 16:31:18] Added switch group item: (null):19200(src 118.69.239.245:16994) [DTMF:101]
                  [2012-05-25 16:31:18] Switch group item SSRC changed to 578962692
                  [2012-05-25 16:31:18] Added switch group item: (null):19216(src :0) [DTMF:101]
                  [2012-05-25 16:31:18] Switch group item SSRC changed to 2495687041
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] Using user profile: 0473056836,0473056836,210.245.15.19,210.245.15.19,3600
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] DTMF payload changed to 101
                  [2012-05-25 16:31:18] Switch group item DTMF changed to 101
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] SendSIPRequestMsg 210.245.15.19:5060
                  [2012-05-25 16:31:18] Dialog Count(in sending):2
                  [2012-05-25 16:31:18] Send to 210.245.15.19:5060 
                691 Bytes Data:
                [INVITE sip:0908407321@210.245.15.19 SIP/2.0
                ......

                ]
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] Call status changed! GT_CALL_RESERVED ---> GT_CALL_DIALING
                  [2012-05-25 16:31:18] [B:0,S:0,C4,CH4] Calling <sip:0908407321@210.245.15.19>(uri:sip:0908407321@210.245.15.19) ...
                  [2012-05-25 16:31:18] Sending out 691 bytes! 210.245.15.19:5060

                  [2012-05-25 16:31:18] NetTCPClientSideSocket - get tcp message[Error CH 0|Reason 100042
                Error CH 0|Reason 100043
                Dialing CH 4|Caller "0839484046 " <sip:0473056836@210.245.15.19>|Callee <sip:0908407321@210.245.15.19>
                ] from 127.0.0.1:8922
                */
                {
                    if (!trans_succeed)
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, errCode);
                }
            }
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (ch == trans_chan.index)
            {
                //ring timeout
                setHwCode(1);
                if (_env.GetChannel(ch).ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.DIALING)
                    _env.DisconnectCall(ch, 0, "", "PBX: ringing timeout in OpACDCallTransfer");
                //abort();
            }
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);

            if (ch == trans_chan.index && trans_chan.link_exten != null)
            {
                trans_chan.link_dtmf += Convert.ToChar(keyValue);

                SIPPBXParkingSlot ps = getEnv().pbx.getParkingSlot(trans_chan.link_dtmf);
                if (ps != null)
                {
                    ps.pbxChan = getPBXChan();

                    //record parking slot in IVR keys:
                    string sCallPark = "CallPark:" + trans_chan.link_exten.UserName + "->" + ps.psDTMF + ";";
                    getPBXChan().ivrKeys += sCallPark;
                    trans_chan.ivrKeys += sCallPark;

                    getEnv().DisconnectCall(trans_chan.index, 0, "", "call parked in park slot in On_RecvDTMFKeyUp of OpACDCallTransfer");
                    getPBXChan().link_chan = null;
                    trans_chan.link_chan = null;
                    return;
                }

                if (getEnv().pbx.isTrunkHookFlashCode(trans_chan.link_dtmf))
                {
                    getEnv().Send_PlayDTMFStr(_pbxChan.index, "X");
                    trans_chan.link_dtmf = "";
                    return;
                }

                if (trans_chan.link_dtmf.EndsWith(getEnv().pbx.blindtrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.consulttrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.trunk_blindtrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.trunk_consulttrans_code))
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                }

                SIPPBXExten extn = getEnv().pbx.isBlindTransfer(trans_chan.link_dtmf);
                if (extn != null)
                {
                    trans_chan.async_op_compound = null;
                    getPBXChan().async_op_compound = new GTOpCallTransBlind(_env.pbx, _env, _pbxChan, trans_chan, extn);
                    getPBXChan().async_op_compound.start();
                    return;
                }

                extn = getEnv().pbx.isConsultTransfer(trans_chan.link_dtmf);
                if (extn != null)
                {
                    trans_chan.async_op_compound = null;
                    getPBXChan().async_op_compound = new GTOpCallTransConsult(_env.pbx, _env, _pbxChan, trans_chan, extn);
                    getPBXChan().async_op_compound.start();
                    return;
                }

                string sTrunkNum = getEnv().pbx.isTrunkBlindTransferCode(trans_chan.link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTAPIASM.GTAPIChan apiChan = getEnv().GetChannel(_pbxChan.index);

                    string sRefID;
                    if (apiChan.originate)
                        sRefID = apiChan.callee_num;
                    else
                        sRefID = apiChan.caller_num;

                    string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sRefID);
                    string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, sRefID);

                    if (!apiChan.originate && !SIPPBXWinUtil.IsValidIPAddress(domainName))
                    {
                        domainName = _pbxChan.sFromIP;
                        if (_pbxChan.nFromPort != 5060 && _pbxChan.nFromPort != 0)
                            portName = _pbxChan.nFromPort.ToString();
                        else
                            portName = "";
                    }

                    if (portName.Length > 0)
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ":" + portName + ">";
                    else
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ">";
                    getEnv().Send_Transfer(_pbxChan.index, sTrunkNum);

                    trans_chan.link_dtmf = "";
                    return;
                }

                sTrunkNum = getEnv().pbx.isTrunkConsultTransferCode(trans_chan.link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTOpCallTransConsultTrunk transConsultTrunk = new GTOpCallTransConsultTrunk(_env.pbx, _env, _pbxChan, trans_chan, sTrunkNum);
                    _pbxChan.async_op_compound = transConsultTrunk;
                    _pbxChan.async_op_compound.start();
                    trans_chan.link_dtmf = "";
                    trans_chan.async_op_compound = null;
                    return;
                }

                SIPPBXDialPlanWrap wrap = getEnv().pbx.isDialplanTransfer(getEnv(), trans_chan, trans_chan.link_exten.UserName, trans_chan.link_exten);
                if (wrap != null)
                {
                    LogoutText(4, "GTOpACDCallTransfer 1: Transfer call to dialplan " + wrap.dp.planName);

                    if (wrap.trans_type == 2 && wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        trans_chan.async_op_compound = null;
                        getPBXChan().async_op_compound = new GTOpCallTransConsultDP(_env.pbx, _env, _pbxChan, trans_chan, wrap.dp, wrap.called_id);
                        getPBXChan().async_op_compound.start();
                        return;
                    }

                    //_env.Send_DuplexDisconnect(_pbxChan.index, trans_chan.index);

                    _env.DisconnectCall(trans_chan.index, 0, "", "PBX: call transfered to dialplan in On_RecvDTMFKeyUp of OpACDCallTransfer");

                    _pbxChan.dp = wrap.dp;
                    if (wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        GTOpOutbound outbound = new GTOpOutbound(_env.pbx, _env, _pbxChan, wrap.dp);
                        outbound._check_caller_extn = false;
                        outbound._called_id = wrap.called_id;
                        _pbxChan.async_op_compound = outbound;
                        _pbxChan.async_op_compound.start();
                    }
                    else
                    {
                        _env.DoDialPlan(_pbxChan.index, _pbxChan, null, null);
                    }

                    return;
                }
            }
            else if (ch == getPBXChan().index && getPBXChan().link_exten != null)
            {
                getPBXChan().link_dtmf += Convert.ToChar(keyValue);

                if (getPBXChan().link_dtmf.Length >= _env.pbx.magic_cancel_code.Length)
                {
                    if(getPBXChan().link_dtmf.Substring(getPBXChan().link_dtmf.Length - _env.pbx.magic_cancel_code.Length) == _env.pbx.magic_cancel_code)
                    {
                        _env.DisconnectCall(trans_chan.index, 0, "", "PBX: magic cancel code in On_RecvDTMFKeyUp of OpACDCallTransfer");
                    }
                }

                SIPPBXParkingSlot ps = getEnv().pbx.getParkingSlot(getPBXChan().link_dtmf);
                if (ps != null)
                {
                    ps.pbxChan = trans_chan;

                    //record parking slot in IVR keys:
                    string sCallPark = "CallPark:" + getPBXChan().link_exten.UserName + "->" + ps.psDTMF + ";";
                    getPBXChan().ivrKeys += sCallPark;
                    trans_chan.ivrKeys += sCallPark;

                    getEnv().DisconnectCall(getPBXChan().index, 0, "", "PBX: call parked in On_RecvDTMFKeyUp of OpACDCallTransfer 1");
                    getPBXChan().link_chan = null;
                    trans_chan.link_chan = null;
                    return;
                }

                if (getEnv().pbx.isTrunkHookFlashCode(_pbxChan.link_dtmf))
                {
                    getEnv().Send_PlayDTMFStr(trans_chan.index, "X");
                    _pbxChan.link_dtmf = "";
                    return;
                }

                if (getPBXChan().link_dtmf.EndsWith(getEnv().pbx.blindtrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.consulttrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.trunk_blindtrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.trunk_consulttrans_code))
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                }

                SIPPBXExten extn = getEnv().pbx.isBlindTransfer(getPBXChan().link_dtmf);
                if (extn != null)
                {
                    getPBXChan().async_op_compound = null;
                    trans_chan.async_op_compound = new GTOpCallTransBlind(_env.pbx, _env, trans_chan, _pbxChan, extn);
                    trans_chan.async_op_compound.start();
                    return;
                }

                extn = getEnv().pbx.isConsultTransfer(getPBXChan().link_dtmf);
                if (extn != null)
                {
                    getPBXChan().async_op_compound = null;
                    trans_chan.async_op_compound = new GTOpCallTransConsult(_env.pbx, _env, trans_chan, _pbxChan, extn);
                    trans_chan.async_op_compound.start();
                    return;
                }

                string sTrunkNum = getEnv().pbx.isTrunkBlindTransferCode(getPBXChan().link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTAPIASM.GTAPIChan apiChan = getEnv().GetChannel(trans_chan.index);

                    string sRefID;
                    if (apiChan.originate)
                        sRefID = apiChan.callee_num;
                    else
                        sRefID = apiChan.caller_num;

                    string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sRefID);
                    string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, sRefID);

                    if (!apiChan.originate && !SIPPBXWinUtil.IsValidIPAddress(domainName))
                    {
                        domainName = trans_chan.sFromIP;
                        if (trans_chan.nFromPort != 5060 && trans_chan.nFromPort != 0)
                            portName = trans_chan.nFromPort.ToString();
                        else
                            portName = "";
                    }

                    if (portName.Length > 0)
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ":" + portName + ">";
                    else
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ">";
                    getEnv().Send_Transfer(trans_chan.index, sTrunkNum);

                    getPBXChan().link_dtmf = "";
                    return;
                }

                sTrunkNum = getEnv().pbx.isTrunkConsultTransferCode(getPBXChan().link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTOpCallTransConsultTrunk transConsultTrunk = new GTOpCallTransConsultTrunk(_env.pbx, _env, trans_chan, _pbxChan, sTrunkNum);
                    trans_chan.async_op_compound = transConsultTrunk;
                    trans_chan.async_op_compound.start();
                    getPBXChan().link_dtmf = "";
                    getPBXChan().async_op_compound = null;
                    return;
                }

                SIPPBXDialPlanWrap wrap = getEnv().pbx.isDialplanTransfer(getEnv(), _pbxChan, _pbxChan.link_exten.UserName, _pbxChan.link_exten);
                if (wrap != null)
                {
                    LogoutText(4, "GTOpACDCallTransfer 2: Transfer call to dialplan " + wrap.dp.planName);

                    if (wrap.trans_type == 2 && wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        getPBXChan().async_op_compound = null;
                        trans_chan.async_op_compound = new GTOpCallTransConsultDP(_env.pbx, _env, trans_chan, _pbxChan, wrap.dp, wrap.called_id);
                        trans_chan.async_op_compound.start();
                        return;
                    }

                    //_env.Send_DuplexDisconnect(_pbxChan.index, trans_chan.index);

                    _env.DisconnectCall(_pbxChan.index, 0, "", "PBX: call is transfered into dialplan in On_RecvDTMFKeyUp of OpACDCallTransfer 1");

                    trans_chan.dp = wrap.dp;
                    if (wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        GTOpOutbound outbound = new GTOpOutbound(_env.pbx, _env, trans_chan, wrap.dp);
                        outbound._check_caller_extn = false;
                        outbound._called_id = wrap.called_id;
                        trans_chan.async_op_compound = outbound;
                        trans_chan.async_op_compound.start();
                    }
                    else
                    {
                        _env.DoDialPlan(trans_chan.index, trans_chan, null, null);
                    }

                    getPBXChan().async_op_compound = null;
                    return;
                }
            }
        }

        public override void On_RecvHolding(int ch, int hold_on)
        {
            base.On_RecvHolding(ch, hold_on);

            if (ch == trans_chan.index)
            {
                if (!_env.IsChanConnected(getPBXChan().index)) return;

                if (hold_on == 1)
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, ch);
                    _env.Send_StartMusicOnHold(getPBXChan().index, _env.pbx.moh_dir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);
                }
                else
                {
                    _env.Send_StopMusicOnHold(getPBXChan().index);

                    bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                    bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                    if (b1 || b2)
                    {
                        //There is already code for duplexconnect in record function.
                        //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }
                    else
                    {
                        if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                            getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                        else
                            getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }

                }
            }
            else if (ch == getPBXChan().index)
            {
                if (!_env.IsChanConnected(trans_chan.index)) return;

                if (hold_on == 1)
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, ch);
                    _env.Send_StartMusicOnHold(trans_chan.index, _env.pbx.moh_dir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);
                }
                else
                {
                    _env.Send_StopMusicOnHold(trans_chan.index);

                    bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                    bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                    if (b1 || b2)
                    {
                        //There is already code for duplexconnect in record function.
                        //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }
                    else
                    {
                        if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                            getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                        else
                            getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }

                }
            }
        }

        public override void On_RecvTransfering(int ch, string sAddr, string sReplaceCallID, string sReplaceFromTag, string sReplaceToTag)
        {
            base.On_RecvTransfering(ch, sAddr, sReplaceCallID, sReplaceFromTag, sReplaceToTag);

            if (ch == trans_chan.index /*&& trans_chan.link_exten != null*/)
            {
                _env.LOG_Trace(4, "GTOpACDCallTransfer::On_RecvTransfering : " + ch.ToString() + " " + sAddr + " " + sReplaceCallID);

                //trans_to_extn = getEnv().pbx.getExtensionBySIPAddr(sAddr);

                //if (trans_to_extn != null)
                {
                    //trans_org_extn = trans_chan.link_exten;
                    transfering_chan_index = ch;
                    transfering_wait_chan = getPBXChan();
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = sAddr;
                    transfering_replaces_callid = sReplaceCallID;
                    transfering_replaces_chan = null;

                    if (transfering_replaces_callid.Length > 0)
                    {
                        //attended transfer
                        //there must be already another leg for replacing
                        //do duplexdisconnect first for this call
                        _env.Send_DuplexDisconnect(getPBXChan().index, ch);

                        for (int i = 0; i < _env.GetChannelCount(); i++)
                        {
                            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(i);
                            string sCallID = _env.GetChanCallID(i);

                            if (sCallID.Length == 0)
                                continue;

                            _env.LOG_Trace(4, "Channel-" + i.ToString() + " CallID: " + sCallID);

                            string sCallID1;
                            int at_idx = sCallID.IndexOf('@');
                            if (at_idx >= 0)
                            {
                                sCallID1 = sCallID.Substring(0, at_idx);
                            }
                            else
                            {
                                sCallID1 = sCallID;
                            }
                            _env.LOG_Trace(4, "Channel-" + i.ToString() + " CallID1: " + sCallID1);

                            if (api_chan.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE && sReplaceCallID.IndexOf(sCallID1) == 0)
                            {
                                transfering_replaces_chan = _env.pbx.chan_list[i].link_chan;

                                if (transfering_replaces_chan != null)
                                {
                                    _env.Send_DuplexDisconnect(i, transfering_replaces_chan.index);

                                    if (_env.IsChanConnected(transfering_replaces_chan.index))
                                    {
                                        trans_chan.transferred = true;
                                        transfering_wait_chan.transferred = true;
                                        transfering_replaces_chan.transferred = true;

                                        _pbxChan = transfering_wait_chan;
                                        trans_chan = transfering_replaces_chan;
                                        //trans_chan.link_exten = getEnv().pbx.getExtensionBySIPAddr(transfering_addr);
                                        /* //In the following case, refer to address is <<sip:GTAPISIPUA-CH1@192.168.1.30:5060?...>, and actually it is calling into an extension. PBX already associated this channel into extension number. SO DO NOT SET
[2011-06-27 11:37:12] 192.168.1.20:5200 -> 192.168.1.30:5060 
750 Bytes Data:
[REFER sip:GTAPISIPUA-CH4@192.168.1.30:5060 SIP/2.0
From: <sip:9492005085@192.168.1.20>;tag=b0a77e8-0-1450-50022-2cf8c-5110fb25-2cf8c
To: <sip:9494598476@199.117.79.180:5060>;tag=1871619718198955447
Call-ID: vg4352l1309199786l12698855l4528lrx
CSeq: 1 REFER
Via: SIP/2.0/UDP 192.168.1.20:5200;branch=z9hG4bK-2cfba-afb716f-72cd93a4
Refer-To: <sip:GTAPISIPUA-CH1@192.168.1.30:5060?Replaces=b0b9c98-0-1450-50022-2cf96-1b05e9d4-2cf96Bto-tagD2735011501694121724Bfrom-tagDb0a7978-0-1450-50022-2cf96-2695c03a-2cf96>
Referred-By: <sip:9492005085@192.168.1.20>
Max-Forwards: 70
Supported: replaces
Contact: <sip:9492005085@192.168.1.20>
Allow: INVITE, CANCEL, ACK, BYE, OPTIONS, INFO, REFER, NOTIFY
Allow-Events: refer
Content-Length: 0
]
                                         */

                                        getPBXChan().link_chan = trans_chan;
                                        trans_chan.link_chan = getPBXChan();

                                        bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                                        bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                                        if (b1 || b2)
                                        {
                                            //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                                        }
                                        else
                                        {
                                            if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                                                getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                                            else
                                                getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                                        }

                                        //if one of the channel is in hold status
                                        //pbx is playing moh now on it
                                        //in this case, we have to stop music.
                                        getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                                        getEnv().Send_StopAudioEx(trans_chan.index, 1, "");

                                        //start DTMF detection for call parking
                                        if (getPBXChan().link_exten != null)
                                        {
                                            getPBXChan().link_dtmf = "";
                                            getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                                        }
                                        if (trans_chan.link_exten != null)
                                        {
                                            trans_chan.link_dtmf = "";
                                            getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                                        }

                                        transfering_chan_index = -1;
                                        transfering_wait_chan = null;
                                        transfering_chan_got_idle_evt = false;
                                        transfering_addr = "";
                                        transfering_replaces_callid = "";
                                        transfering_replaces_chan = null;

                                        //trans_org_extn = null;
                                        //trans_to_extn = null;

                                    }
                                    else
                                    {
                                        //in the case the transfering_replaces_chan is still in ringing..
                                        //getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                                        //GTOpCallBridge's member GTOpCallConnect.beginOp will call Send_StopAudioEx on getPBXChan()

                                        getPBXChan().async_op_compound = new GTOpCallBridge(_env.pbx, getEnv(), getPBXChan(), transfering_replaces_chan);
                                        getPBXChan().async_op_compound.start();

                                        getPBXChan().link_chan = transfering_replaces_chan;
                                        transfering_replaces_chan.link_chan = getPBXChan();
                                    }
                                }


                                _env.pbx.chan_list[i].link_chan = null;
                                _env.pbx.chan_list[i].async_op_compound = null;
                                _env.DisconnectCall(i, 0, "", "PBX: call disconnected in On_RecvTransfering in OpACDCallTransfer");
                                break;
                            }
                        }
                    }

                    getEnv().DisconnectCall(ch, 0, "", "PBX: call disconnected in On_RecvTransfering in OpACDCallTransfer 1");
                }
            }
            //only deal with inbound call transfering right now
/*
            else if (ch == getPBXChan().index && getPBXChan().link_exten != null)
            {
                transfering_chan_index = ch;
                transfering_wait_chan = trans_chan;
                transfering_chan_got_idle_evt = false;
                transfering_addr = sAddr;
                getPBXChan().link_exten = null;
                getEnv().Send_HungUp(ch);
            }
 */
        }

    }

/*
    public class GTOpACDCallConnect : GTOpAsync
    {
        public SIPPBXChan trans_chan;
        public SIPPBXACDHuntGroup hunt_group;

        public GTOpACDCallConnect(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, SIPPBXChan pbx_chan1, SIPPBXACDHuntGroup hg)
            : base(ac, env, pbx_chan, dtmfStr)
        {
            trans_chan = pbx_chan1;
            hunt_group = hg;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpACDCallConnect!");

            getPBXChan().link_chan = trans_chan;
            trans_chan.link_chan = getPBXChan();

            getPBXChan().link_dtmf = "";
            trans_chan.link_dtmf = "";

            if (hunt_group != null)
            {
                if (hunt_group.playMOH)
                    _env.Send_StopMusicOnHold(_pbxChan.index);
            }

            bool b1 = getPBXChan().Record(getEnv(), trans_chan);
            bool b2 = trans_chan.Record(getEnv(), getPBXChan());

            if (b1 || b2)
            {
                //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
            }
            else
            {
                if (_env.GetChanAudioCodec(_pbxChan.index) == _env.GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                    _env.Send_RTPDuplexConnect(_pbxChan.index, trans_chan.index);
                else
                    _env.Send_DuplexConnect(_pbxChan.index, trans_chan.index);
            }

            //start DTMF detection for call parking
            if (getPBXChan().link_exten != null)
            {
                getPBXChan().link_dtmf = "";
                getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
            }
            if (trans_chan.link_exten != null)
            {
                trans_chan.link_dtmf = "";
                getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
            }
        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting transfer in GTOpACDCallConnect::abort");
                getEnv().Send_HangUp(_pbxChan.index, 0, "");
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public override void On_RecvIdle(int ch)
        {
            if (ch == trans_chan.index)
            {
                getPBXChan().link_chan = null;
                trans_chan.link_chan = null;
                getEnv().Send_HangUp(getPBXChan().index, 0, "");
                fireDone(ResultCode.OP_RESULT_SUCCESS, 0);
            }
            else if (ch == getPBXChan().index)
            {
                getPBXChan().link_chan = null;
                trans_chan.link_chan = null;
                getEnv().Send_HangUp(trans_chan.index, 0, "");
                fireDone(ResultCode.OP_RESULT_SUCCESS, 0);
            }

            base.On_RecvIdle(ch);
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);

            if (ch == trans_chan.index && trans_chan.link_exten != null)
            {
                trans_chan.link_dtmf += Convert.ToChar(keyValue);
                SIPPBXParkingSlot ps = getEnv().pbx.getParkingSlot(trans_chan.link_dtmf);
                if (ps != null)
                {
                    ps.pbxChan = getPBXChan();
                    getPBXChan().link_chan = null;
                    trans_chan.link_chan = null;

                    getEnv().Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);

                    getPBXChan().async_op_compound = new GTOpCallPark(_env.pbx, _env, _pbxChan, ps);
                    getPBXChan().async_op_compound.start();

                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    return;
                }

                if (getEnv().pbx.isTrunkHookFlashCode(trans_chan.link_dtmf))
                {
                    getEnv().Send_PlayDTMFStr(_pbxChan.index, "X");
                    trans_chan.link_dtmf = "";
                    return;
                }

                if (trans_chan.link_dtmf.EndsWith(getEnv().pbx.blindtrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.consulttrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.trunk_blindtrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.trunk_consulttrans_code))
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                }

                SIPPBXExten extn = getEnv().pbx.isBlindTransfer(trans_chan.link_dtmf);
                if (extn != null)
                {
                    trans_chan.async_op_compound = null;
                    getPBXChan().async_op_compound = new GTOpCallTransBlind(_env.pbx, _env, _pbxChan, trans_chan, extn);
                    getPBXChan().async_op_compound.start();
                    return;
                }

                extn = getEnv().pbx.isConsultTransfer(trans_chan.link_dtmf);
                if (extn != null)
                {
                    trans_chan.async_op_compound = null;
                    getPBXChan().async_op_compound = new GTOpCallTransConsult(_env.pbx, _env, _pbxChan, trans_chan, extn);
                    getPBXChan().async_op_compound.start();
                    return;
                }

                string sTrunkNum = getEnv().pbx.isTrunkBlindTransferCode(trans_chan.link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTAPIASM.GTAPIChan apiChan = getEnv().GetChannel(_pbxChan.index);

                    string sRefID;
                    if (apiChan.originate)
                        sRefID = apiChan.callee_num;
                    else
                        sRefID = apiChan.caller_num;

                    string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sRefID);
                    string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, sRefID);

                    if (!apiChan.originate && !SIPPBXWinUtil.IsValidIPAddress(domainName))
                    {
                        domainName = _pbxChan.sFromIP;
                        if (_pbxChan.nFromPort != 5060 && _pbxChan.nFromPort != 0)
                            portName = _pbxChan.nFromPort.ToString();
                        else
                            portName = "";
                    }

                    if (portName.Length > 0)
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ":" + portName + ">";
                    else
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ">";
                    getEnv().Send_Transfer(_pbxChan.index, sTrunkNum);

                    trans_chan.link_dtmf = "";
                    return;
                }

                sTrunkNum = getEnv().pbx.isTrunkConsultTransferCode(trans_chan.link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTOpCallTransConsultTrunk transConsultTrunk = new GTOpCallTransConsultTrunk(_env.pbx, _env, _pbxChan, trans_chan, sTrunkNum);
                    _pbxChan.async_op_compound = transConsultTrunk;
                    _pbxChan.async_op_compound.start();
                    trans_chan.link_dtmf = "";
                    trans_chan.async_op_compound = null;
                    return;
                }

                SIPPBXDialPlanWrap wrap = getEnv().pbx.isDialplanTransfer(trans_chan, trans_chan.link_exten.UserName, trans_chan.link_exten);
                if (wrap != null)
                {
                    if (wrap.trans_type == 2 && wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        trans_chan.async_op_compound = null;
                        getPBXChan().async_op_compound = new GTOpCallTransConsultDP(_env.pbx, _env, _pbxChan, trans_chan, wrap.dp, wrap.called_id);
                        getPBXChan().async_op_compound.start();
                        return;
                    }

                    //_env.Send_DuplexDisconnect(_pbxChan.index, trans_chan.index);

                    _env.Send_HangUp(trans_chan.index, 0, "");

                    _pbxChan.dp = wrap.dp;
                    if (wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        GTOpOutbound outbound = new GTOpOutbound(_env.pbx, _env, _pbxChan, wrap.dp);
                        outbound._check_caller_extn = false;
                        outbound._called_id = wrap.called_id;
                        _pbxChan.async_op_compound = outbound;
                        _pbxChan.async_op_compound.start();
                    }
                    else
                    {
                        _env.DoDialPlan(_pbxChan.index, _pbxChan, null, null);
                    }

                    return;
                }
            }
            else if (ch == getPBXChan().index && getPBXChan().link_exten != null)
            {
                getPBXChan().link_dtmf += Convert.ToChar(keyValue);
                SIPPBXParkingSlot ps = getEnv().pbx.getParkingSlot(getPBXChan().link_dtmf);
                if (ps != null)
                {
                    ps.pbxChan = trans_chan;
                    getPBXChan().link_chan = null;
                    trans_chan.link_chan = null;
                    getEnv().Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);

                    getPBXChan().async_op_compound = new GTOpCallPark(_env.pbx, _env, trans_chan, ps);
                    getPBXChan().async_op_compound.start();

                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);

                    return;
                }

                if (getEnv().pbx.isTrunkHookFlashCode(_pbxChan.link_dtmf))
                {
                    getEnv().Send_PlayDTMFStr(trans_chan.index, "X");
                    _pbxChan.link_dtmf = "";
                    return;
                }

                if (getPBXChan().link_dtmf.EndsWith(getEnv().pbx.blindtrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.consulttrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.trunk_blindtrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.trunk_consulttrans_code))
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                }

                SIPPBXExten extn = getEnv().pbx.isBlindTransfer(getPBXChan().link_dtmf);
                if (extn != null)
                {
                    getPBXChan().async_op_compound = null;
                    trans_chan.async_op_compound = new GTOpCallTransBlind(_env.pbx, _env, trans_chan, _pbxChan, extn);
                    trans_chan.async_op_compound.start();
                    return;
                }

                extn = getEnv().pbx.isConsultTransfer(getPBXChan().link_dtmf);
                if (extn != null)
                {
                    getPBXChan().async_op_compound = null;
                    trans_chan.async_op_compound = new GTOpCallTransConsult(_env.pbx, _env, trans_chan, _pbxChan, extn);
                    trans_chan.async_op_compound.start();
                    return;
                }

                string sTrunkNum = getEnv().pbx.isTrunkBlindTransferCode(getPBXChan().link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTAPIASM.GTAPIChan apiChan = getEnv().GetChannel(trans_chan.index);

                    string sRefID;
                    if (apiChan.originate)
                        sRefID = apiChan.callee_num;
                    else
                        sRefID = apiChan.caller_num;

                    string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sRefID);
                    string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, sRefID);

                    if (!apiChan.originate && !SIPPBXWinUtil.IsValidIPAddress(domainName))
                    {
                        domainName = trans_chan.sFromIP;
                        if (trans_chan.nFromPort != 5060 && trans_chan.nFromPort != 0)
                            portName = trans_chan.nFromPort.ToString();
                        else
                            portName = "";
                    }

                    if (portName.Length > 0)
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ":" + portName + ">";
                    else
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ">";
                    getEnv().Send_Transfer(trans_chan.index, sTrunkNum);

                    getPBXChan().link_dtmf = "";
                    return;
                }

                sTrunkNum = getEnv().pbx.isTrunkConsultTransferCode(getPBXChan().link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTOpCallTransConsultTrunk transConsultTrunk = new GTOpCallTransConsultTrunk(_env.pbx, _env, trans_chan, _pbxChan, sTrunkNum);
                    trans_chan.async_op_compound = transConsultTrunk;
                    trans_chan.async_op_compound.start();
                    getPBXChan().link_dtmf = "";
                    getPBXChan().async_op_compound = null;
                    return;
                }

                SIPPBXDialPlanWrap wrap = getEnv().pbx.isDialplanTransfer(_pbxChan, _pbxChan.link_exten.UserName, _pbxChan.link_exten);
                if (wrap != null)
                {
                    if (wrap.trans_type == 2 && wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        getPBXChan().async_op_compound = null;
                        trans_chan.async_op_compound = new GTOpCallTransConsultDP(_env.pbx, _env, trans_chan, _pbxChan, wrap.dp, wrap.called_id);
                        trans_chan.async_op_compound.start();
                        return;
                    }

                    //_env.Send_DuplexDisconnect(_pbxChan.index, trans_chan.index);

                    _env.Send_HangUp(_pbxChan.index, 0, "");

                    trans_chan.dp = wrap.dp;
                    if (wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        GTOpOutbound outbound = new GTOpOutbound(_env.pbx, _env, trans_chan, wrap.dp);
                        outbound._check_caller_extn = false;
                        outbound._called_id = wrap.called_id;
                        trans_chan.async_op_compound = outbound;
                        trans_chan.async_op_compound.start();
                    }
                    else
                    {
                        _env.DoDialPlan(trans_chan.index, trans_chan, null, null);
                    }

                    getPBXChan().async_op_compound = null;
                    return;
                }
            }
        }
    }*/

}
