using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using System.Data.SqlClient;
using Microsoft.Win32;
using System.Reflection;
using System.Net;
using System.Net.Sockets;

namespace SIPPBXv3
{
    class GTOpConference : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPConferRoom _conf;
        public SIPPBXChan _chan;
        public int _opt;

        public GTOpAudioPlayEx _op_audio_play;
        public GTOpAudioPlay _op_audio_play_error;
        public GTOpConfAudioPlay _op_moh;

        public int _err_cnt;
        public bool _be_host;

        public GTOpConference(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPConferRoom conf, int opt)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _conf = conf;
            _opt = opt;
            _err_cnt = 0;
            _be_host = false;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpConference::start()########################====>>");

            if (hasPassword(_conf))
            {
                if(_conf.attendance_need_password)
                {
                    playHostPasswordPrompt(0);
                    return;
                }
                else
                {
                    if (!IsHostIn())
                    {
                        playHostPasswordPrompt(0);
                        return;
                    }
                }
            }

            //no password protection.
            //depends on if there are other channels in the conference room.
            //if there is not, please moh if set
            SetChanIntoConferenceRoom();

        }

        public void playHostPasswordPrompt(int opt)
        {
            List<string> audio_files = new List<string>();

            if (_conf.join_prompt.Length > 0)
                audio_files.Add(_conf.join_prompt);

            if (opt == 1) //wrong password
            {
                audio_files.Add(Application.StartupPath + "\\audio\\wrong-password.wav");
            }

            audio_files.Add(_conf.host_pw_prompt);

            List<string> dtmf_opts = new List<string>();
            dtmf_opts.Add(_conf.host_pw);

            _op_audio_play = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, audio_files, dtmf_opts, 4, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
            _op_audio_play.perform();
        }
        
        public bool IsHostIn()
        {
			for(int i=0; i<_conf.conf_chans.Count; i++)
			{
                try
                {
                    if (_conf.conf_chans[i].async_op_compound != null)
                    {
                        GTOpConference conf_comp = (GTOpConference)_conf.conf_chans[i].async_op_compound;
                        if (conf_comp._be_host) return true;
                    }
                }
                catch (Exception ex)
                {
                    _env.LogoutText(ex.ToString());
                }
			}
			return false;		
		}

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            _env.LOG_Trace(4, "GTOpConference::done()");

            if (opAsync == _op_audio_play)
            {
                string psw = _op_audio_play.getDTMFStr();
                psw.TrimEnd('#');

                if (psw == "")
                {
                    _env.LOG_Trace(4, "GTOpConference::done() psw is null");
                    if (_conf.attendance_need_password)
                    {
                        _err_cnt++;

                        if (_err_cnt == 3)
                        {
                            List<string> audio_files = new List<string>();
                            audio_files.Add(Application.StartupPath + "\\audio\\too-many-errors.wav");

                            _op_audio_play_error = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, null, 0, "", 0);
                            _op_audio_play_error.perform();
                        }
                        else
                        {
                            playHostPasswordPrompt(1);
                        }
                    }
                    else
                    {
                        //not hoster, depends on if hoster is in
                        if (!IsHostIn()) //if host is not in, set to monitor(listening) model when adding into conference room
                            _opt = 2;
                        SetChanIntoConferenceRoom();
                    }
                }
                else if (psw == _conf.host_pw)
                {
                    if (_conf.attendance_need_password)
                    {
                        _env.LOG_Trace(4, "GTOpConference::done() psw is host password and attendance_need_password");
                        SetChanIntoConferenceRoom();
                    }
                    else
                    {
                        _env.LOG_Trace(4, "GTOpConference::done() psw is host password and !attendance_need_password " + _conf.conf_chans.Count.ToString());

                        //host is in. depends on how many users in conference call already.
                        //stop the music first
                        if (_conf.moh_dir.Length > 0)
                            _env.Send_ConfStopAudioEx(_env.GetConfIndex(_conf.conf_handle), 1, "");

                        //bring others back to talking status
                        for (int i = 0; i < _conf.conf_chans.Count; i++)
                        {
                            try
                            {
                                if (_conf.conf_chans[i].async_op_compound != null)
                                {
                                    GTOpConference conf_comp = (GTOpConference)_conf.conf_chans[i].async_op_compound;
                                    conf_comp._opt = 1; //switch _opt back to 1 - adding into conference room model	
                                }
                            }
                            catch (Exception ex)
                            {
                                _env.LogoutText(ex.ToString());
                            }
                            _env.SetChanInConf(_conf.conf_handle, _conf.conf_chans[i].index, 1);
                        }

                        _be_host = true;

                        SetChanIntoConferenceRoom();
                    }
                }
                else
                {
                    _err_cnt++;

                    if (_err_cnt == 3)
                    {
                        List<string> audio_files = new List<string>();
                        audio_files.Add(Application.StartupPath + "\\audio\\too-many-errors.wav");

                        _op_audio_play_error = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, null, 0, "", 0);
                        _op_audio_play_error.perform();
                    }
                    else
                    {
                        playHostPasswordPrompt(1);
                    }
                }
            }
            else if (opAsync == _op_audio_play_error)
            {
				string logInfo = "GTOpConference::done(too many errors) on channel " + _chan.index.ToString() + ". Disconnecting call...";
                opAsync.LogoutText(4, logInfo);
                _env.DisconnectCall(_chan.index, 0, "", "PBX: " + logInfo);
            }
            else if (opAsync == _op_moh && result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
            {
                if (_conf.moh_dir.Length > 0)
                {
                    string[] filePaths = Directory.GetFiles(_conf.moh_dir, "*.wav");

                    List<string> audio_files = new List<string>();

                    for (int i = 0; i < filePaths.Length; i++)
                    {
                        audio_files.Add(filePaths[i]);
                    }

                    _op_moh = new GTOpConfAudioPlay(this, _env, _chan, audio_files, _conf);
                    _op_moh.perform();
                }
            }

        }

        public bool SetChanIntoConferenceRoom()
        {
            bool ret = true;
            SIPConferRoom room = _conf;

            _env.LOG_Trace(4, "SetChanIntoConferenceRoom()");

            if (room.conf_max_num > 0)
            {
                if (room.conf_chans.Count < room.conf_max_num)
                {
                    _env.LOG_Trace(4, "GTOpConference::SetChanIntoConferenceRoom ch:" + _chan.index.ToString() + " opt:" + _opt.ToString());
                    _env.SetChanInConf(room.conf_handle, _chan.index, _opt);
                    _chan.conf_opt = _opt;
                    room.conf_chans.Add(_chan);

                    _pbx.manager.SendConferenceStatus(room, IntPtr.Zero);
                }
                else
                {
                    string logInfo = "Cannot add channel into conference room(" + room.conf_name + ") for incoming calls, because it has reached the max number of calls for this conference room.";
                    _env.LogoutText(logInfo);
                    _env.DisconnectCall(_chan.index, 0, "PBX: " + logInfo);
                    ret = false;
                }
            }
            else
            {
                _env.LOG_Trace(4, "GTOpConference::SetChanIntoConferenceRoom ch:" + _chan.index.ToString() + " opt:" + _opt.ToString());

                _env.SetChanInConf(room.conf_handle, _chan.index, _opt);
                _chan.conf_opt = _opt;
                room.conf_chans.Add(_chan);

                _pbx.manager.SendConferenceStatus(room, IntPtr.Zero);
            }

            _env.LOG_Trace(4, "SetChanIntoConferenceRoom channels " + room.conf_chans.Count.ToString() + " MOH:" + room.moh_dir);

            if (ret)
            {
                if (room.conf_chans.Count == 1)
                {
                    _env.LOG_Trace(4, "SetChanIntoConferenceRoom() room.conf_chans.Count=1");
                    if (_conf.moh_dir.Length > 0)
                    {
                        string[] filePaths = Directory.GetFiles(_conf.moh_dir, "*.wav");

                        List<string> audio_files = new List<string>();

                        if (room.join_prompt.Length > 0)
                            audio_files.Add(room.join_prompt);

                        //should add prompt to tell only one user in conference right now. need waiting
                        audio_files.Add(Application.StartupPath + "\\audio\\conf-onlyone.wav");

                        for (int i = 0; i < filePaths.Length; i++)
                        {
                            audio_files.Add(filePaths[i]);
                        }

                        _op_moh = new GTOpConfAudioPlay(this, _env, _chan, audio_files, _conf);
                        _op_moh.perform();
                    }
                    else
                    {
                        //one user(should be the first user), no moh set, still play join_prompt if set
                        if (room.join_prompt.Length > 0)
                        {
                            _env.Send_ConfPlayAudio(_env.GetConfIndex(room.conf_handle), room.join_prompt, 0, "", 0, 0);
                        }
                    }

                    //one user, so you should start recording
                    StartConfRecord();

                }
                else
                {
                    _env.LOG_Trace(4, "SetChanIntoConferenceRoom() room.conf_chans.Count=" + room.conf_chans.Count.ToString());
                    //more than one user(call) in conference room
                    if (room.conf_chans.Count == 2 && room.moh_dir.Length > 0)
                    {
                        if (hasPassword(room))
                        {
                            _env.LOG_Trace(4, "SetChanIntoConferenceRoom() hasPassword");
                            //password protected. will stop audio in conf when host is in.
                            //here do not stop audio
                            //but in case that hoster is already in first, 

                            if (_conf.attendance_need_password)
                            {
                                if (_conf.moh_dir.Length > 0)
                                    _env.Send_ConfStopAudioEx(_env.GetConfIndex(_conf.conf_handle), 1, "");
                            }
                            else
                            {

                                if (IsHostIn())
                                {
                                    _env.LOG_Trace(4, "SetChanIntoConferenceRoom() IsHostIn && !attendance_need_password");
                                    if (_conf.moh_dir.Length > 0)
                                        _env.Send_ConfStopAudioEx(_env.GetConfIndex(_conf.conf_handle), 1, "");

                                    //bring others back to talking status
                                    for (int i = 0; i < _conf.conf_chans.Count; i++)
                                    {
                                        try
                                        {
                                            if (_conf.conf_chans[i].async_op_compound != null)
                                            {
                                                GTOpConference conf_comp = (GTOpConference)_conf.conf_chans[i].async_op_compound;
                                                conf_comp._opt = 1; //switch _opt back to 1 - adding into conference room model	
                                            }
                                        }
                                        catch (Exception ex)
                                        {
                                            _env.LogoutText(ex.ToString());
                                        }
                                        _env.SetChanInConf(_conf.conf_handle, _conf.conf_chans[i].index, 1);
                                    }

                                }
                            }
                        }
                        else
                        {
                            //second user joined in. Because conference room has MOH set.
                            //Stop audio on it first
                            _env.Send_ConfStopAudioEx(_env.GetConfIndex(room.conf_handle), 1, "");
                        }
                    }

                    //play join_prompt if set
                    if (_be_host)
                    {
                        //play join-in sound according to how many users already in
                        if (room.join_prompt.Length > 0)
                        {
                            _env.Send_ConfClearAudio(_env.GetConfIndex(room.conf_handle));
                            for (int i = 0; i < room.conf_chans.Count - 1; i++)
                            {
                                _env.Send_ConfAddAudio(_env.GetConfIndex(room.conf_handle), room.join_prompt, 0);
                            }
                            _env.Send_ConfPlayAudio(_env.GetConfIndex(room.conf_handle), "", 0, "", 0, 0);
                        }
                    }
                    else
                    {
                        if (room.join_prompt.Length > 0)
                            _env.Send_ConfPlayAudio(_env.GetConfIndex(room.conf_handle), room.join_prompt, 0, "", 0, 0);
                        
                    }
                }

                _chan.confName = room.conf_name;
                if (room.conf_record)
                {
                    _chan.RecordFileName = room.rec_file;
                    _chan.doConfRecordConvert = false;
                }
            }

            return ret;
        }

        public bool hasPassword(SIPConferRoom room)
        {
            if (room.host_pw.Length > 0 && room.host_pw_prompt.Length > 0)
                return true;

            return false;
        }

        public void RemoveChanFromConferenceRoom()
        {
            SIPConferRoom room = _conf;
            if (room.conf_chans.Contains(_chan))
            {
                room.conf_chans.Remove(_chan);
                _chan.conf_opt = 0;

                _pbx.manager.SendConferenceStatus(room, IntPtr.Zero);

                if (hasPassword(room) && _be_host) //password protected, and host leave
                {
                    //disconnect other people
                    for (int i = 0; i < room.conf_chans.Count; i++)
                    {
                        _env.DisconnectCall(room.conf_chans[i].index, 0, "", "PBX: host leave in conference room");
                    }

                    room.conf_chans.Clear();

                    _env.Send_ConfStopAudioEx(_env.GetConfIndex(room.conf_handle), 0, "");
                    StopConfRecord();
                    _chan.doConfRecordConvert = true;

                    return;
                }

                if (room.conf_chans.Count > 1)
                {
                    if(room.leave_prompt.Length > 0)
                    {
                        //there are still members in conference room. play leaving prompt
                        _env.Send_ConfPlayAudio(_env.GetConfIndex(room.conf_handle), room.leave_prompt, 0, "", 0, 0);
                    }
                }
                else if (room.conf_chans.Count > 0)
                {
                    //only one user left. if no password protected, disconnect the last one
                    //if there is password, it must be host left, don't disconnect
                    if (room.disc_call && !hasPassword(room))
                    {
                        room.conf_chans[0].doConfRecordConvert = true;
                        _env.DisconnectCall(room.conf_chans[0].index, 0, "", "PBX: disconnect last user in conference room");
                        StopConfRecord();
                    }
                    else
                    {
                        if (_conf.moh_dir.Length > 0)
                        {
                            //set moh for one user
                            string[] filePaths = Directory.GetFiles(_conf.moh_dir, "*.wav");

                            List<string> audio_files = new List<string>();

                            if (room.leave_prompt.Length > 0)
                                audio_files.Add(room.leave_prompt);

                            //should add prompt for one person.
                            audio_files.Add(Application.StartupPath + "\\audio\\conf-onlyone.wav");

                            for (int i = 0; i < filePaths.Length; i++)
                            {
                                audio_files.Add(filePaths[i]);
                            }

                            if (room.conf_chans[0].async_op_compound != null)
                            {
                                GTOpConference conf_comp = (GTOpConference)room.conf_chans[0].async_op_compound;
                                conf_comp._op_moh = new GTOpConfAudioPlay(conf_comp, _env, _chan, audio_files, _conf);
                                conf_comp._op_moh.perform();
                            }
                        }
                        else if (room.leave_prompt.Length > 0)
                        {
                            //there are still members in conference room. play leaving prompt
                            _env.Send_ConfPlayAudio(_env.GetConfIndex(room.conf_handle), room.leave_prompt, 0, "", 0, 0);
                        }
                    }
                }
                else //if(room.conf_chans.Count == 0)
                {
                    _env.Send_ConfStopAudioEx(_env.GetConfIndex(room.conf_handle), 0, "");
                    StopConfRecord();
                    _chan.doConfRecordConvert = true;
                }
            }
        }

        void StartConfRecord()
        {
            SIPConferRoom room = _conf;
            if (room.conf_record)
            {
                DateTime tNow = DateTime.Now;
                string rec_file = _pbx.record_dir + "conference\\";
                _pbx.CreateDir(rec_file);
                rec_file += room.conf_name + "\\";
                _pbx.CreateDir(rec_file);
                rec_file += SIPPBXWinUtil.GetDirDateTime(tNow) + "\\";
                _pbx.CreateDir(rec_file);

                rec_file += room.conf_name + "-" + tNow.ToString("yyyyMMdd-HHmmss") + "-" + SIPPBXWinUtil.RandomString(6, true);

                if (_env.pbx.AudioFormat == 1) //mp3
                    rec_file += ".mp3";
                else
                    rec_file += ".wav";

                _env.Send_ConfRecordAudio(_env.GetConfIndex(room.conf_handle), rec_file, 0, "", 0, 0);

                room.rec_file = rec_file;
            }
        }

        void StopConfRecord()
        {
            SIPConferRoom room = _conf;
            if (room.conf_record)
            {
                _env.Send_ConfStopAudioEx(_env.GetConfIndex(room.conf_handle), 2, "");
            }
        }
    }

    public class GTOpConfAudioPlay : GTOpAsync
    {
        public List<string> audio_file_list;
        public SIPConferRoom _conf;

        public GTOpConfAudioPlay(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, List<string> a_f, SIPConferRoom conf)
            : base(ac, env, pbx_chan, "")
        {
            audio_file_list = a_f;
            _conf = conf;
        }

        public override void beginOp()
        {
            base.beginOp();

            LogoutText(4, "Start perform asyncronized step - GTOpConfAudioPlay!");

            if (audio_file_list == null)
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, -1);

            if(audio_file_list.Count == 0)
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, -1);

            int conf_idx = _env.GetConfIndex(_conf.conf_handle);

            _env.Send_ConfStopAudioEx(conf_idx, 1, "");
            _env.Send_ConfClearAudio(conf_idx);
            for (int i = 0; i < audio_file_list.Count; i++)
            {
                _env.Send_ConfAddAudio(conf_idx, audio_file_list[i], 0);
            }

            _env.Send_ConfPlayAudio(conf_idx, "", 0, "", 0, 0);
        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting playing audio in GTOpConfAudioPlay");
                //getEnv().Send_StopAudio(getPBXChan().index);
                getEnv().Send_ConfStopAudioEx(_env.GetConfIndex(_conf.conf_handle), 1, "");
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public override void On_RecvConfAudioPlayDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvConfAudioPlayDone(ch, doneReason, dtmfBuffer);

            int ch1 = _env.GetConfIndex(_conf.conf_handle);

            _env.LOG_Trace(4, "GTOpConfAudioPlay::On_RecvConfAudioPlayDone " + ch.ToString() + " " + ch1.ToString());

            if (ch != ch1)
                return;

            switch (doneReason)
            {
                case 0: //GT_AUDIO_DONE_DTMF_TIMEOUT
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_TIMEOUT, 0);
                    break;
                case 1: //GT_AUDIO_DONE_DTMF_MAX_DIGITS
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 1);
                    break;
                case 2: //GT_AUDIO_DONE_DTMF_DIGIT_DETECTED
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 2);
                    break;
                case 3: //GT_AUDIO_DONE_PLAY
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 3);
                    break;
                case 5: //GT_AUDIO_DONE_FORCED_STOP
                    //if (isAborting())
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                    //else
                        //fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 5);
                    break;
            }
        }


    }


}
