using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    class GTOpDialExten : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXDialPlan  _dp;
        public SIPPBXChan _chan;
        public GTOpCallTransfer _op_call_transfer;
        public GTOpAnswerCall _op_answer_call;
        public SIPPBXExten _exten;

        public GTOpDialExten(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXDialPlan dp, SIPPBXExten extn):base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _dp = dp;
            _exten = extn;
            _op_call_transfer = null;
            _op_answer_call = null;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpDialExten::start()########################====>>");

            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);
            SIPPBXExten extn = _exten;

            string caller_num = SIPPBXWinUtil.BuildCallerID(api_chan, "");
            string caller_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
            string called_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num); 

            if (extn != null)
            {
                if (extn.IsVirtualExten())
                {
                    //calling to a virtual extension
                    if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                    {
                        //sip address
                        string sipDestAddr = extn.VirtualExtenDestAddr.Replace("*", called_num);

                        if (sipDestAddr.Contains("sip:"))
                        {
                            if (!transferCall(sipDestAddr, caller_num, extn, null))
                            {
                                //no enough idle channel for outbound
                                toVMB(extn);
                            }
                        }
                        else
                        {
                            if (!transferCall("<sip:" + sipDestAddr + ">", caller_num, extn, null))
                            {
                                //no enough idle channel for outbound
                                toVMB(extn);
                            }
                        }
                    }
                    else
                    {
                        //to see if it matchs any outbound rules
                        SIPPBXVirExtenTransferWrap wrap = _env.pbx.transferCallToVirtualExtension(_env, extn, _chan, caller_num, called_num);

                        if (wrap != null)
                        {
                            if (!transferCall(wrap.callee, wrap.caller, wrap.extn, wrap.acct))
                            {
                                toVMB(extn);
                            }
                        }
                        else
                        {
                            //cannot find right SIP account for outbound
                            toVMB(extn);
                        }

                        /*
                        SIPPBXDialPlan dp1 = _pbx.getDialPlanByCalledNum(_env, extn.VirtualExtenDestAddr, "", GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, caller_num), _pbx.getExtensionBySIPAddr(caller_num), 1);
                        if (dp1 != null)
                        {
                            SIPAccount sip_acct = _pbx.getDialPlanSIPAccount(dp1);
                            if (sip_acct != null)
                            {
                                //outbound, should take out predix digit, then use another channel to dialout
                                string destaddr = dp1.OutboundPrepend + extn.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                                if (extn.bAcceptOtherID && called_num.Length > 0)
                                    destaddr = called_num;
                                destaddr += "@" + sip_acct.DomainServer;
                                destaddr = "<sip:" + destaddr + ">";

                                string fromaddr = sip_acct.UserName;
                                if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                                {
                                    SIPPBXExten ext0 = _pbx.getExtensionBySIPAddr(caller_num);
                                    if (ext0 != null)
                                    {
                                        if (ext0.AlternativePhoneNumber.Length > 0)
                                        {
                                            fromaddr = ext0.AlternativePhoneNumber;
                                        }
                                        else if (sip_acct.DIDList.Count > 0)
                                        {
                                            fromaddr = sip_acct.DIDList[0];
                                            if (sip_acct.OutboundAppendExtenID)
                                            {
                                                fromaddr += ext0.UserName;
                                            }
                                        }
                                    }
                                    else
                                    {
                                        fromaddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
                                        if (fromaddr == "unknown")
                                            fromaddr = sip_acct.UserName;
                                    }
                                }

                                if (fromaddr == "")
                                {
                                    if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                        fromaddr = caller_username;
                                    else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                        fromaddr = sip_acct.DIDList[0];
                                    else if (sip_acct.UserName.Length > 0)
                                        fromaddr = sip_acct.UserName;
                                    else
                                        fromaddr = "unknown";
                                }

                                if (sip_acct.UseLocalIPInFrom)
                                {
                                    if (_pbx.sip_set.sipAddr.Length > 0)
                                        fromaddr += "@" + _pbx.sip_set.sipAddr;
                                    else
                                        fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                                }
                                else
                                    fromaddr += "@" + sip_acct.DomainServer;
                                fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";

                                if (!transferCall(destaddr, fromaddr, extn, sip_acct))
                                {
                                    //no enough idle channel for outbound
                                    toVMB(extn);
                                }
                            }
                            else
                            {
                                //cannot find right SIP account for outbound
                                toVMB(extn);
                            }
                        }
                        else
                        {
                            //no matched outbound dialplan
                            toVMB(extn);
                        }*/
                    }
                }
                else
                {
                    //regular extension
                    if (extn.IsRegistered() && (extn.InCalling == 0 || extn.bMultipleCalls))
                    {
                        string sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, _chan);

                        if (!transferCall(sCallee, caller_num, extn, null))
                        {
                            //no enough idle channel for outbound
                            toVMB(extn);
                        }
                    }
                    else
                    {
                        //not registered yet(offline)
                        toVMB(extn);
                    }
                }
            }

        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _op_call_transfer)
            {
                if (_env.IsChanConnected(_chan.index))
                {
                    if (_pbx.IsPBXChanInParkingSlot(_chan) == null)
                    {
                        if (!_op_call_transfer.trans_succeed)
                        {
                            if (_exten != null)
                            {
                                toVMB(_exten);
                            }
                            else
                            {
                                //shouldn't reach here
                            }
                        }
                        else
                        {
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: succeed in done of OpDialExten 1");
                        }
                    }
                }
                else
                {
                    if (!_op_call_transfer.trans_succeed)
                    {
                        if (_exten != null)
                        {
                            toVMB(_exten);
                        }
                        else
                        {
                            //shouldn't reach here
                        }
                    }
                    else
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: succeed in done of OpDialExten");
                    }
                }
            }
            else if (opAsync == _op_answer_call)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_exten != null)
                    {
                        SIPPBXWinUtil.DoCallForwardingForExtension(_pbx, _env, _chan, _exten);
                    }
                    else
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: _exten is null in done of OpDialExten");
                    }
                }
                else
                {
                    //call cannot be answered. must be idle already.
                }
            }
        }


        public bool transferCall(string callee, string caller, SIPPBXExten extn, SIPAccount acct)
        {
            SIPPBXChan chan2 = _pbx.SeizeChannelForOutbound(_env);
            //GTAPIASM.GTAPIChan api_chan = null;

            if (chan2 == null)
            {
                _env.LogoutText("GTOpDialExten::transferCall SeizeChannelForOutbound return null. No enough outbound channel for calling!");
                return false;
            }

            chan2.ResetAll(_chan.unique_call_id, _chan.call_dir, _pbx, extn);
            chan2.link_exten = extn;
            if(extn != null)
                if (extn.RingTimeoutSec >= 0) //as for -1, it is always forwarding. won't make call out so this state is not updated if set to 10.
                    _pbx.SetExtenCallingState(extn, _env, 10); //offered
            _op_call_transfer = new GTOpCallTransfer(this, _env, _chan, _chan.DTMFBuf, chan2, callee, caller, (extn != null) ? extn.RingTimeoutSec : 0, acct);
            _op_call_transfer.perform();

            return true;
        }

        public void toVMB(SIPPBXExten extn)
        {
            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);
            if (api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED)
            {
                _op_answer_call = new GTOpAnswerCall(this, _env, _chan);
                _op_answer_call.perform();
            }
            else if (_env.IsChanConnected(_chan.index))
            {
                SIPPBXWinUtil.DoCallForwardingForExtension(_pbx, _env, _chan, extn);
            }
        }

    }


}
