using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace SIPPBXv3
{
    public class GTOpMonitorGroup : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXMonitorGroup _mg;
        public SIPPBXChan _chan;
        public GTOpAudioPlayEx _audio_password;
        public GTOpAudioPlayEx _audio_extensions;
        public GTOpCallMonitor _call_monitor;
        public GTOpCallWait _call_wait;
        public SIPPBXExten _no_extn;
        public int _error_cnt;

        public GTOpMonitorGroup(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXMonitorGroup mg, SIPPBXExten noextn)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _mg = mg;
            _no_extn = noextn;
            _error_cnt = 0;

        }


        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpMonitorGroup::start()########################====>>");

            if (_mg.mgPassword.Length > 0)
            {
                StartPasswordAudio();
            }
            else
            {
                StartExtenAudio();
            }
        }

        public void StartPasswordAudio()
        {
            List<string> a_list = new List<string>();
            a_list.Add(_mg.mgPasswordPrompt);

            List<string> d_list = new List<string>();
            d_list.Add(_mg.mgPassword);

            _chan.DTMFBuf = "";
            _audio_password = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, _mg.mgPassword.Length, "#", 20000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
            _audio_password.perform();
        }

        public void StartExtenAudio()
        {
            string no_extn_num = "";
            if (_no_extn != null)
                no_extn_num = _no_extn.UserName;

            List<string> a_list = new List<string>();
            a_list.Add(_mg.mgExtenPrompt);

            List<string> d_list = new List<string>();
            int max_digits = 0;
            if (_mg.mgAllExtens)
            {
                for (int i = 0; i < _pbx.sip_exten.Count; i++)
                {
                    if (no_extn_num != _pbx.sip_exten[i].UserName)
                    {
                        d_list.Add(_pbx.sip_exten[i].UserName);
                        if (_pbx.sip_exten[i].UserName.Length > max_digits)
                            max_digits = _pbx.sip_exten[i].UserName.Length;
                    }
                }
            }
            else
            {
                for (int i = 0; i < _mg.mgExtenList.Count; i++)
                {
                    if (no_extn_num != _pbx.sip_exten[i].UserName)
                    {
                        d_list.Add(_mg.mgExtenList[i]);
                        if (_mg.mgExtenList[i].Length > max_digits)
                            max_digits = _mg.mgExtenList[i].Length;
                    }
                }
            }

            _chan.DTMFBuf = "";
            _audio_extensions = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, max_digits, "#", 20000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
            _audio_extensions.perform();

        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _call_wait)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_call_wait._Tag == 0)
                    {
                        StartPasswordAudio();
                    }
                    else if (_call_wait._Tag == 1)
                    {
                        StartExtenAudio();
                    }
                }
                else
                {
                    //call already disconnected
                }
            }
            else if (opAsync == _audio_password)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    _error_cnt = 0;
                    //StartExtenAudio();
                    _call_wait = new GTOpCallWait(this, _env, _chan, "", 1000, 1);
                    _call_wait.perform();
                }
                else
                {
                    if (++_error_cnt >= 3)
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: password error in MonitorGroup");
                    }
                    else
                    {
                        //StartPasswordAudio();
                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 1000, 0);
                        _call_wait.perform();
                    }
                }
            }
            else if (opAsync == _audio_extensions)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    _error_cnt = 0;
                    _call_monitor = new GTOpCallMonitor(this, _env, _chan, _audio_extensions.getDTMFStr().TrimEnd('#'), _mg);
                    _call_monitor.perform();
                }
                else
                {
                    if (++_error_cnt >= 3)
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: audio_extensions error in MonitorGroup");
                    }
                    else
                    {
                        //StartExtenAudio();
                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 1000, 1);
                        _call_wait.perform();
                    }
                }
            }
            else if (opAsync == _call_monitor)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (hwStatus == 0)
                    {
                        _error_cnt = 0;
                        //StartExtenAudio();
                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 1000, 1);
                        _call_wait.perform();
                    }
                    else
                    {
                        //call should have been already disconnected
                    }
                }
                else
                {
                    _error_cnt = 0;
                    //StartExtenAudio();
                    _call_wait = new GTOpCallWait(this, _env, _chan, "", 1000, 1);
                    _call_wait.perform();
                }
            }
        }
        
    }

    public class GTOpCallMonitor: GTOpAsync
    {
        public SIPPBXMonitorGroup _mg;
        public SIPPBXExten _extn;
        public SIPPBXChan _extn_chan;
        public IntPtr _conf;
        public string _dtmf_str;
        public bool _b_whisper_or_bargin;

        public GTOpCallMonitor(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string extnname, SIPPBXMonitorGroup mg)
            : base(ac, env, pbx_chan, "")
        {
            _extn = env.pbx.getExtensionByName(extnname);
            _conf = IntPtr.Zero;
            _extn_chan = null;
            _dtmf_str = "";
            _mg = mg;
            _b_whisper_or_bargin = false;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpCallMonitor!");

            if (_extn != null)
            {
                if (_extn.InCalling == 30)
                {
                    _extn_chan = getEnv().pbx.getChanByExten(_extn);
                    if (_extn_chan != null)
                    {
                        if (_extn_chan.link_chan != null)
                        {
                            //in a bridge call.
                            getEnv().Send_DuplexDisconnect(_extn_chan.index, _extn_chan.link_chan.index);
                            _conf = getEnv().pbx.getSpareConf(getEnv());
                            getEnv().StartTimer(getPBXChan().index, 200);
                        }
                        else
                        {
                            fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                        }
                    }
                    else
                    {
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                    }
                }
                else
                {
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                }
            }
            else
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
            }
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (ch == getPBXChan().index)
            {
                if (_extn_chan != null)
                {
                    getEnv().SetChanInConf(_conf, _extn_chan.index, 1);
                    if(_extn_chan.link_chan != null)
                        getEnv().SetChanInConf(_conf, _extn_chan.link_chan.index, 1);
                }
                getEnv().SetChanConfMask(getPBXChan().index, 0xffffffff); 
                getEnv().SetChanInConf(_conf, getPBXChan().index, 2);
                getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
            }

        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch == getPBXChan().index)
            {
                if (_extn_chan != null)
                {
                    getEnv().SetChanInConf(_conf, _extn_chan.index, 0);
                    if (_extn_chan.link_chan != null)
                        getEnv().SetChanInConf(_conf, _extn_chan.link_chan.index, 0);
                }
                getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                getEnv().pbx.retSpareConf(_conf);
                _conf = IntPtr.Zero;

                if (_extn_chan != null && _extn_chan.link_chan != null)
                    getEnv().Send_DuplexConnect(_extn_chan.index, _extn_chan.link_chan.index);

                fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 1);
            }
            else
            {
                bool bCheck = false;
                if (_extn_chan != null)
                {
                    if(ch == _extn_chan.index)
                        bCheck = true;
                }
                if(_extn_chan.link_chan != null)
                {
                    if(ch == _extn_chan.link_chan.index)
                        bCheck = true;
                }

                if (bCheck)
                {
                    getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                    getEnv().pbx.retSpareConf(_conf);  //getEnv().DestroyConf(); May cause crash as some channel is still feeding frames. Recycle it first. Fixes on 2017/08/05
                    _conf = IntPtr.Zero;

                    getEnv().Send_DisableDTMF(getPBXChan().index);

                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                }
            }
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);

            if (ch != getPBXChan().index)
                return;

            char dtmf_char = Convert.ToChar(keyValue);

            _dtmf_str += dtmf_char;

            if (_dtmf_str == _mg.mgKeyWhisper)
            {
                if (!_b_whisper_or_bargin)
                {
                    getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                    //only speak to the first channel(extension) - Whisper
                    getEnv().SetChanConfMask(getPBXChan().index, 0x01);
                    getEnv().SetChanInConf(_conf, getPBXChan().index, 1);
                    _b_whisper_or_bargin = true;
                }
                else
                {
                    getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                    getEnv().SetChanConfMask(getPBXChan().index, 0xffffffff);
                    getEnv().SetChanInConf(_conf, getPBXChan().index, 2);
                    _b_whisper_or_bargin = false;
                }
            }
            else if (_dtmf_str == _mg.mgKeyBargeIn)
            {
                //because the supervisor only listening at begining,
                //so need to take him out first, then put it back to normal conference room
                if (!_b_whisper_or_bargin)
                {
                    getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                    getEnv().SetChanConfMask(getPBXChan().index, 0xffffffff);
                    getEnv().SetChanInConf(_conf, getPBXChan().index, 1);
                    _b_whisper_or_bargin = true;
                }
                else
                {
                    getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                    getEnv().SetChanConfMask(getPBXChan().index, 0xffffffff);
                    getEnv().SetChanInConf(_conf, getPBXChan().index, 2);
                    _b_whisper_or_bargin = false;
                }
            }
            else if (_dtmf_str == _mg.mgKeyOut)
            {
                if (_extn_chan != null)
                {
                    getEnv().SetChanInConf(_conf, _extn_chan.index, 0);
                    if(_extn_chan.link_chan != null)
                        getEnv().SetChanInConf(_conf, _extn_chan.link_chan.index, 0);
                }
                getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                getEnv().pbx.retSpareConf(_conf);  //getEnv().DestroyConf(); May cause crash as some channel is still feeding frames. Recycle it first. Fixes on 2017/08/05
                _conf = IntPtr.Zero;

                getEnv().Send_DisableDTMF(getPBXChan().index);

                if (_extn_chan != null && _extn_chan.link_chan != null)
                {
                    if (getEnv().GetChanAudioCodec(_extn_chan.index) == getEnv().GetChanAudioCodec(_extn_chan.link_chan.index) && _env.pbx.sip_set.doRTPRelay)
                        getEnv().Send_RTPDuplexConnect(_extn_chan.index, _extn_chan.link_chan.index);
                    else
                        getEnv().Send_DuplexConnect(_extn_chan.index, _extn_chan.link_chan.index);
                }

                fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
            }

            _dtmf_str = "";

        }

    }

    public class GTOpMonitorCmd : GTOpAsyncCompound
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public SIPPBXExten _extnSupervisor;
        public SIPPBXExten _extnAgent;
        public int _monitorType;
        public GTOpCallMonitorEx _callmonitor;

        public GTOpMonitorCmd(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXExten extnSupervisor, SIPPBXExten extnAgent, int monitorType)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _extnSupervisor = extnSupervisor;
            _extnAgent = extnAgent;
            _monitorType = monitorType;
        }

        public override void start()
        {
            base.start();

            _callmonitor = new GTOpCallMonitorEx(this, _env, _chan, _extnSupervisor, _extnAgent, _monitorType);
            _callmonitor.perform();

        }

    }

    public class GTOpCallMonitorEx : GTOpAsync
    {
        public SIPPBXExten _extn;
        public SIPPBXChan _extn_chan;
        public IntPtr _conf;
        public bool _b_whisper_or_bargin;

        public SIPPBXExten _extnSupervisor;
        public SIPPBXExten _extnAgent;
        public int _monitorType;

        public GTOpCallMonitorEx(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, SIPPBXExten extnSupervisor, SIPPBXExten extnAgent, int monitorType)
            : base(ac, env, pbx_chan, "")
        {
            _extnAgent = _extn = extnAgent;
            _conf = IntPtr.Zero;
            _extn_chan = null;
            _b_whisper_or_bargin = false;
            _extnSupervisor = extnSupervisor;
            _monitorType = monitorType;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpCallMonitorEx!");

            _extn_chan = getEnv().pbx.getChanByExten(_extn);
            if (_extn_chan != null)
            {
                if (_extn_chan.link_chan != null)
                {
                    //in a bridge call.
                    getEnv().Send_DuplexDisconnect(_extn_chan.index, _extn_chan.link_chan.index);
                    _conf = getEnv().pbx.getSpareConf(getEnv());
                    getEnv().StartTimer(getPBXChan().index, 200);
                }
                else
                {
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                }
            }
            else
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
            }

        }

        public void ProcessMonitorCallCommand(SIPPBXExten supervisorExten, SIPPBXExten normalExten, int monitorType)
        {
            LogoutText(4, "Start perform ProcessMonitorCallCommand - GTOpCallMonitorEx! " + supervisorExten.UserName + " " + normalExten.UserName + " " + monitorType.ToString());

            if (supervisorExten != _extnSupervisor || normalExten != _extnAgent)
            {
                LogoutText(4, "GTOpCallMonitorEx! Supervisor extension or agent extension is not same with previous value!");

                DoGetOut();

                _extnAgent = _extn = normalExten;
                _conf = IntPtr.Zero;
                _extn_chan = null;
                _b_whisper_or_bargin = false;
                _extnSupervisor = supervisorExten;
                _monitorType = monitorType;

                perform();
            }
            else
            {
                if (_monitorType != monitorType)
                {
                    _monitorType = monitorType;

                    if (_monitorType == 0) //listen
                    {
                        DoListen();
                    }
                    else if (_monitorType == 1) //whisper
                    {
                        DoWhisper();
                    }
                    else if (_monitorType == 2) //BargeIn
                    {
                        DoBargeIn();
                    }
                    else if (_monitorType == -1) //out
                    {
                        DoGetOut();
                    }
                }
                else
                {
                    _env.pbxMain.LogoutText("Already in monitoring status " + _monitorType.ToString());
                }
            }

        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (ch == getPBXChan().index)
            {
                if (_extn_chan != null)
                {
                    getEnv().SetChanInConf(_conf, _extn_chan.index, 1);
                    if (_extn_chan.link_chan != null)
                        getEnv().SetChanInConf(_conf, _extn_chan.link_chan.index, 1);
                }

                if (_monitorType == 0) //listen
                {
                    DoListen();
                }
                else if (_monitorType == 1) //whisper
                {
                    DoWhisper();
                }
                else if (_monitorType == 2) //BargeIn
                {
                    DoBargeIn();
                }
                else if (_monitorType == -1) //out
                {
                    DoGetOut();
                }
            }

        }

        public void SendServerEventToClient(string extenSupervisor, string extenAgent, int monitorType)
        {
            string sEventCmd = "";
            sEventCmd += extenSupervisor + "|" + extenAgent + "|" + monitorType.ToString();
            _env.pbx.manager.SendEvent("CallMonitoring", sEventCmd);
        }

        public void DoListen()
        {
            getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
            getEnv().SetChanConfMask(getPBXChan().index, 0xffffffff);
            getEnv().SetChanInConf(_conf, getPBXChan().index, 2);

            SendServerEventToClient(_extnSupervisor.UserName, _extnAgent.UserName, 0);
        }

        public void DoWhisper()
        {
            //if (!_b_whisper_or_bargin)
            {
                getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                //only speak to the first channel(extension) - Whisper
                getEnv().SetChanConfMask(getPBXChan().index, 0x01);
                getEnv().SetChanInConf(_conf, getPBXChan().index, 1);
                _b_whisper_or_bargin = true;

                SendServerEventToClient(_extnSupervisor.UserName, _extnAgent.UserName, 1);
            }
            /*
            else
            {
                getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                getEnv().SetChanConfMask(getPBXChan().index, 0xffffffff);
                getEnv().SetChanInConf(_conf, getPBXChan().index, 2);
                _b_whisper_or_bargin = false;

                SendServerEventToClient(_extnSupervisor.UserName, _extnAgent.UserName, 0);
            }*/

        }

        public void DoBargeIn()
        {
            //because the supervisor only listening at begining,
            //so need to take him out first, then put it back to normal conference room
            //if (!_b_whisper_or_bargin)
            {
                getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                getEnv().SetChanConfMask(getPBXChan().index, 0xffffffff);
                getEnv().SetChanInConf(_conf, getPBXChan().index, 1);
                _b_whisper_or_bargin = true;
                SendServerEventToClient(_extnSupervisor.UserName, _extnAgent.UserName, 2);
            }
            /*
            else
            {
                getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                getEnv().SetChanConfMask(getPBXChan().index, 0xffffffff);
                getEnv().SetChanInConf(_conf, getPBXChan().index, 2);
                _b_whisper_or_bargin = false;
                SendServerEventToClient(_extnSupervisor.UserName, _extnAgent.UserName, 0);

            }*/
        }

        public void DoGetOut()
        {
            if (_extn_chan != null)
            {
                getEnv().SetChanInConf(_conf, _extn_chan.index, 0);
                if (_extn_chan.link_chan != null)
                    getEnv().SetChanInConf(_conf, _extn_chan.link_chan.index, 0);
            }
            getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
            getEnv().pbx.retSpareConf(_conf);  //getEnv().DestroyConf(); May cause crash as some channel is still feeding frames. Recycle it first. Fixes on 2017/08/05
            _conf = IntPtr.Zero;

            if (_extn_chan != null && _extn_chan.link_chan != null)
            {
                if (getEnv().GetChanAudioCodec(_extn_chan.index) == getEnv().GetChanAudioCodec(_extn_chan.link_chan.index) && _env.pbx.sip_set.doRTPRelay)
                    getEnv().Send_RTPDuplexConnect(_extn_chan.index, _extn_chan.link_chan.index);
                else
                    getEnv().Send_DuplexConnect(_extn_chan.index, _extn_chan.link_chan.index);
            }

            SendServerEventToClient(_extnSupervisor.UserName, _extnAgent.UserName, -1);

            fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch == getPBXChan().index)
            {
                if (_extn_chan != null)
                {
                    getEnv().SetChanInConf(_conf, _extn_chan.index, 0);
                    if (_extn_chan.link_chan != null)
                        getEnv().SetChanInConf(_conf, _extn_chan.link_chan.index, 0);
                }
                getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                getEnv().pbx.retSpareConf(_conf);  //getEnv().DestroyConf(); May cause crash as some channel is still feeding frames. Recycle it first. Fixes on 2017/08/05
                _conf = IntPtr.Zero;

                if (_extn_chan != null && _extn_chan.link_chan != null)
                    getEnv().Send_DuplexConnect(_extn_chan.index, _extn_chan.link_chan.index);

                fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 1);
            }
            else
            {
                bool bCheck = false;
                if (_extn_chan != null)
                {
                    if (ch == _extn_chan.index)
                        bCheck = true;
                }
                if (_extn_chan.link_chan != null)
                {
                    if (ch == _extn_chan.link_chan.index)
                        bCheck = true;
                }

                if (bCheck)
                {
                    getEnv().SetChanInConf(_conf, getPBXChan().index, 0);
                    getEnv().pbx.retSpareConf(_conf);  //getEnv().DestroyConf(); May cause crash as some channel is still feeding frames. Recycle it first. Fixes on 2017/08/05
                    _conf = IntPtr.Zero;
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                }
            }
        }

    }



}
