using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpRingGroup : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXRingGroup _rg;
        public SIPPBXChan _chan;
        public string _moh_dir;
        public GTOpRingGroupDial op_ringgroup_dial;
        public GTOpCallConnect op_call_connect;
        public GTOpAnswerCall op_answercall;

        public GTOpRingGroup(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXRingGroup rg, string moh_dir)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _rg = rg;
            _moh_dir = moh_dir;
            op_ringgroup_dial = null;
            op_call_connect = null;
            op_answercall = null;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpRingGroup::start()########################====>>");

            if (_rg.playMOH && _env.IsChanConnected(_chan.index))
                _env.Send_StartMusicOnHold(_chan.index, _rg.mohDir, _pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);

            op_ringgroup_dial = new GTOpRingGroupDial(this, _env, _chan, _chan.DTMFBuf, _rg, 30);
            op_ringgroup_dial.perform();
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == op_answercall)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    op_call_connect = new GTOpCallConnect(this, _env, _chan, op_ringgroup_dial.trans_chans[0], null);
                    op_call_connect.perform();
                }
                else
                {
                    //couldn't answer the caller somehow
                    _env.DisconnectCall(op_ringgroup_dial.trans_chans[0].index, 0, "", "PBX: ringgroup caller disconnected unexpected.");
                }
            }
            else if (opAsync == op_ringgroup_dial)
            {
                if (_rg.playMOH && _env.IsChanConnected(_chan.index))
                    _env.Send_StopMusicOnHold(_chan.index);

                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS && op_ringgroup_dial.trans_chans.Count > 0)
                {
                    if (_env.GetChannel(_chan.index).ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED)
                    {
                        op_answercall = new GTOpAnswerCall(this, _env, _chan);
                        op_answercall.perform();
                    }
                    else
                    {
                        op_call_connect = new GTOpCallConnect(this, _env, _chan, op_ringgroup_dial.trans_chans[0], null);
                        op_call_connect.perform();
                    }
                }
                else
                {
                    if (_rg.vmb != null)
                    {
                        _chan.async_op_compound = new GTOpVMB(_pbx, _env, _chan, _rg.vmb);
                        _chan.async_op_compound.start();
                    }
                    else
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: _rg.vmb ringgroup vmb is null in OpRingGroup");
                }
            }
            else if (opAsync == op_call_connect)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                }
                else
                {
                    if (_rg.vmb != null)
                    {
                        _chan.async_op_compound = new GTOpVMB(_pbx, _env, _chan, _rg.vmb);
                        _chan.async_op_compound.start();
                    }
                    else
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: _rg.vmb ringgroup vmb is null in OpRingGroup 1");
                }
            }
        }

    }

    public class GTOpRingGroupDial : GTOpAsync
    {
        public List<SIPPBXChan> trans_chans;
        public int ring_seconds;
        public bool trans_succeed;
        public SIPPBXRingGroup ring_group;

        public GTOpRingGroupDial(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, SIPPBXRingGroup rg, int ringSeconds)
            : base(ac, env, pbx_chan, dtmfStr)
        {
            ring_seconds = ringSeconds;
            trans_succeed = false;
            ring_group = rg;
            trans_chans = new List<SIPPBXChan>();
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpRingGroupDial!");

            GTAPIASM.GTAPIChan chan = getEnv().GetChannel(getPBXChan().index);

            string sCaller;
            if(ring_group.bUseGroupName)
                sCaller = SIPPBXWinUtil.BuildCallerID(chan, ring_group.gpName);
            else
                sCaller = SIPPBXWinUtil.BuildCallerID(chan, "");

            SIPPBXDest dest = null;

            if (ring_group.ringType == 0) //ring all
            {
                for (int j = 0; j < ring_group.destList.Count; j++)
                {
                    dest = ring_group.destList[j];
                    int idx = -1;
                    for (int i = Convert.ToInt32(getEnv().GetChannelCount()) - 1; i >= 0; i--)
                    {
                        if (getEnv().GetChannel(i).Reserve())
                        {
                            idx = i;
                            break;
                        }
                    }

                    if (idx >= 0)
                    {
                        if (dest.DestType == 0) //extension
                        {
                            SIPPBXExten extn = getEnv().pbx.getExtensionByName(dest.DestAddr);
                            if (extn != null)
                            {
                                getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, extn);
                                DialExtension(idx, extn, sCaller, dest, chan);
                            }
                            else
                            {
                                getEnv().LOG_Trace(1, "Cannot call to extension " + dest.DestAddr + ", this extension doesn't exist!");
                                getEnv().GetChannel(idx).Free();
                            }
                        }
                        else if (dest.DestType == 1) //outbound call
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            DialOutboundCall(idx, dest.DestAddr, sCaller, dest);
                        }
                        else if (dest.DestType == 2) //sip address
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, dest.DestAddr, sCaller);
                            getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                            getEnv().pbx.chan_list[idx].link_dest = dest;
                            trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        }
                        else if (dest.DestType == 3) //ACD agent
                        {
                            SIPPBXAgent agent = getEnv().pbx.getAgentByCode(dest.DestAddr);
                            if (agent != null)
                            {
                                if (agent.AtExten != null)
                                {
                                    getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, agent.AtExten);
                                    DialExtension(idx, agent.AtExten, sCaller, dest, chan);
                                }
                                else
                                {
                                    getEnv().LOG_Trace(1, "Agent " + dest.DestAddr + " is not logged in yet! Cannot forward ringgroup call to it.");
                                    getEnv().GetChannel(idx).Free();
                                }
                            }
                            else
                            {
                                //no need to reset, because this channel is going to be free
                                getEnv().LOG_Trace(1, "Cannot call to agent " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
                            }
                        }
                        else
                        {
                            getEnv().GetChannel(idx).Free();
                        }
                    }
                }
            }
            else //dial by order
            {
                ring_group.uiCurrentPos = 0;
rg_retry:				
				if (ring_group.uiCurrentPos < ring_group.destList.Count)
                {
					dest = ring_group.destList[ring_group.uiCurrentPos++];

					int idx = -1;
					for (int i = Convert.ToInt32(getEnv().GetChannelCount()) - 1; i >= 0; i--)
					{
						if (getEnv().GetChannel(i).Reserve())
						{
							idx = i;
							break;
						}
					}

					if (idx >= 0)
					{
						if (dest.DestType == 0) //extension
						{
							SIPPBXExten extn = getEnv().pbx.getExtensionByName(dest.DestAddr);
							if (extn != null)
							{
                                getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, extn);
								if(!DialExtension(idx, extn, sCaller, dest, chan))
									goto rg_retry;
							}
							else
							{
								getEnv().LOG_Trace(1, "Cannot call to extension " + dest.DestAddr);
								getEnv().GetChannel(idx).Free();
								goto rg_retry;
							}
						}
						else if (dest.DestType == 1) //outbound call
						{
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
							if(!DialOutboundCall(idx, dest.DestAddr, sCaller, dest))
								goto rg_retry;
						}
						else if (dest.DestType == 2) //sip address
						{
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
							getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, dest.DestAddr, sCaller);
							getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
							getEnv().pbx.chan_list[idx].link_dest = dest;
							trans_chans.Add(getEnv().pbx.chan_list[idx]);
						}
						else if (dest.DestType == 3) //ACD agent
						{
							SIPPBXAgent agent = getEnv().pbx.getAgentByCode(dest.DestAddr);
							if (agent != null)
							{
								if (agent.AtExten != null)
								{
                                    getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, agent.AtExten);
									if(!DialExtension(idx, agent.AtExten, sCaller, dest, chan))
										goto rg_retry;									
								}
								else
								{
									getEnv().LOG_Trace(1, "Agent " + dest.DestAddr + " is not logged in yet! Cannot forward ringgroup call to it.");
									getEnv().GetChannel(idx).Free();
									goto rg_retry;									
								}
							}
							else
							{
								//no need to reset the channel because it is going to be free
								getEnv().LOG_Trace(1, "Cannot call to agent " + dest.DestAddr);
								getEnv().GetChannel(idx).Free();
								goto rg_retry;
							}
						}
						else
						{
							getEnv().GetChannel(idx).Free();
							goto rg_retry;
						}
					}
				}
            }

            if (trans_chans.Count > 0)
            {
            }
            else
            {
                fireDone(ResultCode.OP_RESULT_ERROR, -1);
            }
        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting transfer in GTOpRingGroupDial::abort");
                for (int i = 0; i < trans_chans.Count; i++)
                {
                    getEnv().DisconnectCall(trans_chans[i].index, 0, "", "PBX: aborting in ringgroup dial of OpRingGroup");
                }
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public bool DialOutboundCall(int idx, string addr, string sCaller, SIPPBXDest dest)
        {
            if (addr.Contains(".") || addr.Contains("@"))
            {
                //sip address
                if (addr.Contains("sip:"))
                {
                    getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, addr, sCaller);
                    getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                    getEnv().pbx.chan_list[idx].link_dest = dest;
                    trans_chans.Add(getEnv().pbx.chan_list[idx]);
                    return true;
                }
                else
                {
                    getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, "<sip:" + addr + ">", sCaller);
                    getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                    getEnv().pbx.chan_list[idx].link_dest = dest;
                    trans_chans.Add(getEnv().pbx.chan_list[idx]);
                    return true;
                }
            }
            else
            {
                //to see if it matchs any outbound rules
                SIPPBXDialPlan dp1 = getEnv().pbx.getDialPlanByCalledNum(_env, addr, "", GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sCaller), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sCaller), getEnv().pbx.getExtensionBySIPAddr(sCaller), 1);
                if (dp1 != null)
                {
                    SIPAccount sip_acct = getEnv().pbx.getDialPlanSIPAccount(dp1);
                    if (sip_acct != null)
                    {
                        //outbound, should take out predix digit, then use another channel to dialout
                        string destaddr = dp1.OutboundPrepend + addr.Substring(dp1.OutboundPreStrip.Length);
                        destaddr += "@" + sip_acct.DomainServer;
                        destaddr = "<sip:" + destaddr + ">";

                        string caller_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sCaller);

                        string fromaddr = sip_acct.UserName;
                        if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                        {
                            SIPPBXExten ext0 = getEnv().pbx.getExtensionBySIPAddr(sCaller);
                            if (ext0 != null)
                            {
                                if (ext0.AlternativePhoneNumber.Length > 0)
                                {
                                    fromaddr = ext0.AlternativePhoneNumber;
                                }
                                else if (sip_acct.DIDList.Count > 0)
                                {
                                    fromaddr = sip_acct.DIDList[0];
                                    if (sip_acct.OutboundAppendExtenID)
                                    {
                                        fromaddr += ext0.UserName;
                                    }
                                }
                            }
                            else
                            {
                                if (sip_acct.DIDList.Count > 0)
                                {
                                    fromaddr = sip_acct.DIDList[0];
                                }
                                else
                                {
                                    fromaddr = caller_username;
                                    if (fromaddr == "unknown")
                                        fromaddr = sip_acct.UserName;
                                }
                            }
                        }

                        if (fromaddr == "")
                        {
                            if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                fromaddr = caller_username;
                            else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                fromaddr = sip_acct.DIDList[0];
                            else if (sip_acct.UserName.Length > 0)
                                fromaddr = sip_acct.UserName;
                            else
                                fromaddr = "unknown";
                        }

                        if (sip_acct.UseLocalIPInFrom)
                        {
                            if (_env.pbx.sip_set.sipAddr.Length > 0)
                                fromaddr += "@" + _env.pbx.sip_set.sipAddr;
                            else
                                fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                        }
                        else
                            fromaddr += "@" + sip_acct.DomainServer;
                        fromaddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(0, sCaller) +"<sip:" + fromaddr + ">";

                        if (getEnv().pbx.sip_set.bForwardPAssertedIdentity)
                        {
                            string sPAssertedIdentity = getEnv().GetPAssertedIdentity(getPBXChan().index);
                            if (sPAssertedIdentity.Length > 0)
                                getEnv().SetPAssertedIdentity(idx, sPAssertedIdentity);
                        }

                        getEnv().pbx.MakeOutboundCall(getEnv(), idx, destaddr, fromaddr, sip_acct);
                        getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                        getEnv().pbx.chan_list[idx].link_dest = dest;
                        trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        return true;
                    }
                    else
                    {
                        getEnv().GetChannel(idx).Free();
                        return false;
                    }
                }
                else
                {
                    getEnv().GetChannel(idx).Free();
                    return false;
                }
            }
        }

        public bool DialExtension(int idx, SIPPBXExten extn, string sCaller, SIPPBXDest dest, GTAPIASM.GTAPIChan api_chan)
        {
            string called_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num); 

            if (extn.IsVirtualExten())
            {
                //calling to a virtual extension
                if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                {
                    //sip address
                    string sipDestAddr = extn.VirtualExtenDestAddr.Replace("*", called_num);

                    if (sipDestAddr.Contains("sip:"))
                    {
                        getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, sipDestAddr, sCaller);
                        getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                        getEnv().pbx.chan_list[idx].link_exten = extn;
                        getEnv().pbx.chan_list[idx].link_dtmf = "";
                        getEnv().pbx.chan_list[idx].link_dest = dest;
                        trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        return true;
                    }
                    else
                    {
                        getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, "<sip:" + sipDestAddr + ">", sCaller);
                        getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                        getEnv().pbx.chan_list[idx].link_exten = extn;
                        getEnv().pbx.chan_list[idx].link_dtmf = "";
                        getEnv().pbx.chan_list[idx].link_dest = dest;
                        trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        return true;
                    }
                }
                else
                {
                    //to see if it matchs any outbound rules
                    SIPPBXDialPlan dp1 = getEnv().pbx.getDialPlanByCalledNum(_env, extn.VirtualExtenDestAddr, "", GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sCaller), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sCaller), getEnv().pbx.getExtensionBySIPAddr(sCaller), 1);
                    if (dp1 != null)
                    {
                        SIPAccount sip_acct = getEnv().pbx.getDialPlanSIPAccount(dp1);
                        if (sip_acct != null)
                        {
                            //outbound, should take out predix digit, then use another channel to dialout
                            string destaddr = dp1.OutboundPrepend + extn.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                            if (extn.bAcceptOtherID && called_num.Length > 0)
                                destaddr = called_num;
                            destaddr += "@" + sip_acct.DomainServer;
                            destaddr = "<sip:" + destaddr + ">";

                            string fromaddr = sip_acct.UserName;
                            if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                            {
                                SIPPBXExten ext0 = getEnv().pbx.getExtensionBySIPAddr(sCaller);
                                if (ext0 != null)
                                {
                                    if (ext0.AlternativePhoneNumber.Length > 0)
                                    {
                                        fromaddr = ext0.AlternativePhoneNumber;
                                    }
                                    else if (sip_acct.DIDList.Count > 0)
                                    {
                                        fromaddr = sip_acct.DIDList[0];
                                        if (sip_acct.OutboundAppendExtenID)
                                        {
                                            fromaddr += ext0.UserName;
                                        }
                                    }
                                }
                                else
                                {
                                    fromaddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sCaller);
                                    if (fromaddr == "unknown")
                                        fromaddr = sip_acct.UserName;
                                }
                            }

                            string caller_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sCaller);

                            if (fromaddr == "")
                            {
                                if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                    fromaddr = caller_username;
                                else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                    fromaddr = sip_acct.DIDList[0];
                                else if (sip_acct.UserName.Length > 0)
                                    fromaddr = sip_acct.UserName;
                                else
                                    fromaddr = "unknown";
                            }

                            if (sip_acct.UseLocalIPInFrom)
                            {
                                if (_env.pbx.sip_set.sipAddr.Length > 0)
                                    fromaddr += "@" + _env.pbx.sip_set.sipAddr;
                                else
                                    fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                            }
                            else
                                fromaddr += "@" + sip_acct.DomainServer;
                            fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";

                            if (getEnv().pbx.sip_set.bForwardPAssertedIdentity)
                            {
                                string sPAssertedIdentity = getEnv().GetPAssertedIdentity(getPBXChan().index);
                                if (sPAssertedIdentity.Length > 0)
                                    getEnv().SetPAssertedIdentity(idx, sPAssertedIdentity);
                            }
                            getEnv().pbx.MakeOutboundCall(getEnv(), idx, destaddr, fromaddr, sip_acct);

                            getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                            getEnv().pbx.chan_list[idx].link_exten = extn;
                            getEnv().pbx.chan_list[idx].link_dtmf = "";
                            getEnv().pbx.chan_list[idx].link_dest = dest;

                            trans_chans.Add(getEnv().pbx.chan_list[idx]);
                            return true;
                        }
                        else
                        {
                            getEnv().GetChannel(idx).Free();
                            return false;
                        }
                    }
                    else
                    {
                        getEnv().GetChannel(idx).Free();
                        return false;
                    }
                }
            }
            else
            {
                //regular extension
                if (extn.IsRegistered())
                {
                    string sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, getEnv().pbx.chan_list[idx]);

                    getEnv().pbx.MakeExtensionCall(getEnv(), idx, sCallee, sCaller, extn);
                    getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                    getEnv().pbx.chan_list[idx].link_exten = extn;
                    getEnv().pbx.chan_list[idx].link_dtmf = "";
                    getEnv().pbx.chan_list[idx].link_dest = dest;
                    trans_chans.Add(getEnv().pbx.chan_list[idx]);
                    return true;
                }
                else
                {
                    getEnv().GetChannel(idx).Free();
                    return false;
                }
            }
        }

        public override void On_RecvConnected(int ch)
        {
            base.On_RecvConnected(ch);

            bool found = false;
            for (int i = 0; i < trans_chans.Count; i++)
            {
                if (ch == trans_chans[i].index)
                {
                    found = true;
                    break;
                }
            }

            if (!found) return;

            getEnv().StopTimer(ch);

            if (ring_group.ringType == 0) //ring all
            {
                for (int i = 0; i < trans_chans.Count; i++)
                {
                    if (trans_chans[i].index != ch)
                        getEnv().DisconnectCall(trans_chans[i].index, 0, "", "PBX: disconnecting in ringgroup dial of OpRingGroup because another channel got connected");
                }

                trans_chans.Clear();
                trans_chans.Add(getEnv().pbx.chan_list[ch]);
            }
            else //ring by order
            {
                //trans_chans already has the one dialing
            }

            fireDone(ResultCode.OP_RESULT_SUCCESS, 0);
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch == getPBXChan().index) //caller hung up
            {
                for (int i = 0; i < trans_chans.Count; i++)
                {
                    getEnv().DisconnectCall(trans_chans[i].index, 0, "", "PBX: caller hung up the call in ringgroup dial of OpRingGroup");
                }
                trans_chans.Clear();
                fireDone(ResultCode.OP_RESULT_ERROR, 0);
                return;
            }

            bool found = false;

            for (int i = 0; i < trans_chans.Count; i++)
            {
                if (ch == trans_chans[i].index)
                {
                    found = true;
                    break;
                }
            }

            if (!found) return;

            getEnv().StopTimer(ch);

            GTAPIASM.GTAPIChan chan = getEnv().GetChannel(getPBXChan().index);

            string sCaller;
            if(ring_group.bUseGroupName)
                sCaller = SIPPBXWinUtil.BuildCallerID(chan, ring_group.gpName);
            else
                sCaller = SIPPBXWinUtil.BuildCallerID(chan, "");

            if (ring_group.ringType == 0) //ring all
            {
                for (int i = 0; i < trans_chans.Count; i++)
                {
                    if (trans_chans[i].index == ch)
                    {
                        trans_chans.RemoveAt(i);
                        break;
                    }
                }

                if (trans_chans.Count == 0)
                {
                    //all calls are rejected
                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                }
            }
            else //ring by order
            {
                trans_chans.Clear();

rg_retry:				
                if (ring_group.uiCurrentPos < ring_group.destList.Count)
                {
                    SIPPBXDest dest = ring_group.destList[ring_group.uiCurrentPos++];

                    int idx = -1;
                    for (int i = Convert.ToInt32(getEnv().GetChannelCount()) - 1; i >= 0; i--)
                    {
                        if (getEnv().GetChannel(i).Reserve())
                        {
                            idx = i;
                            break;
                        }
                    }

                    if (idx >= 0)
                    {
                        if (dest.DestType == 0) //extension
                        {
                            SIPPBXExten extn = getEnv().pbx.getExtensionByName(dest.DestAddr);
                            if (extn != null)
                            {
                                getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, extn);
                                if(!DialExtension(idx, extn, sCaller, dest, chan))
									goto rg_retry;
                            }
                            else
                            {
                                getEnv().LOG_Trace(1, "Cannot call to extension " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
								goto rg_retry;
                            }
                        }
                        else if (dest.DestType == 1) //outbound call
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            if(!DialOutboundCall(idx, dest.DestAddr, sCaller, dest))
								goto rg_retry;
                        }
                        else if (dest.DestType == 2) //sip address
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, dest.DestAddr, sCaller);
                            getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                            getEnv().pbx.chan_list[idx].link_dest = dest;
                            trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        }
                        else if (dest.DestType == 3) //ACD agent
                        {
                            SIPPBXAgent agent = getEnv().pbx.getAgentByCode(dest.DestAddr);
                            if (agent != null)
                            {
                                if (agent.AtExten != null)
                                {
                                    getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, agent.AtExten);
                                    if(!DialExtension(idx, agent.AtExten, sCaller, dest, chan))
										goto rg_retry;
                                }
                                else
                                {
                                    getEnv().LOG_Trace(1, "Agent " + dest.DestAddr + " is not logged in yet! Cannot forward ringgroup call to it.");
                                    getEnv().GetChannel(idx).Free();
									goto rg_retry;
                                }
                            }
                            else
                            {
                                getEnv().LOG_Trace(1, "Cannot call to agent " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
								goto rg_retry;
                            }
                        }
                        else
                        {
                            getEnv().GetChannel(idx).Free();
							goto rg_retry;
                        }
                    }
                    else
                    {
                        fireDone(ResultCode.OP_RESULT_ERROR, -1);
                    }
                }
                else
                {
                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                }

                if (trans_chans.Count == 0)
                {
                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                }
            }

        }

        public override void On_RecvError(int ch, int errCode)
        {
            base.On_RecvError(ch, errCode);

            On_RecvIdle(ch, errCode, "");
        }

        public override void On_RecvRinging(int ch)
        {
            base.On_RecvRinging(ch);

            bool found = false;

            for (int i = 0; i < trans_chans.Count; i++)
            {
                if (ch == trans_chans[i].index)
                {
                    found = true;
                    break;
                }
            }

            if (!found) return;

            SIPPBXDest dest =  getEnv().pbx.chan_list[ch].link_dest;
            getEnv().StartTimer(ch, Convert.ToUInt32(dest.RingTimeout * 1000));
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);


            bool found = false;

            for (int i = 0; i < trans_chans.Count; i++)
            {
                if (ch == trans_chans[i].index)
                {
                    found = true;
                    break;
                }
            }

            if (!found) return;

            GTAPIASM.GTAPIChan chan = getEnv().GetChannel(getPBXChan().index);

            string sCaller;
            if(ring_group.bUseGroupName)
                sCaller = SIPPBXWinUtil.BuildCallerID(chan, ring_group.gpName);
            else
                sCaller = SIPPBXWinUtil.BuildCallerID(chan, "");

            getEnv().DisconnectCall(ch, 0, "", "PBX: ringing timeout in ringgroup dial of OpRingGroup");

            for (int i = 0; i < trans_chans.Count; i++)
            {
                if (trans_chans[i].index == ch)
                {
                    trans_chans.RemoveAt(i);
                    break;
                }
            }

            if (ring_group.ringType == 0) //ring all
            {
                if (trans_chans.Count == 0)
                {
                    //all calls are rejected
                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                }
            }
            else //ring by order
            {
                trans_chans.Clear();

rg_retry:				
                if (ring_group.uiCurrentPos < ring_group.destList.Count)
                {
                    SIPPBXDest dest = ring_group.destList[ring_group.uiCurrentPos++];

                    int idx = -1;
                    for (int i = Convert.ToInt32(getEnv().GetChannelCount()) - 1; i >= 0; i--)
                    {
                        if (getEnv().GetChannel(i).Reserve())
                        {
                            idx = i;
                            break;
                        }
                    }

                    if (idx >= 0)
                    {
                        if (dest.DestType == 0) //extension
                        {
                            SIPPBXExten extn = getEnv().pbx.getExtensionByName(dest.DestAddr);
                            if (extn != null)
                            {
                                getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, extn);
                                if(!DialExtension(idx, extn, sCaller, dest, chan))
									goto rg_retry;
                            }
                            else
                            {
                                getEnv().LOG_Trace(1, "Cannot call to extension " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
								goto rg_retry;
                            }
                        }
                        else if (dest.DestType == 1) //outbound call
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            if(!DialOutboundCall(idx, dest.DestAddr, sCaller, dest))
								goto rg_retry;
                        }
                        else if (dest.DestType == 2) //sip address
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, dest.DestAddr, sCaller);
                            getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                            getEnv().pbx.chan_list[idx].link_dest = dest;
                            trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        }
                        else if (dest.DestType == 3) //ACD agent
                        {
                            SIPPBXAgent agent = getEnv().pbx.getAgentByCode(dest.DestAddr);
                            if (agent != null)
                            {
                                if (agent.AtExten != null)
                                {
                                    getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, agent.AtExten);
                                    if(!DialExtension(idx, agent.AtExten, sCaller, dest, chan))
										goto rg_retry;
                                }
                                else
                                {
                                    getEnv().LOG_Trace(1, "Agent " + dest.DestAddr + " is not logged in yet! Cannot forward ringgroup call to it.");
                                    getEnv().GetChannel(idx).Free();
									goto rg_retry;
                                }
                            }
                            else
                            {
                                getEnv().LOG_Trace(1, "Cannot call to agent " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
								goto rg_retry;
                            }
                        }
                        else
                        {
                            getEnv().GetChannel(idx).Free();
							goto rg_retry;
                        }
                    }
                    else
                    {
                        fireDone(ResultCode.OP_RESULT_ERROR, -1);
                    }
                }
                else
                {
                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                }

                if (trans_chans.Count == 0)
                {
                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                }
            }
        }
    }

}
