using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using GTAPIASM;
using System.IO;

using System.Runtime.InteropServices;


namespace SIPPBXv3
{
    public class GTSIPPBXEnv : GTAPIASM.GTAPIEnv 
    {
        public SIPPBXMain pbxMain;
        public SIPPBX pbx;
        public Queue<string> m_logQueue;


        public GTSIPPBXEnv()
        {
            m_logQueue = new Queue<string>();

        }

        public override void On_RecvRTPPacket(int ch, int fmt, IntPtr buf, int buflen, ushort seq, uint timestamp, IntPtr pSysTime)
        {
            //base.On_RecvRTPPacket(ch, fmt, buf, buflen, seq, timestamp, pSysTime);

            if (pbx.pbx_sys_set.useOpenAI == 0) return;

            //*C# code to access the rtp audio data
            SIPPBXChan pbx_chan = pbx.chan_list[ch];

            lock(pbx_chan)
            {
                if (pbx_chan.openAI != null)
                {
                    //LOG_Trace(4, "On_RecvRTPPacket ch:" + ch.ToString() + " fmt:" + fmt.ToString() + " buflen:" + buflen.ToString());
                    //as OPENAI needs 24KHZ samples, we enlarge the byte arrary 3 times and insert the data. May need to improve here for outof boundary data


                    byte[] bytes = new byte[buflen * 3];

                    int totalBytes = buflen * 3;

                    unsafe
                    {
                        byte* p = (byte*)buf;
                        for (int i = 0; i < totalBytes; i += 6)
                        {
                            bytes[i] = *p;
                            bytes[i + 1] = *(p + 1);

                            if (i < totalBytes - 6)
                            {
                                byte[] ba1 = new byte[2];
                                ba1[0] = *p;
                                ba1[1] = *(p + 1);
                                short value1 = BitConverter.ToInt16(ba1, 0);

                                ba1[0] = *(p + 2);
                                ba1[1] = *(p + 3);
                                short value2 = BitConverter.ToInt16(ba1, 0);

                                short v = (short)((value2 - value1) / 3 + value1);
                                ba1 = BitConverter.GetBytes(v);

                                bytes[i + 2] = ba1[0]; // * p;
                                bytes[i + 3] = ba1[1]; // *(p + 1);

                                v = (short)((value2 - value1) * 2 / 3 + value1);
                                ba1 = BitConverter.GetBytes(v);

                                bytes[i + 4] = ba1[0]; // * p;
                                bytes[i + 5] = ba1[1]; // *(p + 1);
                            }
                            else
                            {
                                bytes[i + 2] = *p;
                                bytes[i + 3] = *(p + 1);

                                bytes[i + 4] = *p;
                                bytes[i + 5] = *(p + 1);
                            }

                            p += 2;
                        }
                    }


                    pbx_chan.openAI.AddAudioToOpenAI(bytes);
                }
            }


        }

        public override void On_SentRTPPacket(int ch, int fmt, IntPtr buf, int buflen, ushort seq, uint timestamp, IntPtr pSysTime)
        {
            //base.On_SentRTPPacket(ch, fmt, buf, buflen, seq, timestamp, pSysTime);

            if (pbx.pbx_sys_set.useOpenAI == 0) return;

            SIPPBXChan pbx_chan = pbx.chan_list[ch];

            lock(pbx_chan)
            {
                if (pbx_chan.openAI != null)
                {
                    byte[] bytes = pbx_chan.openAI.GetAudioFromOpenAI();

                    if (bytes != null)
                    {
                        //LOG_Trace(4, "On_SentRTPPacket ch:" + ch.ToString() + " fmt:" + fmt.ToString() + " buflen:" + buflen.ToString() + " AudioFromOpenAI:" + bytes.Length.ToString());
                        // the bytes from OPENAI is defaultly 24khz audio, so we reduce it 3 times.
                        unsafe
                        {
                            byte* buf_p = (byte*)buf;
                            for (int i = 0; i < buflen * 3; i += 6)
                            {
                                *buf_p++ = bytes[i];
                                *buf_p++ = bytes[i + 1];
                            }
                        }
                    }
                    //else
                        //LOG_Trace(4, "On_SentRTPPacket ch:" + ch.ToString() + " fmt:" + fmt.ToString() + " buflen:" + buflen.ToString() + " AudioFromOpenAI:0");
                }
            }


        }

        public override void On_RecvOffered(int ch, string sCaller, string sCallee, string sDestAddr, string sViaAddr, string sFromIP, ushort nFromPort)
        {
			string logInfo;
            try
            {
                //LOG_Trace(4, "On_RecvOffered Step 1");

                base.On_RecvOffered(ch, sCaller, sCallee, sDestAddr, sViaAddr, sFromIP, nFromPort);

                //LOG_Trace(4, "On_RecvOffered Step 2");

                SIPPBXChan pbx_chan = pbx.chan_list[ch];

                pbx_chan.sCaller = sCaller;
                pbx_chan.sCallee = sCallee;
                pbx_chan.sDestAddr = sDestAddr;
                pbx_chan.sViaAddr = sViaAddr;
                pbx_chan.sFromIP = sFromIP;
                pbx_chan.nFromPort = nFromPort;

                //LOG_Trace(4, "On_RecvOffered Step 3");

                SIPPBXExten caller_extn = pbx.getExtensionBySIPAddr(sCaller);

                //LOG_Trace(4, "On_RecvOffered Step 4");

                SIPPBXExten callee_extn = pbx.getExtensionBySIPAddr(sCallee);

                //LOG_Trace(4, "On_RecvOffered Step 5");
                string caller_username = GetSIPAddressInfo(1, sCaller);
                string toid_username = GetSIPAddressInfo(1, sCallee);

                sDestAddr = "<" + sDestAddr + ">";
                string uri_username = GetSIPAddressInfo(1, sDestAddr);

                //LOG_Trace(4, "On_RecvOffered Step 6");

                SIPPBXDialPlan dp = null;
                SIPPBXDialPlan dp1 = null;

                SIPPBXParkingSlot ps = pbx.getParkingSlotByNumber(toid_username);
                SIPPBXMonitorGroup mg = pbx.getMonitorGroupByNumber(toid_username);

                if (ps == null && mg == null)
                {
                    dp = pbx.getDialPlanByCalledNum(this, toid_username, GetSIPAddressInfo(2, sCallee), caller_username, GetSIPAddressInfo(2, sCaller), caller_extn, 0);
                    dp1 = pbx.getDialPlanByCalledNum(this, uri_username, GetSIPAddressInfo(2, sDestAddr), caller_username, GetSIPAddressInfo(2, sCaller), caller_extn, 0);

                    if (dp == null && dp1 != null)
                    {
                        dp = dp1;
                    }

                    if (dp == null && caller_extn != null) //can't find any inbound matching, try outbound if caller is an extension
                    {
                        dp = pbx.getDialPlanByCalledNum(this, toid_username, GetSIPAddressInfo(2, sCallee), caller_username, GetSIPAddressInfo(2, sCaller), caller_extn, 1);
                        dp1 = pbx.getDialPlanByCalledNum(this, uri_username, GetSIPAddressInfo(2, sDestAddr), caller_username, GetSIPAddressInfo(2, sCaller), caller_extn, 1);

                        if (dp == null && dp1 != null)
                        {
                            dp = dp1;
                        }
                    }
                }

                //LOG_Trace(4, "On_RecvOffered Step 7");

                pbx_chan.ResetAll("", 0, pbx, caller_extn);
                
				//run 'CallOffered' plugin
				for (int i = 0; i < pbx.plugins.Count; i++)
				{
					ISIPPBXPluginClient client = pbx.plugins[i];
					if (client == null)
						break;

                    if (client.Type == "Gateway")
                    {
                        SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
                        plugin_host.pbx_chan = pbx_chan;
                        plugin_host.env = this;
                        plugin_host.Client = client;
                        client.Host = plugin_host;

                        if (plugin_host.Register(client))
                        {
                            pbx_chan.async_op_compound = new GTOpPluginCompound(pbx, this, pbx_chan);
                            plugin_host.event_wait_handle.Set();
                        }

                        return;
                    }
                    else if (client.Type == "CallOffered")
					{
						SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
						plugin_host.pbx_chan = pbx_chan;
						plugin_host.env = this;
						plugin_host.Client = client;
						client.Host = plugin_host;

						try
						{
							client.Start();
							client.Done();
						}
						catch (Exception ex)
						{
							LogoutText(ex.ToString());
						}

					}
				}                


                LOG_Trace(4, "On_RecvOffered Step 8");

                string sEventCmd = "";
                sEventCmd += ch.ToString() + "|";
                sEventCmd += pbx_chan.unique_call_id + "|";
                //sEventCmd += GetSIPAddressInfo(1, sCaller) + "|";
                //sEventCmd += GetSIPAddressInfo(1, sCallee) + "|";

                if (caller_extn != null)
                {
                    sEventCmd += "EXTN:" + caller_extn.UserName + "|";
                }
                else
                {
                    sEventCmd += GetSIPAddressInfo(1, sCaller) + "|";
                }

                if (callee_extn != null)
                {
                    sEventCmd += "EXTN:" + callee_extn.UserName + "|";
                }
                else
                {
                    sEventCmd += toid_username + "|";
                }

                if (ps != null)
                {
                    sEventCmd += ps.psName + "|";
                }
                else if (mg != null)
                {
                    sEventCmd += mg.mgName + "|";
                }
                else if (dp != null)
                {
                    sEventCmd += dp.planName + "|";
                }
                else
                {
                    sEventCmd += "|";
                }

                sEventCmd += pbx_chan.RecordFileName + "|";

                pbx.manager.SendEvent("CallOffered", sEventCmd);

                if (!pbx.passCallBlackList(this, dp, caller_username, toid_username))
                {
                    DisconnectCall(ch, 0, "", "PBX: Call is rejected because it is in blacklist!");
                    LOG_Trace(4, "Call is rejected because it is in blacklist!");
                    LogoutText("Call is rejected because it is in blacklist!");
                    return;
                }
                //else
                //{
                //    LOG_Trace(4, caller_username + " -> " + toid_username + " passed blacklist!");
                //    LogoutText(caller_username + " -> " + toid_username + " passed blacklist!");
                //}

                CallBack cb = pbx.getCallBackByCallInfo(this, caller_username, toid_username);
                if (cb != null)
                {
                    DisconnectCall(ch, 0, "", "PBX: Call is rejected because it is call back! " + cb.Caller + "=>" + cb.Callee + " " +cb.DialPlan);
                    LOG_Trace(4, "Call is rejected because it is call back! " + cb.Caller + "=>" + cb.Callee + " " + cb.DialPlan);
                    LogoutText("Call is rejected because it is call back! " + cb.Caller + "=>" + cb.Callee + " " + cb.DialPlan);

                    //////////////////Set up the call back job......//////////////////////
                    AutoDialerTask task = new AutoDialerTask();
                    task.type_code = Convert.ToInt16(cb.ID);
                    task.type_code += 23000;
                    task.task_name = "CallBack-AutoDialer-Task" + cb.ID.ToString();
                    task.sip_acc = cb.ExtraAttr;
                    task.m_bEnableDetect = false;
                    task.m_bDiscAfterDetect = false;
                    task.isOn = true;
                    task.dial_plan = cb.DialPlan;                   

                    CallJob call = new CallJob();
                    call.isCallBack = true;
                    call.JobTypeCode = task.type_code;
                    call.ID = 0;
                    call.Caller = "";
                    call.Callee = caller_username;
                    call.JobID = ""; //task.task_name;
                    call.Task = task;

                    task.m_JobsQueue.Enqueue(call);

                    pbx.call_back_queue.Enqueue(task);

                    return;
                }

                pbx_chan.dp = dp;
                pbx_chan.link_exten = caller_extn;
                if (caller_extn != null)
                    SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);

                pbx_chan.target_did = pbx.GetTargetDID(toid_username, uri_username);

                if (pbx_chan.link_exten != null)
                {
                    pbx.SetExtenCallingState(pbx_chan.link_exten, this, 10); //offered
                    RefreshMainWnd();
                }

                //LOG_Trace(4, "On_RecvOffered Step 9");

                if (caller_extn != null) //2016-04-12 Added extension Pin code process
                {
                    foreach (SIPPBXPagingGroup pg in pbx.sip_paginggroups) //2016-06-14 for paging group
                    {
                        if(pg.did == toid_username)
                        {
                            Send_Answer(ch);
                            LogoutText("Extension " + caller_extn.UserName + " called to " + toid_username + " for paging group " + pg.gpName);
                            return;
                        }
                    }

                    if (caller_extn.PinCode == toid_username)
                    {
                        Send_Answer(ch);
                        LogoutText("Extension " + caller_extn.UserName + " called to pin code " + toid_username);
                        return;
                    }
                }

                if (dp != null)
                {
                    //pbx_chan.ivr = dp.ivr;
                    //LOG_Trace(4, "On_RecvOffered Step 9 " + "Call to " + sCallee + " using dialplan " + dp.planName);
                    LogoutText("Call to " + sCallee + " using dialplan " + dp.planName);

                    if (dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        pbx_chan.call_dir = 1;

                        if (caller_extn != null)
                        {
                            if (caller_extn.PinCode.Length > 0)
                            {
                                logInfo = "Call(from " + sCaller + "to " + sCallee + ") is rejected because caller extension must dial pin code first!";
                                LogoutText(logInfo);
                                DisconnectCall(ch, 406, "Not Acceptable", "PBX: " + logInfo);
                                return;
                            }

                            if (GetChanCallCredit(ch) > 0 || caller_extn.AuthType == 2)
                            {
                                if (caller_extn.bOnlyAgentLogin && caller_extn.Agent == null)
                                {
                                    logInfo = "Extension " + caller_extn.UserName + " must have an agent to login in order to call out!";
                                    LogoutText(logInfo);
                                    DisconnectCall(ch, 480, "Temporarily Unavailable", "PBX: " + logInfo);
                                    return;
                                }

                                pbx_chan.async_op_compound = new GTOpOutbound(pbx, this, pbx_chan, dp);
                                pbx_chan.async_op_compound.start();
                            }
                            else
                            {
                                logInfo = "Call(from " + sCaller + "to " + sCallee + ") is rejected because caller didn't pass authentication!";
                                LogoutText(logInfo);
                                DisconnectCall(ch, 406, "Not Acceptable", "PBX: " + logInfo);
                                return;
                            }
                        }
                        else //2012.12.10 changed to only extensions of PBX can make outbound calls
                        {
                            logInfo = "Call(from " + sCaller + "to " + sCallee + ") is rejected because caller is not an extension!";
                            LogoutText(logInfo);
                            DisconnectCall(ch, 406, "Not Acceptable", "PBX: " + logInfo);
                            return;
                        }
                    }
                    else
                    {
                        if (caller_extn != null)
                        {
                            if (!pbx.pbx_sys_set.bExtenCanInbound)
                            {
								logInfo = "Extensions cannot try inbound dialplan. You can change this setting in menu server/system options/extensions.";
                                DisconnectCall(ch, 488, "Not Acceptable Here", "PBX: " + logInfo);
                                LogoutText(logInfo);
                                return;
                            }
                        }

                        if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT)
                        {
                            //inbound, answer call
                            SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                            Send_Answer(ch);
                        }
                        else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE)
                        {
                            SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                            Send_Answer(ch);
                        }
                        else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX)
                        {
                            SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                            Send_Answer(ch);
                        }
                        if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION)
                        {
                            pbx_chan.async_op_compound = new GTOpOutbound(pbx, this, pbx_chan, dp);
                            pbx_chan.async_op_compound.start();
                        }
                        else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB)
                        {
							logInfo = "Call(from " + sCaller + "to " + sCallee + ") is rejected because DND is used!";
                            LogoutText(logInfo);
                            DisconnectCall(ch, 486, "Busy Here", "PBX: " + logInfo);
                        }
                        else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP)
                        {
                            SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                            Send_Answer(ch);
                        }
                        else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP)
                        {
                            SIPPBXRingGroup rg = pbx.getRingGroupByName(pbx_chan.dp.DestAddress);
                            SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                            if (rg != null)
                            {
                                if (rg.bAnswerCallFirst)
                                {
                                    Send_Answer(ch);
                                }
                                else
                                {
                                    Send_Ring(ch);
                                    pbx_chan.async_op_compound = new GTOpRingGroup(pbx, this, pbx_chan, rg, pbx.moh_dir);
                                    pbx_chan.async_op_compound.start();
                                }
                            }
                            else
                            {
                                logInfo = "Cannot find ring group(" + pbx_chan.dp.DestAddress + ") for incoming calls.";
                                LogoutText(logInfo);
                                DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                            }

                        }
                        else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM)
                        {
                            SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                            Send_Answer(ch);
                        }

                        else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE)
                        {
                            //inbound, plugin, answer the call
                            SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                            Send_Answer(ch);
                        }
                        else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING)
                        {
                            string dpname = pbx_chan.dp.DestAddress;

                            if (pbx_chan.dp.DestAddress.Contains("@"))
                                dpname = pbx_chan.dp.DestAddress.Substring(pbx_chan.dp.DestAddress.IndexOf('@') + 1);

                            dp1 = pbx.getDialPlanByPlanName(dpname);
                            if (dp1 != null)
                            {
                                if (dp1.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                                {
                                    pbx_chan.async_op_compound = new GTOpOutbound(pbx, this, pbx_chan, dp1);
                                    pbx_chan.async_op_compound.start();
                                }
                                else
                                {
                                    logInfo = "Call(from " + sCaller + "to " + sCallee + ") is rejected because call forwarding is not set to an outbound dialplan!";
                                    LogoutText(logInfo);
                                    DisconnectCall(ch, 486, "Busy Here", "PBX: " + logInfo);
                                }
                            }
                            else
                            {
                                logInfo = "Call(from " + sCaller + "to " + sCallee + ") is rejected because call forwarding is not set to an outbound dialplan!";
                                LogoutText(logInfo);
                                DisconnectCall(ch, 486, "Busy Here", "PBX: " + logInfo);
                            }
                        }
                        else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER || dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST)
                        {
                            SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                            Send_Answer(ch);
                        }
                        else if(dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.OPENAI_NODE)
                        {
                            SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                            Send_Answer(ch);
                        }
                    }
                }
                else if (callee_extn != null)
                {
                    //LOG_Trace(4, "On_RecvOffered Step 10");
                    pbx_chan.async_op_compound = new GTOpDialExten(pbx, this, pbx_chan, null, callee_extn);
                    pbx_chan.async_op_compound.start();
                }
                else if (caller_extn != null && pbx.vmb_code == toid_username)
                {
                    if (pbx_chan.link_exten.vmb != null)
                    {
                        Send_Answer(ch);
                        LogoutText("Extension " + caller_extn.UserName + " called to " + pbx.vmb_code + " to access voice mail box.");
                    }
                    else
                    {
                        logInfo = "Extension " + caller_extn.UserName + " voice mailbox is NOT enabled.";
                        DisconnectCall(ch, 488, "Not Acceptable Here", "PBX: " + logInfo);
                        LogoutText("Extension " + caller_extn.UserName + " called to " + pbx.vmb_code + " to access voice mail box. Rejected because its voice mail box is NOT enabled.");
                    }
                }
                else if (caller_extn != null && pbx.agent_login_number == toid_username)
                {
                    SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                    Send_Answer(ch);
                    LogoutText("Extension " + caller_extn.UserName + " called to " + pbx.agent_login_number + " to login.");
                }
                else if (caller_extn != null && pbx.agent_logout_number == toid_username)
                {
                    SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                    Send_Answer(ch);
                    LogoutText("Extension " + caller_extn.UserName + " called to " + pbx.agent_logout_number + " to logout.");
                }
                else if (caller_extn != null && pbx.acd_number == toid_username)
                {
                    if (caller_extn.ACDCallMethod == 2 || caller_extn.IsSupervisorExten())
                    {
                        SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                        Send_Answer(ch);
                        LogoutText("Extension " + caller_extn.UserName + " called to " + pbx.acd_number + ". Call answered.");
                    }
                    else
                    {
						logInfo = "Extension " + caller_extn.UserName + " is not allowed to call " + pbx.acd_number;
                        DisconnectCall(ch, 488, "Not Acceptable Here", "PBX: " + logInfo);
                        LogoutText(logInfo);
                    }
                }
                else if (toid_username == pbx.pickup_shortcode && caller_extn != null && ps == null && mg == null)
                {
                    //trying to pick up the call in the same group
                    SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                    Send_Answer(ch);
                    LogoutText("Extension " + caller_extn.UserName + " trying to pickup the call in its group.");
                }
                else if (toid_username.IndexOf(pbx.pickup_shortcode) == 0 && caller_extn != null && ps == null && mg == null)
                {
                    //trying to pick up the call in other group
                    SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                    Send_Answer(ch);
                    LogoutText("Extension " + caller_extn.UserName + " trying to pickup the call in other group.");
                }
                else
                {
                    //LOG_Trace(4, "On_RecvOffered Step 11");
                    if (caller_extn != null && ps != null)
                    {
                        //SetChanAudioCodec(ch, GetChanAudioCodec(ps.pbxChan.index));
                        SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                        Send_Answer(ch);
                        LogoutText("Call to " + sCallee + " answered! " + caller_extn.UserName + " is picking up the call on channel " + ps.pbxChan.index);
                    }
                    else if (caller_extn != null && pbx.getParkingSlot(toid_username) != null)
                    {
						logInfo = "Call to " + sCallee + " is rejected because there is no call parked in!";
                        DisconnectCall(ch, 488, "Not Acceptable Here", "PBX: " + logInfo);
                        LogoutText(logInfo);
                    }
                    else if (mg != null)
                    {
                        if (caller_extn != null)
                        {
                            if (caller_extn.IsSupervisorExten())
                            {
                                SIPPBXWinUtil.SetChanAudioCodec(caller_extn, this, pbx, pbx_chan, null);
                                Send_Answer(ch);
                                LogoutText("Call From " + sCaller + " to " + sCallee + " is Answered! Monitor group " + mg.mgName + " will apply this call.");
                            }
                            else
                            {
                                //reject the call. only Supervisor can call MonitorGroup's phone number
                                logInfo = "Call to " + sCallee + " is rejected! Only supervisor exten can call monitor group!";
                                DisconnectCall(ch, 488, "Not Acceptable Here", "PBX: " + logInfo);
                                LogoutText(logInfo);
                            }
                        }
                        else
                        {
							logInfo = "Call to " + sCallee + " is rejected! Only supervisor exten can call monitor group!";
                            DisconnectCall(ch, 488, "Not Acceptable Here", "PBX: " + logInfo);
                            LogoutText(logInfo);
                        }
                    }
                    else
                    {
                        //no dial plan, not dialing extension
                        //just answer the call, and doing nothing
                        logInfo = "Call to " + sCallee + " is rejected! No any dial plan match!";
                        DisconnectCall(ch, 488, "Not Acceptable Here", "PBX: " + logInfo);
                        LogoutText(logInfo);
                    }
                }
            }
            catch (Exception ex)
            {
                LOG_Trace(1, "*************On_RecvOffered got exception: " + ex.Message);
                LOG_Trace(1, ex.ToString());
            }
        }

        public void DoDialPlan(int ch, SIPPBXChan pbx_chan, SIPPBXExten extn, SIPPBXMonitorGroup mg)
        {
			string logInfo;
            if (pbx_chan.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
            {
                if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT)
                {
                    SIPPBXIVR ivrmenu = pbx.getIVRMenuByName(pbx_chan.dp.DestAddress);
                    if (ivrmenu != null)
                    {
                        pbx_chan.async_op_compound = new GTOpIVRMenu(pbx, this, pbx_chan, ivrmenu);
                        pbx_chan.async_op_compound.start();
                    }
                    else
                    {
						logInfo = "Cannot find IVR menu(" + pbx_chan.dp.DestAddress + ") for incoming calls.";
                        LogoutText(logInfo);
                        DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                    }
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION)
                {
                    //*** I don't know why it has to be not NULL. 
                    //In the case that we need to run Dialplan manually, like run dialplan from ACD timeout/no agents, we do need it to run.
                    //if (pbx_chan.call_job != null) 
                    {
                        pbx_chan.async_op_compound = new GTOpOutbound(pbx, this, pbx_chan, pbx_chan.dp);
                        pbx_chan.async_op_compound.start();
                    }
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE)
                {
                    SIPPBXACDHuntGroup hg = pbx.getACDByName(pbx_chan.dp.DestAddress);
                    if (hg != null)
                    {
                        if (hg.calls.Count >= hg.maxNumOfCalls && hg.maxNumOfCalls > 0)
                        {
                            //ACD queue full
                            if (hg.callForwardingType == 0) //to another ACD group
                            {
                                SIPPBXACDHuntGroup hg1 = pbx.getACDByName(hg.callForwardingPlan);
                                if (hg1 != null)
                                {
                                    pbx_chan.async_op_compound = new GTOpACD(pbx, this, pbx_chan, hg1, pbx.moh_dir, false);
                                    pbx_chan.async_op_compound.start();
                                }
                                else
                                {
                                    logInfo = "Cannot find huntgroup(" + hg.callForwardingPlan + ") for incoming calls.";
                                    LogoutText(logInfo);
                                    DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                                }
                            }
                            else if (hg.callForwardingType == 1) //to another Dialplan
                            {
                                SIPPBXDialPlan dp_hg = pbx.getDialPlanByPlanName(hg.callForwardingPlan);
                                if (dp_hg != null)
                                {
                                    pbx_chan.dp = dp_hg;
                                    DoDialPlan(pbx_chan.index, pbx_chan, null, null);
                                }
                                else
                                {
                                    logInfo = "Cannot find dialplan(" + hg.callForwardingPlan + ") for incoming calls.";
                                    LogoutText(logInfo);
                                    DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                                }
                            }
                            else
                            {
                                logInfo = "ACD group " + hg.hgName + " queue is full, but forwarding type is not correct!";
                                LogoutText(logInfo);
                                DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                            }
                        }
                        else
                        {
                            pbx_chan.async_op_compound = new GTOpACD(pbx, this, pbx_chan, hg, pbx.moh_dir, false);
                            pbx_chan.async_op_compound.start();
                        }
                    }
                    else
                    {
						logInfo = "Cannot find huntgroup(" + pbx_chan.dp.DestAddress + ") for incoming calls.";
                        LogoutText(logInfo);
                        DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                    }
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB)
                {
					logInfo = "Call is rejected because the dialplan is set to DND(DO NOT DISTURB)";
                    LogoutText(logInfo);
                    DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX)
                {
                    extn = pbx.getExtensionByName(pbx_chan.dp.DestAddress);
                    if (extn != null)
                    {
                        if (extn.vmb != null)
                        {
                            pbx_chan.async_op_compound = new GTOpVMB(pbx, this, pbx_chan, extn.vmb);
                            pbx_chan.async_op_compound.start();
                        }
                        else
                        {
							logInfo = "Call is rejected because the extension " + pbx_chan.dp.DestAddress + " doesn't have a voice mail box.";
                            LogoutText(logInfo);
                            DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                        }
                    }
                    else
                    {
						logInfo = "Call is rejected because the extension " + pbx_chan.dp.DestAddress + " doesn't exist anymore.";
                        LogoutText(logInfo);
                        DisconnectCall(ch, 0, "", "PBX :" + logInfo);
                    }
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP)
                {
                    SIPPBXRingGroup rg = pbx.getRingGroupByName(pbx_chan.dp.DestAddress);
                    if (rg != null)
                    {
                        pbx_chan.async_op_compound = new GTOpRingGroup(pbx, this, pbx_chan, rg, pbx.moh_dir);
                        pbx_chan.async_op_compound.start();
                    }
                    else
                    {
						logInfo = "Cannot find ring group(" + pbx_chan.dp.DestAddress + ") for incoming calls.";
                        LogoutText(logInfo);
                        DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                    }
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP)
                {
                    mg = pbx.getMonitorGroupByNumber(pbx_chan.dp.DestAddress);
                    if (mg != null)
                    {
                        pbx_chan.async_op_compound = new GTOpMonitorGroup(pbx, this, pbx_chan, mg, pbx_chan.link_exten);
                        pbx_chan.async_op_compound.start();
                    }
                    else
                    {
						logInfo = "Cannot find monitor group(" + pbx_chan.dp.DestAddress + ") for incoming calls.";
                        LogoutText(logInfo);
                        DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                    }
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM)
                {
                    pbx.SetChanIntoConferenceRoom(this, pbx_chan, pbx_chan.dp.DestAddress, 1);
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE)
                {
                    if (pbx.bFreeVersion || pbx.PBXLicKey.Length < 29)
                    {
                        if (ch > 0)
                        {
							logInfo = "Free Version only allows pbx to run plugin on the first channel!";
                            LogoutText(logInfo);
                            DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                            return;
                        }
                    }
                    else
                    {
                        if(GetLicTo().Length == 0)
                        {
                            //non-free-version, but without right licence key
                            if (ch > 0)
                            {
								logInfo = "Trail Version only allows pbx to run plugin on the first channel!";
                                LogoutText(logInfo);
                                DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                                return;
                            }
                        }
                    }

                    ISIPPBXPluginClient client = pbx.GetPluginClientInterfaceByName(pbx_chan.dp.DestAddress);
                    if (client == null)
                    {
						logInfo = "Plugin(" + pbx_chan.dp.DestAddress + ") doesn't exist in the plugin list.";
                        LogoutText(logInfo);
                        DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                        return;
                    }

                    if (client.Type != "IVRMenu")
                    {
						logInfo = "Plugin(" + pbx_chan.dp.DestAddress + ") is not IVRMenu Type!";
                        LogoutText(logInfo);
                        DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                        return;
                    }


                    SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
                    pbx_chan.plugin_host = plugin_host;
                    plugin_host.pbx_chan = pbx_chan;
                    plugin_host.env = this;
                    if (plugin_host.Register(client))
                    {
                        pbx_chan.async_op_compound = new GTOpPluginCompound(pbx, this, pbx_chan);
                        plugin_host.event_wait_handle.Set();
                    }
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING)
                {
                    string dpname = pbx_chan.dp.DestAddress;

                    if (pbx_chan.dp.DestAddress.Contains("@"))
                        dpname = pbx_chan.dp.DestAddress.Substring(pbx_chan.dp.DestAddress.IndexOf('@') + 1);

                    SIPPBXDialPlan dp1 = pbx.getDialPlanByPlanName(dpname);
                    if (dp1 != null)
                    {
                        if (dp1.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                        {
                            pbx_chan.async_op_compound = new GTOpOutbound(pbx, this, pbx_chan, dp1);
                            pbx_chan.async_op_compound.start();
                        }
                        else
                        {
                            logInfo = "Call is rejected because call forwarding is not set to an outbound dialplan!";
                            LogoutText(logInfo);
                            DisconnectCall(ch, 486, "Busy Here", "PBX: " + logInfo);
                        }
                    }
                    else
                    {
                        logInfo = "Call is rejected because call forwarding is not set to a valid outbound dialplan!";
                        LogoutText(logInfo);
                        DisconnectCall(ch, 486, "Busy Here", "PBX: " + logInfo);
                    }

                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER)
                {
                    bool fldExist = false;
                    try
                    {
                        fldExist = Directory.Exists(pbx_chan.dp.DestAddress);
                    }
                    catch (Exception)
                    {
                        fldExist = false;
                    }

                    if (fldExist)
                        Send_StartMusicOnHold(ch, pbx_chan.dp.DestAddress, pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);
                    else
                    {
                        logInfo = "Dir(" + pbx_chan.dp.DestAddress + ") doesn't exist. Using " + pbx.moh_dir + " to host music server";
                        LogoutText(logInfo);
                        Send_StartMusicOnHold(ch, pbx.moh_dir, pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);
                    }
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST)
                {
                    Send_HalfConnect(ch, ch);
                }
                else if (pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.OPENAI_NODE)
                {
                    if (pbx.pbx_sys_set.useOpenAI == 1)
                    {
                        SIPPBXOpenAINode agent = pbx.getOpenAIAgentByName(pbx_chan.dp.DestAddress);

                        if (agent != null)
                        {
                            lock (pbx_chan)
                            {
                                try
                                {
                                    pbx_chan.openAI = new OpenAIRealtimeAccess();
                                    pbx_chan.openAI.OpenAIKey = agent.APIKey;
                                    pbx_chan.openAI.sessionUpdateJson = agent.DefDesc;
                                    pbx_chan.openAI.env = this;
                                    pbx_chan.openAI.Initialize();
                                }
                                catch (Exception ex)
                                {
                                    LogoutText(ex.ToString());
                                    pbx_chan.openAI = null;
                                }
                            }
                        }
                        else
                        {
                            Send_HangUp(pbx_chan.index, 0, "OpenAI agent '" + pbx_chan.dp.DestAddress + "' doesn't exist!");
                        }
                    }
                    else
                    {
                        Send_HangUp(pbx_chan.index, 0, "OpenAI is not enabled!");
                    }

                }
            }

        }

        //0 = Answering Machine
        //1 = Human voice
        //-1 = silence (no voice at all in the "gtsrv.human.detect.duration" milliseconds.)
        //-2 = detected voice, but unknown because "gtsrv.human.detect.duration" is reached.
        public override void On_DetectHumanVoiceDone(int ch, int result)
        {
            base.On_DetectHumanVoiceDone(ch, result);

            GTAPIASM.GTAPIChan api_chan = GetChannel(ch);
            SIPPBXChan pbx_chan = pbx.chan_list[ch];

            SIPPBXExten extn = pbx_chan.link_exten;

            if (pbx_chan.call_job != null)
            {
                if (pbx_chan.call_job.Task.m_bEnableDetect)
                {
                    if(pbx_chan.call_job.DetectResult != 2) //if == 2, means already detected FAX
                        pbx_chan.call_job.DetectResult = result;

                    if (pbx_chan.call_job.Task.m_bDiscAfterDetect)
                    {
                        DisconnectCall(ch, 0, "", "PBX: Disconnect call after human/answer machine/fax detection");
                    }
                    else
                    {
                        pbx_chan.call_job.BeginTime = pbx_chan.call_job.EndTime = DateTime.Now;
                        pbx_chan.call_job.CallResult = 1;
                        pbx_chan.dp = pbx.getDialPlanByPlanName(pbx_chan.call_job.Task.dial_plan);

                        if (pbx_chan.dp != null)
                        {
                            if (pbx_chan.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND &&
                                pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION)
                            {
                                if (pbx_chan.link_chan == null)
                                {
                                    //dial exten, so called extension first
                                    pbx_chan.call_job.InitTime = pbx_chan.call_job.BeginTime = pbx_chan.call_job.EndTime = DateTime.Now;
                                    pbx_chan.call_job.CallResult = 0;

                                    //for CDR
                                    api_chan.originate = false;
                                    string sTemp = api_chan.caller_num;
                                    api_chan.caller_num = api_chan.callee_num;
                                    api_chan.callee_num = sTemp;

                                    pbx_chan.dp = new SIPPBXDialPlan();
                                    pbx_chan.dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND;
                                    pbx_chan.dp.DestAddress = pbx_chan.call_job.Callee;
                                    SIPAccount acct = pbx.getSIPAccountByUserName(pbx_chan.call_job.Task.sip_acc);
                                    if (acct != null)
                                        pbx_chan.dp.OutboundSIPAcct = pbx.sip_acct.IndexOf(acct);
                                    else
                                        pbx_chan.dp.OutboundSIPAcct = 0;

                                    //LOG_Trace(4, "out call job using sip account " + pbx_chan.call_job.Task.sip_acc + " " + pbx_chan.dp.OutboundSIPAcct.ToString());

                                    GTOpOutbound outbound = new GTOpOutbound(pbx, this, pbx_chan, pbx_chan.dp);
                                    outbound._check_caller_extn = false;
                                    outbound._caller_id = pbx_chan.call_job.Caller;
                                    outbound._called_id = pbx_chan.call_job.Callee;
                                    outbound._call_job = pbx_chan.call_job;

                                    pbx_chan.call_job = null;
                                    pbx_chan.async_op_compound = outbound;
                                    pbx_chan.async_op_compound.start();
                                }
                            }
                            else
                                DoDialPlan(ch, pbx_chan, extn, null);
                        }
                        else
                        {
							string logInfo = "Hungup the call because diaplan(" + pbx_chan.call_job.Task.dial_plan + ") is not found.";
                            LogoutText(logInfo);
                            DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                        }

                    }
                }
            }
        }

        public override void On_RecvToneDetected(int ch, int freq)
        {
            base.On_RecvToneDetected(ch, freq);

            SIPPBXChan pbx_chan = pbx.chan_list[ch];

            if (pbx_chan.call_job != null)
            {
                if (pbx_chan.call_job.Task.m_bEnableDetect)
                {
                    pbx_chan.call_job.DetectResult = 2; //FAX
                }
            }
        }

        public override void On_RecvConnected(int ch)
        {
            base.On_RecvConnected(ch);

            GTAPIASM.GTAPIChan api_chan = GetChannel(ch);
            SIPPBXChan pbx_chan = pbx.chan_list[ch];

            pbx_chan.call_connected = true;

            SIPPBXExten extn = pbx_chan.link_exten;
            if (extn != null)
            {
                pbx.SetExtenCallingState(extn, this, 30); //in call
                RefreshMainWnd();
                LOG_Trace(4, "On_RecvConnected " + ch.ToString() + " extension " + extn.UserName + " is set to connected.");
            }         

/*               
            else
            {
                LOG_Trace(4, "On_RecvConnected no extension for channel " + ch.ToString());
            }

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].link_exten != null)
                {
                    LOG_Trace(4, "On_RecvConnected channel " + i.ToString() + " is linked to extension " + pbx.chan_list[i].link_exten.UserName);
                }
                else
                {
                    LOG_Trace(4, "On_RecvConnected channel " + i.ToString() + " is NOT linked any extension");
                }
            }
*/

			string logInfo;

            string sEventCmd = "";
            sEventCmd += ch.ToString() + "|";
            sEventCmd += pbx_chan.unique_call_id + "|";
            //sEventCmd += GetSIPAddressInfo(1, sCaller) + "|";
            //sEventCmd += GetSIPAddressInfo(1, sCallee) + "|";
            if (pbx_chan.dp != null)
            {
                sEventCmd += pbx_chan.dp.planName + "|";
            }
            else
            {
                sEventCmd += "|";
            }
            sEventCmd += pbx_chan.RecordFileName + "|";
            pbx.manager.SendEvent("CallConnected", sEventCmd);

            //run 'CallConnect' plugin
            for (int i = 0; i < pbx.plugins.Count; i++)
            {
                ISIPPBXPluginClient client = pbx.plugins[i];
                if (client == null)
                    break;

                if (client.Type == "CallConnected")
                {
                    SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
                    pbx_chan.plugin_host = plugin_host;
                    plugin_host.pbx_chan = pbx_chan;
                    plugin_host.env = this;
                    if (plugin_host.Register(client))
                    {
                        pbx_chan.async_op_compound = new GTOpPluginCompound(pbx, this, pbx_chan);
                        plugin_host.event_wait_handle.Set();
                    }
                }
            }

            if (pbx.RecordAllCalls) //2020-11-11 Added recording for every call feature
            {
                pbx_chan.Record(this, null, "");
            }

            string toid_username = GetSIPAddressInfo(1, GetChannel(ch).callee_num);
            SIPPBXParkingSlot ps = pbx.getParkingSlotByNumber(toid_username);
            SIPPBXMonitorGroup mg = pbx.getMonitorGroupByNumber(toid_username);

            if (pbx_chan.link_exten != null) //2016-04-12 Added extension Pin code process
            {
                foreach (SIPPBXPagingGroup pg in pbx.sip_paginggroups) //2016-06-14 for paging group
                {
                    if (pg.did == toid_username)
                    {
                        //do the routing for Pincode
                        pbx_chan.async_op_compound = new GTOpPagingGroup(pbx, this, pbx_chan, pg, pbx.moh_dir);
                        pbx_chan.async_op_compound.start();
                        return;
                    }
                }

                if (pbx_chan.link_exten.PinCode == toid_username && pbx_chan.link_chan == null)
                {
                    //do the routing for Pincode
                    pbx_chan.async_op_compound = new GTOpPincodeCall(pbx, this, pbx_chan);
                    pbx_chan.async_op_compound.start();
                    return;
                }
            }

            if (pbx_chan.call_job != null)
            {
                StopTimer(pbx_chan.index);

                if (pbx_chan.call_job.Task.m_bEnableDetect)
                {
                    Send_AddTone(ch, 1100, 400); //1100HZ for 400ms. T30 standard for caller
                    Send_AddTone(ch, 2100, 400); //2100HZ for 2400ms. T30 standard for callee
                    Send_StartToneDetection(ch);
                    goto conn_op;
                }
                else
                {
                    pbx_chan.call_job.BeginTime = pbx_chan.call_job.EndTime = DateTime.Now;
                    pbx_chan.call_job.CallResult = 1;
                    pbx_chan.dp = pbx.getDialPlanByPlanName(pbx_chan.call_job.Task.dial_plan);

                    if (pbx_chan.dp != null)
                    {
                        if (pbx_chan.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND &&
                            pbx_chan.dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION)
                        {
                            if (pbx_chan.link_chan == null)
                            {
                                //dial exten, so called extension first
                                pbx_chan.call_job.InitTime = pbx_chan.call_job.BeginTime = pbx_chan.call_job.EndTime = DateTime.Now;
                                pbx_chan.call_job.CallResult = 0;

                                //for CDR
                                api_chan.originate = false;
                                string sTemp = api_chan.caller_num;
                                api_chan.caller_num = api_chan.callee_num;
                                api_chan.callee_num = sTemp;

                                pbx_chan.dp = new SIPPBXDialPlan();
                                pbx_chan.dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND;
                                pbx_chan.dp.DestAddress = pbx_chan.call_job.Callee;
                                SIPAccount acct = pbx.getSIPAccountByUserName(pbx_chan.call_job.Task.sip_acc);
                                if (acct != null)
                                    pbx_chan.dp.OutboundSIPAcct = pbx.sip_acct.IndexOf(acct);
                                else
                                    pbx_chan.dp.OutboundSIPAcct = 0;

                                //LOG_Trace(4, "out call job using sip account " + pbx_chan.call_job.Task.sip_acc + " " + pbx_chan.dp.OutboundSIPAcct.ToString());

                                GTOpOutbound outbound = new GTOpOutbound(pbx, this, pbx_chan, pbx_chan.dp);
                                outbound._check_caller_extn = false;
                                outbound._caller_id = pbx_chan.call_job.Caller;
                                outbound._called_id = pbx_chan.call_job.Callee;
                                outbound._call_job = pbx_chan.call_job;

                                pbx_chan.call_job = null;
                                pbx_chan.async_op_compound = outbound;
                                pbx_chan.async_op_compound.start();
                            }
                            else
                            {
                                goto conn_op;
                            }
                        }
                        else
                            DoDialPlan(ch, pbx_chan, extn, mg);
                    }
                    else
                    {
						logInfo = "Hungup the call because diaplan(" + pbx_chan.call_job.Task.dial_plan + ") is not found.";
                        LogoutText(logInfo);
                        DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                    }
                }

                return;
            }

            if (pbx_chan.async_op_compound == null)
            {
                if (pbx_chan.dp != null)
                {
                    DoDialPlan(ch, pbx_chan, extn, mg);
                }
                else if (pbx_chan.link_exten != null && pbx.vmb_code == toid_username)
                {
                    if (pbx_chan.link_exten.vmb != null)
                    {
                        pbx_chan.async_op_compound = new GTOpVMBAccess(pbx, this, pbx_chan, pbx_chan.link_exten);
                        pbx_chan.async_op_compound.start();
                    }
                    else
                    {
                        logInfo = "Extension " + pbx_chan.link_exten.UserName + " doesn't have mailbox enabled";
                        LogoutText(logInfo);
                        DisconnectCall(ch, 0, "", "PBX: " + logInfo);
                    }
                }
                else if (pbx_chan.link_exten != null && pbx.agent_login_number == toid_username)
                {
                    pbx_chan.async_op_compound = new GTOpACDAgentLog(pbx, this, pbx_chan, true);
                    pbx_chan.async_op_compound.start();
                }
                else if (pbx_chan.link_exten != null && pbx.agent_logout_number == toid_username)
                {
                    pbx_chan.async_op_compound = new GTOpACDAgentLog(pbx, this, pbx_chan, false);
                    pbx_chan.async_op_compound.start();
                }
                else if (toid_username == pbx.pickup_shortcode && extn != null && ps == null && mg == null)
                {
                    //trying to pick up the call in the same group
                    SIPPBXExten extn1;
                    PickUpGroup pg;

                    LOG_Trace(1, "trying to find the extension which is in ringing status.");

                    for (int i = 0; i < pbx.pickup_groups.Count; i++)
                    {
                        extn1 = null;
                        pg = null;

                        for (int j = 0; j < pbx.pickup_groups[i].ml.members.Count; j++)
                        {
                            if (pbx.pickup_groups[i].ml.mb_type == 0)
                            {
                                if (pbx.pickup_groups[i].ml.members[j] == extn.UserName)
                                {
                                    //found the group
                                    pg = pbx.pickup_groups[i];
                                    break;
                                }
                            }
                            else
                            {
                                if (extn.Agent != null)
                                {
                                    if (pbx.pickup_groups[i].ml.members[j] == extn.Agent.Code)
                                    {
                                        //found the group
                                        pg = pbx.pickup_groups[i];
                                        break;
                                    }
                                }
                            }
                        }

                        if (pg != null)
                        {
                            for (int j = 0; j < pg.ml.members.Count; j++)
                            {
                                if (pg.ml.mb_type == 0)
                                    extn1 = pbx.getExtensionByName(pg.ml.members[j]);
                                else if (extn.Agent != null)
                                    extn1 = extn.Agent.AtExten;
                                else
                                    extn1 = null;

                                if (extn1 != null)
                                {
                                    if (extn1.InCalling != 21)
                                    {
                                        LOG_Trace(1, "Exten " + extn1.UserName + " is not in ringing status!" + extn1.InCalling.ToString());
                                    }
                                    else
                                    {
                                        for (int k = 0; k < GetChannelCount(); k++)
                                        {
                                            if (pbx.chan_list[k].link_exten == extn1 && extn1.InCalling == 21)
                                            {
                                                //set this pbx channel has the same unique call id
                                                pbx_chan.unique_call_id = pbx.chan_list[k].unique_call_id;
                                                pbx_chan.call_dir = pbx.chan_list[k].call_dir;

                                                pbx_chan.async_op_compound = new GTOpCallPickup(pbx, this, pbx_chan, pg, pbx.chan_list[k]);
                                                pbx_chan.async_op_compound.start();
                                                return;
                                            }

                                            LOG_Trace(1, "Channel " + k.ToString() + " is linked to extension " + ((pbx.chan_list[k].link_exten!=null)?pbx.chan_list[k].link_exten.UserName:"") );
                                        }
                                    }
                                }
                                else
                                {
                                    LOG_Trace(1, "Pickup Group member " + pg.ml.members[j] + " doesn't have an extension match!");
                                }
                            }
                        }
                    }
                }
                else if (toid_username.IndexOf(pbx.pickup_shortcode) == 0 && extn != null && ps == null && mg == null)
                {
                    //trying to pick up the call in other group
                    string sPickupCode = toid_username.Substring(pbx.pickup_shortcode.Length);

                    for (int k = 0; k < GetChannelCount(); k++)
                    {
                        if (pbx.chan_list[k].link_exten != null)
                        {
                            if (pbx.chan_list[k].link_exten.InCalling == 21)
                            {
                                if (pbx.chan_list[k].link_exten.UserName == sPickupCode ||
                                    (pbx.chan_list[k].link_exten.Agent != null ? pbx.chan_list[k].link_exten.Agent.Code : "") == sPickupCode)
                                {
                                    //set this pbx channel has the same unique call id
                                    pbx_chan.unique_call_id = pbx.chan_list[k].unique_call_id;
                                    pbx_chan.call_dir = pbx.chan_list[k].call_dir;

                                    pbx_chan.async_op_compound = new GTOpCallPickup(pbx, this, pbx_chan, null, pbx.chan_list[k]);
                                    pbx_chan.async_op_compound.start();
                                    return;
                                }
                                else
                                {
                                    LOG_Trace(1, "Channel " + k.ToString() + " linked extension " + pbx.chan_list[k].link_exten.UAName + " is in ringing, but is not choosed for pickup!");
                                }
                            }
                            else
                            {
                                LOG_Trace(1, "Channel " + k.ToString() + " is not in ringing status");
                            }
                        }
                        else
                        {
                            LOG_Trace(1, "Channel " + k.ToString() + " doesn't have an extension!");
                        }
                    }
                }
                else
                {
                    if (pbx_chan.link_exten != null && ps != null)
                    {
                        if (ps.playMOH)
                            Send_StopMusicOnHold(ps.pbxChan.index);

                        //set this pbx channel has the same unique call id
                        pbx_chan.unique_call_id = ps.pbxChan.unique_call_id;
                        pbx_chan.call_dir = ps.pbxChan.call_dir;

                        pbx_chan.async_op_compound = new GTOpCallBridge(pbx, this, pbx_chan, ps.pbxChan);
                        pbx_chan.async_op_compound.start();

                        ps.pbxChan.async_op_compound = null;
                        ps.pbxChan = null;
                    }
                    else if (pbx_chan.link_exten != null && mg != null)
                    {
                        pbx_chan.async_op_compound = new GTOpMonitorGroup(pbx, this, pbx_chan, mg, pbx_chan.link_exten);
                        pbx_chan.async_op_compound.start();
                    }
                }
            }

conn_op:
            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvConnected(ch);
                    }
                }
            }

        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);
            GTAPIASM.GTAPIChan api_chan = GetChannel(ch);
            SIPPBXChan pbx_chan = pbx.chan_list[ch];

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 1");

            lock(pbx_chan)
            {
                if (pbx_chan.openAI != null)
                {
                    try
                    {
                        pbx_chan.openAI.Free();
                    }
                    catch (Exception ex)
                    {
                        LogoutText(ex.ToString());
                    }
                    pbx_chan.openAI = null;
                }
            }

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 2");

            int at_idx = desc.IndexOf("HangupParty:");
            if (at_idx >= 0)
            {
                string discParty = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, desc.Substring(at_idx + 12));
                pbx_chan.SetHangupParty(this, discParty);
                pbx_chan.SetDiscReason(this, desc.Substring(0, at_idx));
            }
            else
            {
                pbx_chan.SetDiscReason(this, desc);
            }

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 3");

            try
            {
                string sEventCmd = "";
                sEventCmd += ch.ToString() + "|";
                sEventCmd += pbx_chan.unique_call_id + "|";
                //sEventCmd += GetSIPAddressInfo(1, sCaller) + "|";
                //sEventCmd += GetSIPAddressInfo(1, sCallee) + "|";
                if (pbx_chan.dp != null)
                {
                    sEventCmd += pbx_chan.dp.planName + "|";
                }
                else
                {
                    sEventCmd += "|";
                }
                sEventCmd += pbx_chan.RecordFileName + "|";
                pbx.manager.SendEvent("CallIdle", sEventCmd);
            }
            catch (Exception e)
            {
                LOG_Trace(1, e.ToString());
                LogoutText(e.ToString());
            }

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 4");

            try
            {
                //check if it is in one of parking slots
                SIPPBXParkingSlot ps = pbx.IsPBXChanInParkingSlot(pbx_chan);
                if (ps != null)
                    ps.pbxChan = null;
            }
            catch (Exception e)
            {
                LOG_Trace(1, e.ToString());
                LogoutText(e.ToString());
            }

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 5");

            try
            {
                //check if it is in one of conference
                pbx.RemoveChanFromConferenceRoom(this, pbx_chan);
            }
            catch (Exception e)
            {
                LOG_Trace(1, e.ToString());
                LogoutText(e.ToString());
            }

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 6");


            SIPPBXExten extn = pbx_chan.link_exten;
            if (extn != null)
            {
                pbx.SetExtenCallingState(extn, this, 0); //idle
                extn.IdleStartTime = DateTime.Now;
                RefreshMainWnd();

                LOG_Trace(4, "On_RecvIdle " + ch.ToString() + " extension " + extn.UserName + " is set to idle");
            }

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 7");

            /*
                        else
                        {
                            LOG_Trace(4, "On_RecvIdle no extension for channel " + ch.ToString());
                        }

                        for (int i = 0; i < GetChannelCount(); i++)
                        {
                            if (pbx.chan_list[i].link_exten != null)
                            {
                                LOG_Trace(4, "On_RecvConnected channel " + i.ToString() + " is linked to extension " + pbx.chan_list[i].link_exten.UserName);
                            }
                            else
                            {
                                LOG_Trace(4, "On_RecvConnected channel " + i.ToString() + " is NOT linked any extension");
                            }
                        }*/

            try
            {
                for (int i = 0; i < GetChannelCount(); i++)
                {
                    if (pbx.chan_list[i].async_op_compound != null)
                    {
                        if (pbx.chan_list[i].async_op_compound.op != null)
                        {
                            pbx.chan_list[i].async_op_compound.op.On_RecvIdle(ch, code, desc);
                        }
                    }
                }
            }
            catch (Exception e)
            {
                LOG_Trace(1, e.ToString());
                LogoutText(e.ToString());
            }

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 8");


            PBX_CDR pbx_cdr = pbx.WriteCDR(this, api_chan, pbx_chan);

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 9");


            try
            {
                if (pbx_chan.call_job != null)
                {
                    if (pbx_chan.call_job.CallResult == 1)
                    {
                        pbx_chan.call_job.EndTime = DateTime.Now;
                    }
                    else
                    {
                        pbx_chan.call_job.BeginTime = pbx_chan.call_job.EndTime = DateTime.Now;

                        if (pbx_chan.call_job.CallResult == 0)
                        {
                            pbx_chan.call_job.CallResult = GetChanLastMsgCode(ch);
                        }
                    }

                    pbx_chan.call_job.finalCode = code;
                    pbx_chan.call_job.finalCodeDesc = desc;
                    pbx_chan.call_job.CallID = pbx_cdr.unique_call_id;
                    pbx_chan.call_job.RecordFile = pbx_cdr.record_file;

                    if (pbx_chan.call_job.Task.m_bEnableDetect)
                    {
                        Send_DisableVAD(pbx_chan.index);
                    }

                    if(!pbx_chan.call_job.isCallBack)
                        pbx_chan.call_job.Task.m_JobsDone.Enqueue(pbx_chan.call_job);
                    pbx_chan.call_job = null;
                }
            }
            catch (Exception e)
            {
                LOG_Trace(1, e.ToString());
                LogoutText(e.ToString());
            }

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 10");

            //run 'CallIdle' plugin
            for (int i = 0; i < pbx.plugins.Count; i++)
            {
                ISIPPBXPluginClient client = pbx.plugins[i];
                if (client == null)
                    break;

                if (client.Type == "CallIdle")
                {
                    SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
                    plugin_host.pbx_chan = pbx_chan;
                    plugin_host.env = this;
                    plugin_host.Client = client;
                    client.Host = plugin_host;
                    try
                    {
                        client.Start();
                        client.Done();
                    }
                    catch (Exception ex)
                    {
                        LogoutText(ex.ToString());
                    }
                }
            }

            //LOG_Trace(4, "GTSIPPBXEnv::On_RecvIdle 11");

            pbx_chan.Reset();
        }

        public override void On_RecvRinging(int ch)
        {
            base.On_RecvRinging(ch);

            SIPPBXExten extn = pbx.chan_list[ch].link_exten;
            if (extn != null)
            {
                pbx.SetExtenCallingState(extn, this, 21); //ringing
                RefreshMainWnd();
                LOG_Trace(4, "On_RecvRinging " + ch.ToString() + " extension " + extn.UserName + " is set to ringing.");
            }
/*
            else
            {
                LOG_Trace(4, "On_RecvRinging no extension for channel " + ch.ToString());
            }

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].link_exten != null)
                {
                    LOG_Trace(4, "On_RecvConnected channel " + i.ToString() + " is linked to extension " + pbx.chan_list[i].link_exten.UserName);
                }
                else
                {
                    LOG_Trace(4, "On_RecvConnected channel " + i.ToString() + " is NOT linked any extension");
                }
            }
*/

            string sEventCmd = "";
            sEventCmd += ch.ToString() + "|";
            sEventCmd += pbx.chan_list[ch].unique_call_id + "|";
            //sEventCmd += GetSIPAddressInfo(1, sCaller) + "|";
            //sEventCmd += GetSIPAddressInfo(1, sCallee) + "|";
            if (pbx.chan_list[ch].dp != null)
            {
                sEventCmd += pbx.chan_list[ch].dp.planName + "|";
            }
            else
            {
                sEventCmd += "|";
            }
            sEventCmd += pbx.chan_list[ch].RecordFileName + "|";
            pbx.manager.SendEvent("CallRinging", sEventCmd);

            if (pbx.chan_list[ch].call_job != null)
            {
                pbx.chan_list[ch].call_job.CallResult = 180;
                if (pbx.chan_list[ch].call_job.Task.m_ringTimeout > 0)
                {
                    StartTimer(ch, (uint)(pbx.chan_list[ch].call_job.Task.m_ringTimeout * 1000));
                    //return;
                }
            }
            
			//run 'CallRinging' plugin
			for (int i = 0; i < pbx.plugins.Count; i++)
			{
				ISIPPBXPluginClient client = pbx.plugins[i];
				if (client == null)
					break;

				if (client.Type == "CallRinging")
				{
					SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
					plugin_host.pbx_chan = pbx.chan_list[ch];
					plugin_host.env = this;
					plugin_host.Client = client;
					client.Host = plugin_host;
					try
					{
						client.Start();
						client.Done();
					}
					catch (Exception ex)
					{
						LogoutText(ex.ToString());
					}
				}
			}            

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvRinging(ch);
                    }
                }
            }

        }

        public override void On_RecvDialing(int ch, string sCaller, string sCallee)
        {
            base.On_RecvDialing(ch, sCaller, sCallee);

            SIPPBXExten extn = pbx.chan_list[ch].link_exten;
            if (extn != null)
            {
                pbx.SetExtenCallingState(extn, this, 20); //dialing
                RefreshMainWnd();
                LOG_Trace(4, "On_RecvDialing " + ch.ToString() + " extension " + extn.UserName + " is set to calling.");
            }
/*
            else
            {
                LOG_Trace(4, "On_RecvDialing no extension for channel " + ch.ToString());
            }

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].link_exten != null)
                {
                    LOG_Trace(4, "On_RecvConnected channel " + i.ToString() + " is linked to extension " + pbx.chan_list[i].link_exten.UserName);
                }
                else
                {
                    LOG_Trace(4, "On_RecvConnected channel " + i.ToString() + " is NOT linked any extension");
                }
            }
 */

            string sEventCmd = "";
            sEventCmd += ch.ToString() + "|";
            sEventCmd += pbx.chan_list[ch].unique_call_id + "|";

            string caller_id = GetSIPAddressInfo(1, sCaller);
            string callee_id = GetSIPAddressInfo(1, sCallee);

            if (extn != null)
            {
                /*if (extn.UserName == caller_id)
                {
                    sEventCmd += "EXTN:" + caller_id + "|";
                    sEventCmd += callee_id + "|";
                }
                else
                if (extn.UserName == callee_id)*/
                {
                    sEventCmd += caller_id + "|";
                    sEventCmd += "EXTN:" + callee_id + "|";
                }
                /*else
                {
                    sEventCmd += caller_id + "|";
                    sEventCmd += callee_id + "|";
                }*/
            }
            else
            {
                sEventCmd += caller_id + "|";
                sEventCmd += callee_id + "|";
            }

            if (pbx.chan_list[ch].dp != null)
            {
                sEventCmd += pbx.chan_list[ch].dp.planName + "|";
            }
            else
            {
                sEventCmd += "|";
            }
            sEventCmd += pbx.chan_list[ch].RecordFileName + "|";
            pbx.manager.SendEvent("CallDialing", sEventCmd);
            
            //run 'CallDialing' plugin
			for (int i = 0; i < pbx.plugins.Count; i++)
            {
                ISIPPBXPluginClient client = pbx.plugins[i];
                if (client == null)
                    break;

                if (client.Type == "CallDialing")
                {
                    SIPPBXPluginHost plugin_host = new SIPPBXPluginHost();
                    plugin_host.pbx_chan = pbx.chan_list[ch];
                    plugin_host.env = this;
                    plugin_host.Client = client;
                    client.Host = plugin_host;
                    try
                    {
                        client.Start();
                        client.Done();
                    }
                    catch (Exception ex)
                    {
                        LogoutText(ex.ToString());
                    }
                }
            }                        

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvDialing(ch, sCaller, sCallee);
                    }
                }
            }

        }

        public override void  On_RecvTransfering(int ch, string sAddr, string sReplaceCallID, string sReplaceFromTag, string sReplaceToTag)
        {
            base.On_RecvTransfering(ch, sAddr, sReplaceCallID, sReplaceFromTag, sReplaceToTag);

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvTransfering(ch, sAddr, sReplaceCallID, sReplaceFromTag, sReplaceToTag);
                    }
                }
            }
        }

        public override void On_RecvConfAudioPlayDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvConfAudioPlayDone(ch, doneReason, dtmfBuffer);

            LOG_Trace(4, "On_RecvConfAudioPlayDone " + ch.ToString() + " " + doneReason.ToString());

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvConfAudioPlayDone(ch, doneReason, dtmfBuffer);
                    }
                }
            }
        }

        public override void On_RecvConfAudioRecordDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvConfAudioRecordDone(ch, doneReason, dtmfBuffer);

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvConfAudioRecordDone(ch, doneReason, dtmfBuffer);
                    }
                }
            }
        }

        public override void On_RecvAudioPlayDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvAudioPlayDone(ch, doneReason, dtmfBuffer);

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvAudioPlayDone(ch, doneReason, dtmfBuffer);
                    }
                }
            }
        }

        public override void On_RecvAudioRecordDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvAudioRecordDone(ch, doneReason, dtmfBuffer);

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvAudioRecordDone(ch, doneReason, dtmfBuffer);
                    }
                }
            }
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvDTMFKeyUp(ch, keyValue, ticks);
                    }
                }
            }
        }

        public override void On_RecvDTMFDone(int ch, int doneReason, string dtmfBuf)
        {
            base.On_RecvDTMFDone(ch, doneReason, dtmfBuf);

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvDTMFDone(ch, doneReason, dtmfBuf);
                    }
                }
            }
        }

        public override void On_RecvError(int ch, int errCode)
        {
            base.On_RecvError(ch, errCode);

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvError(ch, errCode);
                    }
                }
            }
        }

        public override void On_RecvSessionProgress(int ch)
        {
            base.On_RecvSessionProgress(ch);


            SIPPBXExten extn = pbx.chan_list[ch].link_exten;
            if (extn != null)
            {
                pbx.SetExtenCallingState(extn, this, 21); //ringing or session progress
                RefreshMainWnd();
                LOG_Trace(4, "On_RecvSessionProgress " + ch.ToString() + " extension " + extn.UserName + " is set to ringing.");
            }
/*
            else
            {
                LOG_Trace(4, "On_RecvSessionProgress no extension for channel " + ch.ToString());
            }

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].link_exten != null)
                {
                    LOG_Trace(4, "On_RecvSessionProgress channel " + i.ToString() + " is linked to extension " + pbx.chan_list[i].link_exten.UserName);
                }
                else
                {
                    LOG_Trace(4, "On_RecvSessionProgress channel " + i.ToString() + " is NOT linked any extension");
                }
            }
*/

            string sEventCmd = "";
            sEventCmd += ch.ToString() + "|";
            sEventCmd += pbx.chan_list[ch].unique_call_id + "|";
            //sEventCmd += GetSIPAddressInfo(1, sCaller) + "|";
            //sEventCmd += GetSIPAddressInfo(1, sCallee) + "|";
            if (pbx.chan_list[ch].dp != null)
            {
                sEventCmd += pbx.chan_list[ch].dp.planName + "|";
            }
            else
            {
                sEventCmd += "|";
            }
            sEventCmd += pbx.chan_list[ch].RecordFileName + "|";
            pbx.manager.SendEvent("CallRinging", sEventCmd);

            if (pbx.chan_list[ch].call_job != null)
            {
                pbx.chan_list[ch].call_job.CallResult = 183;
                if (pbx.chan_list[ch].call_job.Task.m_ringTimeout > 0)
                    StartTimer(ch, (uint)pbx.chan_list[ch].call_job.Task.m_ringTimeout * 1000);
                //return;
            }


            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvSessionProgress(ch);
                    }
                }
            }

        }


        public override void On_RecvHolding(int ch, int hold_on)
        {
            base.On_RecvHolding(ch, hold_on);

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_RecvHolding(ch, hold_on);
                    }
                }
            }

            string sEventCmd = "";
            sEventCmd += ch.ToString() + "|";
            sEventCmd += pbx.chan_list[ch].unique_call_id + "|";
            sEventCmd += hold_on.ToString();
            pbx.manager.SendEvent("CallHolding", sEventCmd);
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (pbx.chan_list[ch].call_job != null)
            {
                if (pbx.chan_list[ch].call_job.CallResult == 180 ||
                    pbx.chan_list[ch].call_job.CallResult == 183)
                {
                    DisconnectCall(ch, 0, "", "PBX: Ring timeout for auto dialer call job");
                    pbx.chan_list[ch].call_job.BeginTime = pbx.chan_list[ch].call_job.EndTime = DateTime.Now;
                    pbx.chan_list[ch].call_job.CallID = pbx.chan_list[ch].unique_call_id;
                    pbx.chan_list[ch].call_job.RecordFile = pbx.chan_list[ch].RecordFileName;

                    if (!pbx.chan_list[ch].call_job.isCallBack)
                         pbx.chan_list[ch].call_job.Task.m_JobsDone.Enqueue(pbx.chan_list[ch].call_job);

                    pbx.chan_list[ch].call_job = null;

                    return;
                }
            }

            for (int i = 0; i < GetChannelCount(); i++)
            {
                if (pbx.chan_list[i].async_op_compound != null)
                {
                    if (pbx.chan_list[i].async_op_compound.op != null)
                    {
                        pbx.chan_list[i].async_op_compound.op.On_Timer(ch);
                    }
                }
            }
        }

        public override void On_RecvRegStatus(int user_id, int status, int regtime)
        {
            base.On_RecvRegStatus(user_id, status, regtime);

            if (pbx.sip_acct.Count > 0)
            {
                if (user_id < pbx.sip_acct.Count)
                {
                    if (status == 1)
                    {
                        pbx.sip_acct[user_id].Registered = true;
                        LogoutText("SIP Account(" + pbx.sip_acct[user_id].UserName + ") Registered to " + pbx.sip_acct[user_id].DomainServer);
                    }
                    else
                    {
                        if(pbx.sip_acct[user_id].RegWithProxyServer)
                        {
                            pbx.sip_acct[user_id].Registered = false;
                            LogoutText("SIP Account(" + pbx.sip_acct[user_id].UserName + ") couldn't registered to " + pbx.sip_acct[user_id].DomainServer);
                        }
                    }
                }
            }

            RefreshMainWnd();
        }

        public override void On_RecvNoAudio(int ch, int reserved)
        {
            base.On_RecvNoAudio(ch, reserved);

            LOG_Trace(4, "No Audio Stream for " + pbx.pbx_sys_set.NoAudioDisconnectDur.ToString() + " seconds. ");

            if (pbx.pbx_sys_set.bNoAudioDisconnect)
            {
                //SIPPBXChan chan = pbx.chan_list[ch];
                //TimeSpan tsp = DateTime.Now - chan.NoAudioFirstTime;
                //if (tsp.TotalSeconds >= 8 && tsp.TotalSeconds < 12)
                //{
                LOG_Trace(4, "Disconnect chan " + ch.ToString() + " for no audio stream");
                DisconnectCall(ch, 0, "", "PBX: No audio disconnect");
                //}
                //else if (tsp.TotalSeconds >= 12)
                //{
                //    chan.NoAudioFirstTime = DateTime.Now;
                //}
                //else
                //{
                //    LOG_Trace(4, "RecvNoAudio Chan:" + ch.ToString());
                //}
            }
        }

/*
        public override string GetProxyUserContact(uint pid, string username)
        {
            SIPPBXExten extn = pbx.getExtensionByName(username);
            if (extn != null)
                return extn.ContactAddr;
            else
                return "";
        }

        public override int GetProxyUserNATType(uint pid, string username)
        {
            SIPPBXExten extn = pbx.getExtensionByName(username);
            if (extn != null)
                return extn.NATType;
            else
                return -1;
        }

        public override string GetProxyUserPassword(uint pid, string username)
        {
            SIPPBXExten extn = pbx.getExtensionByName(username);
            if (extn != null)
                return extn.Password;
            else
                return "";
        }

        public override uint GetProxyUserRegExpire(uint pid, string username)
        {
            SIPPBXExten extn = pbx.getExtensionByName(username);
            if (extn != null)
                return extn.RegisterExpire;
            else
                return 0;
        }

        public override uint GetProxyUserRegTime(uint pid, string username)
        {
            SIPPBXExten extn = pbx.getExtensionByName(username);
            if (extn != null)
                return extn.RegSDKTime;
            else
                return 0;
        }

        public override string GetProxyUserUAName(uint pid, string username)
        {
            SIPPBXExten extn = pbx.getExtensionByName(username);
            if (extn != null)
                return extn.UAName;
            else
                return "";
         }

        public override int GetProxyUserValid(uint pid, string username)
        {
            SIPPBXExten extn = pbx.getExtensionByName(username);
            if (extn != null)
                return 1;
            else
                return 0;
        }
*/

        /*here is the patch for Snom320 phone
         * Contact: <sip:101@192.168.1.112:2048;line=5ivgzovu>;reg-id=1;q=1.0;+sip.instance="<urn:uuid:3408bd68-8f69-4bb3-9957-e9548ca24fac>";audio;mobility="fixed";duplex="full";description="snom320";actor="principal";events="dialog";methods="INVITE,ACK,CANCEL,BYE,REFER,OPTIONS,NOTIFY,SUBSCRIBE,PRACK,MESSAGE,INFO"
         * without line=5ivgzovu in INVITE uri, the phone will return 404 User Not Found message.
        */
        public string GetSIPContactAddrInfo(string sContactAddr)
        {
            int nBegin = sContactAddr.IndexOf("<sip:");
            if(nBegin >= 0)
            {
                int nEnd = sContactAddr.Substring(nBegin).IndexOf('>');
                if (nEnd > 0)
                {
                    return sContactAddr.Substring(nBegin, nEnd + 1);
                }
            }

            return MakeSIPAddrByContactInfo(sContactAddr);
        }

        public override void On_ProxyUserRegistered(uint pid, string username, ulong tnow, uint exp_sec, string org_contact, string mapped_contact, string szUAName, int UANatType, string from_id, string to_id, string src_ip, ushort src_port)
        {
            //thread of low level SDK API, should add a lock
            //UANatType: Network Protocol Type. 0  = UDP, 1 = TCP, 2 = TLS
            lock (this)
            {
                try
                {
                    base.On_ProxyUserRegistered(pid, username, tnow, exp_sec, org_contact, mapped_contact, szUAName, UANatType, from_id, to_id, src_ip, src_port);

                    bool fnd = false;
                    SIPPBXExten extn = pbx.getExtensionByName(username);
                    if (extn != null)
                    {
                        extn.RegSDKTime = tnow;
                        extn.RegisterTime = DateTime.Now;
                        extn.RegisterExpire = exp_sec;
                        extn.ContactAddr = GetSIPContactAddrInfo(org_contact);
                        extn.MappedContactAddr = mapped_contact;
                        extn.UAName = szUAName;
                        extn.NATType = UANatType; //UANatType: Network Protocol Type. 0  = UDP, 1 = TCP, 2 = TLS
                        if (extn.NATType < 0) 
                            extn.NATType = 0;

                        extn.RegFromID = from_id;
                        extn.RegToID = to_id;
                        extn.RegSrcIP = src_ip;
                        extn.RegSrcPort = src_port;
                        fnd = true;
                    }

                    string sLogInfo = "";
                    if (exp_sec > 0)
                    {
                        sLogInfo = "Extension " + username + " just registered! Its contact info: " + org_contact;
                        if (mapped_contact.Length > 0)
                            sLogInfo += " Mapped Contact:" + mapped_contact;
                    }
                    else if (fnd)
                        sLogInfo = "Extension " + username + " just unregistered!";

                    if (sLogInfo.Length > 0)
                        LogoutText(sLogInfo);

                    if (!fnd && exp_sec > 0)
                    {
                        LogoutText(username + " registered, but it is not an extension any more!");
                    }

                    RefreshMainWnd();

                    if (extn != null)
                    {
                        if (!SIPPBXCFGDB.SaveExtensionStatusConfigToDB(extn, pbxMain, pbx, this, pbxMain.dbPBXSet, pbxMain.GetPBXLog()))
                        {
                            sLogInfo = "Extension " + username + " latest status cannot be saved into DB";
                            LogoutText(sLogInfo);

                            pbxMain.dbPBXSet.ResetConnection();
                        }

                        if (extn.IsRegistered() && extn.vmb != null)
                            SIPPBXDBUtil.UpdateExtenVoiceMailFromDB(pbx, this, extn, pbxMain.dbPBXSet, pbxMain.GetPBXLog());
                    }
                }
                catch (Exception ex)
                {
                    LOG_Trace(1, "*************On_ProxyUserRegistered got exception: " + ex.Message);
                    LOG_Trace(1, ex.ToString());
                }
            }

        }


        /*
        public override void On_ProxyCallTransaction(uint pid, uint sid, string szFrom, string szTo, string szUri, string szVia, string szRealContact, uint t_start, uint t_end, int session_status, int result_code, string result_txt)
        {
            base.On_ProxyCallTransaction(pid, sid, szFrom, szTo, szUri, szVia, szRealContact, t_start, t_end, session_status, result_code, result_txt);

            string sLogInfo = szFrom + "=>" + szTo + " Reached:" + szRealContact + " " + result_txt;
            LogoutText(sLogInfo);

            SIPProxySite pbxsite = pbx.sip_proxy_sites[0];
            if (pbxsite != null)
            {
                string caller_name = GetSIPAddressInfo(1, szFrom);
                string caller_domain = GetSIPAddressInfo(2, szFrom);
                string callee_name = GetSIPAddressInfo(1, szTo);
                string callee_domain = GetSIPAddressInfo(2, szTo);

                if (pbxsite.domainList.Contains(caller_domain))
                {
                    for (int i = 0; i < pbx.sip_exten.Count; i++)
                    {
                        if (pbx.sip_exten[i].UserName == caller_name)
                        {
                            pbx.sip_exten[i].InCalling = false;
                            RefreshMainWnd();
                            break;
                        }
                    }
                }

                if (pbxsite.domainList.Contains(callee_domain))
                {
                    for (int i = 0; i < pbx.sip_exten.Count; i++)
                    {
                        if (pbx.sip_exten[i].UserName == callee_name)
                        {
                            pbx.sip_exten[i].InCalling = false;
                            RefreshMainWnd();
                            break;
                        }
                    }
                }

                for (int i = 0; i < pbx.sip_proxycalls.Count; i++)
                {
                    if (pbx.sip_proxycalls[i].pid == pid && pbx.sip_proxycalls[i].sid == sid)
                    {
                        if (pbx.sip_proxycalls[i].extnFrom != null)
                        {
                            pbx.sip_proxycalls[i].extnFrom.InCalling = false;
                        }
                        if (pbx.sip_proxycalls[i].extnTo != null)
                        {
                            pbx.sip_proxycalls[i].extnTo.InCalling = false;
                        }
                        break;
                    }
                }

            }

        }
        */

        public string ProxyLBOutboundCall(SIPPBXDest dest, string sCallee, string sCaller, SIPPBXExten caller_extn)
        {
            if (dest.DestAddr.Contains(".") || dest.DestAddr.Contains("@"))
            {
                //sip address
                if (dest.DestAddr.Contains("sip:"))
                {
                    return dest.DestAddr;
                }
                else
                {
                    return "<sip:" + dest.DestAddr + ">";
                }
            }
            else
            {
                //to see if it matchs any outbound rules
                SIPPBXDialPlan dp1 = pbx.getDialPlanByCalledNum(this, dest.DestAddr, "", sCaller, "", caller_extn, 1);
                if (dp1 != null)
                {
                    SIPAccount sip_acct = pbx.getDialPlanSIPAccount(dp1);
                    if (sip_acct!= null)
                    {
                        //outbound, should take out predix digit, then use another channel to dialout
                        string destaddr = dp1.OutboundPrepend + dest.DestAddr.Substring(dp1.OutboundPreStrip.Length);
                        destaddr += "@" + sip_acct.DomainServer;
                        destaddr = "<sip:" + destaddr + ">";

                        string fromaddr = sip_acct.UserName + "@" + sip_acct.DomainServer;
                        fromaddr = sip_acct.DisplayName + "<sip:" + fromaddr + ">";

                        return "To" + destaddr + "|From" + fromaddr + "|User<" + sip_acct.AuthName + ">|Password<" + sip_acct.Password + ">";
                    }
                }
            }

            return "";
        }

        public override string On_ProxyNewCallSession(uint pid, uint sid, IntPtr msg, string authid, string fromid, string toid, string suri, string via, string saddr, ushort nport, bool bCredit)
        {
            string ret = "channel";

            //lock (this)
            {

                try
                {
                    LOG_Trace(4, "On_ProxyNewCallSession " + pid.ToString() + " " + sid.ToString() + " " + msg.ToString() + " " + authid + " " + fromid + " " + toid + " " + suri + " " + via + " " + saddr + " " + nport.ToString() + " " + (bCredit ? "1" : "0"));

                    string toid_username = GetSIPAddressInfo(1, toid);

                    string fromid_username = GetSIPAddressInfo(1, fromid);

                    //LOG_Trace(4, "On_ProxyNewCallSession step 1");

                    SIPPBXExten caller_extn = pbx.getExtensionBySIPAddr(fromid);

                    //LOG_Trace(4, "On_ProxyNewCallSession step 2");

                    SIPPBXExten callee_extn = pbx.getExtensionBySIPAddr(toid);

                    //LOG_Trace(4, "On_ProxyNewCallSession step 3");

                    SIPPBXDialPlan dp = pbx.getDialPlanByCalledNum(this, toid_username, GetSIPAddressInfo(2, toid), fromid_username, GetSIPAddressInfo(2, fromid), caller_extn, 2);

                    //LOG_Trace(4, "On_ProxyNewCallSession step 4");

                    SIPPBXParkingSlot ps = pbx.getParkingSlotByNumber(toid_username);

                    //LOG_Trace(4, "On_ProxyNewCallSession step 5");

                    if (caller_extn != null && !bCredit)
                    {
                        if (caller_extn.AuthType != 2)
                        {
                            ret = "unauthorized";
                            return ret;
                        }
                    }

                    if (dp != null)
                    {
                        //one of dialplan
                        //direct to channel here first

                        if (dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                        {
                            if (!bCredit)
                            {
                                if (caller_extn != null)
                                {
                                    if(caller_extn.AuthType != 2)
                                        ret = "unauthorized";
                                }
                                else //caller is not an extension. Forbid for outbound call
                                {
                                    ret = "rejected";
                                }
                            }
                        }
                    }


                    //LOG_Trace(4, "On_ProxyNewCallSession step 6");

                    if (ret == "channel")
                    {
                        if (pbx.lb_on)
                        {
                            ret = "";
                            SIPPBXDest dest = null;
                            //load balance is on, not send calls to channel
                            if (pbx.lb_addrs.Count > 0)
                            {
                                if (pbx.lb_idx >= 0 && pbx.lb_idx < pbx.lb_addrs.Count)
                                    dest = pbx.lb_addrs[pbx.lb_idx++];
                                else
                                {
                                    dest = pbx.lb_addrs[0];
                                    pbx.lb_idx = 1;
                                }

                                //pbx.lb_idx %= pbx.lb_addrs.Count; //not neccessary

                                if (dest != null)
                                {
                                    switch (dest.DestType)
                                    {
                                        case 0: //extensions
                                            SIPPBXExten extn = pbx.getExtensionByName(dest.DestAddr);
                                            if (extn != null)
                                                ret = extn.ContactAddr;
                                            break;
                                        case 1:
                                            ret = ProxyLBOutboundCall(dest, toid_username, fromid_username, caller_extn);
                                            break;
                                        case 2:
                                            ret = dest.DestAddr;
                                            break;
                                    }
                                }
                            }
                        }
                    }

                    //LOG_Trace(4, "On_ProxyNewCallSession step 7");
                }
                catch (Exception ex)
                {
                    LOG_Trace(1, "*************On_ProxyNewCallSession got exception: " + ex.Message);
                    LOG_Trace(1, ex.ToString());
                    ret = "channel";
                }
            }

            return ret;
        }

        public override void On_RecvMessageText(int ch, string sFrom, string sTo, string sDestAddr, string sViaAddr, string sContent)
        {
            base.On_RecvMessageText(ch, sFrom, sTo, sDestAddr, sViaAddr, sContent);
            //LogoutText("Received SIP MESSAGE:[" + sViaAddr + "]");
            //LogoutText("Content:[" + sContent + "]");

            SIPPBXExten caller_extn = pbx.getExtensionBySIPAddr(sFrom);
            SIPPBXExten callee_extn = pbx.getExtensionBySIPAddr(sTo);

            if (callee_extn != null)
            {
                if (callee_extn.IsRegistered())
                {
                    Send_MessageText(ch, sFrom, callee_extn.ContactAddr, sContent);
                }
                else if (caller_extn != null)
                {
                    Send_MessageText(ch, sTo, caller_extn.ContactAddr, "ERROR: " + callee_extn.UserName + " is not online yet!");
                }
            }
            else
            {
                LogoutText("Got MESSAGE from " + sFrom + " to " + sTo + " for " + sDestAddr + " :[" + sContent + "]");
            }

        }

        public override void On_RecvMessageTextDelivered(int ch, int msg_code, string msg_txt)
        {
            base.On_RecvMessageTextDelivered(ch, msg_code, msg_txt);
        }
/*
        public override void On_ProxyCallSessionStatus(uint pid, uint sid, uint sbegin, uint send, int status, string szFrom, string szTo, string szURI, string szVia, string szRealContact)
        {
            base.On_ProxyCallSessionStatus(pid, sid, sbegin, send, status, szFrom, szTo, szURI, szVia, szRealContact);
            if (status == 11) //call is connected
            {
                SIPProxySite pbxsite = pbx.sip_proxy_sites[0];
                if (pbxsite != null)
                {
                    string caller_name = GetSIPAddressInfo(1, szFrom);
                    string caller_domain = GetSIPAddressInfo(2, szFrom);
                    string callee_name = GetSIPAddressInfo(1, szTo);
                    string callee_domain = GetSIPAddressInfo(2, szTo);

                    if (pbxsite.domainList.Contains(caller_domain))
                    {
                        for (int i = 0; i < pbx.sip_exten.Count; i++ )
                        {
                            if (pbx.sip_exten[i].UserName == caller_name)
                            {
                                pbx.sip_exten[i].InCalling = true;
                                RefreshMainWnd();
                                break;
                            }
                        }
                    }

                    if (pbxsite.domainList.Contains(callee_domain))
                    {
                        for (int i = 0; i < pbx.sip_exten.Count; i++)
                        {
                            if (pbx.sip_exten[i].UserName == callee_name)
                            {
                                pbx.sip_exten[i].InCalling = true;
                                RefreshMainWnd();
                                break;
                            }
                        }
                    }
                }

                for (int i = 0; i < pbx.sip_proxycalls.Count; i++)
                {
                    if (pbx.sip_proxycalls[i].pid == pid && pbx.sip_proxycalls[i].sid == sid)
                    {
                        if (pbx.sip_proxycalls[i].extnFrom != null)
                        {
                            pbx.sip_proxycalls[i].extnFrom.InCalling = true;
                        }
                        if (pbx.sip_proxycalls[i].extnTo != null)
                        {
                            pbx.sip_proxycalls[i].extnTo.InCalling = true;
                        }
                        break;
                    }
                }
            }

        }
*/

        private void RefreshMainWnd()
        {
            //LogoutText("refresh");
            //need add an interface here to refresh client program's
            //don't need it any more because all data are exchanged by DB now.
        }

        public void LogoutText(string s)
        {
            //empty log function for now
            lock (m_logQueue)
            {
                m_logQueue.Enqueue(s);
            }
        }

        public void DisconnectCall(int ch, int code, string desc)
        {
            DisconnectCall(ch, code, desc, "");
        }
        
        public void DisconnectCall(int ch, int code, string desc, string dbdesc)
        {
			if(dbdesc == "") dbdesc = "PBX";
			Send_HangUp(ch, code, desc);
			pbx.chan_list[ch].SetDiscReason(this, dbdesc);
		}

        public bool IsChanConnected(int ch)
        {
            GTAPIASM.GTAPIChan apichan = GetChannel(ch);
            if (apichan.ch_status == GTAPI_CHANNEL_STATE.CONNECTED ||
                apichan.ch_status == GTAPI_CHANNEL_STATE.BE_HOLDED ||
                apichan.ch_status == GTAPI_CHANNEL_STATE.HOLDING)
                return true;
            return false;
        }

/*
        public string ProxyInboundCallToExtension(SIPPBXExten extn, string caller, string callee)
        {
            string s1;
            string ret = "channel";
            string ret1 = "";
            bool transfered = false;

            if (extn.IsSupervisorExten())
            {
                //virtual extension, should use VirtualExtenDestAddr
                ret = GetOutboundProxyAddr(extn.VirtualExtenDestAddr);
                ret1 = extn.VirtualExtenDestAddr;
                transfered = true;
            }
            else
            {
                if (extn.RegisterTime != null)
                {
                    TimeSpan tspan = new TimeSpan(0, 0, Convert.ToInt32(extn.RegisterExpire));

                    if (DateTime.Now >= extn.RegisterTime && DateTime.Now < (extn.RegisterTime + tspan))
                    {
                        if (extn.ContactAddr.Length > 0)
                        {
                            ret1 = ret = extn.ContactAddr;
                            transfered = true;
                        }
                    }
                }
            }

            if (transfered)
                s1 = "Call to " + callee + " transfered to " + ret1;
            else
                s1 = "Call to " + callee + " cannot be transfered because extension is not registered. call transfered to channel for answering.";

            LogoutText(s1);

            return ret;
        }

        public string GetOutboundProxyAddr(string s)
        {
            string sDomain = GetSIPAddressInfo(2, s);
            SIPAccount sipacct = null;
            string ret = s;

            if (!s.Contains("sip:"))
            {
                ret = "<sip:" + s + ">";
                s = ret;
            }

            for (int i = 0; i < pbx.sip_acct.Count; i++)
            {
                if (pbx.sip_acct[i].DomainServer == sDomain)
                {
                    //found
                    sipacct = pbx.sip_acct[i];
                    break;
                }
            }

            if (sipacct != null)
            {
                ret = "From<sip:" + sipacct.UserName + "@" + sipacct.DomainServer + ">";
                ret = ret + "|" + s;
                ret = ret + "|User<" + sipacct.AuthName + ">";
                ret = ret + "|Password<" + sipacct.Password + ">";
            }
            else
            {
                if (s.Contains("sip:"))
                    ret = s;
                else
                    ret = "<sip:" + s + ">";
            }

            return ret;
        }
 */

    }
}
