using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using System.Data.SqlClient;
using Microsoft.Win32;
//using System.Linq;
using System.Management;
using System.Data;
using System.Data.Common;
using System.Data.SqlTypes;
using System.Data.SQLite;

namespace SIPPBXv3
{
    public class SIPPBXDBAgent
    {
        public Thread dbAgentThread;
        public bool isExiting;
        public DBServerSetting db_set;
        public Queue<string> sql_query;
        public Queue<PBXOptCmd> srv_opt_cmd;
        public SIPPBX pbx;
        public GTSIPPBXEnv env;

        public SIPPBXDBAgent()
        {
            isExiting = false;
            db_set = new DBServerSetting();
            dbAgentThread = new Thread(Run);
            sql_query = new Queue<string>();
            srv_opt_cmd = new Queue<PBXOptCmd>();
            pbx = null;
            env = null;
        }

        ~SIPPBXDBAgent()
        {
        }

        public void Start()
        {
            dbAgentThread.Start(this);
        }

        public void Stop()
        {
            isExiting = true;
            dbAgentThread.Join();
        }

        public PBXOptCmd GetSrvOptCmd()
        {
            PBXOptCmd cmd = null;

            if (Monitor.TryEnter(srv_opt_cmd, 100))
            {
                try
                {
                    // use object
                    cmd = srv_opt_cmd.Dequeue();
                }
                catch (Exception)
                {
                    cmd = null;
                }
                finally
                {
                    Monitor.Exit(srv_opt_cmd);
                }
            }

            return cmd;
        }

        public bool AddSQL(string sql)
        {
            bool added = false;
            if (Monitor.TryEnter(sql_query, 100))
            {
                try
                {
                    // use object
                    sql_query.Enqueue(sql);
                    added = true;
                }
                catch (Exception)
                {
                    added = false;
                }
                finally
                {
                    Monitor.Exit(sql_query);
                }
            }

            return added;
        }

        static void Run(object obj)
        {
            SIPPBXDBAgent host = (SIPPBXDBAgent)obj;
            Queue<string> sql1 = new Queue<string>();

            DateTime t = DateTime.Now;

            while (!host.isExiting)
            {
                sql1.Clear();

                if (Monitor.TryEnter(host.sql_query, 500))
                {
                    try
                    {
                        // use object
                        while (host.sql_query.Count > 0)
                        {
                            sql1.Enqueue(host.sql_query.Dequeue());
                        }
                    }
                    catch (Exception)
                    {
                    }
                    finally
                    {
                        Monitor.Exit(host.sql_query);
                    }
                }

                if (sql1.Count > 0)
                {
                    while (sql1.Count > 0)
                    {
                        string sqlstr = sql1.Dequeue();
                        if (!host.RunSQLNonQuery(sqlstr))
                        {
                            host.env.LOG_Trace(1, "SIPPBXDBAgent::Run Failed to run SQL: " + sqlstr);
                        }
                    }
                }

                DateTime tNow = DateTime.Now;
                TimeSpan ts = tNow - t;

                if (ts.TotalSeconds >= 2)
                {
                    t = tNow;

                    host.GetSrvOptCmdFromDB();
                }

                Thread.Sleep(100);
            }

        }

        public bool GetSrvOptCmdFromDB()
        {
            if (!db_set.IsDBConnected())
                if (!db_set.ConnectDB())
                    return false;

            bool ret = true;
            string log_str = "";

            try
            {
                string sqlstr;

                if (db_set.dbType >= 0) //MS SQL Server
                    sqlstr = "SELECT TOP 100 * FROM opt_cmd WHERE CmdType = 0";
                else if (db_set.dbType == -1) //SQLite
                    sqlstr = "SELECT ROWID, CmdType, CmdName, CmdArgs FROM opt_cmd WHERE CmdType = 0 LIMIT 100";
                else
                    return false;

                Queue tempQueue = new Queue();

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        PBXOptCmd cmd = new PBXOptCmd();
                        cmd.ID = myReader.GetInt64(0);
                        cmd.CmdName = myReader.GetString(2);
                        cmd.CmdArgs = myReader.GetString(3);
                        tempQueue.Enqueue(cmd);
                    }
                }
                catch (Exception e)
                {
                    env.LOG_Trace(1, e.ToString());
                    env.LogoutText(e.ToString());
                    ret = false; 
                }

                myReader.Close();

                while (tempQueue.Count > 0)
                {
                    PBXOptCmd cmd = (PBXOptCmd)tempQueue.Dequeue();
                    if (db_set.dbType >= 0) //MS SQL Server
                        sqlstr = "DELETE FROM opt_cmd where ID = " + cmd.ID.ToString();
                    else if (db_set.dbType == -1) //SQLite
                        sqlstr = "DELETE FROM opt_cmd where ROWID = " + cmd.ID.ToString();

                    try
                    {
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                        {
                            lock (srv_opt_cmd)
                            {
                                srv_opt_cmd.Enqueue(cmd);
                            }

                            log_str = "Successfully get command(" + cmd.ID.ToString() + " " + cmd.CmdName + " " + cmd.CmdArgs + ") from opt_cmd table.";
                            env.LOG_Trace(4, log_str);
                            env.LogoutText(log_str);
                        }
                        else
                        {
                            //call is not in table any more
                            //doing nothing
                            log_str = "***Couldn't get command(" + cmd.ID.ToString() + " " + cmd.CmdName + " " + cmd.CmdArgs + ") from opt_cmd table.";
                            env.LOG_Trace(1, log_str);
                            env.LogoutText(log_str);
                            ret = false;
                        }
                    }
                    catch (Exception e)
                    {
                        env.LOG_Trace(1, e.ToString());
                        env.LogoutText(e.ToString());
                        ret = false;
                    }
                }
            }
            catch (Exception e)
            {
                env.LOG_Trace(1, e.ToString());
                env.LogoutText(e.ToString());
                ret = false;
            }

            if (!ret)
                db_set.DisconnectDB();

            return ret;
        }

        public bool RunSQLNonQuery(string sql)
        {
            if (!db_set.IsDBConnected())
                if (!db_set.ConnectDB())
                    return false;

            try
            {
                if (db_set.ExcuteNonQuerySQL(sql, null) == 1)
                {
                }
            }
            catch (Exception ex)
            {
                env.LogoutText(ex.Message);
                env.LOG_Trace(1, ex.Message);

                db_set.DisconnectDB();

                return false;
            }

            return true;
        }
    }
}
