using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using System.Data;
using System.Data.Common;
using System.Data.SqlTypes;
using System.Data.SqlClient;
using Microsoft.Win32;
//using System.Linq;
using System.Management;
using System.Data.SQLite;

namespace SIPPBXv3
{
    public class DBServerSetting
    {
        public SqlConnection myConn;
        public SQLiteConnection sqliteConn;

        public int authType; //0 = SQL Authentication, 1 = Windows Authentication
        public int dbType; //-1 = SQLite, 0 = 2005 Express, 1 = 2005, 2 = 2000
        public string sDBServer;
        public string sDBName;
        public string sUserName;
        public string sPassword;

        public DBServerSetting()
        {
            sqliteConn = null;
            myConn = null;
            authType = 0;
            dbType = 0;
            sDBServer = "";
            sDBName = "sippbxv3";
            sUserName = "sa";
            sPassword = "";
        }

        public void CopyFrom(DBServerSetting db_set)
        {
            dbType = db_set.dbType;
            authType = db_set.authType;
            sDBServer = db_set.sDBServer;
            sDBName = db_set.sDBName;
            sUserName = db_set.sUserName;
            sPassword = db_set.sPassword;
        }

        /*
        http://social.technet.microsoft.com/wiki/contents/articles/940.how-to-embed-sql-server-express-in-an-application.aspx
        */
        public void InstallSQLExpressWPI()
        {
            System.Diagnostics.Process.Start(@"C:\Program Files\Microsoft\Web Platform Installer\webplatforminstaller.exe", " /id SQLExpressTools");
        }

        public void InstallSQLExpress()
        {
            System.Diagnostics.Process processObj = System.Diagnostics.Process.Start(@"c:\temp\sqlsetup\setup.exe", @"/q /Action=Install /Hideconsole /IAcceptSQLServerLicenseTerms=True /Features=SQL,Tools /InstanceName=SQLExpress /SQLSYSADMINACCOUNTS=""Builtin\Administrators"" /SQLSVCACCOUNT=""DomainName\UserName"" /SQLSVCPASSWORD=""StrongPassword""");
        }

        /// <summary>

        /// Enumerates all SQL Server instances on the machine.

        /// </summary>

        /// <returns></returns>
        /// 
/*
        public static bool EnumerateSQLInstances()
        {

            string correctNamespace = GetCorrectWmiNameSpace();

            if (string.Equals(correctNamespace, string.Empty))
            {

                return false;

            }

            string query = string.Format("select * from SqlServiceAdvancedProperty where SQLServiceType = 1 and PropertyName = 'instanceID'");

            ManagementObjectSearcher getSqlEngine = new ManagementObjectSearcher(correctNamespace, query);

            if (getSqlEngine.Get().Count == 0)
            {

                return false;

            }

            Console.WriteLine("SQL Server database instances discovered :");

            string instanceName = string.Empty;

            string serviceName = string.Empty;

            string version = string.Empty;

            string edition = string.Empty;

            Console.WriteLine("Instance Name \t ServiceName \t Edition \t Version \t");

            foreach (ManagementObject sqlEngine in getSqlEngine.Get())
            {

                serviceName = sqlEngine["ServiceName"].ToString();

                instanceName = GetInstanceNameFromServiceName(serviceName);

                version = GetWmiPropertyValueForEngineService(serviceName, correctNamespace, "Version");

                edition = GetWmiPropertyValueForEngineService(serviceName, correctNamespace, "SKUNAME");

                Console.Write("{0} \t", instanceName);

                Console.Write("{0} \t", serviceName);

                Console.Write("{0} \t", edition);

                Console.WriteLine("{0} \t", version);

            }

            return true;

        }

        /// <summary>

        /// Method returns the correct SQL namespace to use to detect SQL Server instances.

        /// </summary>

        /// <returns>namespace to use to detect SQL Server instances</returns>

        public static string GetCorrectWmiNameSpace()

        {

            String wmiNamespaceToUse = "root\\Microsoft\\sqlserver";

            List<string> namespaces = new List<string>();

            try

            {

                // Enumerate all WMI instances of

                // __namespace WMI class.

                ManagementClass nsClass =

                    new ManagementClass(

                    new ManagementScope(wmiNamespaceToUse),

                    new ManagementPath("__namespace"),

                    null);

                foreach (ManagementObject ns in

                    nsClass.GetInstances())

                {

                    namespaces.Add(ns["Name"].ToString());

                }

            }

            catch (ManagementException e)

            {

                Console.WriteLine("Exception = " + e.Message);

            }

            if (namespaces.Count > 0)

            {

                if (namespaces.Contains("ComputerManagement10"))

                {

                    //use katmai+ namespace

                    wmiNamespaceToUse = wmiNamespaceToUse + "\\ComputerManagement10";

                }

                else if (namespaces.Contains("ComputerManagement"))

                {

                    //use yukon namespace

                    wmiNamespaceToUse = wmiNamespaceToUse + "\\ComputerManagement";

                }

                else

                {

                    wmiNamespaceToUse = string.Empty;

                }

            }

            else

            {

                wmiNamespaceToUse = string.Empty;

            }

            return wmiNamespaceToUse;

        }

        /// <summary>

        /// method extracts the instance name from the service name

        /// </summary>

        /// <param name="serviceName"></param>

        /// <returns></returns>

        public static string GetInstanceNameFromServiceName(string serviceName)

        {

            if (!string.IsNullOrEmpty(serviceName))

            {

                if (string.Equals(serviceName, "MSSQLSERVER", StringComparison.OrdinalIgnoreCase))

                {

                    return serviceName;

                }

                else

                {

                    return serviceName.Substring(serviceName.IndexOf('$') + 1, serviceName.Length - serviceName.IndexOf('$') - 1);

                }

            }

            else

            {

                return string.Empty;

            }

        }

        /// <summary>

        /// Returns the WMI property value for a given property name for a particular SQL Server service Name

        /// </summary>

        /// <param name="serviceName">The service name for the SQL Server engine serivce to query for</param>

        /// <param name="wmiNamespace">The wmi namespace to connect to </param>

        /// <param name="propertyName">The property name whose value is required</param>

        /// <returns></returns>

        public static string GetWmiPropertyValueForEngineService(string serviceName, string wmiNamespace, string propertyName)

        {

            string propertyValue = string.Empty;

            string query = String.Format("select * from SqlServiceAdvancedProperty where SQLServiceType = 1 and PropertyName = '{0}' and ServiceName = '{1}'", propertyName, serviceName);

            ManagementObjectSearcher propertySearcher = new ManagementObjectSearcher(wmiNamespace, query);

            foreach (ManagementObject sqlEdition in propertySearcher.Get())

            {

                propertyValue = sqlEdition["PropertyStrValue"].ToString();

            }

            return propertyValue;

        }*/

        public string GetConnStr1()
        {
            string connStr = "Data Source=";

            if (sUserName.Length == 0)
                sUserName = "sa";

            if (dbType == 0)
            {
                if (sDBServer.Length == 0)
                {
                    connStr += ".\\SQLEXPRESS;";
                }
                else
                {
                    connStr += sDBServer + "\\SQLEXPRESS;";
                }
            }
            else if (dbType >= 1)
            {
                if(sDBServer.Length == 0)
                    connStr += "localhost;";
                else
                    connStr += sDBServer + ";";
            }

            connStr += "DATABASE=master;";

            if (authType == 0)
            {
                connStr += "User Id=" + sUserName + ";";
                connStr += "Password=" + sPassword + ";";
            }
            else
            {
                connStr += "Trusted_Connection=Yes;"; // or Integrated Security=SSPI
            }

            return connStr;
        }

        public bool CanConnectMaster()
        {
            if (dbType >= 0) //MS SQL Server
            {
                bool result = false;
                SqlConnection tmpConn = new SqlConnection(GetConnStr1());

                try
                {
                    tmpConn.Open();
                }
                catch (Exception)
                {
                }
                finally
                {
                    if (tmpConn.State == System.Data.ConnectionState.Open)
                    {
                        result = true;
                        tmpConn.Close();
                    }
                }

                return result;
            }

            return false;
        }

        public bool CheckDatabaseExists(string databaseName)
        {
            if (dbType >= 0) //MS SQL Server
            {
                //string sqlCreateDBQuery;
                bool result = false;
                SqlConnection tmpConn = new SqlConnection(GetConnStr1());

                if (databaseName.Length == 0)
                    databaseName = sDBName;

                if (databaseName.Length == 0)
                    databaseName = "sippbxv3"; ;

                /*
                try
                {
                    tmpConn = new SqlConnection(GetConnStr1());

                    sqlCreateDBQuery = string.Format("SELECT database_id FROM sys.databases WHERE Name = '{0}'", databaseName);

                    using (tmpConn)
                    {
                        using (SqlCommand sqlCmd = new SqlCommand(sqlCreateDBQuery, tmpConn))
                        {
                            tmpConn.Open();
                            int databaseID = (int)sqlCmd.ExecuteScalar();    
                            tmpConn.Close();

                            result = (databaseID > 0);
                        }
                    }
                } 
                catch (Exception ex)
                { 
                    result = false;
                }
                 */

                string cmdText = "select * from master.dbo.sysdatabases where name=\'" + databaseName + "\'";

                try
                {
                    tmpConn.Open();
                    using (SqlCommand sqlCmd = new SqlCommand(cmdText, tmpConn))
                    {
                        int nRet = sqlCmd.ExecuteNonQuery();
                        if (nRet <= 0)
                        {
                            result = false;
                        }

                        else
                        {
                            result = true;
                        }
                    }

                }
                catch (Exception)
                {
                }
                finally
                {
                    if (tmpConn.State == System.Data.ConnectionState.Open)
                    {
                        tmpConn.Close();
                    }
                }

                return result;
            }

            return false;
        }

/*
        private void CreateDatabase(DatabaseParam DBParam)
        {
            System.Data.SqlClient.SqlConnection tmpConn;
            string sqlCreateDBQuery;
            tmpConn = new SqlConnection();
            tmpConn.ConnectionString = "SERVER = " + DBParam.ServerName + "; DATABASE = master; User ID = sa; Pwd = sa";
            sqlCreateDBQuery = " CREATE DATABASE "
                               + DBParam.DatabaseName
                               + " ON PRIMARY "
                               + " (NAME = " + DBParam.DataFileName + ", "
                               + " FILENAME = '" + DBParam.DataPathName + "', "
                               + " SIZE = 2MB,"
                               + " FILEGROWTH =" + DBParam.DataFileGrowth + ") "
                               + " LOG ON (NAME =" + DBParam.LogFileName + ", "
                               + " FILENAME = '" + DBParam.LogPathName + "', "
                               + " SIZE = 1MB, "
                               + " FILEGROWTH =" + DBParam.LogFileGrowth + ") ";
            SqlCommand myCommand = new SqlCommand(sqlCreateDBQuery, tmpConn);
            try
            {
                tmpConn.Open();
                MessageBox.Show(sqlCreateDBQuery);
                myCommand.ExecuteNonQuery();
                MessageBox.Show("Database has been created successfully!",
                                  "Create Database", MessageBoxButtons.OK,
                                              MessageBoxIcon.Information);
            }
            catch (System.Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Create Database",
                                            MessageBoxButtons.OK,
                                     MessageBoxIcon.Information);
            }
            finally
            {
                tmpConn.Close();
            }
            return;
        }*/

        public void CreateDB(SIPPBX pbx)
        {
            if (dbType >= 0) //MS SQL Server
            {
                String str;
                SqlConnection tmpConn = new SqlConnection(GetConnStr1()); /*"Server=localhost;Integrated security=SSPI;database=master"*/

                string dbName = sDBName;
                if (dbName.Length == 0)
                    dbName = "sippbxv3";

                string dbFileName = pbx.pbx_dir + "\\" + dbName + "Data.mdf";
                string ldfFileName = pbx.pbx_dir + "\\" + dbName + "Log.ldf";

                str = "CREATE DATABASE " + dbName + " ON PRIMARY " +
                    "(NAME = " + dbName + "_Data, " +
                    "FILENAME = '" + dbFileName + "', " +
                    "SIZE = 10MB, MAXSIZE = 4096MB, FILEGROWTH = 10%) " +
                    "LOG ON (NAME = MyDatabase_Log, " +
                    "FILENAME = '" + ldfFileName + "', " +
                    "SIZE = 5MB, " +
                    "MAXSIZE = 100MB, " +
                    "FILEGROWTH = 10%)";

                SqlCommand myCommand = new SqlCommand(str, tmpConn);
                try
                {
                    tmpConn.Open();
                    myCommand.ExecuteNonQuery();
                    //MessageBox.Show("DataBase is Created Successfully", "MyProgram", MessageBoxButtons.OK, MessageBoxIcon.Information);

                }
                catch (System.Exception ex)
                {
                    //MessageBox.Show(ex.ToString(), "MyProgram", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                finally
                {
                    if (tmpConn.State == System.Data.ConnectionState.Open)
                    {
                        tmpConn.Close();
                    }
                }
            }

        }

        public string GetConnStr()
        {
            string connStr = "Data Source=";

            if (sUserName.Length == 0)
                sUserName = "sa";

            if (dbType == 0)
            {
                if (sDBServer.Length == 0)
                {
                    connStr += ".\\SQLEXPRESS;Initial Catalog=";
                }
                else
                {
                    connStr += sDBServer + "\\SQLEXPRESS;Initial Catalog=";
                }
            }
            else if (dbType >= 1)
            {
                connStr += sDBServer + ";Initial Catalog=";
            }

            if (sDBName.Length == 0)
            {
                connStr += "sippbxv3;";
            }
            else
            {
                connStr += sDBName + ";";
            }

            if (authType == 0)
            {
                connStr += "User Id=" + sUserName + ";";
                connStr += "Password=" + sPassword + ";";
            }
            else
            {
                connStr += "Trusted_Connection=Yes;"; // or Integrated Security=SSPI
            }

            return connStr;
        }

        public bool ConnectDB()
        {
            if (dbType >= 0) //MS SQL Server
            {
                //string connStr = "Data Source=.\\SQLEXPRESS;Initial Catalog=digilog;User Id=sa;Password=12345678";
                string connStr = GetConnStr();

                myConn = new SqlConnection(connStr);
                try
                {
                    myConn.Open();
                }
                catch (Exception e)
                {
                    myConn = null;
                    Console.WriteLine(e.ToString());
                    return false;
                }

                return true;
            }
            else if (dbType == -1) //SQLite
            {
                //bool newDB = false;
                string sqliteDBName = Application.StartupPath + "\\" + sDBName + ".db";
                if (!File.Exists(sqliteDBName))
                {
                    SQLiteConnection.CreateFile(sqliteDBName);
                    //newDB = true;
                }

                sqliteConn = new SQLiteConnection("Data Source='" + sqliteDBName + "';Version=3;");
                sqliteConn.Open();

                //if (newDB) changed 2025-02-12, if DB is not new, it will check if the table exists.
                //If not, create the table
                {
                    SQLiteCreateTables();
                }

                return true;
            }

            return false;
        }

        public bool DisconnectDB()
        {
            if (myConn != null)
            {
                try
                {
                    myConn.Close();
                }
                catch (Exception)
                {
                }
                myConn = null;
            }

            if (sqliteConn != null)
            {
                try
                {
                    sqliteConn.Close();
                }
                catch (Exception)
                {
                }
                sqliteConn = null;
            }

            return true;
        }

        public bool IsDBConnected()
        {
            if (dbType >= 0)
            {
                return myConn != null;
            }
            else if(dbType == -1)
            {
                return sqliteConn != null;
            }

            return false;
        }

        public void ResetConnection()
        {
            try 
            {
                DisconnectDB();
            }
            catch (Exception) 
            { 
            }

            Thread.Sleep(100);

            try
            {
                ConnectDB();
            }
            catch (Exception)
            {
            }
        }

        /*
        public static bool ColumnExists1(SqlConnection dbConn, string columnName, string tableName)
        {
            string checkColumn = String.Format("SELECT 1 FROM sys.columns WHERE Name = N'{0}' AND Object_ID = Object_ID(N'dbo.{1}')", columnName, tableName);
            //SqlCommand command = new SqlCommand(checkTable, myConn);
            //command.CommandType = System.Data.CommandType.Text;
            //return Convert.ToBoolean(command.ExecuteScalar());

            SqlCommand catCMD = dbConn.CreateCommand();
            catCMD.CommandTimeout = 3;
            catCMD.CommandText = checkColumn;
            SqlDataReader myReader = catCMD.ExecuteReader();

            try
            {
                while (myReader.Read())
                {
                    myReader.Close();
                    return true;
                }
            }
            catch (Exception e)
            {
                //if (log != null) log.LogoutText(e.ToString());
            }
            finally
            {
                myReader.Close();
            }

            return false;
        }*/

        public static bool ColumnExists(SqlConnection dbConn, string columnName, string tableName)
        {
            string checkColumn = String.Format("IF COL_LENGTH('dbo.{0}', '{1}') IS NOT NULL SELECT 'true' ELSE SELECT 'false'", tableName, columnName);
            SqlCommand command = new SqlCommand(checkColumn, dbConn);
            command.CommandType = System.Data.CommandType.Text;
            return Convert.ToBoolean(command.ExecuteScalar());
        }

        /*
        public bool TableExists(string tableNameAndSchema)
        {
            string checkTable = String.Format("IF OBJECT_ID('{0}', 'U') IS NOT NULL SELECT 'true' ELSE SELECT 'false'", tableNameAndSchema);
            SqlCommand command = new SqlCommand(checkTable, myConn);
            command.CommandType = System.Data.CommandType.Text;
            return Convert.ToBoolean(command.ExecuteScalar());
        }*/

        public bool SQLServerTableExists(string tableNameAndSchema, string connectionString)
        {
            bool ret = false;
            using (SqlConnection connection = new SqlConnection(connectionString))
            {
                string checkTable = String.Format("IF OBJECT_ID('{0}', 'U') IS NOT NULL SELECT 'true' ELSE SELECT 'false'", tableNameAndSchema);
                SqlCommand command = new SqlCommand(checkTable, connection);
                command.CommandType = System.Data.CommandType.Text;
                connection.Open();
                ret = Convert.ToBoolean(command.ExecuteScalar());
                connection.Close();
                return ret;
            }
        }

        public bool SQLiteTableExists(string tableName)
        {
            bool ret = false;
            string sql;
            SQLiteCommand sqliteCmd = sqliteConn.CreateCommand();

            sql = "SELECT name FROM sqlite_master WHERE type='table' AND name='" + tableName + "';";
            sqliteCmd.CommandText = sql;
            DbDataReader myReader = sqliteCmd.ExecuteReader();

            if (myReader.HasRows)
            {
                ret = true;
            }

            myReader.Close();

            return ret;
        }

        public void SQLiteCreateTables()
        {
            string sql;
            SQLiteCommand sqliteCmd = sqliteConn.CreateCommand();

            if (!SQLiteTableExists("cfg_sys"))
            {
                sql = "CREATE TABLE cfg_sys(CfgName varchar(180) NOT NULL, CfgValue varchar(250) NULL, ModTag SmallInt NOT NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_security"))
            {
                sql = "CREATE TABLE cfg_security(ID INT NOT NULL, WhiteOrBlack SmallInt NOT NULL, FilterType SmallInt NOT NULL, IPAddr varchar(250) NULL, CallID varchar(250) NULL, MacAddr varchar(250) NULL, ModTag SmallInt NOT NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_sipaccounts"))
            {
                sql = "CREATE TABLE cfg_sipaccounts(ID INT NOT NULL, DisplayName varchar(80) NOT NULL, UserName varchar(80) NOT NULL, DomainServer varchar(120) NOT NULL, ProxyServer varchar(120) NOT NULL, AuthName varchar(80) NOT NULL, Password varchar(80) NOT NULL, ExpireSec INT NOT NULL, RegWithProxyServer TinyInt NOT NULL, DIDS varchar(1000) NOT NULL, Disabled TinyInt NOT NULL, ModTag SmallInt NOT NULL, AcceptOtherID TinyInt NULL, UseLocalIPInFrom TinyInt NULL, MappedExten varchar(80) NULL, AppendExtenID TinyInt NULL, SIPProtocol TinyInt NULL, SIPTrunk TinyInt NULL, UseSRTP TinyInt NULL, PRIMARY KEY (ID))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_extensions"))
            {
                sql = "CREATE TABLE cfg_extensions(UserName varchar(80) NOT NULL, RealName varchar(80) NULL, Password varchar(80) NOT NULL, Email varchar(80) NULL, AltPhoneNumber varchar(80), RegSDKTime BIGINT, RegisterTime DATETIME, RegisterExpire INT, ContactAddr varchar(120), RegFromID varchar(120), RegToID varchar(120), UAName varchar(80), NATType INT, MsgWaitingCount INT, MsgTotalCount INT, MsgAccount varchar(80), VoiceMsg varchar(80), PriorityLevel INT NOT NULL, VirtualExtenDestAddr varchar(120), ACDCallMethod INT, RingTimeoutSec INT, CallForwardingPlan varchar(80), RecordCall TINYINT, AcceptOtherID TINYINT, RestSeconds INT, VMBOn TINYINT, VMBPrompt varchar(250), VMBEmail varchar(80), VMBMaxLength INT, VMBPassword varchar(40), ModTag SmallInt NOT NULL, AuthType INT, OnlyAgentLogin TINYINT, MappedContactAddr varchar(120), RegSrcIP varchar(120), RegSrcPort INT, MultipleCall TINYINT NULL, MaxRegExpSec INT NULL, UseSRTP TINYINT NULL, PRIMARY KEY (UserName))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_dialplans"))
            {
                sql = "CREATE TABLE cfg_dialplans(DialPlanName varchar(80) NOT NULL, CallDirection SmallInt NOT NULL, Caller varchar(80) NOT NULL, Called varchar(80) NULL, CallPlan varchar(80), DestAddress varchar(120), OutboundPreStrip varchar(40), OutboundPrepend varchar(40), OutboundSIPAcct INT, OutboundCallerID varchar(40), ExtenPriorityLevel INT, TimeLimited TINYINT, TimeStartHour INT, TimeStartMinute INT, TimeEndHour INT, TimeEndMinute INT, TimeDay INT, ExtenMembers varchar(2048), ModTag SmallInt NOT NULL, DialPlanIndex INT NOT NULL, PRIMARY KEY (DialPlanName))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_huntgroups"))
            {
                sql = "CREATE TABLE cfg_huntgroups(Name varchar(80) NOT NULL, Type INT NOT NULL, PlayMOH TINYINT, MOHDir varchar(250) NULL, DialplanDTMF varchar(20), DialplanName varchar(80), WaitTimeout INT, WaitTimeoutTo varchar(80), VMBDTMF varchar(20), VMBOn TINYINT, VMBPrompt varchar(250), VMBEmail varchar(250), VMBMaxLength INT, VMBPassword varchar(40), AgentType INT, Agents varchar(2048), ModTag SmallInt NOT NULL, MaxNumOfCalls INT NULL, CallForwardingType SmallInt NULL, CallForwardingPlan varchar(80), PromptQueuePosition SmallInt NULL, PRIMARY KEY (Name))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_parkingslots"))
            {
                sql = "CREATE TABLE cfg_parkingslots(Name varchar(80) NOT NULL, DTMFStr varchar(20), PlayMOH TINYINT, MOHDir varchar(250) NULL, DialplanDTMF varchar(20), DialplanName varchar(80), WaitTimeout INT, WaitTimeoutTo varchar(80), VMBDTMF varchar(20), VMBOn TINYINT, VMBPrompt varchar(250), VMBEmail varchar(250), VMBMaxLength INT, VMBPassword varchar(40), ModTag SmallInt NOT NULL, PRIMARY KEY (Name))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_dests"))
            {
                sql = "CREATE TABLE cfg_dests(TYPE INT NOT NULL, Addr varchar(120) NOT NULL, RingTimeout INT, BelongTo varchar(80) NOT NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_ringgroups"))
            {
                sql = "CREATE TABLE cfg_ringgroups(Name varchar(80) NOT NULL, Type INT NOT NULL, PlayMOH TINYINT, MOHDir varchar(250) NULL, VMBOn TINYINT, VMBPrompt varchar(250), VMBEmail varchar(250), VMBMaxLength INT, VMBPassword varchar(40), AnswerCallFirst TINYINT, ModTag SmallInt NOT NULL, PRIMARY KEY (Name))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_paginggroups"))
            {
                sql = "CREATE TABLE cfg_paginggroups(Name varchar(80) NOT NULL, DID varchar(40) NULL, UseGroupName SmallInt NULL, ModTag SmallInt NOT NULL, PRIMARY KEY (Name))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_monitorgroups"))
            {
                sql = "CREATE TABLE cfg_monitorgroups(Name varchar(80) NOT NULL, Number varchar(20), PasswordPrompt varchar(250), Password varchar(60), KeyBargeIn varchar(20), KeyBargeOut varchar(20), KeyWhisper varchar(20), ExtenPrompt varchar(250), ExtenAll TINYINT, Extensions varchar(2048), ModTag SmallInt NOT NULL, PRIMARY KEY (Name))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_agents"))
            {
                sql = "CREATE TABLE cfg_agents(Name varchar(80) NOT NULL, Code varchar(40) NOT NULL, Password varchar(60), RecordCall TINYINT, AtExten varchar(80), LogInTime DATETIME, LogOutTime DATETIME, ModTag SmallInt NOT NULL, SkillLevel SmallInt NULL, Paused TinyInt NULL, PRIMARY KEY (Code))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_ivrsubitems"))
            {
                sql = "CREATE TABLE cfg_ivrsubitems(DTMFStr varchar(20) NOT NULL, IVRMenuAction INT NOT NULL, IVRMenuSoundFile varchar(250), IVRMenuTransferTo varchar(120), BelongTo varchar(80))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_ivrs"))
            {
                sql = "CREATE TABLE cfg_ivrs(MenuName varchar(80) NOT NULL, Action INT NOT NULL, MenuSound varchar(250) NOT NULL, TransferTo varchar(120), MenuDTMFWaitMS INT, DTMFAcceptExtenWaitMS INT, DTMFAcceptExten TINYINT, ModTag SmallInt NOT NULL, PRIMARY KEY (MenuName))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_autodialertasks"))
            {
                sql = "CREATE TABLE cfg_autodialertasks(Name varchar(80) NOT NULL, Enabled TINYINT NOT NULL, TypeCode SMALLINT NOT NULL, SIPAcct varchar(80), DialPlan varchar(80), RingTimeout INT, MaxSimCalls INT, ModTag SmallInt NOT NULL, EnableDetect TinyINT NULL, DiscAfterDetect TinyINT NULL, PRIMARY KEY (Name))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_pickupgroups"))
            {
                sql = "CREATE TABLE cfg_pickupgroups(Name varchar(80) NOT NULL, MemberType INT NOT NULL, Members varchar(2048), ModTag SmallInt NOT NULL, PRIMARY KEY (Name))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_conferencerooms"))
            {
                sql = "CREATE TABLE cfg_conferencerooms(Name varchar(80) NOT NULL, ModTag SmallInt NOT NULL, MaxCallNum INT NOT NULL, JoinPrompt varchar(256), LeavePrompt varchar(256), MOHDir varchar(256), DiscCall TinyINT, HostPW varchar(256), HostPrompt varchar(256), RecordCall TinyINT, EveryonePW TinyINT, PRIMARY KEY (Name))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_calllimit"))
            {
                sql = "CREATE TABLE cfg_calllimit(DialPlan varchar(80) NOT NULL, Seconds INT NOT NULL, RoundupSeconds INT NOT NULL, ModTag SmallInt NOT NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_blacklist"))
            {
                sql = "CREATE TABLE cfg_blacklist(ID INT NOT NULL, Callee varchar(20) NOT NULL, Caller varchar(20) NULL, ModTag SmallInt NOT NULL, PRIMARY KEY (ID))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_attrdef"))
            {
                sql = "CREATE TABLE cfg_attrdef(AttrType INT NOT NULL, AttrName varchar(80) NOT NULL, AttrDesc varchar(256) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_attrs"))
            {
                sql = "CREATE TABLE cfg_attrs(AttrType INT NOT NULL, AttrItemId varchar(80) NOT NULL, AttrItemValue varchar(256) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_callback"))
            {
                sql = "CREATE TABLE cfg_callback(ID INT NOT NULL, Callee varchar(40) NOT NULL, Caller varchar(40) NULL, DialPlan varchar(80) NULL, Exten varchar(80) NULL, ExtraAttr varchar(80), ModTag SmallInt NOT NULL, PRIMARY KEY (ID))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("auto_dialer_jobs"))
            {
                sql = "CREATE TABLE auto_dialer_jobs(ID BIGINT NOT NULL, Type SMALLINT NOT NULL, Caller varchar(80) NULL, Callee varchar(80) NULL, CallTime datetime NULL, JobID varchar(60) NULL, PRIMARY KEY (ID))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("auto_dialer_done"))
            {
                sql = "CREATE TABLE auto_dialer_done(ID BIGINT NOT NULL, Type SMALLINT NOT NULL, Caller varchar(80) NULL, Callee varchar(80) NULL, Result int NOT NULL, CallInit datetime NULL, CallBegin datetime NULL, CallEnd datetime NULL, DTMFs varchar(2048) NULL, JobID varchar(60) NULL, DetectResult int NULL, FinalCode int NULL, FinalDesc varchar(120) NULL, CallID varchar(40) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cdr_pbx"))
            {
                sql = "CREATE TABLE cdr_pbx(Connected tinyint NOT NULL, Caller varchar(80) NOT NULL, Callee varchar(80) NOT NULL, StartTime datetime NOT NULL, EndTime datetime NOT NULL, ACD_Name varchar(40) NULL, ACD_In_Time datetime NULL, ACD_Out_Time datetime NULL, ACD_To_Exten varchar(40) NULL, ACD_To_Agent varchar(40) NULL, RecordFile varchar(256) NULL, CallID varchar(40) NULL, CallDir tinyint, Transferred tinyint, IVRKeys varchar(256), DiscReason varchar(256), ConfName varchar(80), HangupParty varchar(250))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cdr_acd"))
            {
                sql = "CREATE TABLE cdr_acd(ACD_Name varchar(40) NOT NULL, ACD_In_Time datetime NOT NULL, ACD_Out_Time datetime NOT NULL, ACD_To_Exten varchar(40) NULL, ACD_To_Agent varchar(40) NULL, Connected tinyint NOT NULL, Caller varchar(80) NOT NULL, Callee varchar(80) NOT NULL, StartTime datetime NOT NULL, EndTime datetime NOT NULL, RecordFile varchar(256) NULL, CallID varchar(40) NULL, CallDir tinyint, Transferred tinyint, DiscReason varchar(256), HangupParty varchar(250))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cdr_exten"))
            {
                sql = "CREATE TABLE cdr_exten(Extension varchar(80) NOT NULL, Connected tinyint NOT NULL, Caller varchar(80) NOT NULL, Callee varchar(80) NOT NULL, StartTime datetime NOT NULL, EndTime datetime NOT NULL, ACD_Name varchar(40) NULL, ACD_In_Time datetime NULL, ACD_Out_Time datetime NULL, ACD_To_Exten varchar(40) NULL, ACD_To_Agent varchar(40) NULL, RecordFile varchar(256) NULL, CallID varchar(40) NULL, CallDir tinyint, Transferred tinyint, DiscReason varchar(256), HangupParty varchar(250))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cdr_agent"))
            {
                sql = "CREATE TABLE cdr_agent(AgentCode varchar(40) NOT NULL, Action tinyint NOT NULL, LogTime datetime NOT NULL, Extension varchar(80) NOT NULL, Param1 varchar(80), Param2 varchar(80), Param3 varchar(80))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("status_acd"))
            {
                sql = "CREATE TABLE status_acd(ACD_Name varchar(40) NOT NULL, ACD_Type varchar(20) NOT NULL, Agents varchar(1024) NULL, Calls varchar(1024) NULL, WaitTime varchar(1024) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("status_channel"))
            {
                sql = "CREATE TABLE status_channel(ChanID INT NOT NULL, CallStatus varchar(40), Caller varchar(80) NOT NULL, Callee varchar(80) NOT NULL, CallStartTime datetime NULL, LinkedExten varchar(80) NULL, DTMFBuf varchar(80) NULL, Dialplan varchar(40) NULL, OutboundCallTask varchar(40) NULL, ACD_Name varchar(40) NULL, ACD_In_Time datetime NULL, ACD_Out_Time datetime NULL, ACD_To_Exten varchar(40) NULL, ACD_To_Agent varchar(40) NULL, RecordFile varchar(256) NULL, CallID varchar(40) NULL, AutoDialerId bigint NULL, AutoDialerJobId varchar(60) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("status_exten"))
            {
                sql = "CREATE TABLE status_exten(ExtenID varchar(40) NOT NULL, Name varchar(40) NULL, IdleStartTime datetime NULL, ChanIndex INT, Agent varchar(40) NULL, Status varchar(40) NULL, Contact varchar(80) NULL, RegTime datetime NULL, RegExpireSec INT NULL, UAName varchar(80) NULL, NATType INT NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("status_sipaccount"))
            {
                sql = "CREATE TABLE status_sipaccount(AccID INT NOT NULL, DisplayName varchar(80) NULL, UserName varchar(80) NULL, Status varchar(40) NULL, DomainServer varchar(120) NULL, ProxyServer varchar(120) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("status_agent"))
            {
                sql = "CREATE TABLE status_agent(AgentCode varchar(40) NOT NULL, AgentName varchar(40) NULL, Status varchar(40) NULL, LoginTime datetime NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("status_parkingslot"))
            {
                sql = "CREATE TABLE status_parkingslot(Name varchar(80) NOT NULL, Number varchar(80) NULL, ParkedCall varchar(80) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("status_conferenceroom"))
            {
                sql = "CREATE TABLE status_conferenceroom(Name varchar(80) NOT NULL, Chans varchar(1024) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("status_plugin"))
            {
                sql = "CREATE TABLE status_plugin(Name varchar(80) NOT NULL, Type varchar(40) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("voice_mailbox"))
            {
                sql = "CREATE TABLE voice_mailbox(Extension varchar(80) NULL, ToEmail varchar(80) NOT NULL, Caller varchar(80) NULL, Callee varchar(80) NULL, VMTime datetime NULL, VMDuration INT, VMFile varchar(256) NOT NULL, VMStatus INT, CallID varchar(40) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("opt_cmd"))
            {
                sql = "CREATE TABLE opt_cmd(CmdType SMALLINT NOT NULL, CmdName varchar(80) NOT NULL, CmdArgs varchar(1024) NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("log_sys"))
            {
                sql = "CREATE TABLE log_sys(LogTime DateTime, LogInfo varchar(2000))";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }

            if (!SQLiteTableExists("cfg_openainodes"))
            {
                sql = "CREATE TABLE cfg_openainodes(NodeName varchar(180) NOT NULL, APIKey varchar(250) NULL, DefDesc varchar(8000) NULL, Args varchar(250) NULL, Menus varchar(250) NULL, ModTag SmallInt NOT NULL)";
                sqliteCmd.CommandText = sql;
                sqliteCmd.ExecuteNonQuery();
            }
        }

        public void TestCfgTables()
        {
            if (dbType < 0)
                return;

            if (!SQLServerTableExists("cfg_sys", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_sys(CfgName varchar(180) NOT NULL, CfgValue varchar(250) NULL, ModTag SmallInt NOT NULL)";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_security", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_security(ID INT NOT NULL, WhiteOrBlack SmallInt NOT NULL, FilterType SmallInt NOT NULL, IPAddr varchar(250) NULL, CallID varchar(250) NULL, MacAddr varchar(250) NULL, ModTag SmallInt NOT NULL)";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_sipaccounts", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_sipaccounts(ID INT NOT NULL, DisplayName varchar(80) NOT NULL, UserName varchar(80) NOT NULL, DomainServer varchar(120) NOT NULL, ProxyServer varchar(120) NOT NULL, AuthName varchar(80) NOT NULL, Password varchar(80) NOT NULL, ExpireSec INT NOT NULL, RegWithProxyServer TinyInt NOT NULL, DIDS varchar(1000) NOT NULL, Disabled TinyInt NOT NULL, ModTag SmallInt NOT NULL, AcceptOtherID TinyInt NULL, UseLocalIPInFrom TinyInt NULL, MappedExten varchar(80) NULL, AppendExtenID TinyInt NULL, SIPProtocol TinyInt NULL, SIPTrunk TinyInt NULL, UseSRTP TinyInt NULL, PRIMARY KEY (ID))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_extensions", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_extensions(UserName varchar(80) NOT NULL, RealName varchar(80) NULL, Password varchar(80) NOT NULL, Email varchar(80) NULL, AltPhoneNumber varchar(80), RegSDKTime BIGINT, RegisterTime DATETIME, RegisterExpire INT, ContactAddr varchar(120), RegFromID varchar(120), RegToID varchar(120), UAName varchar(80), NATType INT, MsgWaitingCount INT, MsgTotalCount INT, MsgAccount varchar(80), VoiceMsg varchar(80), PriorityLevel INT NOT NULL, VirtualExtenDestAddr varchar(120), ACDCallMethod INT, RingTimeoutSec INT, CallForwardingPlan varchar(80), RecordCall TINYINT, AcceptOtherID TINYINT, RestSeconds INT, VMBOn TINYINT, VMBPrompt varchar(250), VMBEmail varchar(80), VMBMaxLength INT, VMBPassword varchar(40), ModTag SmallInt NOT NULL, AuthType INT, OnlyAgentLogin TINYINT, MappedContactAddr varchar(120), RegSrcIP varchar(120), RegSrcPort INT, MultipleCall TINYINT NULL, MaxRegExpSec INT NULL, UseSRTP TINYINT NULL, PRIMARY KEY (UserName))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_dialplans", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_dialplans(DialPlanName varchar(80) NOT NULL, CallDirection SmallInt NOT NULL, Caller varchar(80) NOT NULL, Called varchar(80) NULL, CallPlan varchar(80), DestAddress varchar(120), OutboundPreStrip varchar(40), OutboundPrepend varchar(40), OutboundSIPAcct INT, OutboundCallerID varchar(40), ExtenPriorityLevel INT, TimeLimited TINYINT, TimeStartHour INT, TimeStartMinute INT, TimeEndHour INT, TimeEndMinute INT, TimeDay INT, ExtenMembers varchar(2048), ModTag SmallInt NOT NULL, DialPlanIndex INT NOT NULL, PRIMARY KEY (DialPlanName))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_huntgroups", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_huntgroups(Name varchar(80) NOT NULL, Type INT NOT NULL, PlayMOH TINYINT, MOHDir varchar(250) NULL, DialplanDTMF varchar(20), DialplanName varchar(80), WaitTimeout INT, WaitTimeoutTo varchar(80), VMBDTMF varchar(20), VMBOn TINYINT, VMBPrompt varchar(250), VMBEmail varchar(250), VMBMaxLength INT, VMBPassword varchar(40), AgentType INT, Agents varchar(2048), ModTag SmallInt NOT NULL, MaxNumOfCalls INT NULL, CallForwardingType SmallInt NULL, CallForwardingPlan varchar(80), PromptQueuePosition SmallInt NULL, PRIMARY KEY (Name))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_parkingslots", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_parkingslots(Name varchar(80) NOT NULL, DTMFStr varchar(20), PlayMOH TINYINT, MOHDir varchar(250) NULL, DialplanDTMF varchar(20), DialplanName varchar(80), WaitTimeout INT, WaitTimeoutTo varchar(80), VMBDTMF varchar(20), VMBOn TINYINT, VMBPrompt varchar(250), VMBEmail varchar(250), VMBMaxLength INT, VMBPassword varchar(40), ModTag SmallInt NOT NULL, PRIMARY KEY (Name))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_dests", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_dests(TYPE INT NOT NULL, Addr varchar(120) NOT NULL, RingTimeout INT, BelongTo varchar(80) NOT NULL)";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_ringgroups", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_ringgroups(Name varchar(80) NOT NULL, Type INT NOT NULL, PlayMOH TINYINT, MOHDir varchar(250) NULL, VMBOn TINYINT, VMBPrompt varchar(250), VMBEmail varchar(250), VMBMaxLength INT, VMBPassword varchar(40), AnswerCallFirst TINYINT, ModTag SmallInt NOT NULL, PRIMARY KEY (Name))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_paginggroups", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_paginggroups(Name varchar(80) NOT NULL, DID varchar(40) NULL, UseGroupName SmallInt NULL, ModTag SmallInt NOT NULL, PRIMARY KEY (Name))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_monitorgroups", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_monitorgroups(Name varchar(80) NOT NULL, Number varchar(20), PasswordPrompt varchar(250), Password varchar(60), KeyBargeIn varchar(20), KeyBargeOut varchar(20), KeyWhisper varchar(20), ExtenPrompt varchar(250), ExtenAll TINYINT, Extensions varchar(2048), ModTag SmallInt NOT NULL, PRIMARY KEY (Name))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_agents", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_agents(Name varchar(80) NOT NULL, Code varchar(40) NOT NULL, Password varchar(60), RecordCall TINYINT, AtExten varchar(80), LogInTime DATETIME, LogOutTime DATETIME, ModTag SmallInt NOT NULL, SkillLevel SmallInt NULL, Paused TinyInt NULL, PRIMARY KEY (Code))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_ivrsubitems", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_ivrsubitems(DTMFStr varchar(20) NOT NULL, IVRMenuAction INT NOT NULL, IVRMenuSoundFile varchar(250), IVRMenuTransferTo varchar(120), BelongTo varchar(80))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_ivrs", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_ivrs(MenuName varchar(80) NOT NULL, Action INT NOT NULL, MenuSound varchar(250) NOT NULL, TransferTo varchar(120), MenuDTMFWaitMS INT, DTMFAcceptExtenWaitMS INT, DTMFAcceptExten TINYINT, ModTag SmallInt NOT NULL, PRIMARY KEY (MenuName))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_autodialertasks", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_autodialertasks(Name varchar(80) NOT NULL, Enabled TINYINT NOT NULL, TypeCode SMALLINT NOT NULL, SIPAcct varchar(80), DialPlan varchar(80), RingTimeout INT, MaxSimCalls INT, ModTag SmallInt NOT NULL, EnableDetect TinyINT NULL, DiscAfterDetect TinyINT NULL, PRIMARY KEY (Name))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_pickupgroups", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_pickupgroups(Name varchar(80) NOT NULL, MemberType INT NOT NULL, Members varchar(2048), ModTag SmallInt NOT NULL, PRIMARY KEY (Name))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_conferencerooms", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_conferencerooms(Name varchar(80) NOT NULL, ModTag SmallInt NOT NULL, MaxCallNum INT NOT NULL, JoinPrompt varchar(256), LeavePrompt varchar(256), MOHDir varchar(256), DiscCall TinyINT, HostPW varchar(256), HostPrompt varchar(256), RecordCall TinyINT, EveryonePW TinyINT, PRIMARY KEY (Name))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_calllimit", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_calllimit(DialPlan varchar(80) NOT NULL, Seconds INT NOT NULL, RoundupSeconds INT NOT NULL, ModTag SmallInt NOT NULL)";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();

            }

            if (!SQLServerTableExists("cfg_blacklist", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_blacklist(ID INT NOT NULL, Callee varchar(20) NOT NULL, Caller varchar(20) NULL, ModTag SmallInt NOT NULL, PRIMARY KEY (ID))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            //new from 2016-02-18
            //decided add two new tables for new cfg attributes for cfg_xxx tables
            if (!SQLServerTableExists("cfg_attrdef", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_attrdef(AttrType INT NOT NULL, AttrName varchar(80) NOT NULL, AttrDesc varchar(256) NULL)";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_attrs", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_attrs(AttrType INT NOT NULL, AttrItemId varchar(80) NOT NULL, AttrItemValue varchar(256) NULL)";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            /////////////////////////////////////////////////////////////////////////////////////////
            if (!SQLServerTableExists("cfg_callback", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_callback(ID INT NOT NULL, Callee varchar(40) NOT NULL, Caller varchar(40) NULL, DialPlan varchar(80) NULL, Exten varchar(80) NULL, ExtraAttr varchar(80), ModTag SmallInt NOT NULL, PRIMARY KEY (ID))";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cfg_openainodes", GetConnStr()))
            {
                string sql = "CREATE TABLE cfg_openainodes(NodeName varchar(180) NOT NULL, APIKey varchar(250) NULL, DefDesc varchar(8000) NULL, Args varchar(250) NULL, Menus varchar(250) NULL, ModTag SmallInt NOT NULL)";
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = sql;
                catCMD.ExecuteNonQuery();
            }

        }

        public void TestTables()
        {
            if (dbType < 0)
                return;

            if (!SQLServerTableExists("auto_dialer_jobs", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE auto_dialer_jobs(ID BIGINT NOT NULL, Type SMALLINT NOT NULL, Caller varchar(80) NULL, Callee varchar(80) NULL, CallTime datetime NULL, JobID varchar(60) NULL, PRIMARY KEY (ID))";
                catCMD.ExecuteNonQuery();
            }
            if (!SQLServerTableExists("auto_dialer_done", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE auto_dialer_done(ID BIGINT NOT NULL, Type SMALLINT NOT NULL, Caller varchar(80) NULL, Callee varchar(80) NULL, Result int NOT NULL, CallInit datetime NULL, CallBegin datetime NULL, CallEnd datetime NULL, DTMFs varchar(2048) NULL, JobID varchar(60) NULL, DetectResult int NULL, FinalCode int NULL, FinalDesc varchar(120) NULL, CallID varchar(40) NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cdr_pbx", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE cdr_pbx(ID bigint IDENTITY(1,1) PRIMARY KEY CLUSTERED, Connected tinyint NOT NULL, Caller varchar(80) NOT NULL, Callee varchar(80) NOT NULL, StartTime datetime NOT NULL, EndTime datetime NOT NULL, ACD_Name varchar(40) NULL, ACD_In_Time datetime NULL, ACD_Out_Time datetime NULL, ACD_To_Exten varchar(40) NULL, ACD_To_Agent varchar(40) NULL, RecordFile varchar(256) NULL, CallID varchar(40) NULL, CallDir tinyint, Transferred tinyint, IVRKeys varchar(256), DiscReason varchar(256), ConfName varchar(80), HangupParty varchar(250))";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cdr_acd", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE cdr_acd(ID bigint IDENTITY(1,1) PRIMARY KEY CLUSTERED, ACD_Name varchar(40) NOT NULL, ACD_In_Time datetime NOT NULL, ACD_Out_Time datetime NOT NULL, ACD_To_Exten varchar(40) NULL, ACD_To_Agent varchar(40) NULL, Connected tinyint NOT NULL, Caller varchar(80) NOT NULL, Callee varchar(80) NOT NULL, StartTime datetime NOT NULL, EndTime datetime NOT NULL, RecordFile varchar(256) NULL, CallID varchar(40) NULL, CallDir tinyint, Transferred tinyint, DiscReason varchar(256), HangupParty varchar(250))";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cdr_exten", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE cdr_exten(ID bigint IDENTITY(1,1) PRIMARY KEY CLUSTERED, Extension varchar(80) NOT NULL, Connected tinyint NOT NULL, Caller varchar(80) NOT NULL, Callee varchar(80) NOT NULL, StartTime datetime NOT NULL, EndTime datetime NOT NULL, ACD_Name varchar(40) NULL, ACD_In_Time datetime NULL, ACD_Out_Time datetime NULL, ACD_To_Exten varchar(40) NULL, ACD_To_Agent varchar(40) NULL, RecordFile varchar(256) NULL, CallID varchar(40) NULL, CallDir tinyint, Transferred tinyint, DiscReason varchar(256), HangupParty varchar(250))";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("cdr_agent", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE cdr_agent(ID bigint IDENTITY(1,1) PRIMARY KEY CLUSTERED, AgentCode varchar(40) NOT NULL, Action tinyint NOT NULL, LogTime datetime NOT NULL, Extension varchar(80) NOT NULL, Param1 varchar(80), Param2 varchar(80), Param3 varchar(80))";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("status_acd", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE status_acd(ACD_Name varchar(40) NOT NULL, ACD_Type varchar(20) NOT NULL, Agents varchar(1024) NULL, Calls varchar(1024) NULL, WaitTime varchar(1024) NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("status_channel", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE status_channel(ChanID INT NOT NULL, CallStatus varchar(40), Caller varchar(80) NOT NULL, Callee varchar(80) NOT NULL, CallStartTime datetime NULL, LinkedExten varchar(80) NULL, DTMFBuf varchar(80) NULL, Dialplan varchar(40) NULL, OutboundCallTask varchar(40) NULL, ACD_Name varchar(40) NULL, ACD_In_Time datetime NULL, ACD_Out_Time datetime NULL, ACD_To_Exten varchar(40) NULL, ACD_To_Agent varchar(40) NULL, RecordFile varchar(256) NULL, CallID varchar(40) NULL, AutoDialerId bigint NULL, AutoDialerJobId varchar(60) NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("status_exten", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE status_exten(ExtenID varchar(40) NOT NULL, Name varchar(40) NULL, IdleStartTime datetime NULL, ChanIndex INT, Agent varchar(40) NULL, Status varchar(40) NULL, Contact varchar(80) NULL, RegTime datetime NULL, RegExpireSec INT NULL, UAName varchar(80) NULL, NATType INT NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("status_sipaccount", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE status_sipaccount(AccID INT NOT NULL, DisplayName varchar(80) NULL, UserName varchar(80) NULL, Status varchar(40) NULL, DomainServer varchar(120) NULL, ProxyServer varchar(120) NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("status_agent", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE status_agent(AgentCode varchar(40) NOT NULL, AgentName varchar(40) NULL, Status varchar(40) NULL, LoginTime datetime NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("status_parkingslot", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE status_parkingslot(Name varchar(80) NOT NULL, Number varchar(80) NULL, ParkedCall varchar(80) NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("status_conferenceroom", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE status_conferenceroom(Name varchar(80) NOT NULL, Chans varchar(1024) NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("status_plugin", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE status_plugin(Name varchar(80) NOT NULL, Type varchar(40) NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("voice_mailbox", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE voice_mailbox(Extension varchar(80) NULL, ToEmail varchar(80) NOT NULL, Caller varchar(80) NULL, Callee varchar(80) NULL, VMTime datetime NULL, VMDuration INT, VMFile varchar(256) NOT NULL, VMStatus INT, CallID varchar(40) NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("opt_cmd", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE opt_cmd(ID bigint IDENTITY(1,1) PRIMARY KEY CLUSTERED, CmdType SMALLINT NOT NULL, CmdName varchar(80) NOT NULL, CmdArgs varchar(1024) NULL)";
                catCMD.ExecuteNonQuery();
            }

            if (!SQLServerTableExists("log_sys", GetConnStr()))
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandText = "CREATE TABLE log_sys(ID bigint IDENTITY(1,1) PRIMARY KEY CLUSTERED, LogTime DateTime, LogInfo varchar(2000))";
                catCMD.ExecuteNonQuery();
            }

            TestCfgTables();
        }

        public DbDataReader ExcuteQuerySQL(string sqlstr, GTSIPPBXEnv env)
        {
            try
            {
                if (dbType >= 0) //MS SQL Server
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    return catCMD.ExecuteReader();
                }
                else if (dbType == -1) //SQLite
                {
                    SQLiteCommand catCMD = sqliteConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    return catCMD.ExecuteReader();
                }
            }
            catch (Exception ex)
            {
                if (env != null)
                {
                    env.LogoutText(ex.Message);
                    env.LOG_Trace(1, ex.Message);
                }

                return null;
            }

            return null;
        }

        /*
        public DbDataReader ExcuteQuerySQL(string sqlstr)
        {
            try
            {
                if (dbType >= 0) //MS SQL Server
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    return catCMD.ExecuteReader();
                }
                else if (dbType == -1) //SQLite
                {
                    SQLiteCommand catCMD = sqliteConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    return catCMD.ExecuteReader();
                }
            }
            catch (Exception ex)
            {
                return null;
            }

            return null;
        }

        public int ExcuteNonQuerySQL(string sqlstr)
        {
            if (dbType >= 0) //MS SQL Server
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = sqlstr;
                return catCMD.ExecuteNonQuery();
            }
            else if (dbType == -1) //SQLite
            {
                SQLiteCommand catCMD = sqliteConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                catCMD.CommandText = sqlstr;
                return catCMD.ExecuteNonQuery();
            }

            return 0;
        }*/

        public int ExcuteNonQuerySQL(string sqlstr, GTSIPPBXEnv env)
        {
            try
            {
                if (dbType >= 0) //MS SQL Server
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    return catCMD.ExecuteNonQuery();
                }
                else if (dbType == -1) //SQLite
                {
                    SQLiteCommand catCMD = sqliteConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    return catCMD.ExecuteNonQuery();
                }

                return 0;
            }
            catch (Exception ex)
            {
                if (env != null)
                {
                    env.LogoutText(ex.Message);
                    env.LOG_Trace(1, ex.Message);
                }

                return 0;
            }
        }

        /*
         * vb.net to check if a table exists
         * Shared Function TableExists(tableNameAndSchema As String) As Boolean   Using connection As New SqlConnection(connectionString)      Dim checkTable As String = [String].Format("IF OBJECT_ID('{0}', 'U') IS NOT NULL SELECT 'true' ELSE SELECT 'false'", tableNameAndSchema)            Dim command As New SqlCommand(checkTable, connection)      command.CommandType = CommandType.Text      connection.Open()       Return Convert.ToBoolean(command.ExecuteScalar())   End UsingEnd Function
         */

        //vb.net to check if a database exists
        /*
        Public Shared Function CheckDatabaseExists(ByVal server As String, ByVal database As String) As Boolean
        Dim connString As String = ("Data Source="  _
                    + (server + ";Initial Catalog=master;Integrated Security=True;"))
        Dim cmdText As String = ("select * from master.dbo.sysdatabases where name=\'"  _
                    + (database + "\'"))
        Dim bRet As Boolean = false
        Using sqlConnection As SqlConnection = New SqlConnection(connString)
        sqlConnection.Open
        Using sqlCmd As SqlCommand = New SqlCommand(cmdText, sqlConnection)
        Using reader As SqlDataReader = sqlCmd.ExecuteReader
        bRet = reader.HasRows
        End Using
        End Using
        End Using
        Return bRet
        End Function 
        */

        /* //SQLite Sample Codes

        SQLiteConnection.CreateFile("MyDatabase.sqlite");
        SQLiteConnection m_dbConnection = new SQLiteConnection("Data Source=MyDatabase.sqlite;Version=3;");
        m_dbConnection.Open();

        string sql = "create table highscores (name varchar(20), score int)";

        SQLiteCommand command = new SQLiteCommand(sql, m_dbConnection);
        command.ExecuteNonQuery();

        sql = "insert into highscores (name, score) values ('Me', 9001)";

        command = new SQLiteCommand(sql, m_dbConnection);
        command.ExecuteNonQuery();
         
 using (TransactionScope tran = new TransactionScope())
 {
     //Insert create script here.

     //Indicates that creating the SQLiteDatabase went succesfully, so the database can be committed.
     tran.Complete();
 }

        m_dbConnection.Close();

        static SQLiteConnection CreateConnection()
        {
            SQLiteConnection sqlite_conn;
            // Create a new database connection:
            sqlite_conn = new SQLiteConnection("Data Source=database.db;Version=3;New=True;Compress=True;");
            // Open the connection:
            try
            {
                sqlite_conn.Open();
            }
            catch (Exception ex)
            {

            }
            return sqlite_conn;
        }
 
        static void CreateTable(SQLiteConnection conn)
        {
            SQLiteCommand sqlite_cmd;
            string Createsql = "CREATE TABLE SampleTable(Col1 VARCHAR(20), Col2 INT)";
            string Createsql1 = "CREATE TABLE SampleTable1(Col1 VARCHAR(20), Col2 INT)";
            sqlite_cmd = conn.CreateCommand();
            sqlite_cmd.CommandText = Createsql;
            sqlite_cmd.ExecuteNonQuery();
            sqlite_cmd.CommandText = Createsql1;
            sqlite_cmd.ExecuteNonQuery();

        }
 
        static void InsertData(SQLiteConnection conn)
        {
            SQLiteCommand sqlite_cmd;
            sqlite_cmd = conn.CreateCommand();
            sqlite_cmd.CommandText = "INSERT INTO SampleTable(Col1, Col2) VALUES ('Test Text ', 1);";
            sqlite_cmd.ExecuteNonQuery();
            sqlite_cmd.CommandText = "INSERT INTO SampleTable(Col1, Col2) VALUES ('Test1 Text1 ', 2);";
            sqlite_cmd.ExecuteNonQuery();
            sqlite_cmd.CommandText = "INSERT INTO SampleTable(Col1, Col2) VALUES ('Test2 Text2 ', 3);";
            sqlite_cmd.ExecuteNonQuery();


            sqlite_cmd.CommandText = "INSERT INTO SampleTable1(Col1, Col2) VALUES ('Test3 Text3 ', 3);";
            sqlite_cmd.ExecuteNonQuery();

        }
 
        static void ReadData(SQLiteConnection conn)
        {
            SQLiteDataReader sqlite_datareader;
            SQLiteCommand sqlite_cmd;
            sqlite_cmd = conn.CreateCommand();
            sqlite_cmd.CommandText = "SELECT * FROM SampleTable";

            sqlite_datareader = sqlite_cmd.ExecuteReader();
            while (sqlite_datareader.Read())
            {
                string myreader = sqlite_datareader.GetString(0);
                Console.WriteLine(myreader);
            }
            conn.Close();
        }*/
    }

    public class ACD_CDR
    {
        public string acd_name;
        public string acd_in_time;
        public string acd_out_time;
        public string acd_to_exten;
        public string acd_to_agent;
        public int connected;
        public string caller;
        public string callee;
        public string start_time;
        public string end_time;
        public string record_file;
        public bool do_convert;
        public string unique_call_id;
        public bool inbound;
        public bool transferred;
        public string discReason;
        public string hangupParty;
        public int chan_id;

        public ACD_CDR()
        {
            acd_name = "";
            acd_in_time = "";
            acd_out_time = "";
            acd_to_exten = "";
            acd_to_agent = "";
            connected = 0;
            caller = "";
            callee = "";
            start_time = "";
            end_time = "";
            record_file = "";
            do_convert = true;
            unique_call_id = "";
            inbound = true;
            transferred = false;
            discReason = "";
            hangupParty = "";
            chan_id = -1;
        }

        public static string GetTxtHeader()
        {
            return "UniqueID, ACDName, ACDInTime, ACDOutTime, ACDToExten, ACDToAgent, Connected, Caller, Called, StartTime, EndTime, RecordFile, Channel, InOrOut, Transferred, DiscReason, HangupParty";
        }

        public string GetTxtCDR()
        {
            string cdrstr = unique_call_id + "," + acd_name + ",";
            cdrstr += acd_in_time + ",";
            cdrstr += acd_out_time + ",";
            cdrstr += acd_to_exten + ",";
            cdrstr += acd_to_agent + ",";
            cdrstr += connected.ToString() + ",";
            cdrstr += caller + ",";
            cdrstr += callee + ",";
            cdrstr += start_time + ",";
            cdrstr += end_time + ",";
            cdrstr += record_file + ",";
            cdrstr += chan_id.ToString() + ",";
            cdrstr += inbound?"I,":"O,";
            cdrstr += transferred ? "Y," : "N,";
            cdrstr += "'" + discReason + "',";
            cdrstr += "'" + hangupParty + "'";

            return cdrstr;
        }

        public void GetSQLiteStr(SQLiteCommand cmd)
        {
            string sqlstr = "INSERT INTO cdr_acd(ACD_Name, ACD_In_Time, ACD_Out_Time, ACD_To_Exten, ACD_To_Agent, Connected, Caller, Callee, StartTime, EndTime, RecordFile, CallID, CallDir, Transferred, DiscReason, HangupParty) VALUES(";
            sqlstr += "@acd_name, ";
            if (acd_in_time.Length > 0)
                sqlstr += "'" + acd_in_time + "', ";
            else
                sqlstr += "NULL, ";

            if (acd_out_time.Length > 0)
                sqlstr += "'" + acd_out_time + "', ";
            else
                sqlstr += "NULL, ";

            sqlstr += "'" + acd_to_exten + "', ";
            sqlstr += "'" + acd_to_agent + "', ";
            sqlstr += connected.ToString() + ", ";
            sqlstr += "'" + caller + "', ";
            sqlstr += "'" + callee + "', ";

            if (start_time.Length > 0)
                sqlstr += "'" + start_time + "', ";
            else
                sqlstr += "NULL, ";

            if (end_time.Length > 0)
                sqlstr += "'" + end_time + "', ";
            else
                sqlstr += "NULL, ";


            sqlstr += "'" + record_file + "', ";
            sqlstr += "'" + unique_call_id + "', ";

            if (inbound)
                sqlstr += "0, ";
            else
                sqlstr += "1, ";

            if (transferred)
                sqlstr += "1, ";
            else
                sqlstr += "0, ";


            sqlstr += "@discReason, @hangupParty)";

            cmd.CommandTimeout = 3;
            cmd.CommandText = sqlstr;
            cmd.Parameters.AddWithValue("@acd_name", acd_name);

            if (discReason.Length > 256) discReason = discReason.Substring(0, 256);
            cmd.Parameters.AddWithValue("@discReason", discReason);

            if (hangupParty.Length > 250) hangupParty = hangupParty.Substring(0, 250);
            cmd.Parameters.AddWithValue("@hangupParty", hangupParty);

            //return sqlstr;
        }

        public void GetSQLStr(SqlCommand cmd)
        {
            string sqlstr = "INSERT INTO cdr_acd(ACD_Name, ACD_In_Time, ACD_Out_Time, ACD_To_Exten, ACD_To_Agent, Connected, Caller, Callee, StartTime, EndTime, RecordFile, CallID, CallDir, Transferred, DiscReason, HangupParty) VALUES(";
            sqlstr += "@acd_name, ";
            if(acd_in_time.Length > 0)
                sqlstr += "'" + acd_in_time + "', ";
            else
                sqlstr += "NULL, ";

            if(acd_out_time.Length > 0)
                sqlstr += "'" + acd_out_time + "', ";
            else
                sqlstr += "NULL, ";

            sqlstr += "'" + acd_to_exten + "', ";
            sqlstr += "'" + acd_to_agent + "', ";
            sqlstr += connected.ToString() + ", ";
            sqlstr += "'" + caller + "', ";
            sqlstr += "'" + callee + "', ";

            if(start_time.Length > 0)
                sqlstr += "'" + start_time + "', ";
            else
                sqlstr += "NULL, ";

            if(end_time.Length > 0)
                sqlstr += "'" + end_time + "', ";
            else
                sqlstr += "NULL, ";


            sqlstr += "'" + record_file + "', ";
            sqlstr += "'" + unique_call_id + "', ";

            if (inbound)
                sqlstr += "0, ";
            else
                sqlstr += "1, ";

            if (transferred)
                sqlstr += "1, ";
            else
                sqlstr += "0, ";


            sqlstr += "@discReason, @hangupParty)";

            cmd.CommandTimeout = 3;
            cmd.CommandText = sqlstr;
            cmd.Parameters.AddWithValue("@acd_name", acd_name);

            if (discReason.Length > 256) discReason = discReason.Substring(0, 256);
            cmd.Parameters.AddWithValue("@discReason", discReason);

            if (hangupParty.Length > 250) hangupParty = hangupParty.Substring(0, 250);
            cmd.Parameters.AddWithValue("@hangupParty", hangupParty);
            //return sqlstr;
        }

        public bool SaveToDB(DBServerSetting db_set)
        {
            if (db_set != null)
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    if (db_set.myConn != null)
                    {
                        SqlCommand catCMD = db_set.myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        GetSQLStr(catCMD);

                        if (catCMD.ExecuteNonQuery() == 1)
                            return true;
                        else
                            return false;
                    }
                }
                else if (db_set.dbType == -1) //SQLite
                {
                    if (db_set.sqliteConn != null)
                    {
                        SQLiteCommand catCMD = db_set.sqliteConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        GetSQLiteStr(catCMD);

                        if (catCMD.ExecuteNonQuery() == 1)
                            return true;
                        else
                            return false;
                    }
                }
            }
            return false;
        }

    }

    public class PBX_CDR
    {
        public int connected;
        public string caller;
        public string callee;
        public string start_time;
        public string end_time;
        public string acd_name;
        public string acd_in_time;
        public string acd_out_time;
        public string acd_to_exten;
        public string acd_to_agent;
        public string record_file;
        public bool do_convert;
        public string org_caller_id;
        public string org_called_id;
        public string unique_call_id;
        public bool inbound;
        public bool transferred;
        public string ivrKeys;
        public string discReason;
        public string hangupParty;
        public string confName;
        public GTSIPPBXEnv env;
        public int chan_id;
        public string sipAcct;

        public PBX_CDR()
        {
            connected = 0;
            caller = "";
            callee = "";
            start_time = "";
            end_time = "";
            acd_name = "";
            acd_in_time = "";
            acd_out_time = "";
            acd_to_exten = "";
            acd_to_agent = "";
            record_file = "";
            do_convert = true;
            org_caller_id = "";
            org_called_id = "";
            unique_call_id = "";
            inbound = true;
            transferred = false;
            ivrKeys = "";
            discReason = "";
            hangupParty = "";
            confName = "";
            env = null;
            chan_id = -1;
            sipAcct = "";
        }

        public static string GetTxtHeader()
        {
            return "UniqueID, Connected, Caller, Called, StartTime, EndTime, ACDName, ACDInTime, ACDOutTime, ACDToExten, ACDToAgent, RecordFile, Channel, InOrOut, Transferred, IVRKeys, DiscReason, ConfName, Trunk, HangupParty";
        }

        public string GetTxtCDR()
        {
            string cdrstr = unique_call_id + "," + connected.ToString() + ",";
            cdrstr += caller + ",";
            cdrstr += callee + ",";
            cdrstr += start_time + ",";
            cdrstr += end_time + ",";
            cdrstr += acd_name + ",";
            cdrstr += acd_in_time + ",";
            cdrstr += acd_out_time + ",";
            cdrstr += acd_to_exten+ ",";
            cdrstr += acd_to_agent + ",";
            cdrstr += record_file + ",";
            cdrstr += chan_id.ToString() + ",";
            cdrstr += inbound?"I,":"O,";
            cdrstr += transferred ? "Y," : "N,";
            cdrstr += "'" + ivrKeys + "',";
            cdrstr += "'" + discReason + "',";
            cdrstr += confName + ",";
            cdrstr += sipAcct + ",";
            cdrstr += hangupParty;

            return cdrstr;
        }

        public void GetSQLiteStr(SQLiteCommand cmd)
        {
            string sqlstr = "INSERT INTO cdr_pbx(Connected, Caller, Callee, StartTime, EndTime, ACD_Name, ACD_In_Time, ACD_Out_Time, ACD_To_Exten, ACD_To_Agent, RecordFile, CallID, CallDir, Transferred, IVRKeys, DiscReason, ConfName, HangupParty) VALUES(";
            sqlstr += connected.ToString() + ", ";
            sqlstr += "@Caller, ";
            sqlstr += "@Callee, ";

            sqlstr += "'" + start_time + "', ";
            sqlstr += "'" + end_time + "', ";
            sqlstr += "'" + acd_name + "', ";

            if (acd_in_time.Length > 0)
                sqlstr += "'" + acd_in_time + "', ";
            else
                sqlstr += "NULL, ";

            if (acd_out_time.Length > 0)
                sqlstr += "'" + acd_out_time + "', ";
            else
                sqlstr += "NULL, ";

            sqlstr += "'" + acd_to_exten + "', ";
            sqlstr += "'" + acd_to_agent + "', ";
            sqlstr += "@recordFile, ";
            sqlstr += "'" + unique_call_id + "', ";
            if (inbound)
                sqlstr += "0, ";
            else
                sqlstr += "1, ";

            if (transferred)
                sqlstr += "1, ";
            else
                sqlstr += "0, ";

            sqlstr += "'" + ivrKeys + "', @discReason, @confName, @hangupParty)";

            cmd.CommandTimeout = 3;
            cmd.CommandText = sqlstr;

            cmd.Parameters.AddWithValue("@Caller", caller);
            cmd.Parameters.AddWithValue("@Callee", callee);
            cmd.Parameters.AddWithValue("@recordFile", record_file);

            if (discReason.Length > 256) discReason = discReason.Substring(0, 256);
            cmd.Parameters.AddWithValue("@discReason", discReason);

            cmd.Parameters.AddWithValue("@confName", confName);

            if (hangupParty.Length > 250) hangupParty = hangupParty.Substring(0, 250);
            cmd.Parameters.AddWithValue("@hangupParty", hangupParty);

            //return sqlstr;
        }


        public void GetSQLStr(SqlCommand cmd)
        {
            string sqlstr = "INSERT INTO cdr_pbx(Connected, Caller, Callee, StartTime, EndTime, ACD_Name, ACD_In_Time, ACD_Out_Time, ACD_To_Exten, ACD_To_Agent, RecordFile, CallID, CallDir, Transferred, IVRKeys, DiscReason, ConfName, HangupParty) VALUES(";
            sqlstr += connected.ToString() + ", ";
            sqlstr += "@Caller, ";
            sqlstr += "@Callee, ";

            sqlstr += "'" + start_time + "', ";
            sqlstr += "'" + end_time + "', ";
            sqlstr += "'" + acd_name + "', ";

            if(acd_in_time.Length > 0)
                sqlstr += "'" + acd_in_time + "', ";
            else
                sqlstr += "NULL, ";

            if(acd_out_time.Length > 0)
                sqlstr += "'" + acd_out_time + "', ";
            else
                sqlstr += "NULL, ";

            sqlstr += "'" + acd_to_exten + "', ";
            sqlstr += "'" + acd_to_agent + "', ";
            sqlstr += "@recordFile, ";
            sqlstr += "'" + unique_call_id + "', ";
            if (inbound)
                sqlstr += "0, ";
            else
                sqlstr += "1, ";

            if (transferred)
                sqlstr += "1, ";
            else
                sqlstr += "0, ";

            sqlstr += "'" + ivrKeys + "', @discReason, @confName, @hangupParty)";

            cmd.CommandTimeout = 3;
            cmd.CommandText = sqlstr;

            cmd.Parameters.AddWithValue("@Caller", caller);
            cmd.Parameters.AddWithValue("@Callee", callee);
            cmd.Parameters.AddWithValue("@recordFile", record_file);

            if (discReason.Length > 256) discReason = discReason.Substring(0, 256);
            cmd.Parameters.AddWithValue("@discReason", discReason);

            cmd.Parameters.AddWithValue("@confName", confName);

            if (hangupParty.Length > 250) hangupParty = hangupParty.Substring(0, 250);
            cmd.Parameters.AddWithValue("@hangupParty", hangupParty);

            //return sqlstr;
        }

        public string GetDTHSQLStr()
        {
            DateTime dt1 = SIPPBXWinUtil.GetDotNetDateTime(start_time);
            DateTime dt2 = SIPPBXWinUtil.GetDotNetDateTime(end_time);
            TimeSpan dt_span = dt2 - dt1;
            int DurSec = Convert.ToInt32(dt_span.TotalSeconds);
            //string unique_id = dt1.ToString("yyyyMMddHHmmss") + "-" + dt2.ToString("yyyyMMddHHmmss") + "-" + org_caller_id + "-" + org_called_id;

            string sqlstr = "INSERT INTO DTH_CallRecordMaster_TBR VALUES(";
            sqlstr += "'" + unique_call_id + "', ";
            sqlstr += "'" + caller + "', ";
            sqlstr += "'" + callee + "', ";
            sqlstr += "'" + start_time + "', ";
            sqlstr += DurSec.ToString() + ", '', '', '', ";
            sqlstr += "'" + org_caller_id + "', ";
            sqlstr += "'" + org_called_id + "', '')";

            return sqlstr;
        }

        public bool SaveToDB(DBServerSetting db_set)
        {
            if (db_set != null)
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    if (db_set.myConn != null)
                    {
                        SqlCommand catCMD = db_set.myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        /*
                                            try
                                            {
                                                if (db_set.TableExists("DTH_CallRecordMaster_TBR") && org_caller_id.Length > 0 && org_called_id.Length > 0)
                                                {
                                                    catCMD.CommandText = GetDTHSQLStr();
                                                    if (catCMD.ExecuteNonQuery() == 1)
                                                    {
                                                    }
                                                }
                                            }
                                            catch (Exception ex)
                                            {
                                                env.LOG_Trace(1, ex.ToString());
                                            }*/

                        GetSQLStr(catCMD);

                        int cmdRes;

                        try
                        {
                            cmdRes = catCMD.ExecuteNonQuery();
                        }
                        catch (Exception ex)
                        {
                            cmdRes = 0;
                            env.LOG_Trace(1, "Error on: " + catCMD.CommandText);
                            env.LOG_Trace(1, ex.ToString());
                        }

                        if (cmdRes == 1)
                            return true;
                        else
                            return false;
                    }
                }
                else if (db_set.dbType == -1) //SQLite
                {
                    if (db_set.sqliteConn != null)
                    {
                        SQLiteCommand catCMD = db_set.sqliteConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        GetSQLiteStr(catCMD);

                        int cmdRes;

                        try
                        {
                            cmdRes = catCMD.ExecuteNonQuery();
                        }
                        catch (Exception ex)
                        {
                            cmdRes = 0;
                            env.LOG_Trace(1, "Error on: " + catCMD.CommandText);
                            env.LOG_Trace(1, ex.ToString());
                        }

                        if (cmdRes == 1)
                            return true;
                        else
                            return false;
                    }
                }
            }
            return false;
        }

    }

    public class Agent_CDR
    {
        public string agent_code;
        public short agent_log_action; //1 = login, 0 = logout
        public string agent_log_time;
        public string agent_log_exten;
        public string param1;
        public string param2;
        public string param3;

        public Agent_CDR()
        {
            agent_code = "";
            agent_log_action = 0;
            agent_log_time = "";
            agent_log_exten = "";
            param1 = "";
            param2 = "";
            param3 = "";
        }

        public static string GetTxtHeader()
        {
            return "AgentCode, AgentLogIn, Time, Extension";
        }

        public string GetTxtCDR()
        {
            string cdrstr = agent_code + ",";
            cdrstr += agent_log_action.ToString() + ",";
            cdrstr += agent_log_time + ",";
            cdrstr += agent_log_exten;
            return cdrstr;
        }

        public void GetSQLiteStr(SQLiteCommand cmd)
        {
            string sqlstr = "INSERT INTO cdr_agent(AgentCode, Action, LogTime, Extension, Param1, Param2, Param3) VALUES(";
            sqlstr += "'" + agent_code + "', ";
            sqlstr += agent_log_action.ToString() + ", ";
            sqlstr += "'" + agent_log_time + "', ";
            sqlstr += "'" + agent_log_exten + "', ";
            sqlstr += "'" + param1 + "', ";
            sqlstr += "'" + param2 + "', ";
            sqlstr += "'" + param3 + "')";

            cmd.CommandText = sqlstr;
            cmd.CommandTimeout = 3;
            //return sqlstr;
        }

        public void GetSQLStr(SqlCommand cmd)
        {
            string sqlstr = "INSERT INTO cdr_agent(AgentCode, Action, LogTime, Extension, Param1, Param2, Param3) VALUES(";
            sqlstr += "'" + agent_code + "', ";
            sqlstr += agent_log_action.ToString() + ", ";
            sqlstr += "'" + agent_log_time + "', ";
            sqlstr += "'" + agent_log_exten + "', ";
            sqlstr += "'" + param1 + "', ";
            sqlstr += "'" + param2 + "', ";
            sqlstr += "'" + param3 + "')";

            cmd.CommandText = sqlstr;
            cmd.CommandTimeout = 3;
            //return sqlstr;
        }

        public bool SaveToDB(DBServerSetting db_set)
        {
            if (db_set != null)
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    if (db_set.myConn != null)
                    {
                        SqlCommand catCMD = db_set.myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        GetSQLStr(catCMD);

                        if (catCMD.ExecuteNonQuery() == 1)
                            return true;
                        else
                            return false;
                    }
                }
                else if (db_set.dbType == -1) //SQLite
                {
                    if (db_set.sqliteConn != null)
                    {
                        SQLiteCommand catCMD = db_set.sqliteConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        GetSQLiteStr(catCMD);

                        if (catCMD.ExecuteNonQuery() == 1)
                            return true;
                        else
                            return false;
                    }
                }
            }
            return false;
        }

    }

    public class Exten_CDR
    {
        public string exten_name;
        public int connected;
        public string caller;
        public string callee;
        public string start_time;
        public string end_time;
        public string acd_name;
        public string acd_in_time;
        public string acd_out_time;
        public string acd_to_exten;
        public string acd_to_agent;
        public string record_file;
        public bool do_convert;
        public string unique_call_id;
        public bool inbound;
        public bool transferred;
        public string discReason;
        public string hangupParty;
        public int chan_id;
        public string sipAcct;

        public Exten_CDR()
        {
            exten_name = "";
            connected = 0;
            caller = "";
            callee = "";
            start_time = "";
            end_time = "";
            acd_name = "";
            acd_in_time = "";
            acd_out_time = "";
            acd_to_exten = "";
            acd_to_agent = "";
            record_file = "";
            do_convert = true;
            unique_call_id = "";
            inbound = true;
            transferred = false;
            discReason = "";
            hangupParty = "";
            chan_id = -1;
            sipAcct = "";
        }

        public static string GetTxtHeader()
        {
            return "Exten, UniqueID, Connected, Caller, Called, StartTime, EndTime, ACDName, ACDInTime, ACDOutTime, ACDToExten, ACDToAgent, RecordFile, Channel, InOrOut, Transferred, DiscReason, Trunk, HangupParty";
        }

        public string GetTxtCDR()
        {
            string cdrstr = exten_name + ",";
            cdrstr += unique_call_id + "," + connected.ToString() + ",";
            cdrstr += caller + ",";
            cdrstr += callee + ",";
            cdrstr += start_time + ",";
            cdrstr += end_time + ",";
            cdrstr += acd_name + ",";
            cdrstr += acd_in_time + ",";
            cdrstr += acd_out_time + ",";
            cdrstr += acd_to_exten + ",";
            cdrstr += acd_to_agent + ",";
            cdrstr += record_file + ",";
            cdrstr += chan_id.ToString() + ",";
            cdrstr += inbound?"I,":"O,";
            cdrstr += transferred? "Y," : "N,";
            cdrstr += "'" + discReason + "',";
            cdrstr += sipAcct + ",";
            cdrstr += "'" + hangupParty + "'";

            return cdrstr;
        }

        public void GetSQLiteStr(SQLiteCommand cmd)
        {
            string sqlstr = "INSERT INTO cdr_exten(Extension, Connected, Caller, Callee, StartTime, EndTime, ACD_Name, ACD_In_Time, ACD_Out_Time, ACD_To_Exten, ACD_To_Agent, RecordFile, CallID, CallDir, Transferred, DiscReason, HangupParty) VALUES(";
            sqlstr += "'" + exten_name + "', ";
            sqlstr += connected.ToString() + ", ";
            sqlstr += "'" + caller + "', ";
            sqlstr += "'" + callee + "', ";
            sqlstr += "'" + start_time + "', ";
            sqlstr += "'" + end_time + "', ";
            sqlstr += "'" + acd_name + "', ";

            if (acd_in_time.Length > 0)
                sqlstr += "'" + acd_in_time + "', ";
            else
                sqlstr += "NULL, ";

            if (acd_out_time.Length > 0)
                sqlstr += "'" + acd_out_time + "', ";
            else
                sqlstr += "NULL, ";

            sqlstr += "'" + acd_to_exten + "', ";
            sqlstr += "'" + acd_to_agent + "', ";
            sqlstr += "'" + record_file + "', ";
            sqlstr += "'" + unique_call_id + "', ";


            if (exten_name == caller)
            {
                sqlstr += "1, ";
            }
            else if (exten_name == callee)
            {
                sqlstr += "0, ";
            }
            else
            {
                if (inbound)
                    sqlstr += "0, ";
                else
                    sqlstr += "1, ";
            }

            if (transferred)
                sqlstr += "1, ";
            else
                sqlstr += "0, ";

            sqlstr += "@discReason, @hangupParty)";

            cmd.CommandTimeout = 3;
            cmd.CommandText = sqlstr;

            if (discReason.Length > 256) discReason = discReason.Substring(0, 256);
            cmd.Parameters.AddWithValue("@discReason", discReason);

            if (hangupParty.Length > 250) hangupParty = hangupParty.Substring(0, 250);
            cmd.Parameters.AddWithValue("@hangupParty", hangupParty);

            //return sqlstr;
        }


        public void GetSQLStr(SqlCommand cmd)
        {
            string sqlstr = "INSERT INTO cdr_exten(Extension, Connected, Caller, Callee, StartTime, EndTime, ACD_Name, ACD_In_Time, ACD_Out_Time, ACD_To_Exten, ACD_To_Agent, RecordFile, CallID, CallDir, Transferred, DiscReason, HangupParty) VALUES(";
            sqlstr += "'" + exten_name + "', ";
            sqlstr += connected.ToString() + ", ";
            sqlstr += "'" + caller + "', ";
            sqlstr += "'" + callee + "', ";
            sqlstr += "'" + start_time + "', ";
            sqlstr += "'" + end_time + "', ";
            sqlstr += "'" + acd_name + "', ";

            if (acd_in_time.Length > 0)
                sqlstr += "'" + acd_in_time + "', ";
            else
                sqlstr += "NULL, ";

            if (acd_out_time.Length > 0)
                sqlstr += "'" + acd_out_time + "', ";
            else
                sqlstr += "NULL, ";

            sqlstr += "'" + acd_to_exten + "', ";
            sqlstr += "'" + acd_to_agent + "', ";
            sqlstr += "'" + record_file + "', ";
            sqlstr += "'" + unique_call_id + "', ";


            if (exten_name == caller)
            {
                sqlstr += "1, ";
            }
            else if (exten_name == callee)
            {
                sqlstr += "0, ";
            }
            else
            {
                if (inbound)
                    sqlstr += "0, ";
                else
                    sqlstr += "1, ";
            }

            if (transferred)
                sqlstr += "1, ";
            else
                sqlstr += "0, ";

            sqlstr += "@discReason, @hangupParty)";

            cmd.CommandTimeout = 3;
            cmd.CommandText = sqlstr;

            if (discReason.Length > 256) discReason = discReason.Substring(0, 256);
            cmd.Parameters.AddWithValue("@discReason", discReason);

            if (hangupParty.Length > 250) hangupParty = hangupParty.Substring(0, 250);
            cmd.Parameters.AddWithValue("@hangupParty", hangupParty);

            //return sqlstr;
        }

        public bool SaveToDB(DBServerSetting db_set)
        {
            if (db_set != null)
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    if (db_set.myConn != null)
                    {
                        try
                        {
                            SqlCommand catCMD = db_set.myConn.CreateCommand();
                            catCMD.CommandTimeout = 3;
                            GetSQLStr(catCMD);

                            if (catCMD.ExecuteNonQuery() == 1)
                                return true;
                            else
                            {
                                if (GTAPIASM.GTAPIEnv.g_Env != null)
                                    GTAPIASM.GTAPIEnv.g_Env.LOG_Trace(1, "Save Extension CDR DB error:" + catCMD.CommandText);
                                return false;
                            }
                        }
                        catch (Exception ex)
                        {
                            if (GTAPIASM.GTAPIEnv.g_Env != null)
                                GTAPIASM.GTAPIEnv.g_Env.LOG_Trace(1, ex.ToString());
                            return false;
                        }
                    }
                }
                else if (db_set.dbType == -1)
                {
                    if (db_set.sqliteConn != null)
                    {
                        try
                        {
                            SQLiteCommand catCMD = db_set.sqliteConn.CreateCommand();
                            catCMD.CommandTimeout = 3;
                            GetSQLiteStr(catCMD);

                            if (catCMD.ExecuteNonQuery() == 1)
                                return true;
                            else
                            {
                                if (GTAPIASM.GTAPIEnv.g_Env != null)
                                    GTAPIASM.GTAPIEnv.g_Env.LOG_Trace(1, "Save Extension CDR DB error:" + catCMD.CommandText);
                                return false;
                            }
                        }
                        catch (Exception ex)
                        {
                            if (GTAPIASM.GTAPIEnv.g_Env != null)
                                GTAPIASM.GTAPIEnv.g_Env.LOG_Trace(1, ex.ToString());
                            return false;
                        }
                    }
                }

            }
            return false;
        }

    }

    public class SIPPBXDBUtil
    {
        public static string FormatTimeSpan(TimeSpan span, bool showSign)
        {
            string sign = String.Empty;
            if (showSign && (span > TimeSpan.Zero))
                sign = "+";

            return sign + span.Days.ToString("00") + "." +
                   span.Hours.ToString("00") + ":" +
                   span.Minutes.ToString("00") + ":" +
                   span.Seconds.ToString("00");
        }

        public static void RetrieveSrvOptCmd(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXDBAgent db_agent/*SqlConnection myConn*/)
        {
            PBXOptCmd cmd = db_agent.GetSrvOptCmd();
            if(cmd != null)
                pbx.opt_cmd_queue.Enqueue(cmd);
        }

        /*
                public static void SaveCFGExtenTable(SIPPBX pbx, GTSIPPBXEnv env, SqlConnection myConn)
                {
                    string sqlstr = "";
                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        catCMD.CommandText = "DELETE FROM cfg_extension";
                        if (catCMD.ExecuteNonQuery() == 1)
                        {
                        }
                    }
                    catch (Exception ex)
                    {
                        if (env != null)
                        {
                            env.LogoutText(ex.Message);
                            env.LOG_Trace(1, ex.Message);
                        }
                    }

                    for (int i = 0; i < pbx.sip_exten.Count; i++)
                    {
                        SIPPBXExten extn = pbx.sip_exten[i];

                        sqlstr = "INSERT INTO cfg_extension VALUES(";

                        sqlstr += "'" + extn.UserName + "', ";
                        sqlstr += "'" + extn.RealName + "', ";
                        sqlstr += "'" + extn.Password + "', ";
                        sqlstr += "'" + extn.Email + "', ";
                        sqlstr += "'" + extn.AlternativePhoneNumber + "', ";
                        sqlstr += extn.PriorityLevel.ToString() + ")";

                        try
                        {
                            SqlCommand catCMD = myConn.CreateCommand();
                            catCMD.CommandText = sqlstr;
                            if (catCMD.ExecuteNonQuery() == 1)
                            {
                            }
                        }
                        catch (Exception ex)
                        {
                            if (env != null)
                            {
                                env.LogoutText(ex.Message);
                                env.LOG_Trace(1, ex.Message);
                            }
                        }
                    }
                }
        */

        public static bool SaveConferenceRoomStatusIntoDB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXDBAgent db_agent/*SqlConnection myConn*/)
        {
            string sqlstr = "";
            bool ret = true;

            for (int i = 0; i < pbx.sip_conferooms.Count; i++)
            {
                SIPConferRoom conf = pbx.sip_conferooms[i];

                sqlstr = "UPDATE status_conferenceroom SET ";

                string chanList = "";
                for (int j = 0; j < conf.conf_chans.Count; j++)
                {
                    chanList += conf.conf_chans[j].index.ToString() + ";";
                }
                sqlstr += "Chans = '" + chanList + "' ";

                sqlstr += "WHERE Name = '" + conf.conf_name + "'";

                db_agent.AddSQL(sqlstr);

                /*
                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandText = sqlstr;
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch (Exception ex)
                {
                    env.LogoutText(ex.Message);
                    env.LOG_Trace(1, ex.Message);
                    ret = false;
                }*/
            }

            return ret;
        }

        public static void InitConferenceRoomStatusTable(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set)
        {
            string sqlstr;

            db_set.ExcuteNonQuerySQL("DELETE FROM status_conferenceroom", env);

            for (int i = 0; i < pbx.sip_conferooms.Count; i++)
            {
                SIPConferRoom conf = pbx.sip_conferooms[i];

                sqlstr = "INSERT INTO status_conferenceroom(Name, Chans) VALUES(";

                sqlstr += "'" + conf.conf_name + "', ";

                string chanList = "";
                for (int j = 0; j < conf.conf_chans.Count; j++)
                {
                    chanList += conf.conf_chans[j].index.ToString() + ";";
                }

                sqlstr += "'" + chanList + "')";

                db_set.ExcuteNonQuerySQL(sqlstr, env);
            }

        }

        public static void InitPluginStatusTable(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set)
        {
            string sqlstr = "";
            db_set.ExcuteNonQuerySQL("DELETE FROM status_plugin", env);

            for (int i = 0; i < pbx.plugins.Count; i++)
            {
                sqlstr = "INSERT INTO status_plugin(Name, Type) VALUES(";

                sqlstr += "'" + pbx.plugins[i].Name + "', ";
                sqlstr += "'" + pbx.plugins[i].Type + "')";

                db_set.ExcuteNonQuerySQL(sqlstr, env);
            }

        }

        public static void AddPluginsIntoComboBox(SIPPBX pbx, ComboBox cb, string defValue, DBServerSetting db_set, SIPPBXLog log)
        {
            int idx = 0;

            cb.Enabled = true;
            cb.Items.Clear();

            try
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    SqlCommand catCMD = db_set.myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "SELECT Name,Type FROM status_plugin";

                    SqlDataReader myReader = catCMD.ExecuteReader();

                    try
                    {
                        int i = 0;
                        while (myReader.Read())
                        {
                            cb.Items.Add(myReader.GetString(0));
                            if (defValue.Length > 0)
                            {
                                if (defValue == myReader.GetString(0))
                                    idx = i;
                            }
                            i++;
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }
                else if (db_set.dbType == -1) //SQLite
                {
                    SQLiteCommand catCMD = db_set.sqliteConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "SELECT Name,Type FROM status_plugin";

                    SQLiteDataReader myReader = catCMD.ExecuteReader();

                    try
                    {
                        int i = 0;
                        while (myReader.Read())
                        {
                            cb.Items.Add(myReader.GetString(0));
                            if (defValue.Length > 0)
                            {
                                if (defValue == myReader.GetString(0))
                                    idx = i;
                            }
                            i++;
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            if (cb.Items.Count > 0)
            {
                if (idx == -1)
                    idx = 0;

                cb.SelectedIndex = idx;
            }
            else
            {
                cb.Enabled = false;
            }
        }

        public static void LoadPluginStatusFromDB(ListView lv, SIPPBX pbx, DBServerSetting db_set, SIPPBXLog log)
        {
            lv.Items.Clear();

            try
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    SqlCommand catCMD = db_set.myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "SELECT Name,Type FROM status_plugin";

                    SqlDataReader myReader = catCMD.ExecuteReader();

                    try
                    {
                        while (myReader.Read())
                        {
                            ListViewItem aItem = new ListViewItem(myReader.GetString(0));
                            aItem.SubItems.Add(myReader.GetString(1));
                            lv.Items.Add(aItem);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }
                else if (db_set.dbType == -1) //SQLite
                {
                    SQLiteCommand catCMD = db_set.sqliteConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "SELECT Name,Type FROM status_plugin";

                    SQLiteDataReader myReader = catCMD.ExecuteReader();

                    try
                    {
                        while (myReader.Read())
                        {
                            ListViewItem aItem = new ListViewItem(myReader.GetString(0));
                            aItem.SubItems.Add(myReader.GetString(1));
                            lv.Items.Add(aItem);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }

                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool SaveParkingSlotStatusIntoDB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXDBAgent db_agent/*SqlConnection myConn*/)
        {
            string sqlstr = "";
            bool ret = true;

            for (int i = 0; i < pbx.sip_parkingslots.Count; i++)
            {
                SIPPBXParkingSlot pkslot = pbx.sip_parkingslots[i];

                sqlstr = "UPDATE status_parkingslot SET ";

                sqlstr += "Number = '" + pkslot.psDTMF + "', ";

                if (pkslot.pbxChan != null)
                    sqlstr += "ParkedCall = 'Call on channel " + pkslot.pbxChan.index.ToString() + "' ";
                else
                    sqlstr += "ParkedCall = '' ";

                sqlstr += "WHERE Name = '" + pkslot.psName + "'";

                db_agent.AddSQL(sqlstr);

                /*

                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch (Exception ex)
                {
                    env.LogoutText(ex.Message);
                    env.LOG_Trace(1, ex.Message);
                    ret = false;
                }*/
            }

            return ret;
        }

        public static void InitParkingSlotStatusTable(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set)
        {
            string sqlstr = "";

            db_set.ExcuteNonQuerySQL("DELETE FROM status_parkingslot", env);

            for (int i = 0; i < pbx.sip_parkingslots.Count; i++)
            {
                SIPPBXParkingSlot pkslot = pbx.sip_parkingslots[i];

                sqlstr = "INSERT INTO status_parkingslot(Name, Number, ParkedCall) VALUES(";

                sqlstr += "'" + pkslot.psName + "', ";
                sqlstr += "'" + pkslot.psDTMF + "', ";

                if (pkslot.pbxChan != null)
                    sqlstr += "'Call on channel " + pkslot.pbxChan.index.ToString() + "')";
                else
                    sqlstr += "'')";

                db_set.ExcuteNonQuerySQL(sqlstr, env);
                
            }

        }

        public static void InitAgentStatusTable(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set)
        {
            string sqlstr = "";

            db_set.ExcuteNonQuerySQL("DELETE FROM status_agent", env);

            for (int i = 0; i < pbx.sip_agents.Count; i++)
            {
                SIPPBXAgent agent = pbx.sip_agents[i];

                sqlstr = "INSERT INTO status_agent(AgentCode, AgentName, Status, LoginTime) VALUES(";

                sqlstr += "'" + agent.Code + "', ";
                sqlstr += "'" + agent.Name + "', ";

                if (agent.AtExten != null)
                {
                    //the format changed, but later on it will be refreshed by SaveAgentStatusIntoDB
                    sqlstr += "'Logged in at " + agent.AtExten.UserName + "', ";
                    sqlstr += "'" + SIPPBXWinUtil.GetSQLDateTime(agent.LogInTime) + "')";
                }
                else
                {
                    sqlstr += "'Offline', ";
                    sqlstr += "NULL)";
                }

                db_set.ExcuteNonQuerySQL(sqlstr, env);
            }
        }

        public static bool SaveAgentStatusIntoDB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXDBAgent db_agent/*SqlConnection myConn*/)
        {
            string sqlstr = "";
            string stastr = "";
			bool ret = true;

            for (int i = 0; i < pbx.sip_agents.Count; i++)
            {
                SIPPBXAgent agent = pbx.sip_agents[i];

                sqlstr = "UPDATE status_agent SET ";
                if (agent.AtExten != null)
                {
                    stastr = "Ext:" + agent.AtExten.UserName;
                    if (agent.LoggedInACD.Count > 0)
                    {
                        stastr += ";ACD:";
                        for (int j = 0; j < agent.LoggedInACD.Count; j++)
                        {
                            if (j != agent.LoggedInACD.Count - 1)
                                stastr += agent.LoggedInACD[j] + ",";
                            else
                                stastr += agent.LoggedInACD[j];
                        }
                    }
                    if (agent.AtExten.InCalling > 0)
                    {
                        sqlstr += "Status = 'Incall;" + stastr + "', ";
                    }
                    else
                    {
                        sqlstr += "Status = 'Idle;" + stastr + "', ";
                    }
                    sqlstr += "LoginTime = '" + SIPPBXWinUtil.GetSQLDateTime(agent.LogInTime) + "' ";
                }
                else
                {
                    sqlstr += "Status = 'Offline', ";
                    sqlstr += "LoginTime = NULL ";
                }

                sqlstr += "WHERE AgentCode = '" + agent.Code + "'";

                db_agent.AddSQL(sqlstr);

                /*
                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch (Exception ex)
                {
                    env.LogoutText(ex.Message);
                    env.LOG_Trace(1, ex.Message);
					ret = false;
                }*/
            }

			return ret;
        }

        public static void InitSIPAccountStatusTable(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set)
        {
            string sqlstr = "";

            db_set.ExcuteNonQuerySQL("DELETE FROM status_sipaccount", env);

            for (int i = 0; i < pbx.sip_acct.Count; i++)
            {
                int idx = i + 1;
                SIPAccount acct = pbx.sip_acct[i];

                sqlstr = "INSERT INTO status_sipaccount(AccID, DisplayName, UserName, Status, DomainServer, ProxyServer) VALUES(";
                sqlstr += idx.ToString() + ", ";
                sqlstr += "'" + acct.DisplayName + "', ";
                sqlstr += "'" + acct.UserName + "', ";
                 
                if (acct.Registered)
                {
                    sqlstr += "'Up', ";
                }
                else
                {
                    sqlstr += "'Offline', ";
                }

                sqlstr += "'" + acct.DomainServer + "', ";
                sqlstr += "'" + acct.ProxyServer + "')";

                db_set.ExcuteNonQuerySQL(sqlstr, env);
            }
        }

        public static bool SaveSIPAccountStatusIntoDB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXDBAgent db_agent/*SqlConnection myConn*/
                                                                                                                                 )
        {
            string sqlstr = "";
			bool ret = true;

            for (int i = 0; i < pbx.sip_acct.Count; i++)
            {
                int idx = i + 1;
                SIPAccount acct = pbx.sip_acct[i];

                sqlstr = "UPDATE status_sipaccount SET ";
                if (acct.Registered)
                {
                    sqlstr += "Status = 'Up' ";
                }
                else
                {
                    sqlstr += "Status = 'Offline' ";
                }

                sqlstr += "WHERE AccID = " + idx.ToString();

                db_agent.AddSQL(sqlstr);

                /*
                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch (Exception ex)
                {
                    env.LogoutText(ex.Message);
                    env.LOG_Trace(1, ex.Message);
					ret = false;
                }*/

            }

			return ret;
        }

        public static bool SaveExtenStatusIntoDB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXDBAgent db_agent/*SqlConnection myConn*/
                                                                                                                            )
        {
            string sqlstr = "";
			bool ret = true;

            for (int i = 0; i < pbx.sip_exten.Count; i++)
            {
                SIPPBXExten exten = pbx.sip_exten[i];
                string sChanID = "-1";
                SIPPBXChan pbxChan = pbx.getChanByExten(exten);
                if (pbxChan != null)
                {
                    sChanID = pbxChan.index.ToString();
                }

                sqlstr = "UPDATE status_exten SET ";
                sqlstr += "IdleStartTime = '" + SIPPBXWinUtil.GetSQLDateTime(exten.IdleStartTime) + "', ";

                if (exten.Agent != null)
                {
                    sqlstr += "Agent = '" + exten.Agent.Code + "', ";
                }
                else
                {
                    sqlstr += "Agent = '', ";
                }

                if (exten.IsRegistered())
                {
                    switch (pbx.sip_exten[i].InCalling)
                    {
                        case 0:
                            sqlstr += "Status = 'Up(Idle)', ";
                            sqlstr += "ChanIndex = -1, ";
                            break;
                        case 10:
                            sqlstr += "Status = 'Up(Offered)', ";
                            sqlstr += "ChanIndex = " + sChanID + ", ";
                            break;
                        case 20:
                            sqlstr += "Status = 'Up(Dialing)', ";
                            sqlstr += "ChanIndex = " + sChanID + ", ";
                            break;
                        case 21:
                            sqlstr += "Status = 'Up(Ringing)', ";
                            sqlstr += "ChanIndex = " + sChanID + ", ";
                            break;
                        case 30:
                        default:
                            sqlstr += "Status = 'Up(In call)', ";
                            sqlstr += "ChanIndex = " + sChanID + ", ";
                            break;
                    }

                    if(exten.MappedContactAddr.Length > 0)
                        sqlstr += "Contact = '" + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, exten.MappedContactAddr) + "', ";
                    else
                        sqlstr += "Contact = '" + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, exten.ContactAddr) + "', ";
                    sqlstr += "RegTime = '" + SIPPBXWinUtil.GetSQLDateTime(exten.RegisterTime) + "', ";
                    sqlstr += "RegExpireSec= " + exten.RegisterExpire.ToString() + ", ";
                    sqlstr += "UAName = '" + exten.UAName + "', ";
                    sqlstr += "NATType = " + exten.NATType.ToString() + " "; //UANatType: Network Protocol Type. 0  = UDP, 1 = TCP, 2 = TLS
                }
                else
                {
                    sqlstr += "ChanIndex = -1, ";
                    sqlstr += "Status = 'Offline', ";
                    sqlstr += "Contact = '', ";
                    sqlstr += "RegTime = NULL, ";
                    sqlstr += "RegExpireSec = 0, ";
                    sqlstr += "UAName = '', ";
                    sqlstr += "NATType = 0 "; //UANatType: Network Protocol Type. 0  = UDP, 1 = TCP, 2 = TLS
                }

                sqlstr += "WHERE ExtenID = '" + exten.UserName + "'";

                db_agent.AddSQL(sqlstr);

                /*
                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch (Exception ex)
                {
                    env.LogoutText(ex.Message);
                    env.LOG_Trace(1, ex.Message);
					ret = false;
                }*/

                //update the cfg_extensions table also
                //need code here
                //this code will run every 2 seconds, which may be not efficient
                //should move to On_ProxyUserRegistered event.


            }

			return ret;
        }

        public static void InitExtenStatusTable(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set)
        {
            string sqlstr = "";

            db_set.ExcuteNonQuerySQL("DELETE FROM status_exten", env);

            for (int i = 0; i < pbx.sip_exten.Count; i++)
            {
                SIPPBXExten exten = pbx.sip_exten[i];

                string sChanID = "-1";
                SIPPBXChan pbxChan = pbx.getChanByExten(exten);
                if (pbxChan != null)
                {
                    sChanID = pbxChan.index.ToString();
                }

                sqlstr = "INSERT INTO status_exten(ExtenID, Name, IdleStartTime, ChanIndex, Agent, Status, Contact, RegTime, RegExpireSec, UAName, NATType) VALUES(";
                sqlstr += "'" + exten.UserName + "', ";
                sqlstr += "'" + exten.RealName + "', ";
                sqlstr += "'" + SIPPBXWinUtil.GetSQLDateTime(exten.IdleStartTime) + "', ";
                sqlstr += sChanID + ", ";

                if (exten.Agent != null)
                {
                    sqlstr += "'" + exten.Agent.Code + "', ";
                }
                else
                {
                    sqlstr += "'', ";
                }

                if (exten.IsRegistered())
                {
                    switch (pbx.sip_exten[i].InCalling)
                    {
                        case 0:
                            sqlstr += "'Up(Idle)', ";
                            break;
                        case 10:
                            sqlstr += "'Up(Offered)', ";
                            break;
                        case 20:
                            sqlstr += "'Up(Dialing)', ";
                            break;
                        case 21:
                            sqlstr += "'Up(Ringing)', ";
                            break;
                        case 30:
                        default:
                            sqlstr += "'Up(In call)', ";
                            break;
                    }

                    if(exten.MappedContactAddr.Length > 0)
                        sqlstr += "'" + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, exten.MappedContactAddr) + "', ";
                    else
                        sqlstr += "'" + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, exten.ContactAddr) + "', ";

                    sqlstr += "'" + SIPPBXWinUtil.GetSQLDateTime(exten.RegisterTime) + "', ";
                    sqlstr += exten.RegisterExpire.ToString() + ", ";
                    sqlstr += "'" + exten.UAName + "', ";
                    sqlstr += exten.NATType.ToString()+ ")";
                }
                else
                {
                    sqlstr += "'Offline', ";
                    sqlstr += "'', ";
                    sqlstr += "NULL, ";
                    sqlstr += "0, ";
                    sqlstr += "'', ";
                    sqlstr += "0)";
                }

                db_set.ExcuteNonQuerySQL(sqlstr, env);
            }
        }

        public static void InitChanStatusTable(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set)
        {
            string sqlstr = "";

            db_set.ExcuteNonQuerySQL("DELETE FROM status_channel", env);

            for (int i = 0; i < env.GetChannelCount(); i++)
            {
                //int idx = i + 1;
                sqlstr = "INSERT INTO status_channel(ChanID, CallStatus, Caller, Callee, CallStartTime, LinkedExten, DTMFBuf, Dialplan, OutboundCallTask, ACD_Name, ACD_In_Time, ACD_Out_Time, ACD_To_Exten, ACD_To_Agent, RecordFile, AutoDialerId, AutoDialerJobId) VALUES(";
                sqlstr += i.ToString() + ", ";
                bool is_idle = false;

                GTAPIASM.GTAPIChan api_chan = env.GetChannel(pbx.chan_list[i].index);

                switch (api_chan.ch_status)
                {
                    case GTAPIASM.GTAPI_CHANNEL_STATE.IDLE:
                        sqlstr += "'IDLE', ";
                        is_idle = true;
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.DIALING:
                        sqlstr += "'DIALING', ";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED:
                        sqlstr += "'OFFERED', ";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED:
                        sqlstr += "'CONNECTED', ";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.DISCONNECTING:
                        sqlstr += "'DISCONNECTING', ";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING:
                        sqlstr += "'HOLDING', ";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED:
                        sqlstr += "'BE HOLDED', ";
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.RESERVED:
                        sqlstr += "'RESERVED', ";
                        break;
                }

                if (api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED ||
                    api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.DIALING || 
                    api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED ||
                    api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING ||
                    api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED)
                {
                    sqlstr += "'" + SIPPBXWinUtil.RemoveOddCharForSQLStr(GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num)) + "', ";
                    sqlstr += "'" + SIPPBXWinUtil.RemoveOddCharForSQLStr(GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num)) + "', ";
                    sqlstr += "'" + SIPPBXWinUtil.GetSQLDateTime(api_chan.call_start_time) + "', ";
                }
                else
                {
                    sqlstr += "'', ";
                    sqlstr += "'', ";
                    sqlstr += "NULL, ";
                }

                string sExtenID = (pbx.chan_list[i].link_exten != null) ? pbx.chan_list[i].link_exten.UserName : "";
                sqlstr += "'" + sExtenID + "', ";

                if(is_idle)
                    sqlstr += "'', ";
                else
                    sqlstr += "'" + pbx.chan_list[i].DTMFBuf + "', ";

                if (pbx.chan_list[i].dp != null && !is_idle)
                {
                    sqlstr += "'" + pbx.chan_list[i].dp.planName + "', ";
                }
                else
                {
                    sqlstr += "'', ";
                }

                if (pbx.chan_list[i].call_job != null && !is_idle)
                {
                    if(pbx.chan_list[i].call_job.Task != null)
                        sqlstr += "'" + pbx.chan_list[i].call_job.Task.task_name + "', ";
                    else
                        sqlstr += "'', ";
                }
                else
                {
                    sqlstr += "'', ";
                }

                if (pbx.chan_list[i].acd_queue != null && !is_idle)
                {
                    sqlstr += "'" + pbx.chan_list[i].acd_queue.hgName + "', ";
                    sqlstr += "'" + SIPPBXWinUtil.GetSQLDateTime(pbx.chan_list[i].in_queue_time) + "', ";
                    sqlstr += "'" + SIPPBXWinUtil.GetSQLDateTime(pbx.chan_list[i].out_queue_time) + "', ";
                    if (pbx.chan_list[i].acd_to_extn != null)
                    {
                        sqlstr += "'" + pbx.chan_list[i].acd_to_extn.UserName + "', ";
                        if (pbx.chan_list[i].acd_to_extn.Agent != null)
                        {
                            sqlstr += "'" + pbx.chan_list[i].acd_to_extn.Agent.Code + "', ";
                            if (pbx.chan_list[i].acd_to_extn.Agent.RecordCall)
                                sqlstr += "'" + pbx.chan_list[i].RecordFileName + "')";
                            else
                                sqlstr += "'')";
                        }
                        else
                        {
                            sqlstr += "'', ";
                            if (pbx.chan_list[i].acd_to_extn.RecordCall)
                                sqlstr += "'" + pbx.chan_list[i].RecordFileName + "')";
                            else
                                sqlstr += "'')";
                        }
                    }
                    else
                    {
                        sqlstr += "'', ";
                        sqlstr += "'', ";
                        sqlstr += "'', 0, '')";
                    }
                }
                else
                {
                    sqlstr += "'', ";
                    sqlstr += "NULL, ";
                    sqlstr += "NULL, ";
                    sqlstr += "'', ";
                    sqlstr += "'', ";
                    sqlstr += "'', 0, '')";
                }

                db_set.ExcuteNonQuerySQL(sqlstr, env);
            }

        }

        public static bool SaveChanStatusIntoDB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXDBAgent db_agent/*SqlConnection myConn*/
                                                                                                                           )
        {
            string sqlstr = "";
			bool ret = true;

            for (int i = 0; i < env.GetChannelCount(); i++)
            {
                //int idx = i + 1;
                bool is_idle = false;

                sqlstr = "UPDATE status_channel SET CallStatus = ";
                GTAPIASM.GTAPIChan api_chan = env.GetChannel(pbx.chan_list[i].index);
                SIPPBXChan chan = pbx.chan_list[i];

                switch (api_chan.ch_status)
                {
                    case GTAPIASM.GTAPI_CHANNEL_STATE.IDLE:
                        sqlstr += "'IDLE', ";
                        is_idle = true;
                        chan.reserved_cnt = 0;
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.DIALING:
                        sqlstr += "'DIALING', ";
                        chan.reserved_cnt = 0;
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED:
                        sqlstr += "'OFFERED', ";
                        chan.reserved_cnt = 0;
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED:
                        sqlstr += "'CONNECTED', ";
                        chan.reserved_cnt = 0;
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.DISCONNECTING:
                        sqlstr += "'DISCONNECTING', ";
                        chan.reserved_cnt = 0;
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING:
                        sqlstr += "'HOLDING', ";
                        chan.reserved_cnt = 0;
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED:
                        sqlstr += "'BE HOLDED', ";
                        chan.reserved_cnt = 0;
                        break;
                    case GTAPIASM.GTAPI_CHANNEL_STATE.RESERVED:
                        sqlstr += "'RESERVED', ";
                        if (++chan.reserved_cnt > 30)
                        {
                            //reserved more that one minute
                            //Weird! Logging out and Free
                            api_chan.Free();
                            env.LOG_Trace(1, "ERROR: Chan " + i.ToString() + " has been reserved more than minute. Freeing...");
                        }
                        break;
                }

                if (api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED ||
                    api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.DIALING ||
                    api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.OFFERED ||
                    api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING ||
                    api_chan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED)
                {
                    sqlstr += "Caller = ";
                    sqlstr += "'" + SIPPBXWinUtil.RemoveOddCharForSQLStr(GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num)) + "', ";
                    sqlstr += "Callee = ";
                    sqlstr += "'" + SIPPBXWinUtil.RemoveOddCharForSQLStr(GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num)) + "', ";
                    sqlstr += "CallStartTime = ";
                    sqlstr += "'" + SIPPBXWinUtil.GetSQLDateTime(api_chan.call_start_time) + "', ";
                }
                else
                {
                    sqlstr += "Caller = '', ";
                    sqlstr += "Callee = '', ";
                    sqlstr += "CallStartTime = NULL, ";
                }

                string sExtenID = (pbx.chan_list[i].link_exten != null) ? pbx.chan_list[i].link_exten.UserName : "";
                sqlstr += "LinkedExten = '" + sExtenID + "', ";

                if (is_idle)
                    sqlstr += "DTMFBuf = '" + pbx.chan_list[i].DTMFBuf + "', ";
                else
                    sqlstr += "DTMFBuf = '', ";

                if (pbx.chan_list[i].dp != null && !is_idle)
                {
                    sqlstr += "Dialplan = '" + pbx.chan_list[i].dp.planName + "', ";
                }
                else
                {
                    sqlstr += "Dialplan = '', ";
                }

                if (pbx.chan_list[i].call_job != null && !is_idle)
                {
                    if (pbx.chan_list[i].call_job.Task != null)
                        sqlstr += "OutboundCallTask = '" + pbx.chan_list[i].call_job.Task.task_name + "', ";
                    else
                        sqlstr += "OutboundCallTask = '', ";
                }
                else
                {
                    sqlstr += "OutboundCallTask = '', ";
                }

                if (pbx.chan_list[i].acd_queue != null && !is_idle)
                {
                    sqlstr += "ACD_Name = '" + pbx.chan_list[i].acd_queue.hgName + "', ";
                    sqlstr += "ACD_In_Time = '" + SIPPBXWinUtil.GetSQLDateTime(pbx.chan_list[i].in_queue_time) + "', ";

                    if (pbx.chan_list[i].out_queue_time != pbx.chan_list[i].in_queue_time)
                        sqlstr += "ACD_Out_Time = '" + SIPPBXWinUtil.GetSQLDateTime(pbx.chan_list[i].out_queue_time) + "', ";
                    else
                        sqlstr += "ACD_Out_Time = NULL, ";

                    if (pbx.chan_list[i].acd_to_extn != null)
                    {
                        sqlstr += "ACD_To_Exten = '" + pbx.chan_list[i].acd_to_extn.UserName + "', ";
                        if (pbx.chan_list[i].acd_to_extn.Agent != null)
                        {
                            sqlstr += "ACD_To_Agent = '" + pbx.chan_list[i].acd_to_extn.Agent.Code + "', ";
                            if (pbx.chan_list[i].acd_to_extn.Agent.RecordCall)
                                sqlstr += "RecordFile = '" + pbx.chan_list[i].RecordFileName + "', ";
                            else
                                sqlstr += "RecordFile = '', ";
                        }
                        else
                        {
                            sqlstr += "ACD_To_Agent = '', ";
                            if (pbx.chan_list[i].acd_to_extn.RecordCall)
                                sqlstr += "RecordFile = '" + pbx.chan_list[i].RecordFileName + "', ";
                            else
                                sqlstr += "RecordFile = '', ";
                        }
                    }
                    else
                    {
                        sqlstr += "ACD_To_Exten = '', ";
                        sqlstr += "ACD_To_Agent = '', ";
                        sqlstr += "RecordFile = '" + pbx.chan_list[i].RecordFileName + "', ";
                    }
                }
                else
                {
                    sqlstr += "ACD_Name = '', ";
                    sqlstr += "ACD_In_Time = NULL, ";
                    sqlstr += "ACD_Out_Time = NULL, ";
                    sqlstr += "ACD_To_Exten = '', ";
                    sqlstr += "ACD_To_Agent = '', ";
                    sqlstr += "RecordFile = '" + pbx.chan_list[i].RecordFileName + "', ";
                }

                sqlstr += "CallID = '" + pbx.chan_list[i].unique_call_id + "', ";

                if (pbx.chan_list[i].call_job != null)
                {
                    sqlstr += "AutoDialerId = " + pbx.chan_list[i].call_job.ID + ", ";
                    sqlstr += "AutoDialerJobId = '" + pbx.chan_list[i].call_job.JobID + "' ";
                }
                else
                {
                    sqlstr += "AutoDialerId = 0, ";
                    sqlstr += "AutoDialerJobId = '' ";
                }

                sqlstr += "WHERE ChanID = " + i.ToString();

                db_agent.AddSQL(sqlstr);

                /*
                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch (Exception ex)
                {
                    env.LogoutText(ex.Message);
                    env.LOG_Trace(1, ex.Message);
					ret = false;
                }*/
            }

			return ret;
        }


        public static void InitACDStatusTable(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set)
        {
            string sqlstr = "";
            string s = "";

            db_set.ExcuteNonQuerySQL("DELETE FROM status_acd", env);

            for (int i = 0; i < pbx.sip_huntgroups.Count; i++)
            {
                sqlstr = "INSERT INTO status_acd(ACD_Name, ACD_Type, Agents, Calls, WaitTime) VALUES(";
                sqlstr += "'" + pbx.sip_huntgroups[i].hgName + "', ";
                switch (pbx.sip_huntgroups[i].hgType)
                {
                    case 0:
                        sqlstr += "'Linear', ";
                        break;
                    case 1:
                        sqlstr += "'Circle', ";
                        break;
                    case 2:
                        sqlstr += "'Most Idle', ";
                        break;
                    case 3:
                        sqlstr += "'Most Skill', ";
                        break;
                    default:
                        sqlstr += "'', ";
                        break;
                }

                s = "";
                for (int j = 0; j < pbx.sip_huntgroups[i].agents.Count; j++)
                {
                    s += pbx.sip_huntgroups[i].agents[j] + ";";
                }
                sqlstr += "'" + s + "', ";

                s = pbx.sip_huntgroups[i].calls.Count.ToString();
                sqlstr += "'" + s + "', ";

                s = "";
                sqlstr += "'" + s + "')";

                db_set.ExcuteNonQuerySQL(sqlstr, env);
                
            }

        }

        public static bool SaveACDStatusIntoDB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXDBAgent db_agent/*SqlConnection myConn*/
                                                                                                                          )
        {
            string sqlstr = "";
            string s = "";
			bool ret = true;

            for (int i = 0; i < pbx.sip_huntgroups.Count; i++)
            {
                sqlstr =  "UPDATE status_acd SET Calls = '";
                SIPPBXACDHuntGroup hg = pbx.sip_huntgroups[i];

                s = hg.calls.Count.ToString();
                if (hg.calls.Count > 0)
                {
                    s += "(";
                    for (int j = 0; j < hg.calls.Count; j++)
                    {
                        GTOpAsync op = hg.calls[j].op;
                        if (op != null)
                        {
                            if (op.getPBXChan() != null)
                                s += op.getPBXChan().index.ToString();
                        }
                        if (j != hg.calls.Count - 1)
                        {
                            s += ",";
                        }
                    }
                    s += ")";
                }
                sqlstr += s + "', WaitTime = '";

                s = "";
                if (hg.calls.Count > 0)
                {
                    for (int j = 0; j < hg.calls.Count; j++)
                    {
                        GTOpAsync op = hg.calls[j].op;
                        if (op != null)
                        {
                            if (op.getPBXChan() != null)
                            {
                                if (op.getPBXChan().acd_queue != null)
                                {
                                    TimeSpan sp = DateTime.Now - op.getPBXChan().in_queue_time;
                                    s += FormatTimeSpan(sp, false);
                                }
                            }
                        }
                        if (j != hg.calls.Count - 1)
                        {
                            s += ",";
                        }
                    }
                }

                sqlstr += s + "', Agents='";

                if (hg.agentType == 2) //dynamic login
                {
                    for (int j = 0; j < pbx.sip_agents.Count; j++)
                    {
                        if (pbx.sip_agents[j].LoggedInACD.Contains(hg.hgName))
                        {
                            if(pbx.sip_agents[j].AtExten != null)
                                sqlstr += pbx.sip_agents[j].Code + "(" + pbx.sip_agents[j].AtExten.UserName + ");";
                            else
                                sqlstr += pbx.sip_agents[j].Code + ";";
                        }
                    }

                }
                else if(hg.agentType == 1)
                {
                    for (int j = 0; j < hg.agents.Count; j++)
                    {
                        SIPPBXAgent agent = pbx.getAgentByCode(hg.agents[j]);
                        if (agent != null)
                        {
                            if (agent.AtExten != null)
                            {
                                sqlstr += agent.Code + "(" + agent.AtExten.UserName + ");";
                            }
                            else
                            {
                                sqlstr += agent.Code + ";";
                            }
                        }
                    }
                }
                else if (hg.agentType == 0) //extension
                {
                    for (int j = 0; j < hg.agents.Count; j++)
                    {
                        SIPPBXExten extn = pbx.getExtensionByName(hg.agents[j]);
                        if (extn != null)
                        {
                            if(extn.IsRegistered())
                                sqlstr += extn.UserName + "(on);";
                            else
                                sqlstr += extn.UserName + ";";
                        }
                    }
                }

                sqlstr.TrimEnd(';');

                sqlstr += "' WHERE ACD_Name = '" + pbx.sip_huntgroups[i].hgName + "'";

                db_agent.AddSQL(sqlstr);

                /*
                try
                {
                    SqlCommand catCMD = myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                }
                catch(Exception ex)
                {
                    env.LogoutText(ex.Message);
                    env.LOG_Trace(1, ex.Message);
					ret = false;
                } */              
            }

			return ret;
        }

        public static List<SIPPBXExtenVoiceMail> GetExtensionVoiceMailFromDB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXExten extn, DBServerSetting db_set, SIPPBXLog log)
        {
            List<SIPPBXExtenVoiceMail> vmlist = new List<SIPPBXExtenVoiceMail>();

            string sqlstr = "SELECT Extension,ToEmail,Caller,Callee,VMTime,VMDuration,VMFile,VMStatus FROM voice_mailbox WHERE Extension ='" + extn.UserName + "' ORDER BY VMTime DESC";

            try
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    SqlCommand catCMD = db_set.myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    SqlDataReader myReader = catCMD.ExecuteReader();

                    try
                    {
                        while (myReader.Read())
                        {
                            SIPPBXExtenVoiceMail vm = new SIPPBXExtenVoiceMail();

                            vm.UserName = myReader.GetString(0);
                            vm.ToEmail = myReader.GetString(1);
                            vm.Caller = myReader.GetString(2);
                            vm.Callee = myReader.GetString(3);
                            vm.tBegin = myReader.GetDateTime(4);
                            vm.nDurSec = myReader.GetInt32(5);
                            vm.VMFile = myReader.GetString(6);
                            vm.VMStatus = myReader.GetInt32(7);
                            vmlist.Add(vm);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }
                else if (db_set.dbType == -1) //SQLite
                {
                    SQLiteCommand catCMD = db_set.sqliteConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = sqlstr;
                    SQLiteDataReader myReader = catCMD.ExecuteReader();

                    try
                    {
                        while (myReader.Read())
                        {
                            SIPPBXExtenVoiceMail vm = new SIPPBXExtenVoiceMail();

                            vm.UserName = myReader.GetString(0);
                            vm.ToEmail = myReader.GetString(1);
                            vm.Caller = myReader.GetString(2);
                            vm.Callee = myReader.GetString(3);
                            vm.tBegin = myReader.GetDateTime(4);
                            vm.nDurSec = myReader.GetInt32(5);
                            vm.VMFile = myReader.GetString(6);
                            vm.VMStatus = myReader.GetInt32(7);
                            vmlist.Add(vm);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return vmlist;

        }

        public static void UpdateExtenVoiceMailFromDB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXExten extn, DBServerSetting db_set, SIPPBXLog log)
        {
            List<SIPPBXExtenVoiceMail> vmlist = GetExtensionVoiceMailFromDB(pbx, env, extn, db_set, log);

            int nTotal = 0;
            int nNew = 0;
            int nOld = 0;

            for (int i = 0; i < vmlist.Count; i++)
            {
                nTotal++;
                if (vmlist[i].VMStatus == 1)
                    nNew++;
                else
                    nOld++;
            }


            string saddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, extn.RegToID);
            string sipVMB = "sip:" + pbx.vmb_code + "@" + saddr + "";
            if(extn.IsRegistered())
			{
				if(nNew > 0)
					env.ProxySetUserMsg(0, extn.UserName, true, sipVMB, nNew, nOld, 0, 0);
				else
					env.ProxySetUserMsg(0, extn.UserName, false, sipVMB, nNew, nOld, 0, 0);
			}
            extn.MsgNewCount = nNew;
            extn.MsgOldCount = nOld;
            extn.MsgAccount = sipVMB;
        }

        public static bool DeleteVoiceMailFromDB(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXExtenVoiceMail vm, SIPPBXLog log)
        {
            string sqlstr = "";
            bool ret = true;

            sqlstr = "DELETE FROM voice_mailbox WHERE VMFile = '" + vm.VMFile + "'";

            db_set.ExcuteNonQuerySQL(sqlstr, env);

            return ret;

        }

        public static bool UpdateVoiceMailIntoDB(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXExtenVoiceMail vm, SIPPBXLog log)
        {
            string sqlstr = "";
            bool ret = true;

            sqlstr = "UPDATE voice_mailbox SET VMStatus = " + vm.VMStatus.ToString() +" WHERE VMFile = '" + vm.VMFile + "'";

            db_set.ExcuteNonQuerySQL(sqlstr, env);

            return ret;
        }

        public static bool SaveVoiceMailIntoDB(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXExtenVoiceMail vm, SIPPBXLog log)
        {
            string sqlstr = "";
			bool ret = true;

            sqlstr = "INSERT INTO voice_mailbox(Extension, ToEmail, Caller, Callee, VMTime, VMDuration, VMFile, VMStatus, CallID) VALUES('";

            sqlstr += vm.UserName + "', '" + vm.ToEmail + "', '" + vm.Caller + "', '" + vm.Callee + "', '";
            sqlstr += SIPPBXWinUtil.GetSQLDateTime(vm.tBegin) + "', " + vm.nDurSec.ToString() + ", '";
            sqlstr += vm.VMFile + "', " + vm.VMStatus.ToString() + ", '" + vm.CallID + "')";

            db_set.ExcuteNonQuerySQL(sqlstr, env);

			return ret;

        }


        public static bool SaveAllStatusIntoDB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXDBAgent db_agent/*SqlConnection myConn*/
                                                                                                                          )
        {
            if (!SIPPBXDBUtil.SaveACDStatusIntoDB(pbx, env, db_agent)) return false;
            if (!SIPPBXDBUtil.SaveChanStatusIntoDB(pbx, env, db_agent)) return false;
            if (!SIPPBXDBUtil.SaveExtenStatusIntoDB(pbx, env, db_agent)) return false;
            if (!SIPPBXDBUtil.SaveSIPAccountStatusIntoDB(pbx, env, db_agent)) return false;
            if (!SIPPBXDBUtil.SaveAgentStatusIntoDB(pbx, env, db_agent)) return false;
            if (!SIPPBXDBUtil.SaveParkingSlotStatusIntoDB(pbx, env, db_agent)) return false;
            if (!SIPPBXDBUtil.SaveConferenceRoomStatusIntoDB(pbx, env, db_agent)) return false;

            return true;
        }

        public static void InitAllStatusTables(SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set)
        {
            SIPPBXDBUtil.InitACDStatusTable(pbx, env, db_set);
            SIPPBXDBUtil.InitChanStatusTable(pbx, env, db_set);
            SIPPBXDBUtil.InitExtenStatusTable(pbx, env, db_set);
            SIPPBXDBUtil.InitSIPAccountStatusTable(pbx, env, db_set);
            SIPPBXDBUtil.InitAgentStatusTable(pbx, env, db_set);
            SIPPBXDBUtil.InitParkingSlotStatusTable(pbx, env, db_set);
            SIPPBXDBUtil.InitConferenceRoomStatusTable(pbx, env, db_set);
            SIPPBXDBUtil.InitPluginStatusTable(pbx, env, db_set);
        }

        public static void ClearDBlog(int days, DBServerSetting db_set, SIPPBXLog log)
        {
            DateTime t = DateTime.Now.AddDays(-days);

            try
            {
                db_set.ExcuteNonQuerySQL("DELETE FROM log_sys WHERE LogTime < '" + SIPPBXWinUtil.GetSQLDateTime(t) + "'", null);
            }
            catch (Exception e)
            {
                if (log != null)
                {
                    if (log != null)
                        log.DoLog(e.ToString());
                }
            }

        }

        public static void SaveDBLog(string LogInfo, DBServerSetting db_set, SIPPBXLog log)
        {
            string sqlstr = "";

            sqlstr = "INSERT INTO log_sys VALUES('";
            sqlstr += SIPPBXWinUtil.GetSQLDateTime(DateTime.Now) + "', @msg)";

            try
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    SqlCommand catCMD = new SqlCommand(sqlstr, db_set.myConn);
                    catCMD.CommandTimeout = 3;
                    // bind the value to the parameter reference        
                    catCMD.Parameters.AddWithValue("@msg", LogInfo);

                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                    else
                    {
                        if (log != null)
                            log.DoLog("Save MS SQL Srv DB Log Failed for message[" + LogInfo + "]");
                    }
                }
                else if (db_set.dbType == -1) //SQLite
                {
                    SQLiteCommand catCMD = new SQLiteCommand(sqlstr, db_set.sqliteConn);
                    catCMD.CommandTimeout = 3;
                    // bind the value to the parameter reference        
                    catCMD.Parameters.AddWithValue("@msg", LogInfo);

                    if (catCMD.ExecuteNonQuery() == 1)
                    {
                    }
                    else
                    {
                        if (log != null)
                            log.DoLog("Save SQLite DB Log Failed for message[" + LogInfo + "]");                        
                    }
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.DoLog(e.ToString());
            }
        }

        public static Int64 LoadDBLog(List<string> logStrList, Int64 LogID, DateTime TimeSince, DBServerSetting db_set, SIPPBXLog log)
        {
            Int64 ret = -1;

            try
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    SqlCommand catCMD = db_set.myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "SELECT * FROM log_sys";
                    catCMD.CommandText += " WHERE LogTime >= '" + SIPPBXWinUtil.GetSQLDateTime(TimeSince) + "'";
                    if (LogID >= 0)
                        catCMD.CommandText += " AND ID > " + LogID.ToString();

                    SqlDataReader myReader = catCMD.ExecuteReader();

                    try
                    {
                        while (myReader.Read())
                        {
                            logStrList.Add("[" + SIPPBXWinUtil.GetSQLiteDateTime(myReader.GetDateTime(1)) + "] " + myReader.GetString(2));
                            ret = myReader.GetInt64(0);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.DoLog(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }
                else if (db_set.dbType == -1) //SQLite
                {
                    SQLiteCommand catCMD = db_set.sqliteConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "SELECT ROWID, LogTime, LogInfo FROM log_sys";
                    catCMD.CommandText += " WHERE LogTime >= '" + SIPPBXWinUtil.GetSQLDateTime(TimeSince) + "'";
                    if (LogID >= 0)
                        catCMD.CommandText += " AND ROWID > " + LogID.ToString();

                    SQLiteDataReader myReader = catCMD.ExecuteReader();

                    try
                    {
                        while (myReader.Read())
                        {
                            logStrList.Add("[" + SIPPBXWinUtil.GetSQLiteDateTime(myReader.GetDateTime(1)) + "] " + myReader.GetString(2));
                            ret = myReader.GetInt64(0);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.DoLog(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.DoLog(e.ToString());
            }

            return ret;
        }

        public static Int64 GetAutoDialerJobsStartID(DBServerSetting db_set)
        {
            Int64 ret = 0;

            try
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    SqlCommand catCMD = db_set.myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "SELECT MAX(ID) FROM auto_dialer_jobs";
                    SqlDataReader myReader = catCMD.ExecuteReader();
                    try
                    {
                        if (myReader.Read())
                        {
                            ret = myReader.GetInt64(0);
                        }
                    }
                    catch (Exception)
                    {
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }
                else if (db_set.dbType == -1) //SQLite
                {
                    SQLiteCommand catCMD = db_set.sqliteConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "SELECT MAX(ID) FROM auto_dialer_jobs";
                    SQLiteDataReader myReader = catCMD.ExecuteReader();
                    try
                    {
                        if (myReader.Read())
                        {
                            ret = myReader.GetInt64(0);
                        }
                    }
                    catch (Exception)
                    {
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }
            }
            catch (Exception)
            {
            }
            finally
            {
            }

            try
            {
                if (db_set.dbType >= 0) //MS SQL Server
                {
                    SqlCommand catCMD = db_set.myConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "SELECT MAX(ID) FROM auto_dialer_done";
                    SqlDataReader myReader = catCMD.ExecuteReader();
                    try
                    {
                        if (myReader.Read())
                        {
                            if (ret < myReader.GetInt64(0))
                                ret = myReader.GetInt64(0);
                        }
                    }
                    catch (Exception)
                    {
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }
                else if (db_set.dbType == -1)
                {
                    SQLiteCommand catCMD = db_set.sqliteConn.CreateCommand();
                    catCMD.CommandTimeout = 3;
                    catCMD.CommandText = "SELECT MAX(ID) FROM auto_dialer_done";
                    SQLiteDataReader myReader = catCMD.ExecuteReader();
                    try
                    {
                        if (myReader.Read())
                        {
                            if (ret < myReader.GetInt64(0))
                                ret = myReader.GetInt64(0);
                        }
                    }
                    catch (Exception)
                    {
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }
            }
            catch (Exception)
            {
            }
            finally
            {
            }

            return ret + 1;
        }

        public static int AddAutoDialerJob(DBServerSetting db_set, string sCaller, string sCallee, Int16 nTypeCode, DateTime dt, int ct, string jobId)
        {
            Int64 idStart = SIPPBXDBUtil.GetAutoDialerJobsStartID(db_set);
            string sDateNeed = SIPPBXWinUtil.GetSQLDateTime(dt);

            if (ct == 0 || nTypeCode == 0 || sCallee.Length == 0)
            {
                return -1;
            }

            for (int i = 0; i < ct; i++)
            {
                try
                {
                    string sqlstr = "INSERT INTO auto_dialer_jobs VALUES(" + idStart.ToString() + ", " + nTypeCode.ToString() + ", '";
                    sqlstr += sCaller + "', '" + sCallee + "', '";
                    if(jobId.Length > 0)
                        sqlstr += sDateNeed + "', '" + jobId + "')";
                    else
                        sqlstr += sDateNeed + "', '" + SIPPBXWinUtil.RandomString(12, false) + "')";

                    if (db_set.ExcuteNonQuerySQL(sqlstr, null) == 1)
                    {
                    }
                    else
                    {
                        break;
                    }
                }
                catch (Exception)
                {
                }

                idStart++;
            }

            return 0;

        }
    }




}
