using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using System.Data.SqlClient;
using Microsoft.Win32;
using System.Reflection;
using System.Net;
using System.Net.Sockets;
//using CassiniDev;
using System.Security;
using NAudio;
using NAudio.Wave;
using WaveLib;
using System.Data;
using System.Data.Common;
using System.Data.SqlTypes;
using System.Data.SQLite;

namespace SIPPBXv3
{
    public class PBXOptCmd
    {
        public Int64 ID;
        public string CmdName;
        public string CmdArgs;

        public PBXOptCmd()
        {
            ID = 0;
            CmdName = "";
            CmdArgs = "";
        }

    }

    public class PBXCDROption
    {
        //0 = disabled, 1 = write to text only, 2 = write to db only, 3 = write to both
        public int pbx_cdr;
        public int acd_cdr;
        public int exten_cdr;
        public int agent_cdr;

        public PBXCDROption()
        {
            pbx_cdr = 0;
            acd_cdr = 0;
            exten_cdr = 0;
            agent_cdr = 0;
        }

        public bool pbx_cdr_to_txt()
        {
            return (pbx_cdr & 0x01) == 0x01;
        }

        public bool pbx_cdr_to_db()
        {
            return (pbx_cdr & 0x02) == 0x02;
        }

        public bool acd_cdr_to_txt()
        {
            return (acd_cdr & 0x01) == 0x01;
        }

        public bool acd_cdr_to_db()
        {
            return (acd_cdr & 0x02) == 0x02;
        }

        public bool exten_cdr_to_txt()
        {
            return (exten_cdr & 0x01) == 0x01;
        }

        public bool exten_cdr_to_db()
        {
            return (exten_cdr & 0x02) == 0x02;
        }

        public bool agent_cdr_to_txt()
        {
            return (agent_cdr & 0x01) == 0x01;
        }

        public bool agent_cdr_to_db()
        {
            return (agent_cdr & 0x02) == 0x02;
        }
    }

    public class PBXMemberList
    {
        public int mb_type; //0 = extension name, 1 = agent code
        public List<string> members;

        public PBXMemberList()
        {
            mb_type = 0;
            members = new List<string>();
        }
    }

    public class SIPAccount
    {
        public int AccID;
        public string DisplayName;
        public string UserName;
        public string DomainServer;
        public string ProxyServer;
        public string AuthName;
        public string Password;
        public int ExpireSec;
        public bool RegWithProxyServer;

        public bool Registered;
        public bool OutboundAcceptOtherID;
        public bool OutboundAppendExtenID;

        public bool UseLocalIPInFrom;
        public string MappedExten;

        public List<string> DIDList;

        public bool Disabled;

        public IntPtr accHandle;

        public int SIPProtocol;

        public int SIPTrunk;

        public int UseSRTP;

        public SIPAccount()
        {
            AccID = 0;
            DisplayName = "";
            UserName = "";
            DomainServer = "";
            ProxyServer = "";
            AuthName = "";
            Password = "";
            ExpireSec = 3600;
            RegWithProxyServer = true;
            Registered = false;
            Disabled = false;
            DIDList = new List<string>();
            accHandle = IntPtr.Zero;
            OutboundAcceptOtherID = false;
            OutboundAppendExtenID = false;
            UseLocalIPInFrom = false;
            MappedExten = "";
            SIPProtocol = 0;
            SIPTrunk = 0;

            UseSRTP = 0;
        }
    }

    public class SIPServerSetting
    {
        public string sipAddr;
        public ushort sipPort;
        public ushort rtpPort;
        public ushort rtpPortSpace;
        public ushort internalPort;
        public string auCodecs;
        public string videoCodecs;
        public string sStunServer;
        public int dtmfMethod;
        public string sPublicIPAddr;
        public ushort managerPort;
        public string sUAName;
        public ushort dynMapRTP;
        public bool doRTPRelay;
        public bool useDNSSRV;
        public bool doExtenProxy;
        public bool bForwardPAssertedIdentity;
        public int sipProtocol;
        public int srtpType;

        public SIPServerSetting()
        {
            sipAddr = "";
            sipPort = 5060;
            rtpPort = 19200;
            rtpPortSpace = 4;
            internalPort = 8922;
            auCodecs = "0,8,3";
            videoCodecs = "";
            sStunServer = ""; // "stun.pcbest.net";
            dtmfMethod = 3;
            sPublicIPAddr = "";
            managerPort = 9232;
            sUAName = "";
            dynMapRTP = 1;
            doRTPRelay = false; //true; found some network not supporting relay well, especiall for PBX running in NAT
            useDNSSRV = false;
            doExtenProxy = false;
            bForwardPAssertedIdentity = false;

            sipProtocol = 1; //default UDP only

            srtpType = 1; //auto
        }

    }

    public class VoiceMailBox
    {
        public string vmbPrompt; //It can be a plugin name, to forward call to self-defined voiceMail plugin.
        public SIPPBXExten vmbExten; //not null if it is exten's voice mail box
        public string vmbEmailAddr; //if it is not null, then send voice file to this email address
        public int maxLengthInSecond;
        public string vmbUniqueFileName;
        public string vmbPassword;

        public VoiceMailBox()
        {
            vmbPrompt = "";
            vmbExten = null;
            vmbEmailAddr = "";
            maxLengthInSecond = 600;
            vmbUniqueFileName = "";
            vmbPassword = "";
        }
    }

    public class SysOptionSet
    {
        public string PreferOutlineCodec;
        public string PreferExtensionCodec;

        public int OutPercent;
        public bool bExtenCanInbound;
        public int MaxProxyUserRegSec;

        public string sRestartTime;
        public bool bRandomPlayMOH;

        public bool bPlayRingbackTone;

        public bool bNoAudioDisconnect;
        public int NoAudioDisconnectDur;

        public int MaxCallDuration; //in minutes

        public bool bStopPlayingForFirstDTMFkey;

        public int useOpenAI;
        //public string apiKey;

        public SysOptionSet()
        {
            PreferOutlineCodec = "";
            PreferExtensionCodec = "";

            OutPercent = 50;
            bExtenCanInbound = true;
            MaxProxyUserRegSec = 3600;

            sRestartTime = "";

            bRandomPlayMOH = false;

            bPlayRingbackTone = false;

            bNoAudioDisconnect = false;

            NoAudioDisconnectDur = 10;

            MaxCallDuration = 0;

            bStopPlayingForFirstDTMFkey = false;

            useOpenAI = 0;

            //apiKey = "";
        }
    }

    public class EmailServerSetting
    {
        public string emailServer;
        public ushort emailPort;
        public string emailAddr;
        public string emailPassword;
        public bool emailSSL;

        public EmailServerSetting()
        {
            emailServer = "";
            emailAddr = "";
            emailPassword = "";
            emailPort = 25;
            emailSSL = false;
        }
    }

    public class CallJob
    {
        public Int64 ID;
        public short JobTypeCode;
        public string Caller;
        public string Callee;
        public string JobID;
        public DateTime InitTime;
        public DateTime BeginTime;
        public DateTime EndTime;
        public string DTMFs;
        public AutoDialerTask Task;
        public int CallResult;
        public int DetectResult;

        public int finalCode;
        public string finalCodeDesc;
        public string CallID;
        public string RecordFile;

        public bool isCallBack;

        public CallJob()
        {
            ID = 0;
            JobTypeCode = 0;
            Caller = "";
            Callee = "";
            JobID = "";
            InitTime = DateTime.Now;
            BeginTime = DateTime.Now;
            EndTime = DateTime.Now;
            DTMFs = "";
            Task = null;
            CallResult = 0;
            DetectResult = -3;

            finalCode = 0;
            finalCodeDesc = "";
            CallID = "";
            RecordFile = "";

            isCallBack = false;
        }
    }

    public class AutoDialerTask
    {
        public string task_name;
        public bool isOn;
        public short type_code;

        public string sip_acc;
        public string dial_plan;
        public Queue m_JobsQueue;
        public Queue m_JobsDone;

        public int m_ringTimeout;
        //public bool m_bWriteSIPCode;

        public int m_maxSimCalls; //0 = no limited
        public int m_curNumCalls;

        public bool m_bEnableDetect;
        public bool m_bDiscAfterDetect;

        public AutoDialerTask()
        {
            isOn = false;
            task_name = "";
            type_code = 0;
            sip_acc = "";
            dial_plan = "";
            m_JobsQueue = new Queue();
            m_JobsDone = new Queue();

            m_ringTimeout = 0;
            //m_bWriteSIPCode = false;

            m_maxSimCalls = 0;
            m_curNumCalls = 0;

            m_bEnableDetect = false;
            m_bDiscAfterDetect = false;
        }

        public bool CanCallOut()
        {
            return (m_maxSimCalls > 0) ? ((m_curNumCalls < m_maxSimCalls)?true:false) : true;
        }

        public bool IncCallNum()
        {
            if (m_maxSimCalls > 0)
            {
                if (m_curNumCalls < m_maxSimCalls)
                {
                    m_curNumCalls++;
                    return true;
                }
                else
                    return false;
            }
            else
            {
                m_curNumCalls++;
                return true;
            }

        }

        public void DecCallNum()
        {
            if (m_curNumCalls > 0)
                m_curNumCalls--;
        }

        public int ProcessJobs(GTSIPPBXEnv env)
        {
            int ret = 0;
            SIPPBXChan pbx_chan = null;
            CallJob call = null;
            string destaddr;
            string fromaddr;

            while (m_JobsQueue.Count > 0 && CanCallOut())
            {
                pbx_chan = env.pbx.SeizeChannelForOutbound(env);

                if (pbx_chan == null) //no available channel
                    break;

                pbx_chan.ResetAll("", 0, env.pbx, null);
                pbx_chan.call_dir = 1;

                call = (CallJob)m_JobsQueue.Dequeue();

                if (call == null)
                {
                    env.pbx.FreeSeizedOutboundChannel(env, pbx_chan.index);
                    break;
                }

                SIPPBXDialPlan dp = env.pbx.getDialPlanByPlanName(call.Task.dial_plan);
                if (dp == null)
                {
                    env.pbx.FreeSeizedOutboundChannel(env, pbx_chan.index);
                    call.CallResult = -1;
                    call.finalCode = -100;
                    call.finalCodeDesc = "Call job failed(-1) as dialplan is not found!";
                    if(!call.isCallBack)
                        m_JobsDone.Enqueue(call);
                    env.LOG_Trace(1, "Call job failed(-1) as dialplan is not found!");
                    env.LogoutText("Call job failed(-1) as dialplan is not found!");
                    continue;
                }

                SIPAccount sip_acct = env.pbx.getSIPAccountByUserName(call.Task.sip_acc);
                SIPPBXExten callee_ext = env.pbx.getExtensionByName(call.Callee);

                //env.LOG_Trace(1, "Call task dialplan " + call.Task.dial_plan + " sip account " + call.Task.sip_acc + " callee " + call.Callee);
                env.LogoutText("Call task dialplan " + call.Task.dial_plan + " sip account " + call.Task.sip_acc + " callee " + call.Callee);

                if (sip_acct == null && callee_ext == null)
                {
                    env.pbx.FreeSeizedOutboundChannel(env, pbx_chan.index);
                    call.CallResult = -1;
                    call.finalCode = -101;
                    call.finalCodeDesc = "Call job failed(-1) as SIP account is not found!";
                    if (!call.isCallBack)
                        m_JobsDone.Enqueue(call);
                    env.LOG_Trace(1, "Call job failed(-1) as SIP account is not found!");
                    env.LogoutText("Call job failed(-1) as SIP account is not found!");
                    continue;
                }

                pbx_chan.call_job = call;

                //2016-07-12, added enable VAD per call job according to the task attribute
                if (call.Task.m_bEnableDetect)
                {
                    env.Send_EnableVAD(pbx_chan.index);
                }

                if (callee_ext != null)
                {
                    //wants to reach an extension, then transfering call to another extension
                    pbx_chan.link_exten = callee_ext;
                    pbx_chan.GenerateRecordFileName(env.pbx, false);

                    if (callee_ext.IsVirtualExten())
                    {
                        //calling to a virtual extension
                        if (callee_ext.VirtualExtenDestAddr.Contains(".") || callee_ext.VirtualExtenDestAddr.Contains("@"))
                        {
                            //sip address
                            if (callee_ext.VirtualExtenDestAddr.Contains("sip:"))
                            {
                                env.pbx.MakeSIPAddrCall(env, pbx_chan.index, callee_ext.VirtualExtenDestAddr, "");
                            }
                            else
                            {
                                env.pbx.MakeSIPAddrCall(env, pbx_chan.index, "<sip:" + callee_ext.VirtualExtenDestAddr + ">", "");
                            }
                        }
                        else
                        {
                            //to see if it matchs any outbound rules
                            SIPPBXDialPlan dp1 = env.pbx.getDialPlanByCalledNum(env, callee_ext.VirtualExtenDestAddr, "", "", "", null, 1);
                            if (dp1 != null)
                            {
                                sip_acct = env.pbx.getDialPlanSIPAccount(dp1);
                                if (sip_acct != null)
                                {
                                    //outbound, should take out predix digit, then use another channel to dialout
                                    destaddr = dp1.OutboundPrepend + callee_ext.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                                    destaddr += "@" + sip_acct.DomainServer;
                                    destaddr = "<sip:" + destaddr + ">";

                                    fromaddr = sip_acct.UserName;
                                    if (fromaddr == "")
                                        fromaddr = "unknown";

                                    if (sip_acct.UseLocalIPInFrom)
                                    {
                                        if (env.pbx.sip_set.sipAddr.Length > 0)
                                            fromaddr += "@" + env.pbx.sip_set.sipAddr;
                                        else
                                            fromaddr += "@" + env.GetMappedPublicSIPIPAddress();
                                    }
                                    else
                                        fromaddr += "@" + sip_acct.DomainServer;
                                    fromaddr = sip_acct.DisplayName + "<sip:" + fromaddr + ">";

                                    env.pbx.MakeOutboundCall(env, pbx_chan.index, destaddr, fromaddr, sip_acct);
                                }
                                else
                                {
                                    env.pbx.FreeSeizedOutboundChannel(env, pbx_chan.index);
                                    call.CallResult = -1;
                                    call.finalCode = -102;
                                    call.finalCodeDesc = "Call job failed(-1) as dialplan SIP account index is not in range!";
                                    if (!call.isCallBack)
                                        m_JobsDone.Enqueue(call);
                                    env.LOG_Trace(1, "Call job failed(-1) as dialplan SIP account index is not in range!");
                                    env.LogoutText("Call job failed(-1) as dialplan SIP account index is not in range!");
                                    continue;
                                }
                            }
                            else
                            {
                                env.pbx.FreeSeizedOutboundChannel(env, pbx_chan.index);
                                call.CallResult = -1;
                                call.finalCode = -103;
                                call.finalCodeDesc = "Call job failed(-1) as dialplan is null!";
                                if (!call.isCallBack)
                                    m_JobsDone.Enqueue(call);
                                env.LOG_Trace(1, "Call job failed(-1) as dialplan is null!");
                                env.LogoutText("Call job failed(-1) as dialplan is null!");
                                continue;
                            }
                        }
                    }
                    else
                    {
                        //regular extension
                        if (callee_ext.IsRegistered() && (callee_ext.InCalling == 0 || callee_ext.bMultipleCalls))
                        {
                            string sCaller = "<sip:" + call.Callee + "@" + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, callee_ext.RegFromID) + ">";
                            env.pbx.MakeExtensionCall(env, pbx_chan.index, callee_ext.RegFromID, sCaller, callee_ext);
                        }
                        else
                        {
                            env.pbx.FreeSeizedOutboundChannel(env, pbx_chan.index);
                            call.CallResult = -1;
                            call.finalCode = -104;
                            call.finalCodeDesc = "Call job failed(-1) as extension is not online or extension is busy on the phone!";
                            if (!call.isCallBack)
                                m_JobsDone.Enqueue(call);
                            env.LOG_Trace(1, "Call job failed(-1) as extension is not online or extension is busy on the phone!");
                            env.LogoutText("Call job failed(-1) as extension is not online or extension is busy on the phone!");
                            continue;
                        }
                    }

                    call.InitTime = DateTime.Now;
                    IncCallNum();
                    ret++;
                    continue;
                }

                destaddr = call.Callee;
                destaddr += "@" + sip_acct.DomainServer;
                destaddr = "<sip:" + destaddr + ">";

                fromaddr = sip_acct.UserName;
                if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                {
                    if (call.Caller.Length == 0)
                    {
                        if (sip_acct.DIDList.Count > 0)
                            fromaddr = sip_acct.DIDList[0];
                    }
                    else
                    {
                        fromaddr = call.Caller;
                    }
                }

                if (fromaddr == "")
                {
                    fromaddr = "unknown";
                }

                if (sip_acct.UseLocalIPInFrom)
                {
                    if (env.pbx.sip_set.sipAddr.Length > 0)
                        fromaddr += "@" + env.pbx.sip_set.sipAddr;
                    else
                        fromaddr += "@" + env.GetMappedPublicSIPIPAddress();
                }
                else
                    fromaddr += "@" + sip_acct.DomainServer;
                fromaddr = sip_acct.DisplayName + "<sip:" + fromaddr + ">";

                if (dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND &&
                    dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION)
                {
                    //if the outbound job is set to reach extension
                    //here we change to dial extension first
                    SIPPBXExten extn = env.pbx.getExtensionByName(call.Caller); 

                    if(extn == null)
                        extn = env.pbx.getExtensionByName(dp.DestAddress);
                    if (extn == null)
                    {
                        //should return this call job back to done queue
                        env.pbx.FreeSeizedOutboundChannel(env, pbx_chan.index);
                        call.CallResult = -1;
                        call.finalCode = -105;
                        call.finalCodeDesc = "Call job failed(-1) as the extension trying to reach is null!";
                        if (!call.isCallBack)
                            m_JobsDone.Enqueue(call);
                        env.LOG_Trace(1, "Call job failed(-1) as the extension trying to reach is null!");
                        env.LogoutText("Call job failed(-1) as the extension trying to reach is null!");
                        continue;                        
                    }

                    pbx_chan.link_exten = extn;
                    pbx_chan.GenerateRecordFileName(env.pbx, false);

                    if (extn.IsVirtualExten())
                    {
                        //calling to a virtual extension
                        if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                        {
                            //sip address
                            if (extn.VirtualExtenDestAddr.Contains("sip:"))
                            {
                                env.pbx.MakeSIPAddrCall(env, pbx_chan.index, extn.VirtualExtenDestAddr, "");
                            }
                            else
                            {
                                env.pbx.MakeSIPAddrCall(env, pbx_chan.index, "<sip:" + extn.VirtualExtenDestAddr + ">", "");
                            }
                        }
                        else
                        {
                            //to see if it matchs any outbound rules
                            SIPPBXDialPlan dp1 = env.pbx.getDialPlanByCalledNum(env, extn.VirtualExtenDestAddr, "", "", "", null, 1);
                            if (dp1 != null)
                            {
                                sip_acct = env.pbx.getDialPlanSIPAccount(dp1);
                                if (sip_acct != null)
                                {
                                    //outbound, should take out predix digit, then use another channel to dialout
                                    destaddr = dp1.OutboundPrepend + extn.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                                    destaddr += "@" + sip_acct.DomainServer;
                                    destaddr = "<sip:" + destaddr + ">";

                                    fromaddr = sip_acct.UserName;
                                    if (fromaddr == "")
                                         fromaddr = "unknown";

                                     if (sip_acct.UseLocalIPInFrom)
                                     {
                                         if (env.pbx.sip_set.sipAddr.Length > 0)
                                             fromaddr += "@" + env.pbx.sip_set.sipAddr;
                                         else
                                             fromaddr += "@" + env.GetMappedPublicSIPIPAddress();
                                     }
                                     else
                                         fromaddr += "@" + sip_acct.DomainServer;
                                    fromaddr = sip_acct.DisplayName + "<sip:" + fromaddr + ">";

                                    env.pbx.MakeOutboundCall(env, pbx_chan.index, destaddr, fromaddr, sip_acct);
                                }
                                else
                                {
                                    env.pbx.FreeSeizedOutboundChannel(env, pbx_chan.index);
                                    call.CallResult = -1;
                                    call.finalCode = -106;
                                    call.finalCodeDesc = "Call job failed(-1) as dialplan SIP account index is not in range!";
                                    if (!call.isCallBack)
                                        m_JobsDone.Enqueue(call);
                                    env.LOG_Trace(1, "Call job failed(-1) as dialplan SIP account index is not in range!");
                                    env.LogoutText("Call job failed(-1) as dialplan SIP account index is not in range!");
                                    continue;
                                }
                            }
                            else
                            {
                                env.pbx.FreeSeizedOutboundChannel(env, pbx_chan.index);
                                call.CallResult = -1;
                                call.finalCode = -107;
                                call.finalCodeDesc = "Call job failed(-1) as dialplan is null!";
                                if (!call.isCallBack)
                                    m_JobsDone.Enqueue(call);
                                env.LOG_Trace(1, "Call job failed(-1) as dialplan is null!");
                                env.LogoutText("Call job failed(-1) as dialplan is null!");
                                continue;
                            }
                        }
                    }
                    else
                    {
                        //regular extension
                        if (extn.IsRegistered() && (extn.InCalling == 0 || extn.bMultipleCalls))
                        {
                            string sCaller = "<sip:" + call.Callee + "@" + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, extn.RegFromID) + ">";
                            env.pbx.MakeExtensionCall(env, pbx_chan.index, extn.RegFromID, sCaller, extn);
                        }
                        else
                        {
                            env.pbx.FreeSeizedOutboundChannel(env, pbx_chan.index);
                            call.CallResult = -1;
                            call.finalCode = -108;
                            call.finalCodeDesc = "Call job failed(-1) as extension is not online or extension is busy on the phone! *#";
                            if (!call.isCallBack)
                                m_JobsDone.Enqueue(call);
                            env.LOG_Trace(1, "Call job failed(-1) as extension is not online or extension is busy on the phone! *#");
                            env.LogoutText("Call job failed(-1) as extension is not online or extension is busy on the phone! *#");
                            continue;
                        }
                    }
                }
                else
                    env.pbx.MakeOutboundCall(env, pbx_chan.index, destaddr, fromaddr, sip_acct);

                call.InitTime = DateTime.Now;

                IncCallNum();

                ret++;
            }

            return ret;
        }

        public void SaveJobs(DBServerSetting db_set, GTSIPPBXEnv env)
        {
            string log_str;
            CallJob call = null;
            while (m_JobsDone.Count > 0)
            {
                DecCallNum();

                call = (CallJob)m_JobsDone.Dequeue();

                if (call != null)
                {
                    if (call.isCallBack) continue;

                    //try, catch at outside to reset DB.
                    {
                        string sNow = SIPPBXWinUtil.GetSQLDateTime(DateTime.Now);
                        string sqlstr = "INSERT INTO auto_dialer_done VALUES(" + call.ID.ToString() + ", " + call.JobTypeCode.ToString() + ", '";
                        sqlstr += call.Caller + "', '" + call.Callee + "', " + call.CallResult.ToString() + ", '";
                        sqlstr += SIPPBXWinUtil.GetSQLDateTime(call.InitTime) + "', '";
                        sqlstr += SIPPBXWinUtil.GetSQLDateTime(call.BeginTime) + "', '";
                        sqlstr += SIPPBXWinUtil.GetSQLDateTime(call.EndTime) + "', '";
                        sqlstr += call.DTMFs + "', '";
                        sqlstr += call.JobID + "', ";
                        sqlstr += call.DetectResult.ToString() + ", ";
                        sqlstr += call.finalCode.ToString() + ", '";
                        sqlstr += call.finalCodeDesc + "', '"; 
                        sqlstr += call.CallID + "')";

                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                        {
                            log_str = "Successfully save task(Job ID:" + call.ID.ToString() + ") back into auto_dialer_done table.";
                            env.LOG_Trace(4, log_str);
                            env.LogoutText(log_str);
                        }
                        else
                        {
                            log_str = "***Cannot save task(Job ID:" + call.ID.ToString() + ") back into auto_dialer_done table.";
                            env.LOG_Trace(1, log_str);
                            env.LogoutText(log_str);
                        }
                    }
                    //catch (Exception ex)
                    //{
                    //    env.LOG_Trace(1, ex.ToString());
                    //    env.LogoutText(ex.ToString());
                    //}
                }
            }
        }

        public void GetJobs(DBServerSetting db_set, GTSIPPBXEnv env)
        {
            string log_str;
            Queue tempQueue = new Queue();

            string sNow = SIPPBXWinUtil.GetSQLDateTime(DateTime.Now);
            //here should add the number of query, which is only allow first env.GetChannelCount()
            string sqlstr;

            if (db_set.dbType >= 0) //MS SQL Server
                sqlstr = "SELECT TOP " + env.GetChannelCount().ToString() + " ID, Type, Caller, Callee, CallTime, JobID FROM auto_dialer_jobs where CallTime < '" + sNow + "' AND Type = " + type_code.ToString();
            else if (db_set.dbType == -1) //SQLite
                sqlstr = "SELECT ID, Type, Caller, Callee, CallTime, JobID FROM auto_dialer_jobs where CallTime < '" + sNow + "' AND Type = " + type_code.ToString() + " LIMIT " + env.GetChannelCount().ToString();
            else
                return;

            DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

            while (myReader.Read())
            {
                CallJob call = new CallJob();
                try
                {
                    call.ID = myReader.GetInt64(0);
                    call.JobTypeCode = myReader.GetInt16(1);
                    call.Caller = myReader.GetString(2);
                    call.Callee = myReader.GetString(3);
                    try
                    {
                        call.JobID = myReader.GetString(5);
                    }
                    catch (Exception)
                    {
                    }
                    call.Task = this;
                }
                catch (Exception)
                {
                    continue;
                }
                tempQueue.Enqueue(call);
            }

            myReader.Close();


            while (m_JobsQueue.Count < env.GetChannelCount() && tempQueue.Count > 0)
            {
                CallJob call = (CallJob)tempQueue.Dequeue();
                sqlstr = "DELETE FROM auto_dialer_jobs where ID = " + call.ID.ToString();
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    m_JobsQueue.Enqueue(call);
                    log_str = "Successfully get task(" + call.ID.ToString() + ") from auto_dialer_jobs table.";
                    env.LOG_Trace(4, log_str);
                    env.LogoutText(log_str);
                }
                else
                {
                    //call is not in table any more
                    //doing nothing
                    log_str = "***Couldn't get task(" + call.ID.ToString() + ") from auto_dialer_jobs table.";
                    env.LOG_Trace(1, log_str);
                    env.LogoutText(log_str);
                }
            }

            //too many jobs in tmep queue
            //just dequeue, and do nothing
            while (tempQueue.Count > 0)
            {
                CallJob call = (CallJob)tempQueue.Dequeue();
            }

        }

    }

    public class SIPPBXExtenVoiceMail
    {
        public string UserName;
        public string ToEmail;
        public string Caller;
        public string Callee;
        public DateTime tBegin;
        public int nDurSec;
        public string VMFile;
        public int VMStatus;
        public string CallID;

        public SIPPBXExtenVoiceMail()
        {
            UserName = "";
            ToEmail = "";
            Caller = "";
            Callee = "";
            tBegin = DateTime.Now;
            nDurSec = 0;
            VMFile = "";
            VMStatus = 0;
            CallID = "";
        }
    }

    public class SIPPBXExten
    {
        public string UserName;
        public string RealName;
        public string Password;
        public string Email;

        //2014-08-07
        //Since nowhere this tag is used, and clients ask for outbound caller id setting
        //so this member is used as same as outbount caller id.
        public string AlternativePhoneNumber;

        //SIP info
        public ulong RegSDKTime;
        public DateTime RegisterTime;
        public uint RegisterExpire;
        public uint RegMaxExp;
        public string ContactAddr;
        public string MappedContactAddr;
        public string UAName;
        public int NATType;
        public string RegFromID;
        public string RegToID;
        public string RegSrcIP;
        public ushort RegSrcPort;

        //if accept original called id
        public bool bAcceptOtherID;

        //call info
        public int InCalling; //0 = idle, 10 = offered, 20 = dialing, 21 = ringing, 30 = connected 

        public DateTime IdleStartTime;
        public int RestSeconds; //0 = no effective

        //voicemail info
        public int MsgNewCount;
        public int MsgOldCount;
        public int MsgNewUrgentCount;
        public int MsgOldUrgentCount;

        public string MsgAccount;
        public string VoiceMsg;

        //agent working on
        public SIPPBXAgent Agent;

        public VoiceMailBox vmb;

        //subscribe info
        public bool bSubscribed;
        
        //priority level
        //1 = normal, 8 = supervisor, 16 = virtual
        public uint PriorityLevel;
        public string VirtualExtenDestAddr;

        //method of answering ACD calls.  1 = once registered. 2 = once connected with *9000.
        public int ACDCallMethod;

        public bool RecordCall;
        //public string RecordFileName;

        public int RingTimeoutSec;
        public string CallForwardingPlan; //if it is "", it means it is this extension's voice mail box

        public int AuthType; //0 = Proxy, 1 = WWW, 2 = NONE

        public int UseSRTP; //0 = no, 1 = yes, for every call

        public bool bOnlyAgentLogin;

        public bool bMultipleCalls;

        //new cfg_attrs
        public bool bBlockIncomingCallerId;
        public string PinCode;

        public SIPPBXExten()
        {
            UserName = "";
            RealName = "";
            Password = "";
            Email = "";
            AlternativePhoneNumber = "";

            RegisterTime = DateTime.Now;
            RegSDKTime = 0;
            RegisterExpire = 0;
            RegMaxExp = 0;
            NATType = 0; //UANatType: Network Protocol Type. 0  = UDP, 1 = TCP, 2 = TLS
            UAName = "";
            ContactAddr = "";
            MappedContactAddr = "";
            RegFromID = "";
            RegToID = "";
            RegSrcIP = "";
            RegSrcPort = 0;

            InCalling = 0;
            IdleStartTime = DateTime.Now;
            RestSeconds = 0;

            MsgNewCount = 0;
            MsgOldCount = 0;
            MsgNewUrgentCount = 0;
            MsgOldUrgentCount = 0;

            MsgAccount = "";
            VoiceMsg = "";

            bSubscribed = false;
            PriorityLevel = 1;
            VirtualExtenDestAddr = "";

            ACDCallMethod = 1;

            vmb = null;

            Agent = null;

            RecordCall = false;

            bAcceptOtherID = false;

            RingTimeoutSec = 20;
            CallForwardingPlan = "";

            AuthType = 0;

            UseSRTP = 0;

            bOnlyAgentLogin = false;

            bMultipleCalls = false;

            //new cfg_attrs
            bBlockIncomingCallerId = false;
            PinCode = "";
        }

        public bool DelAttrs(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "DELETE FROM cfg_attrs WHERE AttrItemId = '" + UserName + "'";
                db_set.ExcuteNonQuerySQL(sqlstr, env);
            }
            catch (Exception ex)
            {
                if (log != null)
                    log.LogoutText(ex.ToString());

                SIPPBXMain.LogMessageToFile(ex.ToString());
            }
            finally
            {
            }

            return true;
        }

        public bool SaveAttrs(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            //read attributes from table
            bool fnd = false;
            try
            {
                string sqlstr = "SELECT AttrItemValue FROM cfg_attrs WHERE AttrType = " + SIPPBXCFGDB.EXTN_BLOCK_INCOMING_CALLERID_ATTR + " AND AttrItemId = '" + UserName + "'";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);
                try
                {
                    if (myReader.Read())
                    {
                        fnd = true;
                    }
                    else
                    {
                        fnd = false;
                    }

                    string sVal = "0";
                    if (bBlockIncomingCallerId) sVal = "1";

                    if (!fnd)
                    {
                        sqlstr = "INSERT INTO cfg_attrs(AttrType, AttrItemId, AttrItemValue) VALUES(" + SIPPBXCFGDB.EXTN_BLOCK_INCOMING_CALLERID_ATTR + ", '" + UserName + "', '" + sVal + "')";
                    }
                    else
                    {
                        sqlstr = "UPDATE cfg_attrs SET AttrItemValue='" + sVal + "' WHERE AttrType = " + SIPPBXCFGDB.EXTN_BLOCK_INCOMING_CALLERID_ATTR + " AND AttrItemId = '" + UserName + "'";
                    }

                    db_set.ExcuteNonQuerySQL(sqlstr, env);
                }
                catch (Exception ex)
                {
                    if (log != null)
                        log.LogoutText(ex.ToString());

                    SIPPBXMain.LogMessageToFile(ex.ToString());
                }
                finally
                {
                    myReader.Close();
                }

            }
            catch (Exception ex1)
            {
            }
            finally { }

            try
            {
                string sqlstr = "SELECT AttrItemValue FROM cfg_attrs WHERE AttrType = " + SIPPBXCFGDB.EXTN_PING_CODE_ATTR + " AND AttrItemId = '" + UserName + "'";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);
                try
                {
                    if (myReader.Read())
                    {
                        fnd = true;
                    }
                    else
                    {
                        fnd = false;
                    }

                    if (!fnd)
                    {
                        sqlstr = "INSERT INTO cfg_attrs(AttrType, AttrItemId, AttrItemValue) VALUES(" + SIPPBXCFGDB.EXTN_PING_CODE_ATTR + ", '" + UserName + "', '" + PinCode + "')";
                    }
                    else
                    {
                        sqlstr = "UPDATE cfg_attrs SET AttrItemValue='" + PinCode + "' WHERE AttrType = " + SIPPBXCFGDB.EXTN_PING_CODE_ATTR + " AND AttrItemId = '" + UserName + "'";
                    }

                    db_set.ExcuteNonQuerySQL(sqlstr, env);
                }
                catch (Exception ex)
                {
                    if (log != null)
                        log.LogoutText(ex.ToString());

                    SIPPBXMain.LogMessageToFile(ex.ToString());
                }
                finally
                {
                    myReader.Close();
                }

            }
            catch (Exception ex1)
            {
            }
            finally { }


            return true;
        }

        public bool ReadAttrs(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            //read attributes from table
            try
            {
                string sqlstr = "SELECT AttrItemValue FROM cfg_attrs WHERE AttrType = " + SIPPBXCFGDB.EXTN_BLOCK_INCOMING_CALLERID_ATTR + " AND AttrItemId = '" + UserName + "'";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                if (myReader != null)
                {
                    try
                    {
                        if (myReader.Read())
                        {
                            try
                            {
                                bBlockIncomingCallerId = Convert.ToInt32(myReader.GetString(0)) == 1;
                            }
                            catch (Exception)
                            {
                                bBlockIncomingCallerId = false;
                            }
                        }
                        else
                        {
                            bBlockIncomingCallerId = false;
                        }
                    }
                    catch (Exception ex)
                    {
                        if (log != null)
                            log.LogoutText(ex.ToString());

                        SIPPBXMain.LogMessageToFile(ex.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }


                sqlstr = "SELECT AttrItemValue FROM cfg_attrs WHERE AttrType = " + SIPPBXCFGDB.EXTN_PING_CODE_ATTR + " AND AttrItemId = '" + UserName + "'";
                myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                if (myReader != null)
                {
                    try
                    {
                        if (myReader.Read())
                        {
                            PinCode = myReader.GetString(0);
                        }
                        else
                        {
                            PinCode = "";
                        }
                    }
                    catch (Exception ex)
                    {
                        if (log != null)
                            log.LogoutText(ex.ToString());

                        SIPPBXMain.LogMessageToFile(ex.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }
   
            }
            catch (Exception ex1)
            {
                if (log != null)
                    log.LogoutText(ex1.ToString());

                SIPPBXMain.LogMessageToFile(ex1.ToString());
            }
            finally { }

            return true;
        }

        public bool IsRegistered()
        {
            bool ret = false;
            if (RegisterTime != null && RegisterExpire > 0 && RegSDKTime > 0)
            {
                TimeSpan tspan = new TimeSpan(0, 0, Convert.ToInt32(RegisterExpire));

                if (DateTime.Now >= RegisterTime && DateTime.Now < (RegisterTime + tspan))
                {
                    if (ContactAddr.Length > 0)
                    {
                        ret = true;
                    }
                }
            }

            return ret;
        }

        public bool IsNormalExten(){return PriorityLevel == 1;}
        public bool IsSupervisorExten() { return PriorityLevel == 8; }
        public bool IsVirtualExten() { return PriorityLevel == 16; }

        public int getChanIndexMask() { return (NATType << 16) | (UseSRTP << 20); }

    }

    public class SIPPBXAgent
    {
        public string Name;
        public string Code;
        public string Password;
        public SIPPBXExten AtExten;
        public DateTime LogInTime;
        public DateTime LogOutTime;
        public bool RecordCall;
        //public string RecordFileName;
        public short SkillLevel;
        public bool Paused;
        public List<string> LoggedInACD;
        //public SIPPBX pbx;
        //public GTSIPPBXEnv env;

        public SIPPBXAgent(/*SIPPBX _pbx, GTSIPPBXEnv _env*/)
        {
            Code = "";
            Password = "";
            AtExten = null;
            LogInTime = DateTime.Now;
            LogOutTime = DateTime.Now;
            RecordCall = false;
            SkillLevel = 0;
            Paused = false;
            LoggedInACD = new List<string>();
            //pbx = _pbx;
            //env = _env;
        }

        bool IsACDAlreadyInList(SIPPBXACDHuntGroup acd)
        {
            for (int i = 0; i < LoggedInACD.Count; i++)
            {
                if (acd.hgName == LoggedInACD[i])
                    return true;
            }
            return false;
        }

        bool RemoveACDFromList(SIPPBXACDHuntGroup acd)
        {
            int idx = -1;
            for (int i = 0; i < LoggedInACD.Count; i++)
            {
                if (acd.hgName == LoggedInACD[i])
                {
                    idx = i;
                    break;
                }
            }

            if (idx >= 0)
            {
                LoggedInACD.RemoveAt(idx);
                return true;
            }

            return false;
        }

        public bool Login(SIPPBXExten extn, SIPPBXACDHuntGroup acd)
        {
            AtExten = extn;
            extn.Agent = this;
            LogInTime = DateTime.Now;
            Paused = false;

            if(acd != null)
            {
                if (acd.agentType == 2 /*&& acd.agents.Contains(Code)*/) //agent login at ACD group
                {
                    //env.LogoutText("" + index.ToString());
                    //env.LOG_Trace(4, "Agent " + Code.ToString() + " has logged into " + LoggedInACD.Count.ToString() + " ACDs");
                    if (!IsACDAlreadyInList(acd))
                    {
                        LoggedInACD.Add(acd.hgName);
                    }
                    //env.LOG_Trace(4, "Agent " + Code.ToString() + " has logged into " + LoggedInACD.Count.ToString() + " ACDs");

                    return true;
                }
                else
                    return false;
            }

            return true;
        }

        public bool Logout(SIPPBXExten extn, SIPPBXACDHuntGroup acd)
        {
            if (acd != null)
            {
                if (!RemoveACDFromList(acd))
                    return false;

                if (LoggedInACD.Count > 0)
                    return true;
            }

            if (extn == null)
                extn = AtExten;

            AtExten = null;
            if(extn != null)
                extn.Agent = null;

            LogOutTime = DateTime.Now;
            Paused = false;

            LoggedInACD.Clear();

            return true;
        }
    }


    public class SIPPBXACDHuntGroup
    {
        public string hgName;

        //type, 0 = linear, 1 = circular, 2 = most idle, 3 = most skill level
        public int hgType;

        public int circularCursor;

        public bool playMOH;
        public string mohDir;

        public int agentType; //0 = extensions, 1 = agents login at extension, 2 = agents login at this acd
        public List<string> agents;

        public List<GTOpAsyncCompound> calls;

        public string vmbDTMF;
        //public int maxWaitingTime;
        public VoiceMailBox vmb;

        public string dpDTMF;
        public string dpName;

        public int waitTimeout; //0 = no effective
        public string waitTimeoutTo; // "" means to voicemailbox, otherwise it is dialplan name

        public bool bUseGroupName; //boolean if use ring group name as display name when distributing calls to extension

        //public int IntervalCallInAndOut;

        //variables used when queue is full
        public int maxNumOfCalls;
        public short callForwardingType; //0 = To Another ACD, 1 = To Another Dialplan
        public string callForwardingPlan; //ACD or Dialplan Name
        public bool promptQueuePosition;

        public SIPPBXACDHuntGroup()
        {
            hgName = "";
            hgType = 0;
            circularCursor = 0;
            playMOH = false;
            mohDir = "";

            agentType = 0;
            agents = new List<string>();
            calls = new List<GTOpAsyncCompound>();

            //maxWaitingTime = 60 * 60 * 4;
            vmb = null;
            vmbDTMF = "";

            dpDTMF = "";
            dpName = "";

            //IntervalCallInAndOut = 2000;

            waitTimeout = 0;
            waitTimeoutTo = "";

            bUseGroupName = false;

            maxNumOfCalls = 0;
            callForwardingType = 0;
            callForwardingPlan = "";
            promptQueuePosition = false;
        }
    }

    public class SIPProxySite
    {
        public string domainList;
        public bool qop;
        public bool opaque;
        public bool recordRoute;
        public bool udpRelay;
        public bool mapSIPAddr;
        public bool optionPingExten;

        public SIPProxySite()
        {
            domainList = "";
            qop = false;
            opaque = false;
            recordRoute = true;
            udpRelay = true;
            mapSIPAddr = true;
            optionPingExten = true;
        }
    }

    public class SIPPBXDTMF
    {
        public string DTMFStr;
        public SIPPBXIVR IVRMenu;

        public SIPPBXDTMF()
        {
            DTMFStr = "";
            IVRMenu = null;
        }
    }

    public class SIPPBXIVR
    {
        public string name;
        public string sound_file;
        public int menu_dtmf_wait_ms;

        public int action; 
        //0 = nothing, no defined yet.
        //1 = play sound(if available) and detect dtmf, 
        //2 = play sound(if available) and dial extension, 
        //3 = play sound(if available) and go to another menu by name
        //4 = play sound(if available) and go hunt group
        //5 = play sound(if available) and forward call to
        //6 = play sound(if available) and go to "Monitor" group
        //7 = play sound(if available) and go to "Ring group"
        //8 = play sound(if available) and go to "Conference room"
        //9 = play sound(if available) and go to "Voice mail box"
        //10 = play sound(if available) and hung up
        //11 = play sound(if available) and run plugin.
        //12 = play sound(if available) and go to another dialplan by name

        public List<SIPPBXDTMF> dtmfs;

        public string transfer_to;
  //      public SIPPBXIVR ParentIVRMenu;
        public bool dtmf_accept_exten;
        public int dtmf_accept_exten_wait_ms;

        public SIPPBXIVR()
        {
            name = "";
            sound_file = "";
            transfer_to = "";
            action = 0;
            dtmfs = new List<SIPPBXDTMF>();
//            ParentIVRMenu = null;
            dtmf_accept_exten = false;
            dtmf_accept_exten_wait_ms = 1600;

            menu_dtmf_wait_ms = 15000;
        }
    }

    public class SIPPBXDialPlan
    {
        public string planName;
        public enum DIALPLAN_CALL_DIRECTION
        {
            CALL_DIR_INBOUND,
            CALL_DIR_OUTBOUND
        };
        public DIALPLAN_CALL_DIRECTION CallDirection;
        public string CalledID;
        public string CallerID;

        //time limitation for outbound calls
        public bool TimeLimited;
        public int[] TimeDays;
        public int TimeStartHour;
        public int TimeStartMinute;
        public int TimeEndHour;
        public int TimeEndMinute;

        public int OutboundSIPAcct;
        public int OutboundSIPAcct1;
        public int OutboundSIPAcct2;

        public string OutboundPreStrip;
        public string OutboundPrepend;
        public string DestAddress;
        public string OutboundCallerID;

        public uint ExtenPriorityLevel; //0 = any, 1 = normal, 8 = supervisor, 16 = virtual

        public PBXMemberList MemberList;

        //call attribute
        public enum DIALPLAN_CALL_PLAN
        {
            AUTO_ATTENDANT,
            ACD_QUEUE,
            VOICE_MAIL_BOX,
            DIAL_EXTENSION,
            DO_NOT_DISTURB,
            MONITOR_GROUP,
            RING_GROUP,
            CONFERENCE_ROOM,
            PLUGIN_ROUTINE,
            CALL_FORWARDING, //call forward to another outbound dialplan, sip address, ...
            MUSIC_SERVER,
            ECHO_TEST,
            OPENAI_NODE
        };
        public DIALPLAN_CALL_PLAN CallPlan;
//        public SIPPBXIVR ivr;

        public SIPPBXDialPlan()
        {
            CallDirection = DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND;
            planName = "";
            CalledID = "";
            CallerID = "";

            CallPlan = DIALPLAN_CALL_PLAN.AUTO_ATTENDANT;
//            ivr = new SIPPBXIVR();
            OutboundPreStrip = "";
            OutboundPrepend = "";
            OutboundSIPAcct = 0;
            OutboundSIPAcct1 = 0;
            OutboundSIPAcct2 = 0;
            OutboundCallerID = "";
            ExtenPriorityLevel = 0;
            DestAddress = "";

            TimeLimited = false;
            TimeDays = new int[7];
            for(int i=0; i<7; i++)
                TimeDays[i] = 0;
            TimeStartHour = 0;
            TimeStartMinute = 0;
            TimeEndHour = 0;
            TimeEndMinute = 0;

            MemberList = null;
        }
    }

    public class SIPPBXDialPlanWrap
    {
        public SIPPBXDialPlan dp;
        public string called_id;
        public int trans_type;

        public SIPPBXDialPlanWrap()
        {
            dp = null;
            called_id = "";
            trans_type = 0;
        }
    }

    public class SIPPBXVirExtenTransferWrap
    {
        public string callee;
        public string caller;
        public SIPPBXExten extn;
        public SIPAccount acct;

        public SIPPBXVirExtenTransferWrap()
        {
            callee = "";
            caller = "";
            extn = null;
            acct = null;
        }
    }

/*
    public class SIPPBXProxyCall
    {
        public uint pid;
        public uint sid;
        public SIPPBXExten extnFrom;
        public SIPPBXExten extnTo;

        public SIPPBXProxyCall()
        {
            pid = 0;
            sid = 0;
            extnFrom = null;
            extnTo = null;
        }
    }
*/

    public class SIPPBXDest
    {
        public int DestType; //0 = extension, 1 = outbound call, 2 = another sip address, 3 = ACD agent
        public string DestAddr;
        public int RingTimeout;

        public SIPPBXDest()
        {
            DestType = 0;
            DestAddr = "";
            RingTimeout = 45;
        }
    }

    public class SIPPBXOpenAINode
    {
        public string NodeName;
        public string APIKey;
        public string DefDesc;
        public string Args;
        public string Menus;

        public SIPPBXOpenAINode()
        {
            NodeName = "";
            APIKey = "";
            DefDesc = "";
            Args = "";
            Menus = "";
        }
    }

    public class SIPPBXPagingGroup
    {
        //for intercom, just need to add header: 
        //Alert-Info: <http://www.notused.com>;info=alert-autoanswer;delay=0
        //Call-Info: answer-after=0
        public string gpName;
        public string did;
        public List<SIPPBXDest> destList;
        public bool bUseGroupName; //boolean if use ring group name as display name when distributing calls to extension
        public IntPtr conf_handle;

        public SIPPBXPagingGroup()
        {
            gpName = "";
            did = "";
            destList = new List<SIPPBXDest>();
            bUseGroupName = false;
            conf_handle = IntPtr.Zero;
        }
        
    }

    public class SIPPBXRingGroup
    {
        public int ringType; //0 = ring all, 1 = ring by order
        public int uiCurrentPos; 
        public string gpName;
        public List<SIPPBXDest> destList;
        public bool playMOH;
        public string mohDir;
        public bool bUseGroupName; //boolean if use ring group name as display name when distributing calls to extension
        public bool bAnswerCallFirst;

        public VoiceMailBox vmb;

        public SIPPBXRingGroup()
        {
            ringType = 0;
            uiCurrentPos = 0;
            gpName = "";
            destList = new List<SIPPBXDest>();
            playMOH = false;
            mohDir = "";
            bUseGroupName = false;
            bAnswerCallFirst = true;

            vmb = null;
        }
    }

    public class SIPPBXParkingSlot
    {
        public string psName;
        public string psDTMF;

        public SIPPBXChan pbxChan;
        public bool playMOH;
        public string mohDir;

        //public int maxWaitingTime;
        public VoiceMailBox vmb;
        public string vmbDTMF;

        public string dpDTMF;
        public string dpName;

        public int waitTimeout; //0 = no effective
        public string waitTimeoutTo; // "" means to voicemailbox, otherwise it is dialplan name

        public SIPPBXParkingSlot()
        {
            psName = "";
            psDTMF = "";

            pbxChan = null;
            playMOH = false;
            mohDir = "";

            //maxWaitingTime = 60 * 60 * 4;
            vmb = null;
            vmbDTMF = "";

            dpDTMF = "";
            dpName = "";

            waitTimeout = 0;
            waitTimeoutTo = "";
        }
    }

    public class SIPPBXMonitorGroup
    {
        public string mgName;
        public string mgNumber;
        public string mgPasswordPrompt;
        public string mgPassword;
        public string mgKeyBargeIn;
        public string mgKeyOut;
        public string mgKeyWhisper;
        public string mgExtenPrompt;
        public bool mgAllExtens;
        public List<string> mgExtenList;

        public SIPPBXMonitorGroup()
        {
            mgName = "";
            mgNumber = "";
            mgPasswordPrompt = "";
            mgPassword = "";
            mgKeyBargeIn = "*";
            mgKeyOut = "#";
            mgKeyWhisper = "1";
            mgExtenPrompt = "";
            mgAllExtens = true;
            mgExtenList = new List<string>();
        }
    }

    public class SIPPBXChan
    {
        public int index;
        //public int call_flow_tag;
        public SIPPBXDialPlan dp;
        public CallJob call_job;
        //public SIPPBXIVR ivr;
        public string DTMFBuf;
        public GTOpAsyncCompound async_op_compound;

        public bool call_connected;
        public bool call_reached_agent;
        public SIPPBXACDHuntGroup acd_queue;
        public bool acd_cdr_saved;

        public DateTime in_queue_time;
        public DateTime out_queue_time;
        public SIPPBXExten acd_to_extn; //acd call transfered to extension

        public SIPPBXChan link_chan;
        public SIPPBXExten link_exten;
        public string link_dtmf;
        public SIPPBXDest link_dest;

        public SIPPBXPluginHost plugin_host;

        //found an error that channel is reserved too long
        //here adding a count to add 1 every 2 seconds.
        //if it is too big, will free channell automatically
        public int reserved_cnt;

        bool recording;
        public string RecordFileName;

        public string target_did; //only for inbound channel

        public string unique_call_id;
        public int call_dir; //0 = inbound, and 1 = outbound.
        //public DateTime NoAudioFirstTime;

        //save incoming call data
        public string sCaller;
        public string sCallee;
        public string sDestAddr;
        public string sViaAddr;
        public string sFromIP;
        public ushort nFromPort;

        //new feature to save if the call has been transferred
        public bool transferred;
        public string ivrKeys;

        public string discReason;
        public string hangupParty;
        public string confName;
        public bool doConfRecordConvert;
        
        public string sCallLimitID;

        public int conf_opt;

        public SIPAccount sip_acct;

        public bool byPassDialPlan;

        public OpenAIRealtimeAccess openAI;

        public SIPPBXChan(int idx)
        {
            index = idx;
            reserved_cnt = 0;
            ResetAll("", 0, null, null);
            openAI = null; //openAI = new OpenAIRealtimeAccess();
        }

        public void GenerateRecordFileName(SIPPBX pbx, bool isReset)
        {
            DateTime tNow = DateTime.Now;

            if (pbx == null)
                return;

            if (link_exten != null)
            {
                if (link_exten.Agent != null)
                {
                    if (link_exten.Agent.RecordCall)
                    {
                        pbx.CreateDir(pbx.record_dir + "agent\\");
                        pbx.CreateDir(pbx.record_dir + "agent\\" + link_exten.Agent.Code);
                        pbx.CreateDir(pbx.record_dir + "agent\\" + link_exten.Agent.Code + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow));
                        RecordFileName = pbx.record_dir + "agent\\" + link_exten.Agent.Code + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow) + "\\" + tNow.ToString("yyyyMMdd-HHmmss") + "-" + index.ToString();
                        if (pbx.AudioFormat == 1) //mp3
                            RecordFileName += ".mp3";
                        else
                            RecordFileName += ".wav";
                    }
                }
                else
                {
                    if (link_exten.RecordCall)
                    {
                        pbx.CreateDir(pbx.record_dir + "exten\\");
                        pbx.CreateDir(pbx.record_dir + "exten\\" + link_exten.UserName);
                        pbx.CreateDir(pbx.record_dir + "exten\\" + link_exten.UserName + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow));
                        RecordFileName = pbx.record_dir + "exten\\" + link_exten.UserName + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow) + "\\" + tNow.ToString("yyyyMMdd-HHmmss") + "-" + index.ToString();
                        if (pbx.AudioFormat == 1) //mp3
                            RecordFileName += ".mp3";
                        else
                            RecordFileName += ".wav";
                    }
                }
            }
            else
            {
                if (pbx.RecordAllCalls && !isReset)
                {
                    pbx.CreateDir(pbx.record_dir + "channel\\");
                    pbx.CreateDir(pbx.record_dir + "channel\\" + index.ToString());
                    pbx.CreateDir(pbx.record_dir + "channel\\" + index.ToString() + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow));
                    RecordFileName = pbx.record_dir + "channel\\" + index.ToString() + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow) + "\\" + tNow.ToString("yyyyMMdd-HHmmss");
                    if (pbx.AudioFormat == 1) //mp3
                        RecordFileName += ".mp3";
                    else
                        RecordFileName += ".wav";
                }
            }

        }

        public void ResetAll(string callid, int calldir, SIPPBX pbx, SIPPBXExten extn)
        {
            dp = null;
            DTMFBuf = "";
            async_op_compound = null;
            link_chan = null;
            link_exten = extn;
            link_dtmf = "";
            link_dest = null;
            call_connected = false;
            call_reached_agent = false;
            acd_queue = null;
            acd_cdr_saved = false;
            acd_to_extn = null;
            call_job = null;
            plugin_host = null;
            target_did = "";
            byPassDialPlan = false;

            //NoAudioFirstTime = DateTime.Now;

            recording = false;
            RecordFileName = "";
            GenerateRecordFileName(pbx, true);

            if (callid.Length == 0)
            {
                call_dir = 0; //default regard it as inbound
                unique_call_id = SIPPBXWinUtil.RandomNumber(100000, 999999) + SIPPBXWinUtil.RandomString(6, false) + DateTime.Now.ToString("yyyyMMddHHmmss") + index.ToString();
            }
            else
            {
                call_dir = calldir;
                unique_call_id = callid;
            }

            transferred = false;
            ivrKeys = "";

            discReason = "";
            hangupParty = "";
            confName = "";
            doConfRecordConvert = false;
            
            sCallLimitID = "";

            conf_opt = 0;

            sip_acct = null;
        }

        public void Reset()
        {
            DTMFBuf = "";
            link_dtmf = "";
            async_op_compound = null;
            call_job = null;
        }

        public void SetDiscReason(GTSIPPBXEnv env, string s)
        {
            if (discReason.Length == 0)
            {
                if (s.Length > 0)
                    discReason = s;
                else
                {
                    GTAPIASM.GTAPIChan api_chan = env.GetChannel(index);
                    if(api_chan.originate)
                    {
                        //outbound call
                        discReason = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num);
                    }
                    else
                    {
                        //inbound call
                        discReason = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num);
                    }
                }
            }
        }


        public void SetHangupParty(GTSIPPBXEnv env, string s)
        {
            if (hangupParty.Length == 0)
            {
                if (s.Length > 0)
                    hangupParty = s;
            }
            else
            {
                if (hangupParty != s)
                    hangupParty += " " + s;
            }
        }

        /*
        public string GetDirPath(string fn)
        {
            int idx = fn.LastIndexOf('\\');
            if (idx > 0)
            {
                return fn.Substring(0, idx);
            }
            return "";
        }
        */

        public bool Record(GTSIPPBXEnv env, SIPPBXChan chan1, string auFile)
        {
            DateTime tNow = DateTime.Now;

            //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 1");

            if (auFile.Length > 0)
            {
                if (chan1 != null)
                {
                    //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 5");
                    env.Send_DuplexConnect(index, chan1.index);
                }

                if (!recording)
                {
                    env.Send_RecordAudio2(index, auFile, 0, "", 0, 0);
                    recording = true;
                }

                return true;
            }

            if (link_exten != null)
            {
                //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 2");

                if (link_exten.Agent != null)
                {
                    //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 3");

                    if (link_exten.Agent.RecordCall)
                    {
                        //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 4");

                        if (chan1 != null)
                        {
                            //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 5");
                            env.Send_DuplexConnect(index, chan1.index);
                        }
                    //retry1:
                        //two way recording
                        //RecordFileName should has been set to a valid path in ResetAll
                        if (!recording)
                        {
                            //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 6");

                            if (RecordFileName.Length == 0)
                            {
                                //Logout error here first
                                env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 7");

                                env.LogoutText("Audio file name is null! Regenerate now.... Chan:" + index.ToString());
                                env.LOG_Trace(1, "Audio file name is null! Regenerate now.... Chan:" + index.ToString());
                                env.pbx.CreateDir(env.pbx.record_dir + "agent\\");
                                env.pbx.CreateDir(env.pbx.record_dir + "agent\\" + link_exten.Agent.Code);
                                env.pbx.CreateDir(env.pbx.record_dir + "agent\\" + link_exten.Agent.Code + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow));
                                RecordFileName = env.pbx.record_dir + "agent\\" + link_exten.Agent.Code + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow) + "\\" + tNow.ToString("yyyyMMdd-HHmmss") + "-" + index.ToString();
                                if (env.pbx.AudioFormat == 1) //mp3
                                    RecordFileName += ".mp3";
                                else
                                    RecordFileName += ".wav";
                            }
                            env.Send_RecordAudio2(index, RecordFileName, 0, "", 0, 0);
                            recording = true;
                        }
                        /*
                        else
                        {
                            RecordFileName = "";
                            recording = false;
                            goto retry1;
                        }*/
                        return true;
                    }
                }
                else
                {
                    //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 8");

                    if (link_exten.RecordCall)
                    {
                        //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 9");

                        if (chan1 != null)
                        {
                            //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 10");
                            env.Send_DuplexConnect(index, chan1.index);
                        }

                    //retry2:
                        //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 11");

                        if (!recording)
                        {
                            //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 12");

                            if (RecordFileName.Length == 0)
                            {
                                //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 13");

                                //Logout error here first
                                env.LogoutText("Audio file name is null! Regenerate now.... Chan:" + index.ToString());
                                env.LOG_Trace(1, "Audio file name is null! Regenerate now.... Chan:" + index.ToString());
                                env.pbx.CreateDir(env.pbx.record_dir + "exten\\");
                                env.pbx.CreateDir(env.pbx.record_dir + "exten\\" + link_exten.UserName);
                                env.pbx.CreateDir(env.pbx.record_dir + "exten\\" + link_exten.UserName + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow));
                                RecordFileName = env.pbx.record_dir + "exten\\" + link_exten.UserName + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow) + "\\" + tNow.ToString("yyyyMMdd-HHmmss") + "-" + index.ToString();
                                if (env.pbx.AudioFormat == 1) //mp3
                                    RecordFileName += ".mp3";
                                else
                                    RecordFileName += ".wav";

                            }
                            env.Send_RecordAudio2(index, RecordFileName, 0, "", 0, 0);
                            recording = true;
                        }
                        /*else
                        {
                            RecordFileName = "";
                            recording = false;
                            goto retry2;
                        }*/

                        return true;
                    }
                }
            }
            else
            {
                if(env.pbx.RecordAllCalls)
                {
                    //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 14");

                    if (chan1 != null)
                    {
                        //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 15");
                        env.Send_DuplexConnect(index, chan1.index);
                    }

                    //retry2:
                    //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 11");

                    if (!recording)
                    {
                        //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 12");

                        if (RecordFileName.Length == 0)
                        {
                            //env.LOG_Trace(1, "chan " + index.ToString() + " chan 1 " + chan1.index.ToString() + " Step 13");

                            //Logout error here first
                            env.LogoutText("Audio file name is null! Regenerate now.... Chan:" + index.ToString());
                            env.LOG_Trace(1, "Audio file name is null! Regenerate now.... Chan:" + index.ToString());
                            env.pbx.CreateDir(env.pbx.record_dir + "channel\\");
                            env.pbx.CreateDir(env.pbx.record_dir + "channel\\" + index.ToString());
                            env.pbx.CreateDir(env.pbx.record_dir + "channel\\" + index.ToString() + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow));
                            RecordFileName = env.pbx.record_dir + "channel\\" + index.ToString() + "\\" + SIPPBXWinUtil.GetDirDateTime(tNow) + "\\" + tNow.ToString("yyyyMMdd-HHmmss");
                            if (env.pbx.AudioFormat == 1) //mp3
                                RecordFileName += ".mp3";
                            else
                                RecordFileName += ".wav";

                        }
                        env.Send_RecordAudio2(index, RecordFileName, 0, "", 0, 0);
                        recording = true;
                    }

                    return true;
                }
            }

            return false;
        }
    }

    public class PickUpGroup
    {
        public string name;
        public PBXMemberList ml;

        public PickUpGroup()
        {
            name = "";
            ml = new PBXMemberList();
        }
    }

    public class SIPConferRoom
    {
        public string conf_name;
        public IntPtr conf_handle;
        public List<SIPPBXChan> conf_chans;
        public int conf_max_num;
        public string join_prompt;
        public string leave_prompt;
        public string moh_dir;

        //advanced features
        public bool disc_call;
        public string host_pw;
        public string host_pw_prompt;
        public bool attendance_need_password;

        public bool conf_record;
        public string rec_file;

        public SIPConferRoom()
        {
            conf_name = "";
            conf_handle = IntPtr.Zero;
            conf_chans = new List<SIPPBXChan>();
            conf_max_num = 0;
            join_prompt = Application.StartupPath + "\\audio\\conf-join.wav";
            leave_prompt = Application.StartupPath + "\\audio\\conf-leave.wav";
            moh_dir = Application.StartupPath + "\\moh";
            disc_call = true;
            host_pw = "";
            host_pw_prompt = Application.StartupPath + "\\audio\\conf-host.wav";
            conf_record = false;
            rec_file = "";
            attendance_need_password = false;
        }
    }

    public class SIPPBXWavProcessWrap
    {
        public string fn;
        public int type; //1 = mp3, 2 = gsm, 3 = encode wav only
        public int encode;
    }

    public class SIPPBXWavWorkProcess
    {
        public Thread workThread;
        public Queue<SIPPBXWavProcessWrap> fnList;
        bool isExiting;
        public SIPPBX pbx;
        public GTSIPPBXEnv env;

        public string UserName;
        public SecureString Password;
        public string Domain;

        public SIPPBXWavWorkProcess()
        {
            fnList = new Queue<SIPPBXWavProcessWrap>();
            workThread = new Thread(Run);
            isExiting = false;

            pbx = null;
            env = null;

            UserName = "";
            Password = null;
            Domain = "";
        }

        public void StartConvert()
        {
            isExiting = false;
            workThread.Start(this);
        }

        public void StopConvert()
        {
            isExiting = true;
            workThread.Join();
        }

        public void AddJob(string fn, int type, int encode)
        {
            SIPPBXWavProcessWrap wrap = new SIPPBXWavProcessWrap();
            wrap.fn = fn;
            wrap.type = type;
            wrap.encode = encode;
            lock (fnList)
            {
                fnList.Enqueue(wrap);
            }
        }

        //code from digilog worked for lame.exe
        public void mciConvertWavMP3(string lamePath, string fileName, bool waitFlag)
        {
            //maxLen is in ms (1000 = 1 second) 
            string mp3fileName = fileName.Replace(".wav", ".mp3");
            string outfile = "--priority 0 \"" + fileName + "\" \"" + mp3fileName + "\"";
            System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo();
            psi.FileName = "\"" + lamePath + "\"";
            psi.Arguments = outfile;
            //psi.WorkingDirectory=pworkingDir; 
            psi.WindowStyle = System.Diagnostics.ProcessWindowStyle.Minimized;
            System.Diagnostics.Process p = System.Diagnostics.Process.Start(psi);
            if (waitFlag)
            {
                p.WaitForExit();
                // wait for exit of called application 
            }
        }

        public void Wav2MP3(string wavPath, string mp3Path)
        {
            //string tempPath = System.IO.Path.GetTempPath();
            string tempPath = pbx.pbx_dir + "\\temp\\";

            string fname = SIPPBX.GetFileNameOnly(wavPath);
            string fext = SIPPBX.getFileExtension(wavPath);
            string fnwav = tempPath + fname + "~" + fext;

            //env.LOG_Trace(1, "Wav2MP3 1");

            if (GTAPIASM.GTAPIEnv.GTAPI_AMULAW2PCM(wavPath, fnwav) == 1)
            {
                File.Delete(wavPath); 
                File.Move(fnwav, wavPath);
            }

            using (WaveFileReader wfr = new WaveFileReader(wavPath))
            {
                //env.LOG_Trace(1, "Wav2MP3 2");
                NAudio.Wave.WaveFormat newFormat = new NAudio.Wave.WaveFormat(16000, wfr.WaveFormat.BitsPerSample, wfr.WaveFormat.Channels);
                //env.LOG_Trace(1, "Wav2MP3 3");
                using (NAudio.Wave.WaveFileWriter wfw = new NAudio.Wave.WaveFileWriter(fnwav, newFormat))
                {
                    //env.LOG_Trace(1, "Wav2MP3 4");
                    using (NAudio.Wave.WaveFormatConversionStream conversionStream = new NAudio.Wave.WaveFormatConversionStream(newFormat, wfr))
                    {
                        //env.LOG_Trace(1, "Wav2MP3 5");
                        conversionStream.Position = 0;
                        byte[] buffer = new byte[1024];
                        while (conversionStream.Position < conversionStream.Length)
                        {
                            //env.LOG_Trace(1, "Wav2MP3 6");
                            int bytesRead = conversionStream.Read(buffer, 0, 1024);
                            if (bytesRead > 0)
                            {
                                wfw.Write(buffer, 0, bytesRead);
                            }
                            else
                            {
                                break;
                            }
                        }
                        wfw.Close();
                        //env.LOG_Trace(1, "Wav2MP3 7");

                    }
                }


            }

            //env.LOG_Trace(1, "Wav2MP3 8");
       
            //if ( File.Exists(textBoxOutFile.Text) && (MessageBox.Show(this, "Override the existing file?", "File exists", MessageBoxButtons.YesNo, MessageBoxIcon.Question) != DialogResult.Yes) )
            //{
            //    return;
            //}
            try
            {
                bool Compressing = true;
                try
                {
                    //env.LOG_Trace(1, "Wav2MP3 9");

                    WaveLib.WaveStream InStr = new WaveLib.WaveStream(fnwav);
                    Yeti.MMedia.Mp3.Mp3WriterConfig m_Config = new Yeti.MMedia.Mp3.Mp3WriterConfig(InStr.Format); ;
                    //env.LOG_Trace(1, "Wav2MP3 10");

                    try
                    {
                        //env.LOG_Trace(1, "Wav2MP3 11");

                        Yeti.MMedia.Mp3.Mp3Writer writer = new Yeti.MMedia.Mp3.Mp3Writer(new FileStream(mp3Path, FileMode.Create), m_Config);

                        //env.LOG_Trace(1, "Wav2MP3 12");

                        try
                        {
                            byte[] buff = new byte[writer.OptimalBufferSize];
                            int read = 0;
                            int actual = 0;
                            //long total = InStr.Length;
                            //Cursor.Current = Cursors.WaitCursor;
                            try
                            {
                                //env.LOG_Trace(1, "Wav2MP3 13");

                                while ((read = InStr.Read(buff, 0, buff.Length)) > 0)
                                {
                                    //Application.DoEvents();
                                    writer.Write(buff, 0, read);
                                    actual += read;
                                    //progressBar.Value = (int)(((long)actual * 100) / total);
                                    //toolTip1.SetToolTip(progressBar, string.Format("{0}% compresssed", progressBar.Value));
                                    //this.Text = string.Format("Audio Compress - {0}% compresssed", progressBar.Value);
                                    //Application.DoEvents();

                                    //env.LOG_Trace(1, "Wav2MP3 14");

                                }
                                //toolTip1.SetToolTip(progressBar, "Done");
                                //this.Text = "Audio Compress - Done";
                            }
                            finally
                            {
                                //Cursor.Current = Cursors.Default;
                            }
                        }
                        finally
                        {
                            writer.Close();
                            //env.LOG_Trace(1, "Wav2MP3 15");

                        }
                    }
                    finally
                    {
                        InStr.Close();
                        //env.LOG_Trace(1, "Wav2MP3 16");

                    }
                }
                finally
                {
                    Compressing = false;
                    //RefreshControls();
                }
            }
            catch (Exception)
            {
            }

            File.Delete(fnwav);
            //env.LOG_Trace(1, "Wav2MP3 17");

        }

        /*
        static double bytesToDouble(byte firstByte, byte secondByte)
        {
            // convert two bytes to one short (little endian)
            short s = (secondByte << 8) | firstByte;
            // convert to range from -1 to (just below) 1
            return s / 32768.0;
        }*/

        // Returns left and right double arrays. 'right' will be null if sound is mono.
        public static int openWav(string filename/*, out double[] left, out double[] right*/)
        {
            int chunkSize = 0;
            byte[] wav = File.ReadAllBytes(filename);

            // Determine if mono or stereo
            int channels = wav[22];     // Forget byte 23 as 99.999% of WAVs are 1 or 2 channels

            // Get past all the other sub chunks to get to the data subchunk:
            int pos = 12;   // First Subchunk ID from 12 to 16

            // Keep iterating until we find the data chunk (i.e. 64 61 74 61 ...... (i.e. 100 97 116 97 in decimal))
            while (!(wav[pos] == 100 && wav[pos + 1] == 97 && wav[pos + 2] == 116 && wav[pos + 3] == 97) && pos < wav.Length - 8)
            {
                pos += 4;
                chunkSize = wav[pos] + wav[pos + 1] * 256 + wav[pos + 2] * 65536 + wav[pos + 3] * 16777216;
                pos += 4 + chunkSize;
            }

            chunkSize = 0;
            if (pos < wav.Length - 8)
            {
                pos += 4;
                chunkSize = wav[pos] + wav[pos + 1] * 256 + wav[pos + 2] * 65536 + wav[pos + 3] * 16777216;
            }
            return chunkSize;

            /*
            pos += 4;

            // Pos is now positioned to start of actual sound data.
            int samples = (wav.Length - pos) / 2;     // 2 bytes per sample (16 bit sound mono)
            if (channels == 2) samples /= 2;        // 4 bytes per sample (16 bit stereo)

            // Allocate memory (right will be null if only mono sound)
            left = new double[samples];
            if (channels == 2) right = new double[samples];
            else right = null;

            // Write to double array/s:
            int i = 0;
            while (pos < length)
            {
                left[i] = bytesToDouble(wav[pos], wav[pos + 1]);
                pos += 2;
                if (channels == 2)
                {
                    right[i] = bytesToDouble(wav[pos], wav[pos + 1]);
                    pos += 2;
                }
                i++;
            }*/
        }

        public static bool IsFileLocked(string filePath)
        {
            FileInfo file = new FileInfo(filePath);
            FileStream stream = null;

            try
            {
                stream = file.Open(FileMode.Open, FileAccess.ReadWrite, FileShare.None);
            }
            catch (IOException)
            {
                //the file is unavailable because it is:
                //still being written to
                //or being processed by another thread
                //or does not exist (has already been processed)
                return true;
            }
            finally
            {
                if (stream != null)
                    stream.Close();
            }

            //file is not locked
            return false;
        }

        static void Run(object obj)
        {
            Queue<SIPPBXWavProcessWrap> fnList = new Queue<SIPPBXWavProcessWrap>();
            SIPPBXWavWorkProcess wav_process = (SIPPBXWavWorkProcess)obj;
            while (!wav_process.isExiting)
            {
                //VRAPIASM.VRAPIEnv.Log(1, "VR2WavWorkProcess.Run 1");
                lock (wav_process.fnList)
                {
                    while (wav_process.fnList.Count > 0)
                    {
                        fnList.Enqueue(wav_process.fnList.Dequeue());
                    }
                }

                //wav_process.env.LOG_Trace(4, "SIPPBXWavWorkProcess.Run " + fnList.Count.ToString());
                //wav_process.env.LogoutText("SIPPBXWavWorkProcess.Run " + fnList.Count.ToString());                

                if (fnList.Count == 0)
                {
                    Thread.Sleep(500);
                }
                else
                {
                    while (fnList.Count > 0)
                    {
                        SIPPBXWavProcessWrap wrap = fnList.Dequeue();
                        string fn1 = "";
                        string outfile = "";

                        Thread.Sleep(500); //Wait 500ms for host app(thread) to finishing writing wav and xml

                        if (!File.Exists(wrap.fn)) continue;

                        bool fileLocked = IsFileLocked(wrap.fn);

                        if (fileLocked)
                        {
                            wav_process.env.LOG_Trace(2, "SIPPBXWavWorkProcess " + wrap.fn + " is being used by another process. cannot convert!");
                            //wav_process.env.LogoutText("SIPPBXWavWorkProcess " + wrap.fn + " is being used by another process. cannot convert!");
                            continue;
                        }

                        if (wrap.type == 1 && wrap.fn.Contains(".mp3"))
                        {
                            goto encode_here;
                        }

                        if (openWav(wrap.fn) == 0)
                        {
                            wav_process.env.LOG_Trace(2, "SIPPBXWavWorkProcess " + wrap.fn + " is not valid, as data trunk is 0!");
                            //wav_process.env.LogoutText("SIPPBXWavWorkProcess " + wrap.fn + " is not valid, as data trunk is 0!");
                            continue;
                        }

                        wav_process.env.LOG_Trace(4, "SIPPBXWavWorkProcess " + wrap.fn + " " + wrap.type.ToString() + " " + wrap.encode.ToString());
                        //wav_process.env.LogoutText("SIPPBXWavWorkProcess " + wrap.fn + " " + wrap.type.ToString() + " " + wrap.encode.ToString());

                        if (wrap.type == 0)
                        {
                            fn1 = wrap.fn;
                            goto encode_here;
                        }
                        if (wrap.type == 1)
                            fn1 = wrap.fn.Replace(".wav", ".mp3");
                        else if (wrap.type == 2)
                            fn1 = wrap.fn.Replace(".wav", "_gsm.wav");
                        else if (wrap.type == 3)
                            fn1 = wrap.fn.Replace(".wav", ".wzp");
                        else
                            continue;

                        wav_process.env.LOG_Trace(4, "SIPPBXWavWorkProcess fn1=" + fn1);
                        //wav_process.env.LogoutText("SIPPBXWavWorkProcess fn1=" + fn1);

                        try
                        {
                            if (!fileLocked)
                            {
                                if (wrap.type == 1)
                                {
                                    wav_process.Wav2MP3(wrap.fn, fn1);
                                }
                                else if (/*wrap.type == 1 ||*/ wrap.type == 2)
                                {

                                    if (wrap.type == 1)
                                        outfile = "--preset phone \"" + wrap.fn + "\" \"" + fn1 + "\"";
                                    //outfile = "\"" + wrap.fn + "\" \"" + fn1 + "\"";
                                    else if (wrap.type == 2)
                                        outfile = "\"" + wrap.fn + "\" -g \"" + fn1 + "\"";

                                    //VRAPIASM.VRAPIEnv.Log(1, "VR2WavWorkProcess.Run 5 " + outfile);

                                    System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo();
                                    if (wrap.type == 1)
                                        psi.FileName = "\"" + Application.StartupPath + "\\lame.exe" + "\"";
                                    else if (wrap.type == 2)
                                        psi.FileName = "\"" + Application.StartupPath + "\\sox.exe" + "\"";

                                    psi.Arguments = outfile;

                                    wav_process.env.LOG_Trace(4, "SIPPBXWavWorkProcess psi.Filename=" + psi.FileName + " psi.Arguments=" + psi.Arguments);
                                    //wav_process.env.LogoutText("SIPPBXWavWorkProcess psi.Filename=" + psi.FileName + " psi.Arguments=" + psi.Arguments);

                                    //psi.WorkingDirectory = Application.StartupPath; 
                                    //psi.WindowStyle = System.Diagnostics.ProcessWindowStyle.Hidden;
                                    psi.WindowStyle = System.Diagnostics.ProcessWindowStyle.Minimized;
                                    //psi.UseShellExecute = false;
                                    //psi.CreateNoWindow = true;

                                    //If you provide a value for the Password property, the UseShellExecute property must be false, 
                                    //or an InvalidOperationException will be thrown when the Process.Start(ProcessStartInfo) method is called. 
                                    if (wav_process.UserName.Length > 0 && wav_process.Password != null /*&& Domain.Length > 0*/)
                                    {
                                        psi.UserName = wav_process.UserName;
                                        psi.Password = wav_process.Password;
                                        psi.Domain = wav_process.Domain;
                                    }

                                    try
                                    {
                                        System.Diagnostics.Process p = System.Diagnostics.Process.Start(psi);
                                        //if (waitFlag)
                                        p.WaitForExit(); // wait for exit of called application 
                                        //VRAPIASM.VRAPIEnv.Log(1, "VR2WavWorkProcess.Run 7 ");
                                    }
                                    catch (Exception ex)
                                    {
                                        wav_process.env.LOG_Trace(1, "SIPPBXWavWorkProcess " + ex.ToString());
                                        //wav_process.env.LogoutText("SIPPBXWavWorkProcess" + ex.ToString());
                                        continue;
                                        //VRAPIASM.VRAPIEnv.Log(1, "VR2WavWorkProcess.Run 8 ");
                                    }
                                }
                            }
                        }
                        catch (Exception ex)
                        {
                            wav_process.env.LOG_Trace(1, "SIPPBXWavWorkProcess " + ex.ToString());
                            //wav_process.env.LogoutText("SIPPBXWavWorkProcess" + ex.ToString());
                            continue;
                        }

                    encode_here:
                        if (wrap.encode == 1 && !fileLocked)
                        {
                            if (wrap.type == 0)
                            {
                                string fn2 = fn1.Replace(".wav", ".wzp");
                                GTAPIASM.GTEncode.FileEncode(fn1, fn2);
                                File.Delete(fn1);
                                fn1 = fn2;
                            }
                            else if (wrap.type == 1)
                            {
                                string fn2 = fn1.Replace(".mp3", ".mzp");
                                GTAPIASM.GTEncode.FileEncode(fn1, fn2);
                                File.Delete(fn1);
                                fn1 = fn2;
                            }
                            else if (wrap.type == 2)
                            {
                                string fn2 = fn1.Replace(".wav", ".wzp");
                                GTAPIASM.GTEncode.FileEncode(fn1, fn2);
                                File.Delete(fn1);
                                fn1 = fn2;
                            }
                        }

                        if (File.Exists(fn1) && !fileLocked)
                        {
                            //VRAPIASM.VRAPIEnv.Log(1, "VR2WavWorkProcess.Run 9 " + wrap.fn + "," + fn1);

                            //successfully converted
                            File.Delete(wrap.fn);

                            /*
                            if (wrap.type == 2 && wrap.encode == 0) //gsm
                            {
                                try
                                {
                                    File.Move(fn1, wrap.fn);
                                }
                                catch (Exception ex)
                                {
                                    //VRAPIASM.VRAPIEnv.Log(1, ex.ToString());
                                }
                            }
                            */

                        }
                    }
                }

            }

        }
    }


    public class CallLimit
    {
        public string Name;
        public SIPPBXDialPlan dp;
        public SIPPBXExten extn;
        public SIPAccount sipaccount;
        public int Seconds;
        public int roundupSeconds;

        public CallLimit()
        {
            Name = "";
            dp = null;
            extn = null;
            sipaccount = null;
            Seconds = 0;
            roundupSeconds = 60;
        }
    }

    public class CallBack
    {
        public int ID;
        public string Callee;
        public string Caller;
        public string DialPlan;
        public string Exten;
        public string ExtraAttr;

        public CallBack()
        {
            ID = 0;
			Callee = "";
			Caller = "";
            DialPlan = "";
            Exten = "";
            ExtraAttr = "";
		}
    }

    public class ConfItem
    {
        public IntPtr ConfHandle;
        public DateTime FreeTime;
    }

    public class CallBlock
    {
        public int ID;
        public string Callee;
        public string Caller;
        
        public CallBlock()
        {
            ID = 0;
			Callee = "";
			Caller = "";
		}
    }

    public class IPFilter
    {
        public int DBIdx;
        public int WhiteOrBlack; //0 = black list, 1 = white list.
        public int FilterType; //0 == IP, 1 == ID, 2 == MAC
        public string IPAddr;
        public string CallID;
        public string MACAddr;
    }

    //need a new service
    //"Direct inward system access (DISA)" service is one of useful IP-PBX services

    public class SIPPBXBase
    {
        public List<SIPAccount> sip_acct;
        public List<SIPPBXExten> sip_exten;
        public List<SIPProxySite> sip_proxy_sites;
        public SIPServerSetting sip_set;
        public EmailServerSetting email_set;
        public DBServerSetting db_set;
        public List<SIPPBXDialPlan> sip_dialplan;
        public List<SIPPBXACDHuntGroup> sip_huntgroups;
        //public List<SIPPBXProxyCall> sip_proxycalls;
        public List<SIPPBXRingGroup> sip_ringgroups;
        public List<SIPPBXParkingSlot> sip_parkingslots;

        public List<SIPPBXPagingGroup> sip_paginggroups;

        public List<SIPPBXMonitorGroup> sip_monitorgroups;
        public List<SIPPBXAgent> sip_agents;

        public List<SIPPBXIVR> sip_ivrs;

        public List<AutoDialerTask> auto_dialer_tasks;

        public Queue<AutoDialerTask> call_back_queue;

        public List<ISIPPBXPluginClient> plugins;

        public List<PickUpGroup> pickup_groups;

        public List<SIPConferRoom> sip_conferooms;

        public List<Object> user_objects;

        public bool calllimit_enabled;
        public List<CallLimit> call_credits;

        public bool callblock_enabled;
        public List<CallBlock> call_blocks;

        public bool callback_enabled;
        public List<CallBack> call_backlist;

        public List<SIPPBXOpenAINode> openai_nodes;

        public Queue<PBXOptCmd> opt_cmd_queue;

        public SIPPBXWavWorkProcess wav_work;

        public Queue<ConfItem> share_confs;

        public string moh_dir;
        public string pbx_dir;
        public string please_enter_extension_number_dir;
        public string please_enter_password_dir;
        public string please_leave_your_message_after_beep_dir;
        public string please_record_your_greeting_dir;

        public string pickup_shortcode;
        public string acd_number;
        public string agent_login_number;
        public string agent_logout_number;
        public string vmb_code;

        public string blindtrans_code;
        public string consulttrans_code;
        public string trunk_blindtrans_code;
        public string trunk_consulttrans_code;
        public string trunk_hook_flash_code;
        public string magic_cancel_code;

        public string acd_agent_prompt1;
        public string acd_agent_prompt2;
        public string acd_agent_prompt3;
        public string acd_agent_prompt4;
        public string acd_agent_prompt5;
        public string acd_agent_prompt6;
        public string acd_agent_prompt7;
        public string acd_agent_prompt8;
        public string acd_agent_prompt9;

        public string call_limit_prompt;

        public string pbx_ringback_tone;

        public string pbx_dial_tone;

        public string log_dir;
        public int log_level;

        public string report_dir;
        public string record_dir;
        public string plugin_dir;

        public string vmb_dir;

        public PBXCDROption cdr_option;
        public SysOptionSet pbx_sys_set;

        public int no_audio_dur;
        public bool use_gpname_as_dispname;
        public bool get_remote_contact_from_ring;

        public string PBXVersion;

        //new web server
        public short web_port;
        public string web_path;
        public string web_vroot;
        public IPAddress web_addr_type;

        //recording settings
        public int AudioFormat; //0 = wav, 1 = mp3, 2 = gsm
        public int AudioEncode; //0 = disabled, 1 = enabled, then wav->wzp, mp3->mzp, and gsm->gzp

        //security
        public List<IPFilter> IPFilterList;

        public bool RecordAllCalls;

        public void CreateDir(string dir_name)
        {
            try
            {
                if (!Directory.Exists(dir_name))
                    Directory.CreateDirectory(dir_name);
            }
            catch (Exception)
            {
            }
        }

        public SIPPBXBase()
        {
            sip_acct = new List<SIPAccount>();
            sip_exten = new List<SIPPBXExten>();
            sip_proxy_sites = new List<SIPProxySite>();
            SIPProxySite asite = new SIPProxySite();
            sip_proxy_sites.Add(asite);
            sip_set = new SIPServerSetting();
            email_set = new EmailServerSetting();
            db_set = null;
            sip_dialplan = new List<SIPPBXDialPlan>();
            sip_huntgroups = new List<SIPPBXACDHuntGroup>();
            //sip_proxycalls = new List<SIPPBXProxyCall>();
            sip_ringgroups = new List<SIPPBXRingGroup>();
            sip_parkingslots = new List<SIPPBXParkingSlot>();
            sip_paginggroups = new List<SIPPBXPagingGroup>();
            user_objects = new List<object>();
            opt_cmd_queue = new Queue<PBXOptCmd>();

            sip_monitorgroups = new List<SIPPBXMonitorGroup>();
            sip_agents = new List<SIPPBXAgent>();

            sip_ivrs = new List<SIPPBXIVR>();

            plugins = new List<ISIPPBXPluginClient>();

            pickup_groups = new List<PickUpGroup>();

            sip_conferooms = new List<SIPConferRoom>();

            auto_dialer_tasks = new List<AutoDialerTask>();
            call_back_queue = new Queue<AutoDialerTask>();

            wav_work = new SIPPBXWavWorkProcess();

            calllimit_enabled = false;
            call_credits = new List<CallLimit>();

            callblock_enabled = false;
            call_blocks = new List<CallBlock>();

            callback_enabled = false;
            call_backlist = new List<CallBack>();

            openai_nodes = new List<SIPPBXOpenAINode>();

            IPFilterList = new List<IPFilter>();

            share_confs = new Queue<ConfItem>();

            pbx_dir = Application.StartupPath;
            //pbx_dir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase);

            moh_dir = pbx_dir + "\\moh\\";
            CreateDir(moh_dir);

            please_enter_extension_number_dir = pbx_dir + "\\audio\\" + "Please-enter-extension-number.wav";
            please_enter_password_dir = pbx_dir + "\\audio\\" + "Please-enter-password.wav";
            please_leave_your_message_after_beep_dir = pbx_dir + "\\audio\\" + "Please-leave-your-message-after-beep.wav";
            please_record_your_greeting_dir = pbx_dir + "\\audio\\" + "Please-record-your-greeting-after-beep.wav";

            pbx_ringback_tone = pbx_dir + "\\audio\\" + "ringback-tone.wav";
            pbx_dial_tone = pbx_dir + "\\audio\\" + "dial-tone.wav";
            call_limit_prompt = pbx_dir + "\\audio\\" + "3m-call-limit.wav";

            log_dir = pbx_dir + "\\log\\";
            CreateDir(log_dir);

            report_dir = pbx_dir + "\\report\\";
            CreateDir(report_dir);

            record_dir = pbx_dir + "\\record\\";
            CreateDir(record_dir);

            plugin_dir = pbx_dir + "\\plugin\\";
            CreateDir(plugin_dir);

            vmb_dir = pbx_dir + "\\vmb\\";
            CreateDir(vmb_dir);

            //Directory.Delete(pbx_dir + "\\temp\\", true);
            CreateDir(pbx_dir + "\\temp\\");

            web_port = 8012;
            web_path = pbx_dir + "\\web\\";
            web_vroot = "/";
            web_addr_type = IPAddress.Any;

            try
            {
                string[] filePaths = Directory.GetFiles(pbx_dir + "\\temp\\");
                foreach (string filePath in filePaths)
                    File.Delete(filePath);
            }
            catch (Exception)
            {
            }

            //should add all files from temp folder
            //current only used by voice mail box recording

            log_level = 4;

            pickup_shortcode = "#";
            acd_number = "*9000";
            agent_login_number = "*71";
            agent_logout_number = "*72";
            vmb_code = "*91";

            blindtrans_code = "*#";
            consulttrans_code = "**";

            trunk_hook_flash_code = "*5";
            trunk_blindtrans_code = "*4";
            trunk_consulttrans_code = "*3";
            magic_cancel_code = "##";

            acd_agent_prompt1 = pbx_dir + "\\audio\\" + "Please-enter-agent-code.wav";
            acd_agent_prompt2 = pbx_dir + "\\audio\\" + "Please-enter-agent-password.wav";
            acd_agent_prompt3 = pbx_dir + "\\audio\\" + "login-ok.wav";
            acd_agent_prompt4 = pbx_dir + "\\audio\\" + "login-failed.wav";
            acd_agent_prompt5 = pbx_dir + "\\audio\\" + "logout-ok.wav";
            acd_agent_prompt6 = pbx_dir + "\\audio\\" + "logout-failed.wav";
            acd_agent_prompt7 = pbx_dir + "\\audio\\" + "Please-enter-acd-group-name.wav";
            acd_agent_prompt8 = pbx_dir + "\\audio\\" + "Please-enter-acd-group-name-to-logout.wav";
            acd_agent_prompt9 = pbx_dir + "\\audio\\" + "you-are-in-queue-position.wav";

            cdr_option = new PBXCDROption();

            pbx_sys_set = new SysOptionSet();

            no_audio_dur = 0;

            AudioFormat = 0;
            AudioEncode = 0;

            use_gpname_as_dispname = false;
            get_remote_contact_from_ring = false;

            RecordAllCalls = false;

            PBXVersion = "";
        }
    }

    public class SIPPBX : SIPPBXBase
    {
        public SIPPBXChan[] chan_list;

        //public int ChansPerSpan;
        //public int SpansPerBoard;
        //public int BoardsPerServer;
        public int ChanNum;

        //public int OutboundIndexStart;

        public string PBXLicKey;
        public bool bFreeVersion;
        public string LicOwner;
        public string LicExpDate;
        public int freeOutCallCount;

        public string USBKeyDriver;
        public string LicMAC;


        //load balance
        public bool lb_on; //if load balance is on
        public List<SIPPBXDest> lb_addrs; //address list
        public int lb_idx;

        public Queue acd_cdr_queue;
        public Queue pbx_cdr_queue;
        public Queue agent_cdr_queue;
        public Queue exten_cdr_queue;

        public SIPPBXManager manager;

        // the web server
        //public CassiniDevServer web_server;

        public SIPPBX() : base()
        {
            //ChansPerSpan = 4;
            //SpansPerBoard = 2;
            //BoardsPerServer = 1;
            //OutboundIndexStart = 6;
            ChanNum = 8;

            PBXLicKey = "";
            LicOwner = "";
            LicExpDate = "";

            bFreeVersion = true;
            freeOutCallCount = 0;

            USBKeyDriver = "";
            LicMAC = "";


            lb_on = false;
            lb_addrs = new List<SIPPBXDest>();
            lb_idx = 0;

            acd_cdr_queue = new Queue();
            pbx_cdr_queue = new Queue();
            agent_cdr_queue = new Queue();
            exten_cdr_queue = new Queue();
        }

        public void StartWebServer()
        {
            //A new way to use latest v4 is to call from command line
            /*
C:\SVNSrc\sipprojectv1\GTSIPPBXv3\CassiniDev 3.5.1.8-4.1.0.8 release\deploy\Rele
ase>CassiniDev4-console.exe /path:"C:\Users\Yonge\Documents\My Web Sites\Starter
 Site" /portMode:Specific /port:8012
started: http://localhost:8012/
Press Enter key to exit....   
             * 
https://cassinidev.codeplex.com/wikipage?title=Using%20CassiniDev%20to%20host%20ASP.Net%20in%20your%20application&referringTitle=Documentation
             * 
             */
/*
            try
            {
                web_server = new CassiniDevServer();
                //web_server = new Cassini.Server(web_port, web_vroot, web_path, web_addr_type);
                // our content is Copy Always into bin
                web_server.StartServer(web_path, web_port, web_vroot, "");
                //web_server.Start();
            }
            catch
            {

                //ShowError(
                    "Cassini Managed Web Server failed to start listening on port " + portNumber + ".\r\n" +
                    "Possible conflict with another Web Server on the same port.");
                //portTextBox.SelectAll();
                //portTextBox.Focus();

                return;
            }
 */
        }

        public void StopWebServer()
        {
/*
            try
            {
                if (web_server != null)
                {
                    web_server.StopServer();
                    web_server = null;
                }
            }
            catch
            {
            }*/
        }

        public void StartManager(GTSIPPBXEnv env)
        {
            manager = new SIPPBXManager();
            manager.pbx = this;
            manager.env = env;

            if (env.GetLicTo().Length == 0 || bFreeVersion || PBXLicKey.Length < 29)
            {
                manager.Start(sip_set.managerPort, "", 1);
            }
            else
            {
                manager.Start(sip_set.managerPort, "", 200);
            }

            wav_work.pbx = this;
            wav_work.env = env;
            wav_work.StartConvert();
        }

        public void StopManager()
        {
            wav_work.StopConvert();

            manager.Stop();
            manager = null;
        }

        public void LoadPlugins(GTSIPPBXEnv env)
        {
            plugins.Clear();

            string[] pluginFiles = Directory.GetFiles(plugin_dir, "*.DLL");
 
            for (int i = 0; i < pluginFiles.Length; i++)
            {
                /*
                string args = pluginFiles[i].Substring(
                    pluginFiles[i].LastIndexOf("\\") + 1,
                    pluginFiles[i].IndexOf(".DLL") -
                    pluginFiles[i].LastIndexOf("\\") - 1);
                 */

                //Type ObjType = null;
                try
                {
                    // load it
                    Assembly asm = null;
                    asm = Assembly.LoadFile(pluginFiles[i]);
                    if (asm != null)
                    {
                        Type[] types = asm.GetTypes();
                        //ObjType = ass.GetType(args + ".SIPPBXPluginClient");
                        foreach (Type t in types)
                        {
                            //if (t.ToString() == "Dynamic.SIPPBXPluginClient")
                            if (typeof(ISIPPBXPluginClient).IsAssignableFrom(t))
                            {
                                plugins.Add((ISIPPBXPluginClient)Activator.CreateInstance(t));
                            }
                        }
                    }
                }
                catch (Exception ex)
                {
                    env.LOG_Trace(1, ex.Message);
                    env.LogoutText(ex.Message);
                }
/*
                try
                {
                    // OK Lets create the object as we have the Report Type
                    if (ObjType != null)
                    {
                        plugins.Add((ISIPPBXPluginClient)Activator.CreateInstance(ObjType));
                        //ipi[i].Host = this;
                    }
                }
                catch (Exception ex)
                {
                    env.LOG_Trace(1, ex.Message);
                    env.LogoutText(ex.Message);
                }
*/
            }

        }

        public int getTotalChanCount()
        {
            return chan_list.GetLength(0);
        }

        public DBServerSetting GetDBServerSet()
        {
            if (db_set != null)
            {
                DBServerSetting db_set1 = new DBServerSetting();
                db_set1.CopyFrom(db_set);
                return db_set1;
            }

            return null;
        }

        public ISIPPBXPluginClient GetPluginClientInterfaceByName(string name)
        {
            for (int i = 0; i < plugins.Count; i++)
            {
                if (plugins[i].Name == name)
                    return plugins[i];
            }

            return null;
        }

        public void FreeSeizedOutboundChannel(GTAPIASM.GTAPIEnv env, int chan_idx)
        {
            GTAPIASM.GTAPIChan api_chan = env.GetChannel(chan_idx);

            if (api_chan != null)
                api_chan.Free();
        }

        public SIPPBXChan SeizeChannelForOutbound(GTAPIASM.GTAPIEnv env, int no_idx)
        {
            SIPPBXChan pbx_chan = null;
            GTAPIASM.GTAPIChan api_chan = null;
            int OutboundIndexStart = Convert.ToInt32(env.GetChannelCount() * (1.00 - (pbx_sys_set.OutPercent / 100.00)));

            //step 1: seize a channel
            for (int i = OutboundIndexStart; i < env.GetChannelCount(); i++)
            {
                if (i == no_idx) continue;

                api_chan = env.GetChannel(i);
                if (api_chan.Reserve())
                {
                    pbx_chan = chan_list[i];
                    return pbx_chan;
                }
            }

            if (pbx_chan == null)
            {
                for (int i = 0; i < OutboundIndexStart; i++)
                {
                    if (i == no_idx) continue;

                    api_chan = env.GetChannel(i);
                    if (api_chan.Reserve())
                    {
                        pbx_chan = chan_list[i];
                        return pbx_chan;
                    }
                }
            }

            return pbx_chan;
        }

        public SIPPBXChan SeizeChannelForOutbound(GTAPIASM.GTAPIEnv env)
        {
            SIPPBXChan pbx_chan = null;
            GTAPIASM.GTAPIChan api_chan = null;
            int OutboundIndexStart = Convert.ToInt32(env.GetChannelCount() * (1.00 - (pbx_sys_set.OutPercent / 100.00)));

            //step 1: seize a channel
            for (int i = OutboundIndexStart; i < env.GetChannelCount(); i++)
            {
                api_chan = env.GetChannel(i);
                if (api_chan.Reserve())
                {
                    pbx_chan = chan_list[i];
                    return pbx_chan;
                }
            }

            if (pbx_chan == null)
            {
                for (int i = 0; i < OutboundIndexStart; i++)
                {
                    api_chan = env.GetChannel(i);
                    if (api_chan.Reserve())
                    {
                        pbx_chan = chan_list[i];
                        return pbx_chan;
                    }
                }
            }

            return pbx_chan;
        }

        public void MakeSIPAddrCall(GTSIPPBXEnv env, int idx, string sCallee, string sCaller)
        {
            chan_list[idx].call_connected = false;
            chan_list[idx].call_reached_agent = false;
            chan_list[idx].acd_queue = null;
            chan_list[idx].acd_cdr_saved = false;
            chan_list[idx].in_queue_time = chan_list[idx].out_queue_time = DateTime.Now;
            chan_list[idx].acd_to_extn = null;

            env.Send_Make(idx, sCallee, sCaller);
        }

        public void MakeExtensionCall(GTSIPPBXEnv env, int idx, string sCallee, string sCaller, SIPPBXExten extn)
        {
            chan_list[idx].call_connected = false;
            chan_list[idx].call_reached_agent = false;

            chan_list[idx].acd_queue = null;
            chan_list[idx].acd_cdr_saved = false;
            chan_list[idx].in_queue_time = chan_list[idx].out_queue_time = DateTime.Now;

            chan_list[idx].acd_to_extn = null;
            chan_list[idx].link_exten = extn;

            if (extn != null)
            {
                env.LOG_Trace(4, "MakeExtensionCall extn.getChanIndexMask() returns " + extn.getChanIndexMask().ToString());

                if (extn.IsVirtualExten())
                    env.Send_Make(idx, sCallee, sCaller);
                else
                {
                    //env.Send_Make(idx, sCallee, sCaller, extn.ContactAddr, "", "", "", extn.RegSrcIP, extn.RegSrcPort);
                    if (extn.IsRegistered() && extn.MappedContactAddr.Length > 0)
                    {
                        //changed 2014/10/29
                        string portid = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, extn.MappedContactAddr);
                        if (portid == "") portid = "5060";

                        env.Send_Make(idx | extn.getChanIndexMask(), sCallee, sCaller, extn.ContactAddr, "", "", "", GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, extn.MappedContactAddr), Convert.ToUInt16(portid));
                    }
                    else
                        env.Send_Make(idx | extn.getChanIndexMask(), sCallee, sCaller, extn.ContactAddr, "", "", "");
                }
            }
            else
                env.Send_Make(idx, sCallee, sCaller);
        }

        public void MakeOutboundCall(GTSIPPBXEnv env, int idx, string sCallee, string sCaller, SIPAccount sip_acct)
        {
            chan_list[idx].call_connected = false;
            chan_list[idx].call_reached_agent = false;

            chan_list[idx].acd_queue = null;
            chan_list[idx].acd_cdr_saved = false;
            chan_list[idx].in_queue_time = chan_list[idx].out_queue_time = DateTime.Now;

            chan_list[idx].acd_to_extn = null;
            chan_list[idx].sip_acct = sip_acct;

            if (sip_acct.MappedExten.Length > 0)
            {
                SIPPBXExten extn = getExtensionByName(sip_acct.MappedExten);
                if (extn != null)
                {
                    env.LOG_Trace(4, "MakeOutboundCall extn.getChanIndexMask() returns " + extn.getChanIndexMask().ToString());

                    if (!extn.IsVirtualExten())
                    {
                        string sRealAddr = "";
                        if (extn.IsRegistered() && extn.MappedContactAddr.Length > 0)
                            sRealAddr = extn.MappedContactAddr;
                        else
                            sRealAddr = extn.ContactAddr;

                        if (sRealAddr.Length > 0)
                        {
                            string userName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sCallee);
                            string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sRealAddr);
                            string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, sRealAddr);

                            if (portName.Length > 0)
                                sRealAddr = "<sip:" + userName + "@" + domainName + ":" + portName + ">";
                            else
                                sRealAddr = "<sip:" + userName + "@" + domainName + ">";

                                env.Send_Make(idx | extn.getChanIndexMask(), sCallee, sCaller, sRealAddr, "", "", "");
                        }
                        return;
                    }
                }
            }
            
            env.Send_Make(idx, sCallee, sCaller, "", "", sip_acct.AuthName, sip_acct.Password);
        }

        public SIPPBXChan getChanByExten(SIPPBXExten extn)
        {
            if(extn == null)
                return null;

            for (int i = 0; i < ChanNum; i++)
            {
                if (chan_list[i].link_exten == extn)
                    return chan_list[i];
            }

            return null;
        }

        public void SetExtenCallingState(SIPPBXExten extn, GTSIPPBXEnv env, int state)
        {
            extn.InCalling = state;
            switch (extn.InCalling)
            {
                case 0: //idle
                    env.ProxyUpdateUserState(0, extn.UserName, "", "terminated");
                    break;
                case 10: //offered
                    env.ProxyUpdateUserState(0, extn.UserName, "initiator", "early");
                    break;
                case 20: //dialing
                    env.ProxyUpdateUserState(0, extn.UserName, "recipient", "early");
                    break;
                case 21: //ringing
                    env.ProxyUpdateUserState(0, extn.UserName, "recipient", "early");
                    break;
                case 30: //in call
                default:
                    env.ProxyUpdateUserState(0, extn.UserName, "", "confirmed");
                    //env.ProxyUpdateUserState(0, extn.UserName, "", "active");
                    break;
            }

            string sEventCmd = extn.UserName;

            sEventCmd += "|" + extn.InCalling.ToString();

            if(manager != null)
                manager.SendEvent("ExtenStatus", sEventCmd);
        }

        public int getNextSIPAccountID()
        {
            int maxID = 0;
            for (int i = 0; i < sip_acct.Count; i++)
            {
                if (sip_acct[i].AccID > maxID)
                    maxID = sip_acct[i].AccID;
            }
            return maxID + 1;
        }

        public SIPAccount getSIPAccountByID(int acc_id)
        {
            for (int i = 0; i < sip_acct.Count; i++)
            {
                if (sip_acct[i].AccID == acc_id)
                    return sip_acct[i];
            }

            return null;
        }

        public SIPAccount getSIPAccountByDomain(string acc_domain)
        {
            for (int i = 0; i < sip_acct.Count; i++)
            {
                if (sip_acct[i].DomainServer == acc_domain)
                    return sip_acct[i];
            }

            return null;
        }

        public SIPAccount getSIPAccountByDisplayName(string display_name)
        {
            for (int i = 0; i < sip_acct.Count; i++)
            {
                if (sip_acct[i].DisplayName == display_name)
                    return sip_acct[i];
            }

            return null;
        }

        public SIPAccount getSIPAccountByUserName(string user_name)
        {
            for (int i = 0; i < sip_acct.Count; i++)
            {
                if(string.Equals(sip_acct[i].UserName, user_name, StringComparison.OrdinalIgnoreCase))
                //if (sip_acct[i].UserName == user_name)
                    return sip_acct[i];
            }

            return null;
        }

        public IPFilter getSecurityFilterByID(int idx)
        {
            for (int i = 0; i < IPFilterList.Count; i++)
            {
                if (IPFilterList[i].DBIdx == idx)
                    return IPFilterList[i];
            }

            return null;
        }

        public int getSecurityFilterMaxID()
        {
            int maxID = 0;
            for (int i = 0; i < IPFilterList.Count; i++)
            {
                if (IPFilterList[i].DBIdx > maxID)
                    maxID = IPFilterList[i].DBIdx;
            }
            return maxID + 1;
        }

        public SIPPBXExten getExtensionBySIPAddr(string sip_addr)
        {
            string username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sip_addr);
            string domain = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sip_addr);

            //if (sip_proxy_sites[0].domainList.Contains(domain))
            //too strict, sometimes the phone use other domain or local up
                return getExtensionByName(username);

            //return null;
        }

        public SIPPBXExten getExtensionByName(string extn_name)
        {
            for (int i = 0; i < sip_exten.Count; i++)
            {
                if (sip_exten[i].UserName == extn_name)
                {
                    return sip_exten[i];
                }
            }

            return null;
        }

        public SIPPBXOpenAINode getOpenAIAgentByName(string agent_name)
        {
            for (int i = 0; i < openai_nodes.Count; i++)
            {
                if (openai_nodes[i].NodeName == agent_name)
                {
                    return openai_nodes[i];
                }
            }

            return null;
        }

        public SIPPBXAgent getAgentByName(string sName)
        {
            for (int i = 0; i < sip_agents.Count; i++)
            {
                if (sip_agents[i].Name == sName)
                {
                    return sip_agents[i];
                }
            }

            return null;
        }

        public SIPPBXAgent getAgentByCode(string agent_code)
        {
            for (int i = 0; i < sip_agents.Count; i++)
            {
                if (sip_agents[i].Code == agent_code)
                {
                    return sip_agents[i];
                }
            }

            return null;
        }

        public string getACDDigitName(SIPPBXACDHuntGroup acd)
        {
            string b = "";

            for (int i = 0; i < acd.hgName.Length; i++)
            {
                if (Char.IsDigit(acd.hgName[i]))
                    b += acd.hgName[i];
            }

            return b;
        }

        public SIPPBXACDHuntGroup getACDByDigit(string acd_digit_name)
        {
            for (int i = 0; i < sip_huntgroups.Count; i++)
            {
                if (getACDDigitName(sip_huntgroups[i]) == acd_digit_name)
                {
                    return sip_huntgroups[i];
                }
            }

            return null;

        }

        public SIPPBXACDHuntGroup getACDByName(string acd_name)
        {
            for (int i = 0; i < sip_huntgroups.Count; i++)
            {
                if (sip_huntgroups[i].hgName == acd_name)
                {
                    return sip_huntgroups[i];
                }
            }

            return null;
        }

        public SIPPBXPagingGroup getPagingGroupByName(string pg_name)
        {
            for (int i = 0; i < sip_paginggroups.Count; i++)
            {
                if (sip_paginggroups[i].gpName == pg_name)
                {
                    return sip_paginggroups[i];
                }
            }

            return null;
        }

        public SIPPBXRingGroup getRingGroupByName(string rg_name)
        {
            for (int i = 0; i < sip_ringgroups.Count; i++)
            {
                if (sip_ringgroups[i].gpName == rg_name)
                {
                    return sip_ringgroups[i];
                }
            }

            return null;
        }

        public AutoDialerTask getAutoDialerTaskByName(string sName)
        {
            for (int i = 0; i < auto_dialer_tasks.Count; i++)
            {
                if (auto_dialer_tasks[i].task_name == sName)
                {
                    return auto_dialer_tasks[i];
                }
            }

            return null;
        }

        public PickUpGroup getPickupGroupByName(string sName)
        {
            for (int i = 0; i < pickup_groups.Count; i++)
            {
                if (pickup_groups[i].name == sName)
                {
                    return pickup_groups[i];
                }
            }

            return null;
        }
        

        public bool DialPlanTimeMatched(SIPPBXDialPlan dp)
        {
            if (!dp.TimeLimited)
                return true;

            try
            {
                DateTime dt = DateTime.Now;
                DateTime dt1 = new DateTime(dt.Year, dt.Month, dt.Day, dp.TimeStartHour, dp.TimeStartMinute, 0);
                DateTime dt2 = new DateTime(dt.Year, dt.Month, dt.Day, dp.TimeEndHour, dp.TimeEndMinute, 0);

                int idxDay = 0;
                switch(dt.DayOfWeek)
                {
                    case DayOfWeek.Monday:
                        idxDay = 0;
                        break;
                    case DayOfWeek.Tuesday:
                        idxDay = 1;
                        break;
                    case DayOfWeek.Wednesday:
                        idxDay = 2;
                        break;
                    case DayOfWeek.Thursday:
                        idxDay = 3;
                        break;
                    case DayOfWeek.Friday:
                        idxDay = 4;
                        break;
                    case DayOfWeek.Saturday:
                        idxDay = 5;
                        break;
                    case DayOfWeek.Sunday:
                        idxDay = 6;
                        break;
                }

                if (dp.TimeDays[idxDay] == 0)
                    return false;

                if (dt1 <= dt2)
                {
                    if (dt >= dt1 && dt <= dt2)
                        return true;
                    else
                        return false;
                }
                else
                {
                    if (dt > dt2 && dt < dt1)
                        return false;
                    else
                        return true;
                }
            }
            catch (Exception)
            {
                return false;
            }

        }

        public SIPAccount getDialPlanSIPAccount(SIPPBXDialPlan dp)
        {
            SIPAccount acct = null;
            if (dp.OutboundSIPAcct >= 0 && dp.OutboundSIPAcct < sip_acct.Count)
            {
                //outbound, should take out predix digit, then use another channel to dialout
                acct = sip_acct[dp.OutboundSIPAcct];
                if (acct.RegWithProxyServer)
                {
                    if (acct.Registered)
                    {
                        return acct;
                    }
                }
                else
                    return acct;
            }

            if (dp.OutboundSIPAcct1 >= 0 && dp.OutboundSIPAcct1 < sip_acct.Count)
            {
                //outbound, should take out predix digit, then use another channel to dialout
                acct = sip_acct[dp.OutboundSIPAcct1];
                if (acct.RegWithProxyServer)
                {
                    if (acct.Registered)
                    {
                        return acct;
                    }
                }
                else
                    return acct;
            }

            if (dp.OutboundSIPAcct2 >= 0 && dp.OutboundSIPAcct2 < sip_acct.Count)
            {
                //outbound, should take out predix digit, then use another channel to dialout
                acct = sip_acct[dp.OutboundSIPAcct2];
                if (acct.RegWithProxyServer)
                {
                    if (acct.Registered)
                    {
                        return acct;
                    }
                }
                else
                    return acct;
            }

            return null;
        }

        public SIPPBXDialPlan getDialPlanByPlanName(string plan_name)
        {
            for (int i = 0; i < sip_dialplan.Count; i++)
            {
                if (String.Equals(sip_dialplan[i].planName, plan_name, StringComparison.OrdinalIgnoreCase)) //StringComparison.CurrentCultureIgnoreCase
                //if (sip_dialplan[i].planName == plan_name)
                    return sip_dialplan[i];
            }

            return null;
        }

        //dp_dir 0 = inbound 1 = outbound 2 = both
        public SIPPBXDialPlan getDialPlanByCalledNum(GTSIPPBXEnv env, string called_num, string called_ip, string caller_num, string caller_ip, SIPPBXExten caller_extn, int dp_dir)
        {
            SIPPBXDialPlan dp = null;

            //env.LOG_Trace(1, "getDialPlanByCalledNum CalledNum:" + called_num + " CalledIP:" + called_ip + " CallerNum:" + caller_num + " CallerIP:" + caller_ip);
            //env.LogoutText("getDialPlanByCalledNum CalledNum:" + called_num + " CalledIP:" + called_ip + " CallerNum:" + caller_num + " CallerIP:" + caller_ip);

            if (sip_dialplan.Count > 0)
            {
                //env.LOG_Trace(1, "getDialPlanByCalledNum 2.");
                //env.LogoutText("getDialPlanByCalledNum 2.");

                for (int i = 0; i < sip_dialplan.Count; i++)
                {
                    if (dp_dir == 0) //only need inbound plan
                    {
                        if (sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                            continue;
                    }
                    else if (dp_dir == 1) //only need outbound plan
                    {
                        if (sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
                            continue;
                    }

                    if (!DialPlanTimeMatched(sip_dialplan[i]))
                        continue;

                    dp = null;

                    //env.LOG_Trace(1, "getDialPlanByCalledNum 3." + sip_dialplan[i].planName);
                    //env.LogoutText("getDialPlanByCalledNum 3." + sip_dialplan[i].planName);

                    if (sip_dialplan[i].CallerID.Length > 0)
                    {
                        string dpCallerName = sip_dialplan[i].CallerID;
                        string dpCallerIP = "";

                        if (sip_dialplan[i].CallerID.Contains("@"))
                        {
                            dpCallerName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sip_dialplan[i].CallerID);
                            dpCallerIP = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sip_dialplan[i].CallerID);
                        }

                        //env.LOG_Trace(1, "getDialPlanByCalledNum 3-1. " + sip_dialplan[i].CallerID + " " + dpCallerName + " " + dpCallerIP);
                        //env.LogoutText("getDialPlanByCalledNum 3-1. " + sip_dialplan[i].CallerID + " " + dpCallerName + " " + dpCallerIP);

                        //if caller id takes effect on dialplan
                        if (dpCallerName.Contains("*") || dpCallerName.Contains("?"))
                        {
                            if (PatternMatch(dpCallerName, caller_num))
                                dp = sip_dialplan[i];
                            else
                            {
                                dp = null;
                                continue;
                            }
                        }
                        else
                        {
                            if (dpCallerName == caller_num)
                                dp = sip_dialplan[i];
                            else
                            {
                                dp = null;
                                continue;
                            }
                        }


                        if(dpCallerIP.Length > 0 && dpCallerIP != caller_ip)
                        {
                            dp = null;
                            continue;
                        }
                    }

                    if (sip_dialplan[i].CalledID.Length > 0)
                    {
                        string dpCalledName = sip_dialplan[i].CalledID;
                        string dpCalledIP = "";

                        if (sip_dialplan[i].CalledID.Contains("@"))
                        {
                            dpCalledName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sip_dialplan[i].CalledID);
                            dpCalledIP = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sip_dialplan[i].CalledID);
                        }

                        //env.LOG_Trace(1, "getDialPlanByCalledNum 3-2. " + sip_dialplan[i].CalledID + " " + dpCalledName + " " + dpCalledIP);
                        //env.LogoutText("getDialPlanByCalledNum 3-2. " + sip_dialplan[i].CalledID + " " + dpCalledName + " " + dpCalledIP);

                        if (dpCalledName.Contains("*") || dpCalledName.Contains("?"))
                        {
                            if (PatternMatch(dpCalledName, called_num))
                                dp = sip_dialplan[i];
                            else
                            {
                                dp = null;
                                continue;
                            }
                        }
                        else
                        {
                            if (dpCalledName == called_num)
                                dp = sip_dialplan[i];
                            else
                            {
                                dp = null;
                                continue;
                            }
                        }

                        if (dpCalledIP.Length > 0 && dpCalledIP != called_ip)
                        {
                            dp = null;
                            continue;
                        }
                    }

                    //env.LOG_Trace(1, "getDialPlanByCalledNum 4.");
                    //env.LogoutText("getDialPlanByCalledNum 4.");

//for outbound plan, check if the caller extension is in the list
                    //check if the caller is allowed to call out
                    if (dp != null)
                    {
                        //env.LOG_Trace(1, "getDialPlanByCalledNum 5." + dp.planName);
                        //env.LogoutText("getDialPlanByCalledNum 5." + dp.planName);

                        if (dp.MemberList != null)
                        {

                            //env.LOG_Trace(1, "getDialPlanByCalledNum 6.");
                            //env.LogoutText("getDialPlanByCalledNum 6.");

                            if (caller_extn == null)
                            {
                                dp = null;
                                continue;
                            }

                            bool FoundInList = false;

                            //env.LOG_Trace(1, "getDialPlanByCalledNum 7.");
                            //env.LogoutText("getDialPlanByCalledNum 7.");

                            for (int j = 0; j < dp.MemberList.members.Count; j++)
                            {

                                //env.LOG_Trace(1, "getDialPlanByCalledNum 8.");
                                //env.LogoutText("getDialPlanByCalledNum 8.");

                                if (dp.MemberList.mb_type == 0) //extension type
                                {
                                    //env.LOG_Trace(1, "getDialPlanByCalledNum 9.");
                                    //env.LogoutText("getDialPlanByCalledNum 9.");

                                    if (dp.MemberList.members[j] == caller_extn.UserName)
                                    {
                                        //env.LOG_Trace(1, "getDialPlanByCalledNum 10.");
                                        //env.LogoutText("getDialPlanByCalledNum 10.");

                                        FoundInList = true;
                                        break;
                                    }
                                }
                                else //agent code
                                {
                                    //env.LOG_Trace(1, "getDialPlanByCalledNum 11.");
                                    //env.LogoutText("getDialPlanByCalledNum 11.");

                                    if (caller_extn.Agent != null)
                                    {
                                        //env.LOG_Trace(1, "getDialPlanByCalledNum 12.");
                                        //env.LogoutText("getDialPlanByCalledNum 12.");

                                        if (dp.MemberList.members[j] == caller_extn.Agent.Code)
                                        {
                                            //env.LOG_Trace(1, "getDialPlanByCalledNum 13.");
                                            //env.LogoutText("getDialPlanByCalledNum 13.");

                                            FoundInList = true;
                                            break;
                                        }
                                    }
                                }
                            }

                            if (!FoundInList)
                            {
                                dp = null;
                                continue;
                            }

                        }
                    }

                    if (dp == null)
                    {
                        //env.LOG_Trace(1, "getDialPlanByCalledNum 14, null.");
                        //env.LogoutText("getDialPlanByCalledNum 14. null.");
                    }
                    else
                    {
                        //env.LOG_Trace(1, "getDialPlanByCalledNum 14." + dp.planName);
                        //env.LogoutText("getDialPlanByCalledNum 14." + dp.planName);
                    }

                    if (dp != null)
                        break;
                }
            }

            return dp;
        }

        public bool PatternMatch(string pattern, string s1)
        {
            int idx = 0;
            int j = 0;
            for (j = 0; j < s1.Length && idx < pattern.Length; j++)
            {
                if (pattern[idx] == '*')
                {
                    if (idx < pattern.Length - 1)
                    {
                        if (s1[j] != pattern[idx + 1])
                        {
                            continue;
                        }
                        else
                        {
                            idx += 2;
                            continue;
                        }
                    }
                    else
                        return true;
                }
                else if (pattern[idx] == '?')
                {
                    idx++;
                    continue;
                }
                else
                {
                    if (s1[j] != pattern[idx])
                    {
                        return false;
                    }
                    else
                    {
                        idx++;
                    }
                }
            }

            if (j == s1.Length && idx == pattern.Length)
                return true;
            else
                return false;

        }

        public bool isTrunkHookFlashCode(string dtmfStr)
        {
            if (dtmfStr.Contains(trunk_hook_flash_code))
                return true;

            return false;
        }

        public string isTrunkConsultTransferCode(string dtmfStr)
        {
            if (dtmfStr.Contains(trunk_consulttrans_code) && dtmfStr.EndsWith("#"))
            {
                int pos1 = dtmfStr.LastIndexOf(trunk_consulttrans_code);

                if (pos1 == -1) //no match at all
                    return "";

                string sNum = dtmfStr.Substring(pos1 + trunk_consulttrans_code.Length);

                if (sNum.Length == 0)
                    return "";

                sNum = sNum.TrimEnd('#');

                return sNum;
            }

            return "";
        }

        public string isTrunkBlindTransferCode(string dtmfStr)
        {
            if (dtmfStr.Contains(trunk_blindtrans_code) && dtmfStr.EndsWith("#"))
            {
                int pos1 = dtmfStr.LastIndexOf(trunk_blindtrans_code);

                if (pos1 == -1) //no match at all
                    return "";

                string sNum = dtmfStr.Substring(pos1 + trunk_blindtrans_code.Length);

                if (sNum.Length == 0)
                    return "";

                sNum = sNum.TrimEnd('#');

                return sNum;
            }

            return "";
        }

        public SIPPBXExten isBlindTransfer(string dtmfStr)
        {
            for (int i = 0; i < sip_exten.Count; i++)
            {
                string s1 = blindtrans_code + sip_exten[i].UserName;

                if (dtmfStr.Length >= s1.Length)
                {
                    string s = dtmfStr.Substring(dtmfStr.Length - s1.Length);

                    if (s == s1)
                    {
                        return sip_exten[i];
                    }
                }
            }

            for (int i = 0; i < sip_agents.Count; i++)
            {
                string s1 = blindtrans_code + sip_agents[i].Code;

                if (dtmfStr.Length >= s1.Length)
                {
                    string s = dtmfStr.Substring(dtmfStr.Length - s1.Length);

                    if (s == s1 && sip_agents[i].AtExten != null)
                    {
                        return sip_agents[i].AtExten;
                    }
                }
            }

            return null;
        }

        public SIPPBXExten isConsultTransfer(string dtmfStr)
        {
            for (int i = 0; i < sip_exten.Count; i++)
            {
                string s1 = consulttrans_code + sip_exten[i].UserName;

                if (dtmfStr.Length >= s1.Length)
                {
                    string s = dtmfStr.Substring(dtmfStr.Length - s1.Length);

                    if (s == s1)
                    {
                        return sip_exten[i];
                    }
                }
            }

            for (int i = 0; i < sip_agents.Count; i++)
            {
                string s1 = consulttrans_code + sip_agents[i].Code;

                if (dtmfStr.Length >= s1.Length)
                {
                    string s = dtmfStr.Substring(dtmfStr.Length - s1.Length);

                    if (s == s1 && sip_agents[i].AtExten != null)
                    {
                        return sip_agents[i].AtExten;
                    }
                }
            }

            return null;
        }

        public SIPPBXDialPlanWrap isDialplanTransfer(GTSIPPBXEnv env, SIPPBXChan pbxChan, string caller_num, SIPPBXExten caller_extn)
        {
            string sNum = "";
            string dtmfStr = pbxChan.link_dtmf;
            int pos1 = dtmfStr.LastIndexOf(consulttrans_code);
            int pos2 = dtmfStr.LastIndexOf(blindtrans_code);
            int trans_type = 1;

            if (pos1 == -1 && pos2 == -1) //no match at all
                return null;

            if (pos1 > pos2 && pos1 != -1)
            {
                sNum = dtmfStr.Substring(pos1 + consulttrans_code.Length);
                trans_type = 2;
            }
            else if (pos2 > pos1 && pos2 != -1)
            {
                sNum = dtmfStr.Substring(pos2 + blindtrans_code.Length);
            }
            else if (pos1 != -1) //should be impossible here except consulttrans_code & blindtrans_code are set same  
            {
                sNum = dtmfStr.Substring(pos1 + consulttrans_code.Length);
                trans_type = 2;
            }

            if (sNum.Length == 0)
                return null;

            if (!sNum.EndsWith("#"))
                return null;

            sNum = sNum.TrimEnd('#');

            //0 == inbound dialplan, 1 == outbound dialplan, 2 == both
            SIPPBXDialPlan dp = getDialPlanByCalledNum(env, sNum, "", caller_num, "", caller_extn, 2);
            if (dp == null)
            {
                //reset the pbxChan's link_dtmf
                pbxChan.link_dtmf = "";
                return null;
            }

            SIPPBXDialPlanWrap wrap = new SIPPBXDialPlanWrap();
            wrap.dp = dp;
            wrap.called_id = sNum;
            wrap.trans_type = trans_type;

            return wrap;
        }

        //note: here caller_num is full sip address, but called_num is just the called_id before IP
        public SIPPBXVirExtenTransferWrap transferCallToVirtualExtension(GTSIPPBXEnv env, SIPPBXExten vir_extn, SIPPBXChan pbxChan, string caller_num, string called_num)
        {
            GTAPIASM.GTAPIChan api_chan = env.GetChannel(pbxChan.index);

            string sipDestAddr = vir_extn.VirtualExtenDestAddr;
            if (vir_extn.VirtualExtenDestAddr.Contains("*"))
                sipDestAddr = vir_extn.VirtualExtenDestAddr.Replace("*", called_num);

            SIPPBXDialPlan dp1 = env.pbx.getDialPlanByCalledNum(env, sipDestAddr, "", GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, caller_num), env.pbx.getExtensionBySIPAddr(caller_num), 1);
            if (dp1 != null)
            {
                SIPAccount sip_acct = env.pbx.getDialPlanSIPAccount(dp1);
                if (sip_acct != null)
                {
                    //outbound, should take out prefix digit, then use another channel to dialout
                    string destaddr = dp1.OutboundPrepend + sipDestAddr.Substring(dp1.OutboundPreStrip.Length);
                    if (vir_extn.bAcceptOtherID && called_num.Length > 0 && !vir_extn.VirtualExtenDestAddr.Contains("*"))
                        destaddr = dp1.OutboundPrepend + called_num.Substring(dp1.OutboundPreStrip.Length);

                    destaddr += "@" + sip_acct.DomainServer;
                    destaddr = "<sip:" + destaddr + ">";

                    string fromaddr = sip_acct.UserName;
                    if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                    {
                        SIPPBXExten ext0 = env.pbx.getExtensionBySIPAddr(caller_num);
                        if (ext0 != null)
                        {
                            if (ext0.AlternativePhoneNumber.Length > 0)
                            {
                                fromaddr = ext0.AlternativePhoneNumber;
                            }
                            else if (sip_acct.DIDList.Count > 0)
                            {
                                fromaddr = sip_acct.DIDList[0];

                                if (sip_acct.OutboundAppendExtenID)
                                    fromaddr += ext0.UserName;
                            }
                        }
                        else
                        {
                            fromaddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
                            if (fromaddr == "unknown")
                                fromaddr = sip_acct.UserName;
                        }
                    }

                    if (fromaddr == "")
                    {
                        if (caller_num.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                            fromaddr = caller_num;
                        else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                            fromaddr = sip_acct.DIDList[0];
                        else if (sip_acct.UserName.Length > 0)
                            fromaddr = sip_acct.UserName;
                        else
                            fromaddr = "unknown";
                    }

                    if (sip_acct.UseLocalIPInFrom)
                    {
                        if (env.pbx.sip_set.sipAddr.Length > 0)
                            fromaddr += "@" + env.pbx.sip_set.sipAddr;
                        else
                            fromaddr += "@" + env.GetMappedPublicSIPIPAddress();
                    }
                    else
                        fromaddr += "@" + sip_acct.DomainServer;

                    fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";

                    SIPPBXVirExtenTransferWrap wrap = new SIPPBXVirExtenTransferWrap();
                    wrap.caller = fromaddr;
                    wrap.callee = destaddr;
                    wrap.extn = vir_extn;
                    wrap.acct = sip_acct;

                    return wrap;
                }
            }
            return null;
        }

        public SIPPBXParkingSlot getParkingSlotByName(string sName)
        {
            for (int i = 0; i < sip_parkingslots.Count; i++)
            {
                if (sip_parkingslots[i].psName == sName)
                {
                    return sip_parkingslots[i];
                }
            }

            return null;
        }

        public SIPPBXParkingSlot getParkingSlot(string dtmfStr)
        {
            for (int i = 0; i < sip_parkingslots.Count; i++)
            {
                if (dtmfStr.Length >= sip_parkingslots[i].psDTMF.Length)
                {
                    string s = dtmfStr.Substring(dtmfStr.Length - sip_parkingslots[i].psDTMF.Length);

                    if (sip_parkingslots[i].pbxChan == null && s == sip_parkingslots[i].psDTMF)
                    {
                        return sip_parkingslots[i];
                    }
                }
            }

            return null;
        }

        public SIPPBXParkingSlot getParkingSlotByNumber(string sNumber)
        {
            for (int i = 0; i < sip_parkingslots.Count; i++)
            {
                if (sip_parkingslots[i].pbxChan != null && sip_parkingslots[i].psDTMF == sNumber)
                {
                    return sip_parkingslots[i];
                }
            }

            return null;
        }

        public SIPPBXMonitorGroup getMonitorGroupByName(string sName)
        {
            for (int i = 0; i < sip_monitorgroups.Count; i++)
            {
                if (sip_monitorgroups[i].mgName == sName)
                {
                    return sip_monitorgroups[i];
                }
            }

            return null;
        }

        public SIPPBXMonitorGroup getMonitorGroupByNumber(string sNumber)
        {
            for (int i = 0; i < sip_monitorgroups.Count; i++)
            {
                if (sip_monitorgroups[i].mgNumber == sNumber)
                {
                    return sip_monitorgroups[i];
                }
            }

            return null;
        }

        public SIPPBXIVR getIVRMenuByName(string ivr_name)
        {
            for (int i = 0; i < sip_ivrs.Count; i++)
            {
                if(sip_ivrs[i].name == ivr_name)
                {
                    return sip_ivrs[i];
                }
            }

            return null;
        }

        public bool SetChanIntoConferenceRoom(GTSIPPBXEnv env, SIPPBXChan pbx_chan, string conf_name, int opt)
        {
            bool ret = true;
            SIPConferRoom room = getConferenceRoomByName(conf_name);
            if (room != null)
            {
                if (room.conf_chans.Contains(pbx_chan))
                {
                    string logInfo = "Channel " + pbx_chan.index.ToString() + " is already in conference room conf_name.";
                    env.LogoutText(logInfo);
                    env.pbx.manager.SendConferenceStatus(room, IntPtr.Zero);
                    ret = true;
                }
                else
                {
                    pbx_chan.async_op_compound = new GTOpConference(env.pbx, env, pbx_chan, room, opt);
                    pbx_chan.async_op_compound.start();
                    /*
                                    if (room.conf_max_num > 0)
                                    {
                                        if (room.conf_chans.Count < room.conf_max_num)
                                        {
                                            env.SetChanInConf((uint)room.conf_handle, pbx_chan.index, opt);
                                            room.conf_chans.Add(pbx_chan);                
                                        }
                                        else
                                        {
                                            env.LogoutText("Cannot add channel into conference room(" + conf_name + ") for incoming calls, because it has reached the max number of calls for this conference room.");
                                            env.Send_HangUp(pbx_chan.index, 0, "");
                                            ret = false;
                                        }
                                    }
                                    else
                                    {
                                        env.SetChanInConf((uint)room.conf_handle, pbx_chan.index, opt);
                                        room.conf_chans.Add(pbx_chan);
                                    }
                     */
                }
            }
            else
            {
                string logInfo = "Cannot find conference room(" + conf_name + ") for incoming calls.";
                env.LogoutText(logInfo);
                env.DisconnectCall(pbx_chan.index, 0, "", "PBX: " + logInfo);
                ret = false;
            }

/*
            if (ret)
            {           
                if (room.join_prompt.Length > 0)
                {
                    env.Send_ConfPlayAudio(env.GetConfIndex((uint)room.conf_handle), room.join_prompt, 0, "", 0, 0);
                }
            }
*/
            return ret;
        }

        public void RemoveChanFromConferenceRoom(GTSIPPBXEnv env, SIPPBXChan pbx_chan)
        {
            for (int i = 0; i < sip_conferooms.Count; i++)
            {
                SIPConferRoom room = sip_conferooms[i];
                if (room.conf_chans.Contains(pbx_chan))
                {
                    /*
                    room.conf_chans.Remove(pbx_chan);
                    if (room.conf_chans.Count > 0 && room.leave_prompt.Length > 0)
                    {
                        //there are still members in conference room. play leaving prompt
                        env.Send_ConfPlayAudio(env.GetConfIndex((uint)room.conf_handle), room.leave_prompt, 0, "", 0, 0);
                    }*/
                    try
                    {
                        if (pbx_chan.async_op_compound != null)
                        {
                            GTOpConference conf_comp = (GTOpConference)pbx_chan.async_op_compound;
                            conf_comp.RemoveChanFromConferenceRoom();
                        }
                    }
                    catch (Exception ex)
                    {
                        env.LogoutText(ex.ToString());
                    }
                }
            }
        }

        public SIPConferRoom getConferenceRoomByName(string conf_name)
        {
            for (int i = 0; i < sip_conferooms.Count; i++)
            {
                if (sip_conferooms[i].conf_name == conf_name)
                {
                    return sip_conferooms[i];
                }
            }

            return null;
        }

        public SIPPBXParkingSlot IsPBXChanInParkingSlot(SIPPBXChan chan)
        {
            for (int i = 0; i < sip_parkingslots.Count; i++)
            {
                if (sip_parkingslots[i].pbxChan == chan)
                {
                    return sip_parkingslots[i];
                }
            }

            return null;
        }

        public string GetTargetDID(string to_id, string uri_id)
        {
            if (to_id == uri_id)
                return to_id;

            SIPAccount acct = getSIPAccountByUserName(to_id);
            if (acct != null)
            {
                if (acct.DIDList.Contains(uri_id))
                    return uri_id;
                else
                    return to_id;
            }
            else
            {
                acct = getSIPAccountByUserName(uri_id);
                if (acct != null)
                {
                    if (acct.DIDList.Contains(to_id))
                        return to_id;
                    else
                        return uri_id;
                }
            }

            return to_id;
        }

        public void SaveCDRToTxtFile(string header, string cdr_str, string fn, GTSIPPBXEnv env)
        {
            int retry_count = 0;

            if (cdr_str.Length > 0)
            {
            cdr_again:
                try
                {
                    FileInfo fi = new FileInfo(fn);
                    if (!fi.Exists) cdr_str = header + "\r\n" + cdr_str;

                    FileStream file = new FileStream(fn, FileMode.Append, FileAccess.Write);
                    StreamWriter sw = new StreamWriter(file);
                    sw.WriteLine(cdr_str);
                    sw.Close();
                    file.Close();
                }
                catch (Exception)
                {
                    if (retry_count++ < 3)
                    {
                        Thread.Sleep(100);
                        env.ProcessGTAPIEvent();
                        goto cdr_again;
                    }
                }
            }
        }

        public static string getFileExtension(string fileName)
        {
            /*
            string extension = "";
            char[] arr = fileName.ToCharArray();
            int index = 0;
            for (int i = 0; i < arr.Length; i++)
            {
                if (arr[i] == '.')
                {
                    index = i; //get the last dot in the string 
                }
            }
            for (int x = index + 1; x < arr.Length; x++)//build the new string 
            {
                extension = extension + arr[x];
            }

            return extension;
            */
            FileInfo fi = new FileInfo(fileName);
            return fi.Extension;
        }

        public static string GetFileNameOnly(string sFileName)
        {
            FileInfo fi = new FileInfo(sFileName);
            string ext = fi.Extension;
            string fn = fi.Name;
            string fn1 = "";
            for (int i = 0; i < fn.Length - ext.Length; i++)
            {
                fn1 += fn[i];
            }
            return fn1;
        }

        public string handleAudioFileName(string fn)
        {

            string cmd1, cmd2, cmd3;
            string tempPath = System.IO.Path.GetTempPath();

            if (tempPath[tempPath.Length - 1] != '\\')
                tempPath += "\\";

            cmd1 = tempPath + "*.wav";
            cmd2 = tempPath + "*.mp3";
            cmd3 = tempPath + "*.gsm";

            try
            {
                File.Delete(cmd1);
                File.Delete(cmd2);
                File.Delete(cmd3);
            }
            catch (Exception)
            {

            }

            string fname = GetFileNameOnly(fn);
            string fext = getFileExtension(fn);
            string fnwav;

            if (fext == ".wzp")
            {
                fnwav = tempPath + fname + ".wav";

                try
                {
                    File.Delete(fnwav);
                }
                catch (Exception)
                {
                }

                GTAPIASM.GTEncode.FileDecode(fn, fnwav);
                fn = fnwav;
            }
            else if (fext == ".mzp")
            {
                fnwav = tempPath + fname + ".mp3";

                try
                {
                    File.Delete(fnwav);
                }
                catch (Exception)
                {
                }

                GTAPIASM.GTEncode.FileDecode(fn, fnwav);
                fn = fnwav;
            }
            else if (fext == ".gzp")
            {
                fnwav = tempPath + fname + ".gsm";

                try
                {
                    File.Delete(fnwav);
                }
                catch (Exception)
                {
                }

                GTAPIASM.GTEncode.FileDecode(fn, fnwav);
                fn = fnwav;
            }

            return fn;

        }

        public string processAudioFormatAndEncode(string fn, bool doConvert)
        {
            if (fn.Length > 0)
            {
                if (AudioFormat == 0 && AudioEncode == 1)
                {
                    if(doConvert)
                        wav_work.AddJob(fn, 0, AudioEncode);
                    return fn.Replace(".wav", ".wzp");
                }
                else if (AudioFormat == 1 && fn.Contains(".wav")) //needs mp3, convert first, then encode if needed
                {
                    if (doConvert)
                        wav_work.AddJob(fn, 1, AudioEncode);
                    if (AudioEncode == 1)
                    {
                        return fn.Replace(".wav", ".mzp");
                    }
                    else
                    {
                        return fn.Replace(".wav", ".mp3");
                    }
                }
                else if(AudioFormat == 1 && fn.Contains(".mp3") && AudioEncode == 1) //already mp3, only encode
                {
                    if (doConvert)
                        wav_work.AddJob(fn, 1, AudioEncode);
                    return fn.Replace(".mp3", ".mzp");
                }
                else if (AudioFormat == 2 && fn.Contains(".wav")) //needs gsm
                {
                    //gsm is still using gzp file.
                    if (doConvert)
                        wav_work.AddJob(fn, 2, AudioEncode);
                    if (AudioEncode == 1)
                        return fn.Replace(".wav", "_gsm.wzp");
                    else
                        return fn.Replace(".wav", "_gsm.wav");
                }
            }

            return fn;
           
        }

        public void SaveCDRQueue(GTSIPPBXEnv env, DBServerSetting active_dbset)
        {
            string sTxt = "";

            if ((pbx_cdr_queue.Count > 0 && cdr_option.pbx_cdr_to_db()) ||
                (acd_cdr_queue.Count > 0 && cdr_option.acd_cdr_to_db()) ||
                (exten_cdr_queue.Count> 0 && cdr_option.exten_cdr_to_db()) || 
                (agent_cdr_queue.Count> 0 && cdr_option.agent_cdr_to_db()))
            {
                /*
                if (active_dbset != null)
                {
                    if (!active_dbset.IsDBConnected())
                    {
                        env.LOG_Trace(1, "****Cannot open database connection.");
                        env.LogoutText("****Cannot open database connection.");
                    }
                }
                else
                {
                    env.LOG_Trace(1, "****There is no active database connection for cdr logging.");
                    env.LogoutText("****There is no active database connection for cdr logging.");
                }
                */
            }

            while (pbx_cdr_queue.Count > 0)
            {
                PBX_CDR cdr = (PBX_CDR)pbx_cdr_queue.Dequeue();
                if (cdr == null) break;

                if(cdr.record_file.Length > 0)
                    cdr.record_file = processAudioFormatAndEncode(cdr.record_file, cdr.do_convert);

                if (cdr_option.pbx_cdr_to_txt()) //save to text file
                {
                    if(sTxt.Length == 0)
                        sTxt += cdr.GetTxtCDR();
                    else
                        sTxt += "\r\n" + cdr.GetTxtCDR();
                }

                if (cdr_option.pbx_cdr_to_db()) //save to DB
                {
                    if (!cdr.SaveToDB(active_dbset))
                    {
                        env.LOG_Trace(1, "****Cannot save pbx cdr log into database.");
                        env.LogoutText("****Cannot save pbx cdr log into database.");
                        env.LOG_Trace(1, "Caller:" + cdr.caller);
                        env.LOG_Trace(1, "Callee:" + cdr.callee);
                        env.LOG_Trace(1, "RecordFile:" + cdr.record_file);
                        env.LOG_Trace(1, "DiscReason:" + cdr.discReason);
                        env.LOG_Trace(1, "ConfName:" + cdr.confName);
                        env.LOG_Trace(1, "Resetting DB Connection ......");
                        try 
                        { 
                            active_dbset.DisconnectDB(); 
                        }
                        catch (Exception ex) 
                        {
                            env.LOG_Trace(1, "Disconnecting DB error: " + ex.ToString());
                        }
                        try
                        {
                            active_dbset.ConnectDB();
                        }
                        catch (Exception ex)
                        {
                            env.LOG_Trace(1, "Reconnecting DB error: " + ex.ToString());
                        }
                    }
                }
            }

            SaveCDRToTxtFile(PBX_CDR.GetTxtHeader(), sTxt, report_dir + "pbx_cdr.txt", env);

            sTxt = "";

            while (acd_cdr_queue.Count > 0)
            {
                ACD_CDR cdr = (ACD_CDR)acd_cdr_queue.Dequeue();
                if (cdr == null) break;

                cdr.record_file = processAudioFormatAndEncode(cdr.record_file, cdr.do_convert);

                if (cdr_option.acd_cdr_to_txt()) //save to text file
                {
                    if (sTxt.Length == 0)
                        sTxt += cdr.GetTxtCDR();
                    else
                        sTxt += "\r\n" + cdr.GetTxtCDR();
                }

                if (cdr_option.acd_cdr_to_db()) //save to DB
                {
                    if (!cdr.SaveToDB(active_dbset))
                    {
                        env.LOG_Trace(1, "****Cannot save acd cdr log into database.");
                        env.LogoutText("****Cannot save acd cdr log into database.");
                        try { active_dbset.DisconnectDB(); }
                        catch (Exception) { }
                        active_dbset.ConnectDB();
                    }
                }
            }

            SaveCDRToTxtFile(ACD_CDR.GetTxtHeader(), sTxt, report_dir + "acd_cdr.txt", env);

            sTxt = "";

            while (exten_cdr_queue.Count > 0)
            {
                Exten_CDR cdr = (Exten_CDR)exten_cdr_queue.Dequeue();
                if(cdr == null) break;

                cdr.record_file = processAudioFormatAndEncode(cdr.record_file, cdr.do_convert);

                if (cdr_option.exten_cdr_to_txt()) //save to text file
                {
                    if (sTxt.Length == 0)
                        sTxt += cdr.GetTxtCDR();
                    else
                        sTxt += "\r\n" + cdr.GetTxtCDR();
                }
                if (cdr_option.exten_cdr_to_db()) //save to DB
                {
                    if (!cdr.SaveToDB(active_dbset))
                    {
                        env.LOG_Trace(1, "****Cannot save extension cdr log into database.");
                        env.LogoutText("****Cannot save extension cdr log into database.");
                        try { active_dbset.DisconnectDB(); }
                        catch (Exception) { }
                        active_dbset.ConnectDB();
                    }
                }
            }

            SaveCDRToTxtFile(Exten_CDR.GetTxtHeader(), sTxt, report_dir + "exten_cdr.txt", env);

            sTxt = "";

            while (agent_cdr_queue.Count > 0)
            {
                Agent_CDR cdr = (Agent_CDR)agent_cdr_queue.Dequeue();
                if (cdr == null) break;

                if (cdr_option.agent_cdr_to_txt()) //save to text file
                {
                    if (sTxt.Length == 0)
                        sTxt += cdr.GetTxtCDR();
                    else
                        sTxt += "\r\n" + cdr.GetTxtCDR();
                }
                if (cdr_option.agent_cdr_to_db()) //save to DB
                {
                    if (!cdr.SaveToDB(active_dbset))
                    {
                        env.LOG_Trace(1, "****Cannot save agent cdr log into database.");
                        env.LogoutText("****Cannot save agent cdr log into database.");
                        try { active_dbset.DisconnectDB(); }
                        catch (Exception) { }
                        active_dbset.ConnectDB();
                    }
                }
            }

            SaveCDRToTxtFile(Agent_CDR.GetTxtHeader(), sTxt, report_dir + "agent_cdr.txt", env);

        }

        public void WriteAgentCDR(SIPPBXExten extn, SIPPBXAgent agent, bool login, string p1, string p2, string p3)
        {
            Agent_CDR agent_cdr = new Agent_CDR();

            agent_cdr.agent_code = agent.Code;
            if (login)
            {
                agent_cdr.agent_log_action = 1;
                agent_cdr.agent_log_time = agent.LogInTime.ToString("yyyy-MM-dd HH:mm:ss");
            }
            else
            {
                agent_cdr.agent_log_action = 0;
                agent_cdr.agent_log_time = agent.LogOutTime.ToString("yyyy-MM-dd HH:mm:ss");
            }
            agent_cdr.agent_log_exten = extn.UserName;

            //trying to use p1 space to save ACD ids
            for (int i = 0; i < agent.LoggedInACD.Count; i++)
            {
                p1 += ";" + agent.LoggedInACD[i];
            }

            agent_cdr.param1 = p1;
            agent_cdr.param2 = p2;
            agent_cdr.param3 = p3;

            agent_cdr_queue.Enqueue(agent_cdr);
        }

/*
        public void WriteAgentCDR(SIPPBXExten extn, SIPPBXAgent agent, bool login)
        {
            int retry_count = 0;

            string fn = report_dir + "agent_cdr.txt";
            string cdrstr;
            if(login)
                cdrstr = agent.Code + ",1," + agent.LogInTime.ToString("yyyy-MM-dd HH:mm:ss") + "," + extn.UserName;
            else
                cdrstr = agent.Code + ",0," + agent.LogOutTime.ToString("yyyy-MM-dd HH:mm:ss") + "," + extn.UserName;

cdr_again1:
            try
            {
                FileStream file = new FileStream(fn, FileMode.Append, FileAccess.Write);
                StreamWriter sw = new StreamWriter(file);
                sw.WriteLine(cdrstr);
                sw.Close();
                file.Close();
            }
            catch (Exception)
            {
                if (retry_count++ < 3)
                {
                    Thread.Sleep(100);
                    goto cdr_again1;
                }
            }
        }
*/

        public void WriteACDCDR(GTAPIASM.GTAPIChan api_chan, SIPPBXChan pbx_chan)
        {
            ACD_CDR acd_cdr = new ACD_CDR();

            if (pbx_chan.acd_queue != null)
            {
                acd_cdr.acd_name = pbx_chan.acd_queue.hgName;
                acd_cdr.acd_in_time = pbx_chan.in_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                acd_cdr.acd_out_time = pbx_chan.out_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                if (pbx_chan.acd_to_extn != null)
                {
                    acd_cdr.acd_to_exten = pbx_chan.acd_to_extn.UserName;
                    if (pbx_chan.acd_to_extn.Agent != null)
                    {
                        acd_cdr.acd_to_agent = pbx_chan.acd_to_extn.Agent.Code;
                        if (pbx_chan.acd_to_extn.Agent.RecordCall)
                            acd_cdr.record_file = pbx_chan.RecordFileName;
                    }
                    else if (pbx_chan.acd_to_extn.RecordCall)
                    {
                        acd_cdr.record_file = pbx_chan.RecordFileName;
                    }
                }

                acd_cdr.connected = pbx_chan.call_connected ?(pbx_chan.call_reached_agent?2:1) : 0;
                acd_cdr.caller = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num);
                acd_cdr.callee = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num);
                acd_cdr.start_time = api_chan.call_start_time.ToString("yyyy-MM-dd HH:mm:ss");
                acd_cdr.end_time = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");

                acd_cdr.unique_call_id = pbx_chan.unique_call_id;
                acd_cdr.inbound = pbx_chan.call_dir == 0; //!api_chan.originate;
                acd_cdr.transferred = pbx_chan.transferred;
                //acd_cdr.ivrKeys = pbx_chan.ivrKeys;

                acd_cdr.discReason = pbx_chan.discReason;
                acd_cdr.hangupParty = pbx_chan.hangupParty;

                acd_cdr.chan_id = pbx_chan.index;

                acd_cdr_queue.Enqueue(acd_cdr);
            }
        }

/*
        public void WriteACDCDR(GTAPIASM.GTAPIChan api_chan, SIPPBXChan pbx_chan)
        {
            int retry_count = 0;

            if (pbx_chan.acd_queue != null)
            {
                string fn = report_dir + "acd_cdr.txt";
                string cdrstr = pbx_chan.acd_queue.hgName + "," + pbx_chan.in_queue_time.ToString("yyyy-MM-dd HH:mm:ss") + "," + pbx_chan.out_queue_time.ToString("yyyy-MM-dd HH:mm:ss") + ",";
                if (pbx_chan.to_extn != null)
                    cdrstr += pbx_chan.to_extn.UserName;
                cdrstr += "," + (pbx_chan.call_connected ? "1," : "0,") + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num) + "," + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num) + "," + api_chan.call_start_time.ToString("yyyy-MM-dd HH:mm:ss") + "," + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");

cdr_again1:
                try
                {
                    FileStream file = new FileStream(fn, FileMode.Append, FileAccess.Write);
                    StreamWriter sw = new StreamWriter(file);
                    sw.WriteLine(cdrstr);
                    sw.Close();
                    file.Close();
                }
                catch (Exception)
                {
                    if (retry_count++ < 3)
                    {
                        Thread.Sleep(100);
                        goto cdr_again1;
                    }
                }                
            }
        }
*/

        public PBX_CDR WriteCDR(GTSIPPBXEnv env, GTAPIASM.GTAPIChan api_chan, SIPPBXChan pbx_chan)
        {
            PBX_CDR pbx_cdr = new PBX_CDR();
            pbx_cdr.env = env;

            if (api_chan.caller_num == "" && api_chan.callee_num == "")
                return pbx_cdr;

            env.LOG_Trace(4, "WriteCDR Channel " + pbx_chan.index.ToString());

            pbx_cdr.connected = pbx_chan.call_connected ? 1 : 0;
            pbx_cdr.caller = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num);
            pbx_cdr.callee = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num);
            pbx_cdr.start_time = api_chan.call_start_time.ToString("yyyy-MM-dd HH:mm:ss");
            pbx_cdr.end_time = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            pbx_cdr.discReason = pbx_chan.discReason;
            pbx_cdr.hangupParty = pbx_chan.hangupParty;
            pbx_cdr.confName = pbx_chan.confName;
            if (pbx_chan.sip_acct != null)
            {
                pbx_cdr.sipAcct = pbx_chan.sip_acct.UserName + "@" + pbx_chan.sip_acct.DomainServer;
            }

            pbx_cdr.chan_id = pbx_chan.index;

            if (pbx_chan.confName.Length > 0)
            {
                pbx_cdr.record_file = pbx_chan.RecordFileName;
                pbx_cdr.do_convert = pbx_chan.doConfRecordConvert;
            }

            if (api_chan.originate && pbx_chan.link_chan != null)
            {
                GTAPIASM.GTAPIChan api_chan1 = env.GetChannel(pbx_chan.link_chan.index);
                pbx_cdr.org_caller_id = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan1.caller_num);
                pbx_cdr.org_called_id = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan1.callee_num);
            }


            if (pbx_chan.acd_queue != null)
            {
                env.LOG_Trace(4, "WriteCDR acd_queue " + pbx_chan.acd_queue.hgName);
                if (pbx_chan.link_chan != null)
                {
                    env.LOG_Trace(4, "WriteCDR link_chan " + pbx_chan.link_chan.index.ToString());

                    if (env.IsChanConnected(pbx_chan.link_chan.index))
                    {
                        env.LOG_Trace(4, "WriteCDR link_chan copy acd_queue");

                        pbx_chan.link_chan.acd_queue = pbx_chan.acd_queue;
                        pbx_chan.link_chan.acd_cdr_saved = !pbx_chan.acd_cdr_saved;
                        pbx_chan.link_chan.in_queue_time = pbx_chan.in_queue_time;
                        pbx_chan.link_chan.out_queue_time = pbx_chan.out_queue_time;
                        pbx_chan.link_chan.acd_to_extn = pbx_chan.acd_to_extn;
                    }
                }

                pbx_cdr.acd_name = pbx_chan.acd_queue.hgName;
                pbx_cdr.acd_in_time = pbx_chan.in_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                pbx_cdr.acd_out_time = pbx_chan.out_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                if (pbx_chan.acd_to_extn != null)
                {
                    pbx_cdr.acd_to_exten = pbx_chan.acd_to_extn.UserName;
                    if (pbx_chan.acd_to_extn.Agent != null)
                    {
                        pbx_cdr.acd_to_agent = pbx_chan.acd_to_extn.Agent.Code;
                        if (pbx_chan.acd_to_extn.Agent.RecordCall)
                            pbx_cdr.record_file = pbx_chan.RecordFileName;
                    }
                    else if (pbx_chan.acd_to_extn.RecordCall)
                    {
                        pbx_cdr.record_file = pbx_chan.RecordFileName;
                    }
                }

                pbx_cdr.connected = pbx_chan.call_connected ? (pbx_chan.call_reached_agent?2:1) : 0;

                if (!pbx_chan.acd_cdr_saved)
                {
                    env.LOG_Trace(4, "WriteCDR acd_queue in real for " + pbx_cdr.acd_name);
                    WriteACDCDR(api_chan, pbx_chan);
                    pbx_chan.acd_cdr_saved = true;
                }
            }
            else if (pbx_chan.link_chan != null)
            {
                if (pbx_chan.link_chan.acd_queue != null)
                {
                    pbx_cdr.acd_name = pbx_chan.link_chan.acd_queue.hgName;
                    pbx_cdr.acd_in_time = pbx_chan.link_chan.in_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                    pbx_cdr.acd_out_time = pbx_chan.link_chan.out_queue_time.ToString("yyyy-MM-dd HH:mm:ss");

                }

                if (pbx_chan.link_chan.acd_to_extn != null)
                {
                    pbx_cdr.acd_to_exten = pbx_chan.link_chan.acd_to_extn.UserName;
                    if (pbx_chan.link_chan.acd_to_extn.Agent != null)
                    {
                        pbx_cdr.acd_to_agent = pbx_chan.link_chan.acd_to_extn.Agent.Code;
                        if (pbx_chan.link_chan.acd_to_extn.Agent.RecordCall)
                            pbx_cdr.record_file = pbx_chan.link_chan.RecordFileName;
                    }
                    else if (pbx_chan.link_chan.acd_to_extn.RecordCall)
                    {
                        pbx_cdr.record_file = pbx_chan.link_chan.RecordFileName;
                    }
                }


            }

            //if (pbx_chan.link_chan != null)
            {
                //if (pbx_chan.link_chan.index < pbx_chan.index)
                {
                    if (pbx_chan.link_exten != null)
                    {
                        env.LOG_Trace(4, "WriteCDR link_exten " + pbx_chan.link_exten.UserName);

                        Exten_CDR exten_cdr = new Exten_CDR();

                        exten_cdr.exten_name = pbx_chan.link_exten.UserName;
                        exten_cdr.connected = pbx_chan.call_connected ? 1 : 0;
                        exten_cdr.caller = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num);
                        exten_cdr.callee = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num);

                        exten_cdr.start_time = api_chan.call_start_time.ToString("yyyy-MM-dd HH:mm:ss");
                        exten_cdr.end_time = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");

                        exten_cdr.transferred = pbx_chan.transferred;

                        exten_cdr.discReason = pbx_chan.discReason;
                        exten_cdr.hangupParty = pbx_chan.hangupParty;

                        exten_cdr.chan_id = pbx_chan.index;

                        if(pbx_chan.sip_acct != null)
                        {
                            exten_cdr.sipAcct = pbx_chan.sip_acct.UserName + "@" + pbx_chan.sip_acct.DomainServer;
                        }

                        if (pbx_chan.acd_queue != null)
                        {
                            env.LOG_Trace(4, "WriteCDR link_exten acd_queue " + pbx_chan.acd_queue.hgName);

                            exten_cdr.acd_name = pbx_chan.acd_queue.hgName;
                            exten_cdr.acd_in_time = pbx_chan.in_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                            exten_cdr.acd_out_time = pbx_chan.out_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                            if (pbx_chan.acd_to_extn != null)
                            {
                                exten_cdr.acd_to_exten = pbx_chan.acd_to_extn.UserName;
                                if (pbx_chan.acd_to_extn.Agent != null)
                                {
                                    exten_cdr.acd_to_agent = pbx_chan.acd_to_extn.Agent.Code;
                                    if (pbx_chan.acd_to_extn.Agent.RecordCall)
                                    {
                                        exten_cdr.record_file = pbx_chan.RecordFileName;
                                    }
                                    else
                                    {
                                        if (pbx_chan.acd_to_extn.RecordCall)
                                        {
                                            exten_cdr.record_file = pbx_chan.RecordFileName;
                                        }
                                    }
                                }
                                else
                                {
                                    if (pbx_chan.acd_to_extn.RecordCall)
                                    {
                                        exten_cdr.record_file = pbx_chan.RecordFileName;
                                    }
                                }
                            }

                        }
                        else if (pbx_chan.link_chan != null)
                        {
                            if (pbx_chan.link_chan.acd_queue != null)
                            {
                                exten_cdr.acd_name = pbx_chan.link_chan.acd_queue.hgName;
                                exten_cdr.acd_in_time = pbx_chan.link_chan.in_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                                exten_cdr.acd_out_time = pbx_chan.link_chan.out_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                                if (pbx_chan.link_chan.acd_to_extn != null)
                                {
                                    exten_cdr.acd_to_exten = pbx_chan.link_chan.acd_to_extn.UserName;
                                    if (pbx_chan.link_chan.acd_to_extn.Agent != null)
                                    {
                                        exten_cdr.acd_to_agent = pbx_chan.link_chan.acd_to_extn.Agent.Code;
                                        if (pbx_chan.link_chan.acd_to_extn.Agent.RecordCall)
                                        {
                                            exten_cdr.record_file = pbx_chan.link_chan.RecordFileName;
                                        }
                                        else
                                        {
                                            if (pbx_chan.link_chan.acd_to_extn.RecordCall)
                                            {
                                                exten_cdr.record_file = pbx_chan.link_chan.RecordFileName;
                                            }
                                        }
                                    }
                                    else
                                    {
                                        if (pbx_chan.link_chan.acd_to_extn.RecordCall)
                                        {
                                            exten_cdr.record_file = pbx_chan.link_chan.RecordFileName;
                                        }
                                    }
                                }
                            }
                        }


                        if (pbx_chan.link_exten.Agent != null)
                        {
                            exten_cdr.acd_to_exten = pbx_chan.link_exten.UserName;
                            exten_cdr.acd_to_agent = pbx_chan.link_exten.Agent.Code;
/*
                            if (exten_cdr.acd_name == "")
                            {
                                //according to Yasar's sugguestion,
                                //search for the first ACD group that has agent,
                                //then put the acd group name in the table
                                for (int i = 0; i < sip_huntgroups.Count; i++)
                                {
                                    if (sip_huntgroups[i].agents.Contains(pbx_chan.link_exten.Agent.Code))
                                    {
                                        exten_cdr.acd_name = sip_huntgroups[i].hgName;
                                        break;
                                    }
                                }
                            }*/

                            if (pbx_chan.link_exten.Agent.RecordCall)
                            {
                                exten_cdr.record_file = pbx_chan.RecordFileName;
                            }
                            else
                            {
                                if(pbx_chan.link_exten.RecordCall)
                                    exten_cdr.record_file = pbx_chan.RecordFileName;
                            }
                        }
                        else if (pbx_chan.link_exten.RecordCall)
                        {
                            exten_cdr.record_file = pbx_chan.RecordFileName;
                        }

                        exten_cdr.unique_call_id = pbx_chan.unique_call_id;
                        exten_cdr.inbound = pbx_chan.call_dir == 0; //!api_chan.originate;
                        exten_cdr.transferred = pbx_chan.transferred;
                        //exten_cdr.ivrKeys = pbx_chan.ivrKeys;

                        exten_cdr_queue.Enqueue(exten_cdr);
                    }
/*
                    else
                    {
                        //doing nothing
                        return;
                    }
 */
                }
            }

            if (pbx_chan.link_exten != null)
            {
                if (pbx_chan.link_exten.Agent != null)
                {
                    pbx_cdr.acd_to_exten = pbx_chan.link_exten.UserName;
                    pbx_cdr.acd_to_agent = pbx_chan.link_exten.Agent.Code;

                    if (pbx_chan.link_exten.Agent.RecordCall)
                    {
                        pbx_cdr.record_file = pbx_chan.RecordFileName;
                    }
                    else
                    {
                        if (pbx_chan.link_exten.RecordCall)
                            pbx_cdr.record_file = pbx_chan.RecordFileName;
                    }
                }
                else if (pbx_chan.link_exten.RecordCall)
                {
                    pbx_cdr.record_file = pbx_chan.RecordFileName;
                }
            }

            pbx_cdr.unique_call_id = pbx_chan.unique_call_id;
            pbx_cdr.inbound = pbx_chan.call_dir == 0; //!api_chan.originate;
            pbx_cdr.transferred = pbx_chan.transferred;
            pbx_cdr.ivrKeys = pbx_chan.ivrKeys;

            pbx_cdr_queue.Enqueue(pbx_cdr);

            return pbx_cdr;
        }

        public bool AgentLogin(SIPPBXAgent agent, SIPPBXExten extn, GTSIPPBXEnv env, string p1, string p2, string p3, SIPPBXACDHuntGroup acd)
        {
            if (agent == null)
                return false;

            if (!agent.Login(extn, acd))
                return false;
            if(acd != null)
                WriteAgentCDR(extn, agent, true, p1, acd.hgName, p3);
            else
                WriteAgentCDR(extn, agent, true, p1, p2, p3);

            if (!SIPPBXCFGDB.UpdateAgentStatusInDB(agent, env.pbxMain, this, env, env.pbxMain.dbPBXSet, env.pbxMain.GetPBXLog()))
            {
                env.LogoutText("AgentLogin UpdateAgentStatusInDB failed! Agent:" + agent.Code);
                env.pbxMain.dbPBXSet.ResetConnection();
            }
            string sEventCmd = "";
            sEventCmd += agent.Code + "|" + extn.UserName + "|" + p1 + "|" + p2 + "|" + p3;
            if(acd != null)
                sEventCmd += "|" + acd.hgName;
            manager.SendEvent("AgentLogin", sEventCmd);

            sEventCmd = agent.Code;

            if (agent.AtExten != null)
            {
                sEventCmd += "|" + agent.AtExten.UserName;
                sEventCmd += "|" + agent.AtExten.InCalling.ToString();
            }
            else
            {
                sEventCmd += "||0";
            }

            if (acd != null)
                sEventCmd += "|" + acd.hgName;

            sEventCmd += "|";
            if (agent.LoggedInACD.Count > 0)
            {
                for (int i = 0; i < agent.LoggedInACD.Count; i++)
                {
                    sEventCmd += agent.LoggedInACD[i];
                }
            }
            sEventCmd += "|";

            manager.SendEvent("AgentStatus", sEventCmd);

            env.LogoutText("Agent " + agent.Code + " successfully login!");

            return true;
        }

        public bool AgentLogout(SIPPBXAgent agent, SIPPBXExten extn, GTSIPPBXEnv env, string p1, string p2, string p3, SIPPBXACDHuntGroup acd)
        {
            agent.Logout(extn, acd);

            if (acd != null)
                WriteAgentCDR(extn, agent, false, p1, acd.hgName, p3);
            else
                WriteAgentCDR(extn, agent, false, p1, p2, p3);

            if (!SIPPBXCFGDB.UpdateAgentStatusInDB(agent, env.pbxMain, this, env, env.pbxMain.dbPBXSet, env.pbxMain.GetPBXLog()))
                env.pbxMain.dbPBXSet.ResetConnection();
            string sEventCmd = "";
            sEventCmd += agent.Code + "||" + p1 + "|" + p2 + "|" + p3;
            if (acd != null)
                sEventCmd += "|" + acd.hgName;
            manager.SendEvent("AgentLogout", sEventCmd);

            sEventCmd = agent.Code;

            if (agent.AtExten != null)
            {
                sEventCmd += "|" + agent.AtExten.UserName;
                sEventCmd += "|" + agent.AtExten.InCalling.ToString();
            }
            else
            {
                sEventCmd += "||0";
            }
            if (acd != null)
                sEventCmd += "|" + acd.hgName;

            sEventCmd += "|";
            if (agent.LoggedInACD.Count > 0)
            {
                for (int i = 0; i < agent.LoggedInACD.Count; i++)
                {
                    sEventCmd += agent.LoggedInACD[i];
                }
            }
            sEventCmd += "|";

            manager.SendEvent("AgentStatus", sEventCmd);

            return true;
        }

        public CallBack getCallBackByCallInfo(GTSIPPBXEnv env, string caller_num, string callee_num)
        {
            CallBack cb = null;

            if (call_backlist.Count > 0 && callback_enabled)
            {
                for (int i = 0; i < call_backlist.Count; i++)
                {
                    if (call_backlist[i].Callee.Length > 0)
                    {
                        if (PatternMatch(call_backlist[i].Callee, callee_num))
                        {
                            if (call_backlist[i].Caller.Length > 0)
                            {
                                if (PatternMatch(call_backlist[i].Caller, caller_num))
                                {
                                    cb = call_backlist[i];
                                    break;
                                }
                            }
                            else
                            {
                                cb = call_backlist[i];
                                break;
                            }
                        }
                    }
                    else if (call_backlist[i].Caller.Length > 0)
                    {
                        if (PatternMatch(call_backlist[i].Caller, caller_num))
                        {
                            cb = call_backlist[i];
                            break;
                        }
                    }
                }
            }

            return cb;

        }

        public bool passCallBlackList(GTSIPPBXEnv env, SIPPBXDialPlan dp, string caller_num, string callee_num)
        {
            if (call_blocks.Count > 0 && callblock_enabled)
            {
                for (int i = 0; i < call_blocks.Count; i++)
                {
                    if (call_blocks[i].Callee.Length > 0)
                    {
                        //env.LOG_Trace(4, "BlackList checking callee rule:" + call_blocks[i].Callee + " callee id:" + callee_num);
                        if (PatternMatch(call_blocks[i].Callee, callee_num))
                        {
                            //env.LOG_Trace(4, "BlackList checking callee rule:" + call_blocks[i].Callee + " callee id:" + callee_num + " matched");
                            if (call_blocks[i].Caller.Length > 0)
                            {
                                //env.LOG_Trace(4, "BlackList checking Caller rule:" + call_blocks[i].Caller + " caller id:" + caller_num);
                                if (PatternMatch(call_blocks[i].Caller, caller_num))
                                {
                                    //env.LOG_Trace(4, "BlackList checking Caller rule:" + call_blocks[i].Caller + " caller id:" + caller_num + " matched");
                                    return false;
                                }
                                else
                                {
                                    //env.LOG_Trace(4, "BlackList checking Caller rule:" + call_blocks[i].Caller + " caller id:" + caller_num + " doesn't matched");
                                }
                            }
                            else
                            {
                                //env.LOG_Trace(4, "BlackList checking callee rule:" + call_blocks[i].Callee + " callee id:" + callee_num + " doesn't matched");
                                return false;
                            }
                        }
                    }
                    else if (call_blocks[i].Caller.Length > 0)
                    {
                        //env.LOG_Trace(4, "BlackList checking Caller rule:" + call_blocks[i].Caller + " caller id:" + caller_num);
                        if (PatternMatch(call_blocks[i].Caller, caller_num))
                        {
                            //env.LOG_Trace(4, "BlackList checking Caller rule:" + call_blocks[i].Caller + " caller id:" + caller_num + " matched");
                            return false;
                        }
                        else
                        {
                            //env.LOG_Trace(4, "BlackList checking Caller rule:" + call_blocks[i].Caller + " caller id:" + caller_num + " doesn't matched");
                        }
                    }
                }
            }

            return true;
        }

        public void countCallLimit(GTSIPPBXEnv env, CallLimit cl, TimeSpan tsp)
        {
            int ts = Convert.ToInt32(tsp.TotalSeconds);
            if (cl.roundupSeconds <= 0) cl.roundupSeconds = 60;
            int cnt = (ts + cl.roundupSeconds - 1) / cl.roundupSeconds;
            cl.Seconds -= (cnt * cl.roundupSeconds);

            env.LOG_Trace(4, "countCallLimit: " + cl.Name + " " + cl.Seconds.ToString());
			
			//update DB.
            if (!SIPPBXCFGDB.UpdateCallLimitInDB(cl, null, this, env, env.pbxMain.dbPBXSet, env.pbxMain.GetPBXLog(), 0))
                env.pbxMain.dbPBXSet.ResetConnection();
		}

        public CallLimit getCallLimit(SIPPBXDialPlan dp, string caller_num, string callee_num, SIPPBXChan pbx_chan)
        {
            if (call_credits.Count > 0 && calllimit_enabled)
            {
                if (pbx_chan != null)
                {
                    if (pbx_chan.sCallLimitID.Length > 0)
                    {
                        for (int i = 0; i < call_credits.Count; i++)
                        {
                            if (PatternMatch(call_credits[i].Name, pbx_chan.sCallLimitID))
                            {
                                return call_credits[i];
                            }
                        }
                    }
                }
				
				
                for (int i = 0; i < call_credits.Count; i++)
                {
                    if (call_credits[i].dp == dp)
                    {
                        return call_credits[i];
                    }
                }

                SIPPBXExten extn = getExtensionByName(caller_num);
                if (extn != null)
                {
                    for (int i = 0; i < call_credits.Count; i++)
                    {
                        if (call_credits[i].extn == extn)
                        {
                            return call_credits[i];
                        }
                    }
                }

                if (sip_acct != null)
                {
                    if (dp.OutboundSIPAcct < sip_acct.Count)
                    {
                        SIPAccount sa = sip_acct[dp.OutboundSIPAcct];
                        for (int i = 0; i < call_credits.Count; i++)
                        {
                            if (call_credits[i].sipaccount == sa)
                            {
                                return call_credits[i];
                            }
                        }
                    }

                    if (dp.OutboundSIPAcct1 < sip_acct.Count)
                    {
                        SIPAccount sa = sip_acct[dp.OutboundSIPAcct1];
                        for (int i = 0; i < call_credits.Count; i++)
                        {
                            if (call_credits[i].sipaccount == sa)
                            {
                                return call_credits[i];
                            }
                        }
                    }

                    if (dp.OutboundSIPAcct2 < sip_acct.Count)
                    {
                        SIPAccount sa = sip_acct[dp.OutboundSIPAcct2];
                        for (int i = 0; i < call_credits.Count; i++)
                        {
                            if (call_credits[i].sipaccount == sa)
                            {
                                return call_credits[i];
                            }
                        }
                    }

                }

                for (int i = 0; i < call_credits.Count; i++)
                {
                    if(PatternMatch(call_credits[i].Name, callee_num))
                    {
                        return call_credits[i];
                    }
                }


            }

            return null;
        }

        public void setCallLimitParameters(CallLimit cl)
        {
            cl.dp = getDialPlanByPlanName(cl.Name);
            if (cl.dp == null)
            {
                cl.extn = getExtensionByName(cl.Name);

                if (cl.extn == null)
                {
                    cl.sipaccount = getSIPAccountByUserName(cl.Name);
                }
            }
        }

        public CallLimit getCallLimitByName(string clname)
        {
            CallLimit cl = null;

            for (int i = 0; i < call_credits.Count; i++)
            {
                if (string.Equals(call_credits[i].Name, clname, StringComparison.OrdinalIgnoreCase))
                //if (call_credits[i].Name == clname)
                {
                    cl = call_credits[i];
                    break;
                }
            }

            return cl;
        }

        public void playCallLimitSound(GTSIPPBXEnv env, int ch1, int ch2)
        {
            env.Send_PlayAudio(ch1, call_limit_prompt, 0, "", 0, 0);
            env.Send_PlayAudio(ch2, call_limit_prompt, 0, "", 0, 0);
        }

        /*public SIPPBXOpenAINode getOpenAINode(string name)
        {
            SIPPBXOpenAINode node = null;
            for (int i = 0; i < openai_nodes.Count; i++)
            {
                if (openai_nodes[i].NodeName == name)
                {
                    node = openai_nodes[i];
                    break;
                }
            }

            return node;
        }*/

        public CallBack getCallBackByID(int ID)
        {
            CallBack cb = null;

            for (int i = 0; i < call_backlist.Count; i++)
            {
                if (call_backlist[i].ID == ID)
                //if (string.Equals(call_backlist[i].Callee, callee, StringComparison.OrdinalIgnoreCase) && string.Equals(call_backlist[i].Caller, caller, StringComparison.OrdinalIgnoreCase))
                //if (call_backlist[i].Prefix == cbName)
                {
                    cb = call_backlist[i];
                    break;
                }
            }

            return cb;
        }

        public CallBlock getCallBlockByID(int ID)
        {
            CallBlock cb = null;

            for (int i = 0; i < call_blocks.Count; i++)
            {
                if(call_blocks[i].ID == ID)
                //if (string.Equals(call_blocks[i].Callee, callee, StringComparison.OrdinalIgnoreCase) && string.Equals(call_blocks[i].Caller, caller, StringComparison.OrdinalIgnoreCase))
                //if (call_blocks[i].Prefix == cbName)
                {
                    cb = call_blocks[i];
                    break;
                }
            }

            return cb;
        }

        public IntPtr getSpareConf(GTSIPPBXEnv env)
        {
            if (share_confs.Count == 0)
                return env.CreateConf();
            else
            {
                TimeSpan tp = DateTime.Now - share_confs.Peek().FreeTime;
                if (tp.TotalSeconds < 10)
                    return env.CreateConf();
                else
                {
                    ConfItem ci = share_confs.Dequeue();
                    return ci.ConfHandle;
                }
            }
        }

        public void retSpareConf(IntPtr conf)
        {
            ConfItem ci = new ConfItem();
            ci.ConfHandle = conf;
            ci.FreeTime = DateTime.Now;
            share_confs.Enqueue(ci);
        }

        /*
        public void WriteCDR(GTAPIASM.GTAPIChan api_chan, SIPPBXChan pbx_chan)
        {
            string fn = report_dir + "pbx_cdr.txt";
            string cdrstr = (pbx_chan.call_connected ? "1," : "0,") + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num) + "," + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num) + "," + api_chan.call_start_time.ToString("yyyy-MM-dd HH:mm:ss") + "," + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            if (pbx_chan.acd_queue != null)
            {
                cdrstr += "," + pbx_chan.acd_queue.hgName + "," + pbx_chan.in_queue_time.ToString("yyyy-MM-dd HH:mm:ss") + "," + pbx_chan.out_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                if (pbx_chan.acd_to_extn != null)
                    cdrstr += "," + pbx_chan.acd_to_extn.UserName;
                WriteACDCDR(api_chan, pbx_chan);
            }

            int retry_count = 0;

            if (pbx_chan.link_chan != null)
            {
                if (pbx_chan.link_chan.index < pbx_chan.index)
                {
                    if (pbx_chan.link_exten != null)
                    {
                        fn = report_dir + "exten_cdr.txt";
                        cdrstr = pbx_chan.link_exten.UserName + "," + (pbx_chan.call_connected ? "1," : "0,") + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num) + "," + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num) + "," + api_chan.call_start_time.ToString("yyyy-MM-dd HH:mm:ss") + "," + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                        if (pbx_chan.link_chan.acd_queue != null)
                        {
                            cdrstr += "," + pbx_chan.link_chan.acd_queue.hgName + "," + pbx_chan.link_chan.in_queue_time.ToString("yyyy-MM-dd HH:mm:ss") + "," + pbx_chan.link_chan.out_queue_time.ToString("yyyy-MM-dd HH:mm:ss");
                            if (pbx_chan.link_chan.acd_to_extn != null)
                            {
                                cdrstr += "," + pbx_chan.link_chan.acd_to_extn.UserName;
                                if (pbx_chan.link_chan.acd_to_extn.Agent != null)
                                {
                                    cdrstr += "," + pbx_chan.link_chan.acd_to_extn.Agent.Code;
                                    if (pbx_chan.link_chan.acd_to_extn.Agent.RecordCall)
                                    {
                                        cdrstr += "," + pbx_chan.link_chan.acd_to_extn.Agent.RecordFileName;
                                    }
                                    else
                                    {
                                        if (pbx_chan.link_chan.acd_to_extn.RecordCall)
                                        {
                                            cdrstr += "," + pbx_chan.link_chan.acd_to_extn.RecordFileName;
                                        }
                                    }
                                }
                                else
                                {
                                    if (pbx_chan.link_chan.acd_to_extn.RecordCall)
                                    {
                                        cdrstr += "," + pbx_chan.link_chan.acd_to_extn.RecordFileName;
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        //doing nothing
                        return;
                    }
                }
            }

cdr_again:
            try
            {
                FileStream file = new FileStream(fn, FileMode.Append, FileAccess.Write);
                StreamWriter sw = new StreamWriter(file);
                sw.WriteLine(cdrstr);
                sw.Close();
                file.Close();
            }
            catch (Exception)
            {
                if (retry_count++ < 3)
                {
                    Thread.Sleep(100);
                    goto cdr_again;
                }
            }
        }
         */
    }



}
