using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using GTAPIASM;

namespace SIPPBXv3
{
/*
    public class GTTCPServerClient
    {
        public Socket clientSocket;
        public Thread clientThread;
        public bool isExiting;

        public GTTCPServerClient()
        {
            clientSocket = null;
            clientThread = new Thread(Run);
            isExiting = false;
        }

        public void Start()
        {
            clientThread.Start(this);
        }

        static void Run(object obj)
        {
            GTTCPServerClient host = (GTTCPServerClient)obj;

            while (!host.isExiting && host.clientSocket != null)
            {
                if (host.clientSocket.())
                {
                }
            }
        }
    }


    public class GTTCPServer
    {

        public SIPPBXLog log;

        public GTTCPServer()
        {
            log = null;
        }

        public void StartListening(int port)
        {
            // Data buffer for incoming data.
            byte[] bytes = new Byte[1024];

            // Establish the local endpoint for the socket.
            // Dns.GetHostName returns the name of the 
            // host running the application.
            IPHostEntry ipHostInfo = Dns.Resolve(Dns.GetHostName());

            // Loop on the AddressList
            if (log != null)
            {
                foreach (IPAddress curAdd in ipHostInfo.AddressList)
                {
                    // Display the type of address family supported by the server. If the
                    // server is IPv6-enabled this value is: InternNetworkV6. If the server
                    // is also IPv4-enabled there will be an additional value of InterNetwork.
                    log.LogoutText("AddressFamily: " + curAdd.AddressFamily.ToString());

                    // Display the ScopeId property in case of IPV6 addresses.
                    if (curAdd.AddressFamily.ToString() == ProtocolFamily.InterNetworkV6.ToString())
                        log.LogoutText("Scope Id: " + curAdd.ScopeId.ToString());


                    // Display the server IP address in the standard format. In 
                    // IPv4 the format will be dotted-quad notation, in IPv6 it will be
                    // in in colon-hexadecimal notation.
                    log.LogoutText("Address: " + curAdd.ToString());

                    // Display the server IP address in byte format.
                    log.LogoutText("AddressBytes: ");

                    Byte[] bytes = curAdd.GetAddressBytes();
                    for (int i = 0; i < bytes.Length; i++)
                    {
                        log.LogoutText(bytes[i]);
                    }

                    log.LogoutText("\r\n");
                }
            }

            IPAddress ipAddress = ipHostInfo.AddressList[0];

            IPEndPoint localEndPoint = new IPEndPoint(ipAddress, port);

            // Create a TCP/IP socket.
            Socket listener = new Socket(AddressFamily.InterNetwork,
                SocketType.Stream, ProtocolType.Tcp);

            // Bind the socket to the local endpoint and 
            // listen for incoming connections.
            try
            {
                listener.Bind(localEndPoint);
                listener.Listen(100);

                // Start listening for connections.
                while (true)
                {
                    if(log != null)
                        log.LogoutText("Waiting for a connection...");
                    // Program is suspended while waiting for an incoming connection.
                    Socket handler = listener.Accept();
                    data = null;

                    // An incoming connection needs to be processed.
                    while (true)
                    {
                        bytes = new byte[1024];
                        int bytesRec = handler.Receive(bytes);
                        data += Encoding.ASCII.GetString(bytes, 0, bytesRec);
                        if (data.IndexOf("<EOF>") > -1)
                        {
                            break;
                        }
                    }

                    // Show the data on the console.
                    Console.WriteLine("Text received : {0}", data);

                    // Echo the data back to the client.
                    byte[] msg = Encoding.ASCII.GetBytes(data);

                    handler.Send(msg);
                    handler.Shutdown(SocketShutdown.Both);
                    handler.Close();
                }

            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }

            Console.WriteLine("\nPress ENTER to continue...");
            Console.Read();

        }


    }
*/

    public class SIPPBXManager : GTTCPCMDServer 
    {
        public SIPPBXLog log;
        public SIPPBX pbx;
        public GTSIPPBXEnv env;
        public List<IntPtr> m_socketList;

        public SIPPBXManager() : base()
        {
            log = null;
            pbx = null;
            env = null;
            m_socketList = new List<IntPtr>();
        }


        public void SendEventEx(IntPtr sock, string eventName, string eventArg)
        {
            if (sock == IntPtr.Zero)
            {
                SendEvent(eventName, eventArg);
                return;
            }

            try
            {
                string sCmd = eventName + ' ' + eventArg + '\n';

                Send(sock, sCmd, sCmd.Length);

                if (log != null)
                {
                    log.LogoutText("SIPPBXManager Sent out command: " + sCmd + " to " + sock.ToString());
                }

                if (env != null)
                {
                    env.LOG_Trace(4, "SIPPBXManager Sent out command: " + sCmd + " to " + sock.ToString());
                }
            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }
        }

        public void SendEvent(string eventName, string eventArg)
        {
            if (m_socketList.Count == 0)
                return;

            try
            {
                string sCmd = eventName + ' ' + eventArg + '\n';
                for (int i = 0; i < m_socketList.Count; i++)
                {
                    Send(m_socketList[i], sCmd, sCmd.Length);
                }
                if (log != null)
                {
                    log.LogoutText("SIPPBXManager Sent out command: " + sCmd);
                }
                if (env != null)
                {
                    env.LOG_Trace(4, "SIPPBXManager Sent out command: " + sCmd);
                }
            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }
        }

        public override void On_ClientAccepted(IntPtr hSocket, IntPtr UserData)
        {
            m_socketList.Add(hSocket);

            SendExtensionStatus(hSocket);

            SendAgentStatus(hSocket);

            SendChannelStatus(hSocket);

            SendConferenceStatus(hSocket);

        }

        public void SendExtensionStatus(IntPtr hSocket)
        {
            //Notify extension status and agent status first
            for (int i = 0; i < pbx.sip_exten.Count; i++)
            {
                SIPPBXExten extn = pbx.sip_exten[i];

                string sEventCmd = extn.UserName;

                sEventCmd += "|" + extn.InCalling.ToString();

                SendEventEx(hSocket, "ExtenStatus", sEventCmd);
            }
        }

        public void SendAgentStatus(IntPtr hSocket)
        {
            //notify agent status
            for (int i = 0; i < pbx.sip_agents.Count; i++)
            {
                SIPPBXAgent agent = pbx.sip_agents[i];
                if (agent != null)
                {
                    string sEventCmd = agent.Code;

                    if (agent.AtExten != null)
                    {
                        sEventCmd += "|" + agent.AtExten.UserName;
                        sEventCmd += "|" + agent.AtExten.InCalling.ToString();
                    }
                    else
                    {
                        sEventCmd += "||0";
                    }

                    pbx.manager.SendEventEx(hSocket, "AgentStatus", sEventCmd);
                }
            }
        }

        public void SendChannelStatus(IntPtr hSocket)
        {
            //update channel status too:
            for (int i = 0; i < pbx.ChanNum; i++)
            {
                SIPPBXChan pbx_chan = pbx.chan_list[i];
                int ch = i;

                string sEventCmd = "";
                sEventCmd += ch.ToString() + "|";
                sEventCmd += pbx_chan.unique_call_id + "|";
                //sEventCmd += GetSIPAddressInfo(1, sCaller) + "|";
                //sEventCmd += GetSIPAddressInfo(1, sCallee) + "|";

                /*
                if (caller_extn != null)
                {
                    sEventCmd += "EXTN:" + caller_extn.UserName + "|";
                }
                else
                {
                    sEventCmd += GetSIPAddressInfo(1, sCaller) + "|";
                }
                */
                sEventCmd += GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, pbx_chan.sCaller) + "|";

                /*
                if (callee_extn != null)
                {
                    sEventCmd += "EXTN:" + callee_extn.UserName + "|";
                }
                else
                {
                    sEventCmd += toid_username + "|";
                }*/
                sEventCmd += GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, pbx_chan.sCallee) + "|";

                if (pbx_chan.dp != null)
                {
                    sEventCmd += pbx_chan.dp.planName + "|";
                }
                else
                {
                    sEventCmd += "|";
                }

                sEventCmd += pbx_chan.RecordFileName + "|";

                GTAPIASM.GTAPIChan api_chan = env.GetChannel(i);

                switch (api_chan.ch_status)
                {
                    case GTAPI_CHANNEL_STATE.OFFERED:
                        SendEventEx(hSocket, "CallOffered", sEventCmd);
                        break;
                    case GTAPI_CHANNEL_STATE.IDLE:
                    case GTAPI_CHANNEL_STATE.RESERVED:
                        SendEventEx(hSocket, "CallIdle", sEventCmd);
                        break;
                    case GTAPI_CHANNEL_STATE.HOLDING:
                    case GTAPI_CHANNEL_STATE.BE_HOLDED:
                    case GTAPI_CHANNEL_STATE.CONNECTED:
                        SendEventEx(hSocket, "CallConnected", sEventCmd);
                        break;
                    case GTAPI_CHANNEL_STATE.DIALING:
                        SendEventEx(hSocket, "CallDialing", sEventCmd);
                        break;
                    case GTAPI_CHANNEL_STATE.DISCONNECTING:
                        SendEventEx(hSocket, "CallIdle", sEventCmd);
                        break;
                }

            }

        }

        public void SendConferenceStatus(SIPConferRoom conf, IntPtr hSocket)
        {
            string conf_cmd_name = "ConfStatus";
            string sEventCmd = "";

            sEventCmd = conf.conf_name + "|"; ;

            for (int j = 0; j < conf.conf_chans.Count; j++)
            {
                sEventCmd += (conf.conf_chans[j].index.ToString() + "," + conf.conf_chans[j].conf_opt.ToString() + ";");
            }

            SendEventEx(hSocket, conf_cmd_name, sEventCmd);
        }

        public void SendConferenceStatus(IntPtr hSocket)
        {
            //update client with conference status
            for (int i = 0; i < pbx.sip_conferooms.Count; i++)
            {
                SendConferenceStatus(pbx.sip_conferooms[i], hSocket);
            }            
        }

        public override void On_ClientClosed(IntPtr hSocket, IntPtr UserData)
        {
            m_socketList.Remove(hSocket);
        }

        public override void On_RecvCmd(IntPtr hSocket, string CmdStr, int nSize, IntPtr UserData)
        {
            if (nSize <= 0 || nSize >= 2048)
                return;

            if (log != null)
            {
                log.LogoutText("SIPPBXManager Received command: " + CmdStr);
            }
            if (env != null)
            {
                env.LOG_Trace(4, "SIPPBXManager Received command: " + CmdStr);
            }

            //char[] delimiters = new char[] { ';', ',', ' ', '|' };
            char[] delimiters = new char[] { '\n' };
            string[] members = CmdStr.Split(delimiters, StringSplitOptions.RemoveEmptyEntries);

            try
            {
                for (int i = 0; i < members.Length; i++)
                {
                    string sCmd = members[i];
                    sCmd = sCmd.TrimStart(' ');
                    sCmd = sCmd.TrimEnd('\n', ' ');
                    int nIndex = sCmd.IndexOf(' ');
                    if (nIndex > 0)
                    {
                        PBXOptCmd cmd = new PBXOptCmd();

                        cmd.CmdName = sCmd.Substring(0, nIndex);
                        cmd.CmdArgs = sCmd.Substring(nIndex + 1);

                        //may need lock for the fellowing call
                        //pbx.opt_cmd_queue.Enqueue(cmd);

                        PBXOptCmdProcess.ProcessPBXOptCmd(pbx, env, cmd);
                    }
                }
            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }
            }

        }

        public override void On_SendCmd(IntPtr hSocket, string CmdStr, int nSize, IntPtr UserData)
        {
        }

        public override void On_Exception(IntPtr hSocket, IntPtr UserData)
        {
        }
    }

    public class SIPPBXManagerClient : GTTCPCMDClient
    {
        public IntPtr m_hSocket;
        public Random random;

        public SIPPBXManagerClient()
            : base()
        {
            m_hSocket = IntPtr.Zero;
            random = new Random(Convert.ToInt32(ConvertToUnixTimestamp(DateTime.Now)));
        }

        static double ConvertToUnixTimestamp(DateTime date)
        {
            DateTime origin = new DateTime(1970, 1, 1, 0, 0, 0, 0);
            TimeSpan diff = date - origin;
            return Math.Floor(diff.TotalSeconds);
        }

        private int RandomNumber(int min, int max)
        {
            return random.Next(min, max);
        }

        private string RandomString(int size, bool lowerCase)
        {
            StringBuilder builder = new StringBuilder();
            char ch;
            for (int i = 0; i < size; i++)
            {
                ch = Convert.ToChar(Convert.ToInt32(Math.Floor(26 * random.NextDouble() + 65)));
                builder.Append(ch);
            }

            if (lowerCase)
                return builder.ToString().ToLower();

            return builder.ToString();
        }

        private string RandomStringAndNum(int size, bool lowerCase)
        {
            StringBuilder builder = new StringBuilder();

            for (int i = 0; i < size; i++)
            {
                int idx = Convert.ToInt32(Math.Floor(36 * random.NextDouble()));
                if (idx >= 0 && idx <= 9)
                {
                    builder.Append(idx.ToString());
                }
                else
                {
                    idx -= 10;
                    builder.Append(Convert.ToChar(65 + idx));
                }
            }

            if (lowerCase)
                return builder.ToString().ToLower();

            return builder.ToString();
        }

        public override void On_ClientAccepted(IntPtr hSocket, IntPtr UserData)
        {
            m_hSocket = hSocket;
            ServerConnected(true);
        }

        public override void On_ClientClosed(IntPtr hSocket, IntPtr UserData)
        {
            m_hSocket = IntPtr.Zero;
            ServerConnected(false);
        }

        public override void On_RecvCmd(IntPtr hSocket, string CmdStr, int nSize, IntPtr UserData)
        {
            if (nSize <= 0 || nSize >= 4096)
                return;

            //char[] delimiters = new char[] { ';', ',', ' ', '|' };
            char[] delimiters = new char[] { '\n' };
            string[] members = CmdStr.Split(delimiters, StringSplitOptions.RemoveEmptyEntries);

            try
            {
                for (int i = 0; i < members.Length; i++)
                {
                    string sCmd = members[i];
                    sCmd = sCmd.TrimStart(' ');
                    sCmd = sCmd.TrimEnd('\n', ' ');
                    int nIndex = sCmd.IndexOf(' ');
                    if (nIndex > 0)
                    {
                        ProcessServerCmd(sCmd.Substring(0, nIndex), sCmd.Substring(nIndex + 1));
                    }
                }
            }
            catch (Exception)
            {
                /*
                if (log != null)
                {
                    log.LogoutText(e.ToString());
                }*/
            }
        }

        public virtual void OnCallOffered(int ch, string unique_id, string caller, string callee, string dialplan_name, string audio_fn)
        {
        }

        public virtual void OnCallDialing(int ch, string unique_id, string caller, string callee, string dialplan_name, string audio_fn)
        {
        }

        public virtual void OnCallRinging(int ch, string unique_id, string dialplan_name, string audio_fn)
        {
        }

        public virtual void OnCallConnected(int ch, string unique_id, string dialplan_name, string audio_fn)
        {
        }

        public virtual void OnCallHolding(int ch, string unique_id, int hold_on)
        {
        }

        public virtual void OnCallIdle(int ch, string unique_id, string dialplan_name, string audio_fn)
        {
        }

        public virtual void ServerConnected(bool bConnected)
        {
        }

        public virtual void OnCallMonitoring(string extenSupervisor, string extenNormal, int monitorType)
        {
        }

        public virtual void OnAgentLog(bool bLogIn, string agentCode, string extenNum, string p1, string p2, string p3)
        {
        }

        //callStatus: 0 = idle, 10 = offered, 20 = dialing, 21 = ringing, 30 = connected 
        public virtual void OnAgentStatus(string agentCode, string atExten, string callStatus)
        {
        }

        //callStatus: 0 = idle, 10 = offered, 20 = dialing, 21 = ringing, 30 = connected 
        public virtual void OnExtenStatus(string extenNum, string callStatus)
        {
        }

        public virtual void OnCommandResult(string cmdID, string result)
        {
        }

        public virtual void OnConferenceRoomStatus(string roomName, string channels)
        {
        }

        public void AgentPaused(string agentCode, int paused)
        {
            string sCmd = "agentpaused ";

            sCmd += agentCode + "|" + paused.ToString();

            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void AgentLogin(string agentCode, string extenNum, bool bLogin, string acdName, string p2, string p3)
        {
            string sCmd = "";
            if(bLogin)
                sCmd = "agentlogin ";
            else
                sCmd = "agentlogout ";

            sCmd += agentCode + "|" + extenNum + "|" + acdName + "|" + p2 + "|" + p3;

            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void GetAgentStatus(string agentCode)
        {
            string sCmd = "agentstatus ";

            sCmd += agentCode;

            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void GetExtenStatus(string extnNum)
        {
            string sCmd = "extenstatus ";

            sCmd += extnNum;

            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void ResetChannel(int ch)
        {
            string sCmd = "resetchan ";

            if(ch == -1)
                sCmd += "all";
            else
                sCmd += ch.ToString();

            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void ResetACD(string acdName)
        {
            string sCmd = "resetacd " + acdName;
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void ExtenCallOut(string extnNum, string destNum, string sipAcctUserName, int ringTimeoutSec)
        {
            string sCmd = "extncallout " + extnNum + "|" + destNum + "|" + sipAcctUserName + "|" + ringTimeoutSec.ToString();
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void ExtenCallOutEx(string extnNum, string destNum, string sipAcctUserName, int ringTimeoutSec, bool enableDetect, bool disconectAfterDetect)
        {
            string sCmd = "extncallout " + extnNum + "|" + destNum + "|" + sipAcctUserName + "|" + ringTimeoutSec.ToString();
            if (enableDetect)
                sCmd += "|1";
            else
                sCmd += "|0";
            if (disconectAfterDetect)
                sCmd += "|1";
            else
                sCmd += "|0";
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        //monitor type
        //0 = listen
        //1 = whisper
        //2 = talking(bargin)
        //-1 = stop(get out)
        public void MonitorCall(string extnSupervisor, string extnNormal, int monitorType)
        {
            string sCmd = "monitorcall " + extnSupervisor + "|" + extnNormal + "|" + monitorType.ToString();
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public string MakeExtensionCall(int ch, string extnNum, string sCaller)
        {
            string sCmdID = RandomStringAndNum(8, false);

            string sCmd = "makeextensioncall " + ch.ToString() + "|" + extnNum + "|" + sCaller + "|" + sCmdID;
            if (m_hSocket != IntPtr.Zero)
            {
                Send(m_hSocket, sCmd, sCmd.Length);
                return sCmdID;
            }

            return "";
        }

        public string MakeCall(int ch, string caller, string callee)
        {
            string sCmdID = RandomStringAndNum(8, false);
            string sCmd = "makecall " + sCmdID + "|" + ch.ToString() + "|" + caller + "|" + callee;
            if (m_hSocket != IntPtr.Zero)
            {
                Send(m_hSocket, sCmd, sCmd.Length);
                return sCmdID;
            }
            return "";
        }

        public string MakeCall(int ch, string caller, string callee, string username, string passwd)
        {
            string sCmdID = RandomStringAndNum(8, false);
            string sCmd = "makecall " + sCmdID + "|" + ch.ToString() + "|" + caller + "|" + callee + "|" + username + "|" + passwd;
            if (m_hSocket != IntPtr.Zero)
            {
                Send(m_hSocket, sCmd, sCmd.Length);
                return sCmdID;
            }
            return "";
        }

        public string MakeCall(int ch, string caller, string callee, string username, string passwd, string uri, string contact)
        {
            string sCmdID = RandomStringAndNum(8, false);
            string sCmd = "makecall " + sCmdID + "|" + ch.ToString() + "|" + caller + "|" + callee + "|" + username + "|" + passwd + "|" + uri + "|" + contact;
            if (m_hSocket != IntPtr.Zero)
            {
                Send(m_hSocket, sCmd, sCmd.Length);
                return sCmdID;
            }
            return "";
        }

        public void AnswerCall(int ch)
        {
            string sCmd = "answercall " + ch.ToString();
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void HangupCall(int ch)
        {
            string sCmd = "hangupcall " + ch.ToString();
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void HangupCall(int ch, int reasonCode, string reasonDesc)
        {
            string sCmd = "hangupcall " + ch.ToString() + "|" + reasonCode.ToString() + "|" + reasonDesc;
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void HoldCall(int ch)
        {
            string sCmd = "holdcall " + ch.ToString();
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void TransferCall(int ch, string callee) //blind transfer
        {
            string sCmd = "transfercall " + ch.ToString() + "|" + callee;
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void TransferCall(int ch, string callee, int ch1) //consult transfer
        {
            string sCmd = "transfercall " + ch.ToString() + "|" + callee + "|" + ch1.ToString();
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void MagicTransfer(int ch, string transCode)
        {
            string sCmd = "magictransfer " + ch.ToString() + "|" + transCode;
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public void RunDialPlan(int ch, string planName)
        {
            string sCmd = "rundialplan " + ch.ToString() + "|" + planName;
            if (m_hSocket != IntPtr.Zero)
                Send(m_hSocket, sCmd, sCmd.Length);
        }

        public string BridgeTwoCalls(int ch1, int ch2)
        {
            string sCmdID = RandomStringAndNum(8, false);
            string sCmd = "bridgetwocalls " + ch1.ToString() + "|" + ch2.ToString() + "|" + sCmdID;
            if (m_hSocket != IntPtr.Zero)
            {
                Send(m_hSocket, sCmd, sCmd.Length);
                return sCmdID;
            }
            return "";
        }

        public void SetChanInConferenceRoom(int ch, string conf_name, int opt) //opt: 0 = take out of conference room. 1 = add into conference room. 2 = monitor(listening only, not speaking)
        {
            string sCmd = "setchaninconfroom " + ch.ToString() + "|" + conf_name + "|" + opt.ToString();
            if (m_hSocket != IntPtr.Zero)
            {
                Send(m_hSocket, sCmd, sCmd.Length);
            }
		}

        public void SetChanConferenceBitMask(int ch, uint bitMask)
		{
            string sCmd = "setchanconfmask " + ch.ToString() + "|" + bitMask.ToString();
            if (m_hSocket != IntPtr.Zero)
            {
                Send(m_hSocket, sCmd, sCmd.Length);
            }	
		}

        public void CreateConferenceRoom(string conf_name)
		{
            string sCmd = "createconfroom " + conf_name;
            if (m_hSocket != IntPtr.Zero)
            {
                Send(m_hSocket, sCmd, sCmd.Length);
            }				
		}

        public void DestroyConferenceRoom(string conf_name)
		{
            string sCmd = "destroyconfroom " + conf_name;
            if (m_hSocket != IntPtr.Zero)
            {
                Send(m_hSocket, sCmd, sCmd.Length);
            }			
		}

        public void GetConferenceRoomStatus(string conf_name)
        {
            string sCmd = "confstatus " + conf_name;
            if (m_hSocket != IntPtr.Zero)
            {
                Send(m_hSocket, sCmd, sCmd.Length);
            }
        }

        public void ProcessServerCmd(string cmdName, string cmdArgs)
        {
            char[] delimiters = new char[] { '|' };
            string[] members = cmdArgs.Split(delimiters, StringSplitOptions.None);

            try
            {
                if (cmdName == "CallOffered")
                {
                    OnCallOffered(Convert.ToInt32(members[0]), members[1], members[2], members[3], members[4], members[5]);
                    return;
                }
                if (cmdName == "CallDialing")
                {
                    OnCallDialing(Convert.ToInt32(members[0]), members[1], members[2], members[3], members[4], members[5]);
                    return;
                }
                if (cmdName == "CallRinging")
                {
                    OnCallRinging(Convert.ToInt32(members[0]), members[1], members[2], members[5]);
                    return;
                }
                if (cmdName == "CallConnected")
                {
                    OnCallConnected(Convert.ToInt32(members[0]), members[1], members[2], members[3]);
                    return;
                }
                if (cmdName == "CallHolding")
                {
                    OnCallHolding(Convert.ToInt32(members[0]), members[1], Convert.ToInt32(members[2]));
                    return;
                }

                if (cmdName == "CallIdle")
                {
                    OnCallIdle(Convert.ToInt32(members[0]), members[1], members[2], members[3]);
                    return;
                }
                if (cmdName == "CallMonitoring")
                {
                    OnCallMonitoring(members[0], members[1], Convert.ToInt32(members[2]));
                    return;
                }
                if (cmdName == "AgentLogin")
                {
                    OnAgentLog(true, members[0], members[1], members[2], members[3], members[4]);
                    return;
                }
                if (cmdName == "AgentLogout")
                {
                    OnAgentLog(false, members[0], members[1], members[2], members[3], members[4]);
                    return;
                }
                if (cmdName == "AgentStatus")
                {
                    OnAgentStatus(members[0], members[1], members[2]);
                    return;
                }
                if (cmdName == "ExtenStatus")
                {
                    OnExtenStatus(members[0], members[1]);
                    return;
                }
                if (cmdName == "CommandResult")
                {
                    OnCommandResult(members[0], members[1]);
                    return;
                }
                if (cmdName == "ConfStatus")
                {
                    OnConferenceRoomStatus(members[0], members[1]);
                }
            }
            catch (Exception)
            {
                
            }
        }
    }
}
