// ------------------------------------------------------------------
//	File: VRAPI.h
//
//	Description:	This header file is DLL 'C' file that
//                includes all of the required header files for developing
//				   a SIP recorder project
//
// ==================================================================
// IF YOU DO NOT AGREE WITH THE FOLLOWING STATEMENT, YOU MUST 
// PROMPTLY RETURN THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION 
// ("PRODUCT") TO PCBest Network Inc.(www.pcbest.net).
//
// PCBest Network Inc. owns all title and 
// ownership rights to Software.  "Software" means any data processing
// programs (hereinafter "programs") consisting of a series of 
// instructions or statements in object code form, including any 
// systemized collection of data in the form of a data base, and any
// related proprietary materials such as flow charts, logic diagrams, 
// manuals media and listings provided for use with the programs.
// User has no right, express or implied, to transfer, sell, provide
// access to or dispose of Software to any third party without PCBest Network's
// prior written consent.  User will not copy, reverse assemble,
// reverse engineer, decompile, modify, alter, translate or display
// the Software other than as expressly permitted by PCBest Network in writing.
// ------------------------------------------------------------------

#ifndef VRAPI_HIGH_LEVEL_INTERFACE_HEAD_FILE
#define VRAPI_HIGH_LEVEL_INTERFACE_HEAD_FILE

#include "VRAPIDef.h"

#ifdef __cplusplus
extern "C" 
{
#endif
// ------------------------------------------------------------------
// ------------------------------------------------------------------
    void VR_API VR_InitCapture(int vrType);
    void VR_API VR_FreeCapture();

	void VR_API VR_SetLicenseKey(const char* s);
	void VR_API VR_SetLicenseMAC(const char* s);
    void VR_API VR_SetChannelCount(int cnt);
	int VR_API VR_GetChannelCount();
    void VR_API VR_SetLogFileName(const char* fn);
    void VR_API VR_SetLogLevel(short l);
    void VR_API VR_SetAudioRootFolder(const char* root);
	void VR_API VR_SetAudioFileFormat(int f);

    //void VR_API VR_SetMP3(short b);

    int VR_API VR_StartCapture();
    int VR_API VR_StopCapture();

    int VR_API VR_IsLicensed();
	const char* VR_API VR_GetLicTo();
	const char* VR_API VR_ValidateLicence(const char *sKey, unsigned int numChan, const char* appVersion, const char* sMacAddr);

    const char* VR_API VR_GetChanCallerID(int ch);
    const char* VR_API VR_GetChanCallerIP(int ch);
    int VR_API VR_GetChanCallerPort(int ch);

    const char* VR_API VR_GetChanCalleeID(int ch);
	const char* VR_API VR_GetChanCalleeIP(int ch);
    int VR_API VR_GetChanCalleePort(int ch);

    int VR_API VR_GetChanStatus(int ch);

    const char* VR_API VR_GetChanUniqueID(int ch);
    const char* VR_API VR_GetChanAudioFileName(int ch);
    int VR_API VR_GetChanAudioFileNumber(int ch);

    void VR_API VR_SetRecording(int b);
    void VR_API VR_SetEnableXML(int b);
	void VR_API VR_SetRecordStereo(int b);

    void VR_API VR_SetAvayaCDRPort(unsigned short p);
    void VR_API VR_SetAvayaCDRProtocol(int p);
    void VR_API VR_SetAvayaSIPTrunkCount(int cnt);
    void VR_API VR_SetAvayaSIPTrunkID(int trunkID, const char* id);
    void VR_API VR_SetAvayaCDRFormat(int TimePos1, int TimePos2, int CondPos1, int CondPos2, int CallerPos1, int CallerPos2, int CalleePos1, int CalleePos2);

	void VR_API VR_SetSamsungCDRInfo(const char* ip, unsigned short port);

	//BIB recording functions
	void VR_API VR_EnableCiscoBIBRecording();

	//In SIP To To: <sip:7777@192.168.1.170>, 7777 is the recording trunk name/DID
	//Which marks SIP call is for BIB recording. Can be multiple names, seperate with ;
    void VR_API VR_SetCiscoBIBRecordingTrunkName(const char* trunkName);

	//From: <sip:1004@192.168.1.146;x-nearend;x-refci=20482684;x-nearendclusterid=StandAloneCluster;x-nearenddevice=SEP0090F5DE91C9;x-nearendaddr=1004;x-farendrefci=20482683;x-farendclusterid=StandAloneCluster;x-farenddevice=PCBest_Telekom_PBX;x-farendaddr=3551234>;tag=1835~4b10e8a8-eb98-46b1-b2a2-036e5a422eac-20482688
	//In this case, PCBest_Telekom_PBX marked by x-farenddevice is the incoming trunk name
	void VR_API VR_SetCiscoBIBIncomingTrunkName(const char* trunkName);

	//From: <sip:1004@192.168.1.146;x-nearend;x-refci=20482701;x-nearendclusterid=StandAloneCluster;x-nearenddevice=SEP0090F5DE91C9;x-nearendaddr=1004;x-farendrefci=20482702;x-farendclusterid=StandAloneCluster;x-farenddevice=TEST_TRUNK;x-farendaddr=176>;tag=1847~4b10e8a8-eb98-46b1-b2a2-036e5a422eac-20482706
	//In this case, TEST_TRUNK marked by x-farenddevice is the outgoing trunk name
	void VR_API VR_SetCiscoBIBOutgoingTrunkName(const char* trunkName);


/*
    void VR_API VR_EnableH323(int b);
    void VR_API VR_SetH323PBXAddr(const char* ip);
    void VR_API VR_SetH323ExtenCount(int cnt);
    void VR_API VR_SetH323Exten(int idx, const char* Name, const char* ExtenNumber, const char* IPAddr);
*/

    void VR_API VR_SetRTPPBXCount(int cnt);
    void VR_API VR_SetRTPPBXAddr(int idx, const char* ip);
    void VR_API VR_SetRTPExtenCount(int cnt);
    void VR_API VR_SetRTPExten(int idx, const char* Name, const char* ExtenNumber, const char* IPAddr);

	void VR_API VR_SetCB_Call_Offered(VR_CB_call_offered p);
	void VR_API VR_SetCB_Call_Connected(VR_CB_call_connected p);
	void VR_API VR_SetCB_Call_Idle(VR_CB_call_idle p);
	void VR_API VR_SetCB_Call_Audio_Buffer(VR_CB_call_audio_buffer p);
	void VR_API VR_SetCB_Call_DTMF(VR_CB_call_dtmf p);
	void VR_API VR_SetCB_Call_ID(VR_CB_call_id p);
	void VR_API VR_SetCB_Call_Info(VR_CB_call_info p);
	void VR_API VR_SetCB_Call_SIP_Info(VR_CB_call_sip_info p);
	void VR_API VR_SetCB_Set_ChanName(VR_CB_set_channame p);

	void VR_API VR_SetCB_Fatal_Error(VR_CB_fatal_error p);

	void VR_API VR_SetCB_GetWAVFileName(VR_CB_get_wav_file_name p);
	void VR_API VR_SetCB_GetWAVFileName1(VR_CB_get_wav_file_name1 p);

	void VR_API VR_SetCB_GetXMLFileName(VR_CB_get_xml_file_name p);

	void VR_API VR_SetDeviceType(int DeviceID, int DeviceType, const char* DeviceDesc, void*);
	void VR_API VR_SetChannelType(int ChanID, int ChanType, const char* ChanDesc, void*);

	void VR_API VR_Log(int LogLevel, const char* LogInfo);

	int VR_API VR_GetTotalCallCount();
	int VR_API VR_GetSuccessfulCallCount();

	void VR_API VR_WAV2MP3(const char* sWavFile, const char* sMP3File, int bDelWav);
	void VR_API VR_WAV2GSM(const char* sWavFile, const char* sGSMFile, int bDelWav);

	//PCBest VoIP Recorder Related Functions
	void VR_API VR_SetProtocol(const char* sProtocolName);
	void VR_API VR_SetPort(unsigned short PortNum);

	//0 == IP Addr, 1 == ID, 2 = MAC address
    void VR_API VR_SetFilterType(int t);
    void VR_API VR_SetFilterCount(int cnt);
    void VR_API VR_SetFilterItem(int idx, const char* s);
	void VR_API VR_SetFilter(const char* s, int act); //act == 1 add, 0 == remove

	//0 == IP Addr, 1 == ID, 2 = MAC address
    void VR_API VR_SetExcludeType(int t);
    void VR_API VR_SetExcludeCount(int cnt);
    void VR_API VR_SetExcludeItem(int idx, const char* s);
	void VR_API VR_SetExclude(const char* s, int act); //act == 1 add, 0 == remove

    void VR_API VR_SetMaxWavSeconds(int s);

    void VR_API VR_SetIgnorePossibleSameCall(int b);
    void VR_API VR_SetNoAudioSeconds(int s);
    void VR_API VR_EnableAudioStreamEvent(int b);
    void VR_API VR_SetPCAPFile(const char* fn);

	void VR_API VR_SetDumpFile(const char* fn);
	void VR_API VR_SetDumpFileMaxSize(int maxsize);
	int VR_API VR_PlayDumpFile(const char* fn, short idx, int sync);

    void VR_API VR_EnableRTSrv(int b);

    short VR_API VR_GetNICCount();
    const char* VR_API VR_GetNICName(short idx);
    const char* VR_API VR_GetNICDescription(short idx);

    short VR_API VR_GetNICIPCount(short idx);
    const char* VR_API VR_GetNICIP(short idxNIC, short idxIP);

    void VR_API VR_SetNIC(short idx);
    void VR_API VR_SetNICByIP(const char* ipAddr);
	void VR_API VR_SetPromiscuousMode(int m); //m = promiscuous mode (nonzero means promiscuous)

    void VR_API VR_SetMaxDays(int days);
    void VR_API VR_SetFIFOSpace(int mb);

	int	VR_API VR_ProcessEthernetFrame(struct timeval* ts, const unsigned char* pkt_data, unsigned int pkt_len);

	void VR_API VR_SetUsePacketTime(int b);

	//void VR_API VR_SetPauseDTMFKey(char c);

	void VR_API VR_SetRecordOnlyAfterAnswer(int b);

	unsigned int VR_API VR_GetSysProcessedPacketCount();

	void VR_API VR_SetRecordCallLegs(int b);

	void VR_API VR_StartChanRecording(int ch, const char* newWavFile);
	void VR_API VR_StopChanRecording(int ch);
	void VR_API VR_PauseRecording(int ch, int pause);
	// opt & 0x01 = 1 recording during pause, 0 = not recording during pause
	// opt & 0x02 = 2 auto pause when call starts, 0 = not auto-pause
	void VR_API VR_SetPauseOption(int ch, int opt); 
	void VR_API VR_SetPauseDTMFStr(const char* c);

	void VR_API VR_RecordSIPHeadersInXML(const char* headers); //seperated by ';'
	void VR_API VR_SetExtenPattern(const char* patterns); //seperated by ';', * for any length of string, and ? for one digit
	int VR_API VR_GetChanByCallID(const char* call_id);
	int VR_API VR_GetChanBySIPID(const char* sip_id);
	int VR_API VR_GetChanByPChargingVector(const char* pcv);
	int VR_API VR_GetChanByPAssertedIdentity(const char* pai);
	int VR_API VR_GetChanByRemotePartyID(const char* rpi);

	const char* VR_API VR_GetChanSIPMsg(int ch, int t); //t: 0=INVITE, 1=OK, 2=18x, 3=ACK
	const char* VR_API VR_GetCDRRawData(int resv0, const char* resv1, const char* resv2, void* resv3);

	void VR_API VR_EnableSaveCallPcapFile(int b);

	void VR_API VR_EnableAddingDateAndTimeInAudio(int enabled); //0 = disabled, 1 = beginning, 2 = end
	void VR_API VR_SetAddingDateAndTimeInAudioText(const char* fmt); 

/*
#define PCAP_DRIVER_NONE 0 
#define PCAP_DRIVER_WINPCAP 1 
#define PCAP_DRIVER_NPCAP 2 
*/
	int VR_API VR_GetPcapDriverType();
	const char* VR_API VR_GetPcapDriverTypeStr();

#ifdef __cplusplus
}
#endif

#endif

// ------------------------------------------------------------------
// ------------------------------------------------------------------
