using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace OptiLogixRecorder
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            cbCard1Type.Items.Add("0: USB Analog 1 channel");
            cbCard1Type.Items.Add("1: USB Analog 4/8 channels");
            cbCard1Type.Items.Add("2 : USB GSM 1/2 users");
            cbCard1Type.Items.Add("3 : USB GSM 1/2 users (conference)");
            cbCard1Type.Items.Add("4 : USB Basic Rate 1 port");
            cbCard1Type.Items.Add("5 : USB Basic Rate 2/4 ports");
            cbCard1Type.Items.Add("6 : USB PRI fractional / 30 channels");
            cbCard1Type.Items.Add("7 : USB PRI fractional / 30 channels (mains powered)");
            cbCard1Type.Items.Add("8 : No Device");
            cbCard1Type.Items.Add("9 : PCI Analog 1 channel");
            cbCard1Type.Items.Add("10: PCI Analog 4/8 channels");
            cbCard1Type.Items.Add("11: PCI Analog 16 channels   (PCI or PCIe)");
            cbCard1Type.Items.Add("12: PCI GSM 1/2 users");
            cbCard1Type.Items.Add("13: PCI GSM 1/2 users (conference)");
            cbCard1Type.Items.Add("14: PCI Basic Rate 1 port");
            cbCard1Type.Items.Add("15: PCI Basic Rate 2/4 ports");
            cbCard1Type.Items.Add("16: PCI Basic Rate 8 ports   (PCI or PCIe)");
            cbCard1Type.Items.Add("17: PCI PRI fractional       (PCI or PCIe)");
            cbCard1Type.Items.Add("18: PCI PRI 30 channels      (PCI or PCIe)");
            cbCard1Type.Items.Add("19: PCI Dual PRI 60 channels (PCIe)");
            cbCard1Type.Items.Add("20 : No Device");
            cbCard1Type.Items.Add("21: PCI GSM 8 users");
            cbCard1Type.Items.Add("22: PCI GSM 16 users (conference)");
            cbCard1Type.SelectedIndex = 8;

            cbCard2Type.Items.Add("0: USB Analog 1 channel");
            cbCard2Type.Items.Add("1: USB Analog 4/8 channels");
            cbCard2Type.Items.Add("2 : USB GSM 1/2 users");
            cbCard2Type.Items.Add("3 : USB GSM 1/2 users (conference)");
            cbCard2Type.Items.Add("4 : USB Basic Rate 1 port");
            cbCard2Type.Items.Add("5 : USB Basic Rate 2/4 ports");
            cbCard2Type.Items.Add("6 : USB PRI fractional / 30 channels");
            cbCard2Type.Items.Add("7 : USB PRI fractional / 30 channels (mains powered)");
            cbCard2Type.Items.Add("8 : No Device");
            cbCard2Type.Items.Add("9 : PCI Analog 1 channel");
            cbCard2Type.Items.Add("10: PCI Analog 4/8 channels");
            cbCard2Type.Items.Add("11: PCI Analog 16 channels   (PCI or PCIe)");
            cbCard2Type.Items.Add("12: PCI GSM 1/2 users");
            cbCard2Type.Items.Add("13: PCI GSM 1/2 users (conference)");
            cbCard2Type.Items.Add("14: PCI Basic Rate 1 port");
            cbCard2Type.Items.Add("15: PCI Basic Rate 2/4 ports");
            cbCard2Type.Items.Add("16: PCI Basic Rate 8 ports   (PCI or PCIe)");
            cbCard2Type.Items.Add("17: PCI PRI fractional       (PCI or PCIe)");
            cbCard2Type.Items.Add("18: PCI PRI 30 channels      (PCI or PCIe)");
            cbCard2Type.Items.Add("19: PCI Dual PRI 60 channels (PCIe)");
            cbCard2Type.Items.Add("20 : No Device");
            cbCard2Type.Items.Add("21: PCI GSM 8 users");
            cbCard2Type.Items.Add("22: PCI GSM 16 users (conference)");
            cbCard2Type.SelectedIndex = 8;

            try
            {
                VRAPIASM.VRAPIEnv.VR_InitCapture(1);
            }
            catch (Exception e1)
            {
                MessageBox.Show(e1.ToString());
            }

            btnStart.Enabled = true;
            btnStop.Enabled = false;
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            VRAPIASM.VRAPIEnv.VR_SetAudioRootFolder(Application.StartupPath + "\\Records\\");
            VRAPIASM.VRAPIEnv.VR_SetLogFileName(Application.StartupPath + "\\vrapi.log");
            VRAPIASM.VRAPIEnv.VR_SetLogLevel(4);

            if(cbCard1Type.SelectedIndex != 8 && cbCard1Type.SelectedIndex != 20)
                VRAPIASM.VRAPIEnv.VR_SetDeviceType(0, cbCard1Type.SelectedIndex, "", IntPtr.Zero);

            if (cbCard2Type.SelectedIndex != 8 && cbCard2Type.SelectedIndex != 20)
                VRAPIASM.VRAPIEnv.VR_SetDeviceType(1, cbCard2Type.SelectedIndex, "", IntPtr.Zero);

            VRAPIASM.VRAPIEnv.VR_StartCapture();

            btnStart.Enabled = false;
            btnStop.Enabled = true;
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            VRAPIASM.VRAPIEnv.VR_StopCapture();

            //Sleep(200);

            VRAPIASM.VRAPIEnv.VR_FreeCapture();

            //Sleep(200);

            VRAPIASM.VRAPIEnv.VR_InitCapture(1);

            //Sleep(200);

            btnStart.Enabled = true;
            btnStop.Enabled = false;
        }
    }
}