// FrameFeeder.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "pcap.h"
#include "VRAPIDef.h"
#include "VRAPI.h"

int _tmain(int argc, _TCHAR* argv[])
{
	pcap_if_t *alldevs;
	pcap_if_t *d;
	int inum;
	int i=0;
	pcap_t *adhandle;
	int res;
	char errbuf[PCAP_ERRBUF_SIZE];
	struct tm *ltime;
	char timestr[16];
	struct pcap_pkthdr *header;
	const u_char *pkt_data;
	time_t local_tv_sec;
		
    
	/* Retrieve the device list */
	if(pcap_findalldevs(&alldevs, errbuf) == -1)
	{
		fprintf(stderr,"Error in pcap_findalldevs: %s\n", errbuf);
		return -1;
	}
    
    /* Print the list */
    for(d=alldevs; d; d=d->next)
    {
        printf("%d. %s", ++i, d->name);
        if (d->description)
            printf(" (%s)\n", d->description);
        else
            printf(" (No description available)\n");
    }
	
    if(i==0)
    {
        printf("\nNo interfaces found! Make sure WinPcap is installed.\n");
        return -1;
    }
    
    printf("Enter the interface number (1-%d):",i);
    scanf("%d", &inum);
    
    if(inum < 1 || inum > i)
    {
        printf("\nInterface number out of range.\n");
        /* Free the device list */
        pcap_freealldevs(alldevs);
        return -1;
    }
	
    /* Jump to the selected adapter */
    for(d=alldevs, i=0; i< inum-1 ;d=d->next, i++);
    
	/* Open the adapter */
	if ((adhandle= pcap_open_live(d->name,	// name of the device
							 65536,			// portion of the packet to capture. 
											// 65536 grants that the whole packet will be captured on all the MACs.
							 1,				// promiscuous mode (nonzero means promiscuous)
							 1000,			// read timeout
							 errbuf			// error buffer
							 )) == NULL)
	{
		fprintf(stderr,"\nUnable to open the adapter. %s is not supported by WinPcap\n", d->name);
		/* Free the device list */
		pcap_freealldevs(alldevs);
		return -1;
	}
    
    printf("\nlistening on %s...\n", d->description);
	
    /* At this point, we don't need any more the device list. Free it */
    pcap_freealldevs(alldevs);


	//PCBest VR2 API initialization
	VR_InitCapture(0);
    VR_SetNIC(-1);

    VR_SetChannelCount(4);
	VR_SetAudioRootFolder("c:\\temp\\VR2");

	//log
    VR_SetLogLevel(4);
    VR_SetLogFileName("C:\\temp\\VR2\\VR2.txt");

	//Protocol: SIP, H323, RTP, MGCP, and SCCP or SKINNY or SKINNY_CCM71 or SCCP_CCM71, IAX2
	VR_SetProtocol("SIP");
	//VR_SetPort(2000);

	//VR_SetCB_Call_Offered(cb_call_offered);
	//VR_SetCB_Call_Connected(cb_call_connected);
	//VR_SetCB_Call_Idle(cb_call_idle);

	//if(m_btnEnableAudioStream.GetCheck() == 1)
	//{
	//	VR_SetCB_Call_Audio_Buffer(cb_call_audio_buffer);
	//}

    VR_StartCapture();
	///////////////////////////////

	
	/* Retrieve the packets */
	while((res = pcap_next_ex( adhandle, &header, &pkt_data)) >= 0){
		
		if(res == 0)
			/* Timeout elapsed */
			continue;
		
		/*
		// convert the timestamp to readable format
		local_tv_sec = header->ts.tv_sec;
		ltime=localtime(&local_tv_sec);
		strftime( timestr, sizeof timestr, "%H:%M:%S", ltime);
		
		printf("%s,%.6d len:%d\n", timestr, header->ts.tv_usec, header->len);
		*/

		VR_ProcessEthernetFrame(&header->ts, pkt_data, header->len);
	}
	
	if(res == -1){
		printf("Error reading the packets: %s\n", pcap_geterr(adhandle));
		return -1;
	}

	//PCBest VR2 API uninlialize
    VR_StopCapture();
    VR_FreeCapture();

   pcap_close(adhandle);  
   return 0;
}

