unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OleCtrls, VR2CtrlLib_TLB;

type
  TForm1 = class(TForm)
    VR2Ctrl1: TVR2Ctrl;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label2: TLabel;
    Edit1: TEdit;
    btnStart: TButton;
    btnStop: TButton;
    Label3: TLabel;
    Edit2: TEdit;
    Label4: TLabel;
    Chan1Log: TEdit;
    Label5: TLabel;
    Chan2Log: TEdit;
    Label6: TLabel;
    Chan3Log: TEdit;
    Label7: TLabel;
    Chan4Log: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure VR2Ctrl1CallConnected(ASender: TObject; ChanID: Integer;
      const CallerIP, CallerID, CalleeIP, CalleeID: WideString; InitTime,
      ConnectTime: Integer; const UniqueID, AudioFile: WideString;
      CallDir: Integer);
    procedure VR2Ctrl1CallOffered(ASender: TObject; ChanID: Integer;
      const CallerIP, CallerID, CalleeIP, CalleeID: WideString;
      CallTime: Integer; const UniqueID, AudioFile: WideString;
      CallDir: Integer);
    procedure VR2Ctrl1CallIdle(ASender: TObject; ChanID: Integer;
      const CallerIP, CallerID, CalleeIP, CalleeID: WideString; InitTime,
      ConnectTime, EndTime: Integer; const UniqueID, AudioFile: WideString;
      AudioFileNum, Reason, CallDir: Integer; const DTMFStr: WideString);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure LogChanInfo(idx: integer; info: string);
  end;

var
  Form1: TForm1;
  Recording: Boolean;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
    var j: integer;
    var i: integer;
    var s: string;
begin
    VR2Ctrl1.InitCapture(0);

for j := 0 to VR2Ctrl1.GetNICCount()-1 do
  begin
        s := VR2Ctrl1.GetNICDescription(j) + ' - IP:';
        for i := 0 to VR2Ctrl1.GetNICIPCount(j)-1 do
        begin
            if(VR2Ctrl1.GetNICIP(j, i) <> '0.0.0.0') then
            begin
                s := s + VR2Ctrl1.GetNICIP(j, i) + ';';
            end;
        end;
        ComboBox1.AddItem(s, nil);
  end;

  ComboBox1.ItemIndex := 0;
  Edit1.Text := 'c:\temp';
  Edit2.Text := '4';

  btnStart.Enabled := true;
  btnStop.Enabled := false;

  Chan1Log.Text := '';
  Chan2Log.Text := '';
  Chan3Log.Text := '';
  Chan4Log.Text := '';

  //VR2 ActiveX Control Must be Visible, in order to get events
  //But we can change its width and height to minimal,
  //So it won't see in the GUI
  VR2Ctrl1.Width := 0;
  VR2Ctrl1.Height := 0;

  Recording := false;

end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    if recording then
    begin
         VR2Ctrl1.StopCapture();
    end;
    VR2Ctrl1.FreeCapture();
end;

procedure TForm1.LogChanInfo(idx: integer; info: string);
begin
       if idx = 0 then
       begin
             Chan1Log.Text := info;
       end;
       if idx = 1 then
       begin
             Chan2Log.Text := info;
       end;
       if idx = 2 then
       begin
             Chan3Log.Text := info;
       end;
       if idx = 3 then
       begin
             Chan4Log.Text := info;
       end;
end;

procedure TForm1.btnStartClick(Sender: TObject);
begin
      VR2Ctrl1.SetLogLevel(4);
      VR2Ctrl1.SetLogFileName('c:\temp\vr2.log');

      VR2Ctrl1.SetNIC(ComboBox1.ItemIndex);
      VR2Ctrl1.SetChannelCount(4); //should use value from Edit2.Text
      VR2Ctrl1.SetAudioRootFolder(Edit1.Text);

      VR2Ctrl1.SetProtocol('SIP');

      VR2Ctrl1.StartCapture();

      btnStart.Enabled := false;
      btnStop.Enabled := true;

      Recording := true;
end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
      VR2Ctrl1.StopCapture();

      btnStart.Enabled := true;
      btnStop.Enabled := false;

      Recording := false;

      //Reset the component for next time use
      VR2Ctrl1.FreeCapture();
      VR2Ctrl1.InitCapture(0);
end;

procedure TForm1.VR2Ctrl1CallConnected(ASender: TObject; ChanID: Integer;
  const CallerIP, CallerID, CalleeIP, CalleeID: WideString; InitTime,
  ConnectTime: Integer; const UniqueID, AudioFile: WideString;
  CallDir: Integer);
var s: string;
begin
  s := 'Call Connected' +  CallerID + ' ' +  CalleeID;
  LogChanInfo(ChanID, s);
end;

procedure TForm1.VR2Ctrl1CallOffered(ASender: TObject; ChanID: Integer;
  const CallerIP, CallerID, CalleeIP, CalleeID: WideString;
  CallTime: Integer; const UniqueID, AudioFile: WideString;
  CallDir: Integer);
var s: string;
begin
  s := 'New Call' +  CallerID + ' ' +  CalleeID;
  LogChanInfo(ChanID, s);

end;

procedure TForm1.VR2Ctrl1CallIdle(ASender: TObject; ChanID: Integer;
  const CallerIP, CallerID, CalleeIP, CalleeID: WideString; InitTime,
  ConnectTime, EndTime: Integer; const UniqueID, AudioFile: WideString;
  AudioFileNum, Reason, CallDir: Integer; const DTMFStr: WideString);
var s: string;
begin
  s := 'Call done' +  CallerID + ' ' +  CalleeID;
  LogChanInfo(ChanID, s);

end;

end.
