﻿Public Class Form1
    Public m_pCallOffered As VRAPIASM.VRAPIEnv.VR_CB_Call_Offered
    Public m_pCallConnected As VRAPIASM.VRAPIEnv.VR_CB_Call_Connected
    Public m_pCallIdle As VRAPIASM.VRAPIEnv.VR_CB_Call_Idle
    Public m_pCallDTMF As VRAPIASM.VRAPIEnv.VR_CB_Call_DTMF
    Public m_pSIPCallInfo As VRAPIASM.VRAPIEnv.VR_CB_Call_SIP_Info

    Private ChanNum As Integer

    Public Shared main_form As Form1
    Public Started As Boolean

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ChanNum = 0

        m_pCallOffered = New VRAPIASM.VRAPIEnv.VR_CB_Call_Offered(AddressOf cbCallOffered)
        m_pCallConnected = New VRAPIASM.VRAPIEnv.VR_CB_Call_Connected(AddressOf cbCallConnected)
        m_pCallIdle = New VRAPIASM.VRAPIEnv.VR_CB_Call_Idle(AddressOf cbCallIdle)
        m_pCallDTMF = New VRAPIASM.VRAPIEnv.VR_CB_Call_DTMF(AddressOf cbCallDTMF)
        m_pSIPCallInfo = New VRAPIASM.VRAPIEnv.VR_CB_Call_SIP_Info(AddressOf cb_Call_SIP_Info)

        main_form = Me

        Started = False


        VRAPIASM.VRAPIEnv.InitCapture(0)

        Dim nicCount As Short = VRAPIASM.VRAPIEnv.GetNICCount()

        If nicCount <= 0 Then
            MessageBox.Show("No Network Interface!")
            btnStartAndStop.Enabled = False
        Else
            For i As Short = 0 To nicCount - 1
                Dim s As String = i.ToString() & " : " & VRAPIASM.VRAPIEnv.GetNICName(i) & " - " & VRAPIASM.VRAPIEnv.GetNICDescription(i)
                cbNIC.Items.Add(s)
            Next
            cbNIC.SelectedIndex = 0
        End If

        tbChanNum.Text = "4"

        DataGridView1.Enabled = False


    End Sub


    Public Function OnCallOffered(ByVal ChanIndex As Integer, ByVal CallerIP As String, ByVal CallerID As String, ByVal CalleeIP As String, ByVal CalleeID As String, ByVal CallTime As UInteger, _
     ByVal UniqueID As String, ByVal AudioFile As String, ByVal CallDir As Integer) As Integer
        DataGridView1.Rows(ChanIndex).Cells(0).Value = "Ringing"
        DataGridView1.Rows(ChanIndex).Cells(1).Value = CallerIP
        DataGridView1.Rows(ChanIndex).Cells(2).Value = CallerID
        DataGridView1.Rows(ChanIndex).Cells(3).Value = CalleeIP
        DataGridView1.Rows(ChanIndex).Cells(4).Value = CalleeID
        DataGridView1.Rows(ChanIndex).Cells(5).Value = UniqueID
        DataGridView1.Rows(ChanIndex).Cells(6).Value = AudioFile
        DataGridView1.Rows(ChanIndex).Cells(7).Value = If(CallDir = 0, "Inbound", "Outbound")
        Return 1
    End Function


    Public Shared Function cbCallOffered(ByVal ChanIndex As Integer, ByVal CallerIP As String, ByVal CallerID As String, ByVal CalleeIP As String, ByVal CalleeID As String, ByVal CallTime As UInteger, _
     ByVal UniqueID As String, ByVal AudioFile As String, ByVal CallDir As Integer) As Integer
        Return main_form.OnCallOffered(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, CallTime, _
         UniqueID, AudioFile, CallDir)
    End Function

    Public Sub OnCallConnected(ByVal ChanIndex As Integer, ByVal CallerIP As String, ByVal CallerID As String, ByVal CalleeIP As String, ByVal CalleeID As String, ByVal InitTime As UInteger, _
     ByVal ConnectTime As UInteger, ByVal UniqueID As String, ByVal AudioFile As String, ByVal CallDir As Integer)
        dataGridView1.Rows(ChanIndex).Cells(0).Value = "Recording"
        dataGridView1.Rows(ChanIndex).Cells(1).Value = CallerIP
        dataGridView1.Rows(ChanIndex).Cells(2).Value = CallerID
        dataGridView1.Rows(ChanIndex).Cells(3).Value = CalleeIP
        dataGridView1.Rows(ChanIndex).Cells(4).Value = CalleeID
        dataGridView1.Rows(ChanIndex).Cells(5).Value = UniqueID
        dataGridView1.Rows(ChanIndex).Cells(6).Value = AudioFile
        dataGridView1.Rows(ChanIndex).Cells(7).Value = If(CallDir = 0, "Inbound", "Outbound")
    End Sub

    Public Shared Sub cbCallConnected(ByVal ChanIndex As Integer, ByVal CallerIP As String, ByVal CallerID As String, ByVal CalleeIP As String, ByVal CalleeID As String, ByVal InitTime As UInteger, _
     ByVal ConnectTime As UInteger, ByVal UniqueID As String, ByVal AudioFile As String, ByVal CallDir As Integer)
        main_form.OnCallConnected(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, InitTime, _
         ConnectTime, UniqueID, AudioFile, CallDir)
    End Sub

    Public Sub OnCallIdle(ByVal ChanIndex As Integer, ByVal CallerIP As String, ByVal CallerID As String, ByVal CalleeIP As String, ByVal CalleeID As String, ByVal InitTime As UInteger, _
     ByVal ConnectTime As UInteger, ByVal EndTime As UInteger, ByVal UniqueID As String, ByVal AudioFile As String, ByVal AudioFileNum As Integer, ByVal Reason As Integer, _
     ByVal CallDir As Integer, ByVal DTMFStr As String)
        dataGridView1.Rows(ChanIndex).Cells(0).Value = "Idle"
        dataGridView1.Rows(ChanIndex).Cells(1).Value = ""
        dataGridView1.Rows(ChanIndex).Cells(2).Value = ""
        dataGridView1.Rows(ChanIndex).Cells(3).Value = ""
        dataGridView1.Rows(ChanIndex).Cells(4).Value = ""
        dataGridView1.Rows(ChanIndex).Cells(5).Value = ""
        dataGridView1.Rows(ChanIndex).Cells(6).Value = ""
        dataGridView1.Rows(ChanIndex).Cells(7).Value = ""
        dataGridView1.Rows(ChanIndex).Cells(8).Value = ""
    End Sub

    Public Shared Sub cbCallIdle(ByVal ChanIndex As Integer, ByVal CallerIP As String, ByVal CallerID As String, ByVal CalleeIP As String, ByVal CalleeID As String, ByVal InitTime As UInteger, _
     ByVal ConnectTime As UInteger, ByVal EndTime As UInteger, ByVal UniqueID As String, ByVal AudioFile As String, ByVal AudioFileNum As Integer, ByVal Reason As Integer, _
     ByVal CallDir As Integer, ByVal DTMFStr As String, ByVal Codec as Integer)
        main_form.OnCallIdle(ChanIndex, CallerIP, CallerID, CalleeIP, CalleeID, InitTime, _
         ConnectTime, EndTime, UniqueID, AudioFile, AudioFileNum, Reason, _
         CallDir, DTMFStr)
    End Sub

    Public Shared Sub cbCallDTMF(ByVal ChanIndex As Integer, ByVal KeyPressed As String, ByVal DTMFStr As String)
    End Sub

    Public Shared Sub cb_Call_SIP_Info(ByVal ChanIndex As Integer, ByVal CallerIP As String, ByVal CallerID As String, ByVal CalleeIP As String, ByVal CalleeID As String, ByVal UniqueID As String, ByVal RequestURI As String, ByVal ContactAddr As String, ByVal PAssertedIdentity As String, ByVal PChargingVector As String, ByVal SIPCallID As String, ByVal SIPInviteMsg As String)
    End Sub


    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        If Started Then
            StopRecord()
        End If

        VRAPIASM.VRAPIEnv.FreeCapture()
    End Sub

    Public Sub StartRecord()
        VRAPIASM.VRAPIEnv.SetAudioRootFolder(tbRootFolder.Text)

        '<!-- 0 = default(.wav), 1 = mp3, 2 = gsm -->
        VRAPIASM.VRAPIEnv.SetAudioFileFormat(1)

        'log
        VRAPIASM.VRAPIEnv.SetLogFileName("c:\temp\VoIP-Recorder-Log.txt")
        VRAPIASM.VRAPIEnv.SetLogLevel(4)

        'license key
        'VRAPIASM.VRAPIEnv.SetLicenseKey("");

        'how many channels to open
        VRAPIASM.VRAPIEnv.SetChannelCount(Convert.ToInt32(tbChanNum.Text))

        'SIP, SCCP or SKINNY, RTP, H323, IAX2, UNISTIM, MGCP
        'NOTE: only SIP, SCCP, RTP, and MGCP work so far
        VRAPIASM.VRAPIEnv.SetProtocol("SIP")

        VRAPIASM.VRAPIEnv.SetNIC(Convert.ToInt16(cbNIC.SelectedIndex))

        VRAPIASM.VRAPIEnv.SetCB_Call_Offered(m_pCallOffered)
        VRAPIASM.VRAPIEnv.SetCB_Call_Connected(m_pCallConnected)
        VRAPIASM.VRAPIEnv.SetCB_Call_Idle(m_pCallIdle)
        VRAPIASM.VRAPIEnv.SetCB_Call_DTMF(m_pCallDTMF)
        VRAPIASM.VRAPIEnv.SetCB_Call_SIP_Info(m_pSIPCallInfo)

        VRAPIASM.VRAPIEnv.StartCapture()

        ChanNum = VRAPIASM.VRAPIEnv.GetChannelCount()

        '
        '            if (VRAPIASM.VRAPIEnv.IsLicensed() != 0)
        '            {
        '                VRAPIASM.VRAPIEnv.Log(4, "Licensed Software");
        '            }


        If Not DataGridView1.Enabled OrElse DataGridView1.RowCount <> ChanNum Then
            DataGridView1.Enabled = True

            DataGridView1.RowCount = ChanNum
            DataGridView1.ColumnCount = 9

            DataGridView1.Columns(0).HeaderText = "Status"
            DataGridView1.Columns(1).HeaderText = "CallerIP"
            DataGridView1.Columns(2).HeaderText = "CallerID"
            DataGridView1.Columns(3).HeaderText = "CalleeIP"
            DataGridView1.Columns(4).HeaderText = "calleeID"
            DataGridView1.Columns(5).HeaderText = "UniqueID"
            DataGridView1.Columns(6).HeaderText = "AudioFile"
            DataGridView1.Columns(7).HeaderText = "Direction"
            DataGridView1.Columns(8).HeaderText = "DTMF"

            'dataGridView1.Rows[0].HeaderCell.OwningColumn.Width = 200;

            For i As Integer = 0 To ChanNum - 1
                Dim index As Integer = i + 1
                DataGridView1.Rows(i).HeaderCell.Value = index.ToString()
                DataGridView1.Rows(i).Cells(0).Value = "Idle"
            Next
        End If

        Started = True
        btnStartAndStop.Text = "Stop"
    End Sub

    Public Sub StopRecord()
        DataGridView1.Enabled = False

        VRAPIASM.VRAPIEnv.StopCapture()

        'reset recorder API just in case
        VRAPIASM.VRAPIEnv.FreeCapture()
        VRAPIASM.VRAPIEnv.InitCapture(0)

        Started = False
        btnStartAndStop.Text = "Start"
    End Sub

    Private Sub btnBrowse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBrowse.Click
        If FolderBrowserDialog1.ShowDialog() = DialogResult.OK Then
            tbRootFolder.Text = FolderBrowserDialog1.SelectedPath
        End If
    End Sub

    Private Sub btnStartAndStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStartAndStop.Click
        If Not Started Then
            StartRecord()
        Else
            StopRecord()
        End If
    End Sub
End Class
