using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace VR2WinApp
{
    public partial class RunningModel : Form
    {
        public int RunModel;
        public string ServerIP;
        public ushort ServerPort;

        public RunningModel()
        {
            InitializeComponent();
            RunModel = 0;
            ServerIP = "";
            ServerPort = 0;
        }

        private void RunningModel_Load(object sender, EventArgs e)
        {
            if (RunModel == 0)
            {
                radioButton1.Checked = true;
                radioButton2.Checked = false;
                tbIPAddr.Enabled = false;
                tbPort.Enabled = false;
                radioButton3.Checked = false;
                tbIPAddr1.Enabled = false;
                tbPort1.Enabled = false;
            }
            else if (RunModel == 1)
            {
                radioButton1.Checked = false;
                radioButton2.Checked = true;
                tbIPAddr.Enabled = true;
                tbIPAddr.ReadOnly = true;
                tbIPAddr.Text = "127.0.0.1";
                tbPort.Enabled = true;
                tbPort.Text = ServerPort.ToString();
                radioButton3.Checked = false;
                tbIPAddr1.Enabled = false;
                tbPort1.Enabled = false;
            }
            else if (RunModel == 2)
            {
                radioButton1.Checked = false;
                radioButton2.Checked = false;
                tbIPAddr.Enabled = false;
                tbPort.Enabled = false;
                radioButton3.Checked = true;
                tbIPAddr1.Enabled = true;
                tbIPAddr1.Text = ServerIP;
                tbPort1.Enabled = true;
                tbPort1.Text = ServerPort.ToString();
            }
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton1.Checked)
            {
                tbIPAddr.Enabled = false;
                tbPort.Enabled = false;
                tbIPAddr1.Enabled = false;
                tbPort1.Enabled = false;
            }
            else if (radioButton2.Checked)
            {
                tbIPAddr.Enabled = true;
                tbIPAddr.ReadOnly = true;
                tbIPAddr.Text = "127.0.0.1";
                tbPort.Enabled = true;
                tbPort.Text = ServerPort.ToString();

                tbIPAddr1.Enabled = false;
                tbPort1.Enabled = false;
            }
            else if (radioButton3.Checked)
            {
                tbIPAddr.Enabled = false;
                tbPort.Enabled = false;

                tbIPAddr1.Enabled = true;
                tbIPAddr1.Text = ServerIP;
                tbPort1.Enabled = true;
                tbPort1.Text = ServerPort.ToString();
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (radioButton1.Checked)
            {
                RunModel = 0;
            }
            else if (radioButton2.Checked)
            {
                RunModel = 1;
                ServerIP = tbIPAddr.Text;
                ServerPort = Convert.ToUInt16(tbPort.Text);
            }
            else if (radioButton3.Checked)
            {
                RunModel = 2;
                ServerIP = tbIPAddr1.Text;
                ServerPort = Convert.ToUInt16(tbPort1.Text);
            }

            DialogResult = DialogResult.OK;

            Close();
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton1.Checked)
            {
                tbIPAddr.Enabled = false;
                tbPort.Enabled = false;
                tbIPAddr1.Enabled = false;
                tbPort1.Enabled = false;
            }
            else if (radioButton2.Checked)
            {
                tbIPAddr.Enabled = true;
                tbIPAddr.ReadOnly = true;
                tbIPAddr.Text = "127.0.0.1";
                tbPort.Enabled = true;
                tbPort.Text = ServerPort.ToString();

                tbIPAddr1.Enabled = false;
                tbPort1.Enabled = false;
            }
            else if (radioButton3.Checked)
            {
                tbIPAddr.Enabled = false;
                tbPort.Enabled = false;

                tbIPAddr1.Enabled = true;
                tbIPAddr1.Text = ServerIP;
                tbPort1.Enabled = true;
                tbPort1.Text = ServerPort.ToString();
            }
        }

        private void radioButton3_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton1.Checked)
            {
                tbIPAddr.Enabled = false;
                tbPort.Enabled = false;
                tbIPAddr1.Enabled = false;
                tbPort1.Enabled = false;
            }
            else if (radioButton2.Checked)
            {
                tbIPAddr.Enabled = true;
                tbIPAddr.ReadOnly = true;
                tbIPAddr.Text = "127.0.0.1";
                tbPort.Enabled = true;
                tbPort.Text = ServerPort.ToString();

                tbIPAddr1.Enabled = false;
                tbPort1.Enabled = false;
            }
            else if (radioButton3.Checked)
            {
                tbIPAddr.Enabled = false;
                tbPort.Enabled = false;

                tbIPAddr1.Enabled = true;
                tbIPAddr1.Text = ServerIP;
                tbPort1.Enabled = true;
                tbPort1.Text = ServerPort.ToString();
            }
        }


    }
}