using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.IO;
using Traysoft.AddTapi;
using VR2;

namespace VR2WinApp
{
    public partial class VR2Options : Form
    {
        public XmlDocument xmlCfg;
       //public Form1 mainForm;
        public int StartRecordingOnBoot;
        public string AdminPassword;
        public List<string> NICs;

        public VR2Options()
        {
            InitializeComponent();
            //mainForm = null;
            xmlCfg = null;
            StartRecordingOnBoot = 0;
            AdminPassword = "";
        }

        public static bool GetBooleanFromXMLNode(XmlNode tmpNode)
        {
            if (tmpNode != null)
            {
                if (tmpNode.InnerText.Trim().ToUpper() == "TRUE")
                    return true;
                else
                {
                    if (tmpNode.InnerText.Trim() == "1")
                        return true;
                    else
                        return false;
                }
            }

            return false;
        }


        private void VR2Options_Load(object sender, EventArgs e)
        {
            for (int i = 0; i < NICs.Count; i++)
            {
                cbNICs.Items.Add(NICs[i]);
            }

            cbNICs.SelectedIndex = 0;

            cbAddWavDateTime.Items.Add("0 - Disabled");
            cbAddWavDateTime.Items.Add("1 - Add at the beginning of recording");
            cbAddWavDateTime.Items.Add("2 - Add at the end of recording");
            cbAddWavDateTime.SelectedIndex = 0;

            if (StartRecordingOnBoot == 1)
                cbStartRecordingOnBoot.Checked = true;
            else
                cbStartRecordingOnBoot.Checked = false;

            if (AdminPassword.Length > 0)
                lbAdminPassword.Text = "Password Set";
            else
                lbAdminPassword.Text = "No Password";

            XmlElement root = xmlCfg.DocumentElement;

            XmlNode tmpNode = null;

            try
            {
                /*
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Type");
                if (tmpNode != null)
                {
                    VRType = Convert.ToInt32(tmpNode.InnerText.Trim());
                }
                */

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioRootFolder");
                    if (tmpNode != null)
                    {
                        tbRootFolder.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioFileName");
                    if (tmpNode != null)
                    {
                        tbAudioFileName.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioFileFormat");
                    if (tmpNode != null)
                    {
                        int AudioFormat = Convert.ToInt32(tmpNode.InnerText.Trim());

                        if (AudioFormat == 0)
                        {
                            rbWav.Checked = true;
                            rbMP3.Checked = false;
                            rbGSM.Checked = false;
                            rbWZP.Checked = false;
                            rbRaw.Checked = false;
                        }
                        else if (AudioFormat == 1)
                        {
                            rbWav.Checked = false;
                            rbMP3.Checked = true;
                            rbGSM.Checked = false;
                            rbWZP.Checked = false;
                            rbRaw.Checked = false;
                        }
                        else if (AudioFormat == 2)
                        {
                            rbWav.Checked = false;
                            rbMP3.Checked = false;
                            rbGSM.Checked = true;
                            rbWZP.Checked = false;
                            rbRaw.Checked = false;
                        }
                        else if (AudioFormat == 3)
                        {
                            rbWav.Checked = false;
                            rbMP3.Checked = false;
                            rbGSM.Checked = false;
                            rbWZP.Checked = true;
                            rbRaw.Checked = false;
                        }
                        else if (AudioFormat == 4)
                        {
                            rbWav.Checked = false;
                            rbMP3.Checked = false;
                            rbGSM.Checked = false;
                            rbWZP.Checked = false;
                            rbRaw.Checked = true;
                        }

                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/EncryptAudioFile");
                    if (tmpNode != null)
                    {
                        if (Convert.ToInt32(tmpNode.InnerText.Trim()) == 1)
                        {
                            cbEncryptAudioFile.Checked = true;
                        }
                        else
                        {
                            cbEncryptAudioFile.Checked = false;
                        }
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                /*
                                tmpNode = root.SelectSingleNode("//VoiceRecorder/Credential");
                                if (tmpNode != null)
                                {
                                    try
                                    {
                                        string sCredential = tmpNode.InnerText.Trim();
                                        if (sCredential.Length > 0)
                                        {
                                            char[] delimiters = new char[] { ';', ',' };
                                            string[] members = sCredential.Split(delimiters, StringSplitOptions.None);
                                            if (members.Length == 3)
                                            {
                                                UserName = members[0];
                                                Password = new SecureString();
                                                for (int j = 0; j < members[1].Length; j++)
                                                {
                                                    Password.AppendChar(members[1][j]);
                                                }
                                                Domain = members[2];
                                            }
                                        }
                                    }
                                    catch (Exception)
                                    {
                                    }
                                }*/

                cbLogLevel.Items.Add("Disabled");
                cbLogLevel.Items.Add("Error only");
                cbLogLevel.Items.Add("Error + Warning");
                cbLogLevel.Items.Add("Error + Warning + Debug");
                cbLogLevel.Items.Add("ALL");
                cbLogLevel.SelectedIndex = 0;
                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/LogLevel");
                    if (tmpNode != null)
                    {
                        try
                        {
                            cbLogLevel.SelectedIndex = Convert.ToInt16(tmpNode.InnerText.Trim());
                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show(ex.ToString());
                        }
                    }
                    else
                    {
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                tbLogFile.Text = "";
                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/LogFileName");
                    if (tmpNode != null)
                    {
                        tbLogFile.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                //Filters:
                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Filters");
                    if (tmpNode != null)
                    {
                        tbFilters.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Excludes");
                    if (tmpNode != null)
                    {
                        tbExcludes.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/ChannelCount");
                    if (tmpNode != null)
                    {
                        tbChannels.Text = tmpNode.InnerText.Trim();
                        if (tbChannels.Text == "")
                            tbChannels.Text = "4";
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/LicKey");
                    if (tmpNode != null)
                    {
                        tbLicKey.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/LicMAC");
                    if (tmpNode != null)
                    {
                        tbLicMAC.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/ManagerPort");
                    if (tmpNode != null)
                    {
                        tbManagePort.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/KeepRecordMaxDays");
                    if (tmpNode != null)
                    {
                        tbMaxDays.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/FIFOSpaceInMB");
                    if (tmpNode != null)
                    {
                        tbFIFOSpace.Text = tmpNode.InnerText.Trim();
                    }
                    else
                    {
                        tbFIFOSpace.Text = "0";
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/EnableRTSrv");
                    if (tmpNode != null)
                    {
                        int EnableRTSrv;
                        try
                        {
                            EnableRTSrv = Convert.ToInt32(tmpNode.InnerText.Trim());
                        }
                        catch (Exception)
                        {
                            EnableRTSrv = 0;
                        }

                        if (EnableRTSrv == 1)
                        {
                            cbRTSrv.Checked = true;
                            cbBIB.Checked = false;
                        }
                        else if (EnableRTSrv == 2)
                        {
                            cbRTSrv.Checked = true;
                            cbBIB.Checked = true;
                        }
                        else
                        {
                            cbRTSrv.Checked = false;
                            cbBIB.Checked = false;
                        }

                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/CiscoBIB/RecordingTrunk");
                    if (tmpNode != null)
                    {
                        tbBIBRecordingTrunkName.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }
				
                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/CiscoBIB/IncomingTrunk");
                    if (tmpNode != null)
                    {
						tbBIBIncomingTrunkName.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/CiscoBIB/OutgoingTrunk");
                    if (tmpNode != null)
                    {
						tbBIBOutgoingTrunkName.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }				

                //DATABASE
                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Enabled");
                    if (tmpNode != null)
                    {
                        cbDBEnabled.Checked = GetBooleanFromXMLNode(tmpNode);
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBType");
                    if (tmpNode != null)
                    {
                        cbDBType.SelectedIndex = Convert.ToInt32(tmpNode.InnerText);
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBServer");
                    if (tmpNode != null)
                    {
                        tbDBServer.Text = tmpNode.InnerText;
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBName");
                    if (tmpNode != null)
                    {
                        tbDBName.Text = tmpNode.InnerText;
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/AuthType");
                    if (tmpNode != null)
                    {
                        cbDBAuthType.SelectedIndex = Convert.ToInt32(tmpNode.InnerText);
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/UserName");
                    if (tmpNode != null)
                    {

                        tbDBUserName.Text = tmpNode.InnerText;
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {

                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Password");
                    if (tmpNode != null)
                    {
                        tbDBPassword.Text = tmpNode.InnerText;
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

/*
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/CallLogTableName");
                if (tmpNode != null)
                {
                    if (tmpNode.InnerText.Length > 0)
                        db_set.CallLogTableName = tmpNode.InnerText;
                }

                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/ChannelStatusTableName");
                if (tmpNode != null)
                {
                    if (tmpNode.InnerText.Length > 0)
                        db_set.ChannelStatusTableName = tmpNode.InnerText;
                }*/

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/UpdateChannelStatusToDB");
                    if (tmpNode != null)
                    {
                        cbUpdateChanToDB.Checked = GetBooleanFromXMLNode(tmpNode);
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                //VoIP related options
                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Protocol");
                    if (tmpNode != null)
                    {
                        cbProtocol.Text = tmpNode.InnerText.Trim();
                    }

                    if (cbProtocol.Text == "SIP" || cbProtocol.Text == "RTP")
                    {
                        tbPort.Enabled = false;
                    }
                    else
                    {
                        tbPort.Enabled = true;
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Port");
                    if (tmpNode != null)
                    {
                        tbPort.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/PromiscuousMode");
                }
                catch (Exception)
                {
                    tmpNode = null;
                }

                try
                {
                    if (tmpNode != null)
                    {
                        cbPromiscuousMode.Checked = Convert.ToInt32(tmpNode.InnerText) != 0;
                    }
                    else
                    {
                        tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Port");
                        if (tmpNode != null)
                        {
                            //Create a new node.
                            XmlElement elem = xmlCfg.CreateElement("PromiscuousMode");
                            elem.InnerText = "1";

                            //Add the node to the document.
                            tmpNode.ParentNode.AppendChild(elem);

                            cbPromiscuousMode.Checked = true;
                        }
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/NIC");
                    if (tmpNode != null)
                    {
                        string nicTxt = tmpNode.InnerText.Trim();
                        nicTxt = nicTxt.ToLower();

                        if (nicTxt.EndsWith(".pcap"))
                        {
                            cbNICs.Enabled = false;
                            cbPromiscuousMode.Enabled = false;
                            tbPcapFile.Enabled = true;
                            tbPcapFile.Text = nicTxt;
                            btnPcapBrowse.Enabled = true;
                            cbUsePcapFile.Checked = true;

                            //cbDumpToFile.Enabled = false;
                            //cbDumpToFile.Checked = false;
                            //tbDumpFileName.Text = "";
                            //tbDumpFileName.Enabled = false;
                        }
                        else
                        {
                            cbNICs.Enabled = true;
                            cbPromiscuousMode.Enabled = true;

                            cbUsePcapFile.Enabled = true;
                            cbUsePcapFile.Checked = false;
                            tbPcapFile.Enabled = false;
                            tbPcapFile.Text = "";

                            btnPcapBrowse.Enabled = false;

                            //cbDumpToFile.Enabled = true;
                            //cbDumpToFile.Checked = false;
                            //tbDumpFileName.Text = "";
                            //tbDumpFileName.Enabled = false;

                            short NicIndex = 0;

                            try
                            {
                                NicIndex = Convert.ToInt16(nicTxt);
                            }
                            catch (Exception)
                            {
                            }

                            if (NicIndex >= 0 && NicIndex < NICs.Count)
                                cbNICs.SelectedIndex = NicIndex;
                        }
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/DumpFile");
                    if (tmpNode != null)
                    {
                        string dumpFileName = tmpNode.InnerText.Trim();
                        if (dumpFileName.Length > 0)
                        {
                            cbDumpToFile.Enabled = true;
                            cbDumpToFile.Checked = true;
                            tbDumpFileName.Enabled = true;
                            tbDumpFileName.Text = dumpFileName;

                            //cbUsePcapFile.Enabled = false;
                            //cbUsePcapFile.Checked = false;
                            //tbPcapFile.Enabled = false;
                            //btnPcapBrowse.Enabled = false;

                            //cbNICs.Enabled = false;
                        }
                        else
                        {
                            cbDumpToFile.Enabled = true;
                            cbDumpToFile.Checked = false;
                            tbDumpFileName.Text = "";
                            tbDumpFileName.Enabled = false;
                        }
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RTP/PBXAddr");
                    if (tmpNode != null)
                    {
                        tbPBXAddr.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RTP/ExtenAddr");
                    if (tmpNode != null)
                    {
                        tbExtensionList.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/IgnorePossibleSameCall");
                    if (tmpNode != null)
                    {
                        cbIgnorePossibleSameCall.Checked = GetBooleanFromXMLNode(tmpNode);
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Recording");
                    if (tmpNode != null)
                    {
                        cbRecordingCalls.Checked = GetBooleanFromXMLNode(tmpNode);
                    }
                    else
                        cbRecordingCalls.Checked = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordCallLegs");
                    if (tmpNode != null)
                    {
                        cbCallLegs.Checked = GetBooleanFromXMLNode(tmpNode);
                    }
                    else
                        cbCallLegs.Checked = false;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordStereo");
                    if (tmpNode != null)
                    {
                        cbRecordStereo.Checked = GetBooleanFromXMLNode(tmpNode);
                    }
                    else
                        cbRecordStereo.Checked = false;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/XMLCallInfo");
                    if (tmpNode != null)
                    {
                        cbXMLCallInfo.Checked = GetBooleanFromXMLNode(tmpNode);
                    }
                    else
                        cbXMLCallInfo.Checked = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/UsePacketTime");
                    if (tmpNode != null)
                    {
                        cbPacketTime.Checked = GetBooleanFromXMLNode(tmpNode);
                    }
                    else
                        cbPacketTime.Checked = false;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordPauseDTMFKey");
                    if (tmpNode != null)
                    {
                        tbPauseDTMF.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordPauseOption");
                    if (tmpNode != null)
                    {
                        tbPauseSet.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/SIPHeadersInXML");
                    if (tmpNode != null)
                    {
                        tbSIPHeaders.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/ExtenPattern");
                    if (tmpNode != null)
                    {
                        tbExtenPattern.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordOnlyAfterAnswer");
                    if (tmpNode != null)
                    {
                        cbRecordAfterAnswer.Checked = GetBooleanFromXMLNode(tmpNode);
                    }
                    else
                        cbRecordAfterAnswer.Checked = false;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/NoAudioSeconds");
                    if (tmpNode != null)
                    {
                        tbNoAudioSec.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/WriteCallPcapFile");
                    if (tmpNode != null)
                    {
                        if(Convert.ToInt32(tmpNode.InnerText.Trim()) == 1)
                            cbWriteCallPcap.Checked = true;
                        else
                            cbWriteCallPcap.Checked = false;
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }


                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/AddDateTimeAnnouncement");
                    if (tmpNode != null)
                    {
                        int sel = Convert.ToInt32(tmpNode.InnerText.Trim());
                        if (sel >= 0 && sel < 3)
                            cbAddWavDateTime.SelectedIndex = sel;
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/AddDateTimeAnnouncementFmt");
                    if (tmpNode != null)
                    {
                        tbAddWavDateTimeFmt.Text = tmpNode.InnerText.Trim();

                        if(cbAddWavDateTime.SelectedIndex > 0)
                        {
                            tbAddWavDateTimeFmt.Enabled = true;
                        }
                        else
                        {
                            tbAddWavDateTimeFmt.Enabled = false;
                        }

                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }



                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/IDMaps");
                    if (tmpNode != null)
                    {
                        tbIDMaps.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/NotifyEmails");
                    if (tmpNode != null)
                    {
                        tbNotifyEmailAddr.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/NotifyRecordingEmails");
                    if (tmpNode != null)
                    {
                        tbRecordingEmails.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/NotifyRecordingScript");
                    if (tmpNode != null)
                    {
                        tbRecordingScript.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/NotifyXMLServiceURI");
                    if (tmpNode != null)
                    {
                        tbXMLServiceURI.Text = tmpNode.InnerText.Trim();
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Server");
                    if (tmpNode != null)
                        tbSMTPSrv.Text = tmpNode.InnerText;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Port");
                    if (tmpNode != null)
                        tbSMTPPort.Text = tmpNode.InnerText;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/EmailAddr");
                    if (tmpNode != null)
                        tbEmailAddr.Text = tmpNode.InnerText;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Password");
                    if (tmpNode != null)
                        tbEmailPassword.Text = tmpNode.InnerText;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }


                //AddTAPI.NET
                try
                {
                    // Set the serial number if you purchased AddTapi.NET
                    TapiApp.SerialNumber = "2CBCI9C-CKU828D-38QTN3C-7PW22";
                    // Initialize AddTapi
                    TapiApp.Initialize("VR2");
                }
                catch (TapiException exc)
                {
                    MessageBox.Show(exc.Message, "TapiException!", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    //Close();
                }
                catch (Exception exc)
                {
                    MessageBox.Show(exc.Message, "Exception!", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    //Close();
                }

                try
                {
                    string sLines = "";
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/TAPI/MonitorLines");
                    if (tmpNode != null)
                    {
                        sLines = tmpNode.InnerText;
                    }
                    TAPILines.Items.Clear();
                    foreach (TapiLine line in TapiApp.Lines)
                    {
                        string s1 = line.Name + ";";
                        if (sLines.Contains(s1))
                            TAPILines.Items.Add(line, true);
                        else
                            TAPILines.Items.Add(line, false);
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/TAPI/RestartHours");
                    if (tmpNode != null)
                    {
                        tbTAPIRestartHours.Text = tmpNode.InnerText;
                    }
                    else
                    {
                        tbTAPIRestartHours.Text = "0";
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SamsungCDR/ServerIPAddr");
                    if (tmpNode != null)
                    {
                        string ipAddr = tmpNode.InnerText.Trim();
                        ushort port = 0;
                        if (ipAddr.Length > 0)
                        {
                            tmpNode = root.SelectSingleNode("//VoiceRecorder/SamsungCDR/ServerPort");
                            port = Convert.ToUInt16(tmpNode.InnerText.Trim());

                            if (port > 0)
                            {
                                cbEnableSamsung.Checked = true;
                                tbSamsungIP.Text = ipAddr;
                                tbSamsungPort.Text = port.ToString();
                            }
                        }
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

                try
                {
                    cbSSL.Checked = GetBooleanFromXMLNode(root.SelectSingleNode("//VoiceRecorder/SMTPServer/SSL"));
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.ToString(), "Error");
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {

            XmlElement root = xmlCfg.DocumentElement;

            XmlNode tmpNode = null;

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioRootFolder");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbRootFolder.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("AudioRootFolder");
                        elem.InnerText = tbRootFolder.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try{
                tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioFileName");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbAudioFileName.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("AudioFileName");
                        elem.InnerText = tbAudioFileName.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try{
                tmpNode = root.SelectSingleNode("//VoiceRecorder/AudioFileFormat");
                if (tmpNode != null)
                {
                    if (rbWav.Checked) tmpNode.InnerText = "0";
                    if (rbMP3.Checked) tmpNode.InnerText = "1";
                    if (rbGSM.Checked) tmpNode.InnerText = "2";
                    if (rbWZP.Checked) tmpNode.InnerText = "3";
                    if (rbRaw.Checked) tmpNode.InnerText = "4";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("AudioFileName");

                        if (rbWav.Checked) elem.InnerText = "0";
                        if (rbMP3.Checked) elem.InnerText = "1";
                        if (rbGSM.Checked) elem.InnerText = "2";
                        if (rbWZP.Checked) elem.InnerText = "3";
                        if (rbRaw.Checked) elem.InnerText = "4";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try{
                tmpNode = root.SelectSingleNode("//VoiceRecorder/EncryptAudioFile");
                if (tmpNode != null)
                {
                    if(cbEncryptAudioFile.Checked)
                        tmpNode.InnerText = "1";
                    else
                        tmpNode.InnerText = "0";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("EncryptAudioFile");

                        if (cbEncryptAudioFile.Checked)
                            elem.InnerText = "1";
                        else
                            elem.InnerText = "0";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            /*
                            tmpNode = root.SelectSingleNode("//VoiceRecorder/Credential");
                            if (tmpNode != null)
                            {
                                try
                                {
                                    string sCredential = tmpNode.InnerText.Trim();
                                    if (sCredential.Length > 0)
                                    {
                                        char[] delimiters = new char[] { ';', ',' };
                                        string[] members = sCredential.Split(delimiters, StringSplitOptions.None);
                                        if (members.Length == 3)
                                        {
                                            UserName = members[0];
                                            Password = new SecureString();
                                            for (int j = 0; j < members[1].Length; j++)
                                            {
                                                Password.AppendChar(members[1][j]);
                                            }
                                            Domain = members[2];
                                        }
                                    }
                                }
                                catch (Exception)
                                {
                                }
                            }*/

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/LogLevel");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = cbLogLevel.SelectedIndex.ToString();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("LogLevel");

                        elem.InnerText = cbLogLevel.SelectedIndex.ToString();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/LogFileName");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbLogFile.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("LogFileName");

                        elem.InnerText = tbLogFile.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            //Filters:
            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Filters");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbFilters.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Filters");

                        elem.InnerText = tbFilters.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Excludes");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbExcludes.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Excludes");

                        elem.InnerText = tbExcludes.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/ChannelCount");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbChannels.Text.Trim();
                    if (tmpNode.InnerText == "")
                        tmpNode.InnerText = "4";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("ChannelCount");

                        elem.InnerText = tbChannels.Text.Trim();

                        if (elem.InnerText == "")
                            elem.InnerText = "4";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/LicKey");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbLicKey.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("LicKey");

                        elem.InnerText = tbLicKey.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/LicMAC");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbLicMAC.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("LicMAC");

                        elem.InnerText = tbLicMAC.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/ManagerPort");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbManagePort.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("ManagerPort");

                        elem.InnerText = tbManagePort.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/KeepRecordMaxDays");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbMaxDays.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("KeepRecordMaxDays");

                        elem.InnerText = tbMaxDays.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/FIFOSpaceInMB");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbFIFOSpace.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("FIFOSpaceInMB");

                        elem.InnerText = tbFIFOSpace.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/EnableRTSrv");
                if (tmpNode != null)
                {
                    if(cbBIB.Checked)
                        tmpNode.InnerText = "2";
                    else if (cbRTSrv.Checked)
                        tmpNode.InnerText = "1";
                    else
                        tmpNode.InnerText = "0";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("EnableRTSrv");

                        if (cbBIB.Checked)
                            elem.InnerText = "2";
                        else if (cbRTSrv.Checked)
                            elem.InnerText = "1";
                        else
                            elem.InnerText = "0";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }
			
			
			try
			{
				tmpNode = root.SelectSingleNode("//VoiceRecorder/CiscoBIB/RecordingTrunk");
				if (tmpNode != null)
				{
					tmpNode.InnerText = tbBIBRecordingTrunkName.Text.Trim();
				}
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/CiscoBIB");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("RecordingTrunk");

                        elem.InnerText = tbBIBRecordingTrunkName.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
			catch (Exception ex)
			{
				MessageBox.Show(ex.ToString(), "Error");
			}
			
			try
			{
				tmpNode = root.SelectSingleNode("//VoiceRecorder/CiscoBIB/IncomingTrunk");
				if (tmpNode != null)
				{
					tmpNode.InnerText = tbBIBIncomingTrunkName.Text.Trim();
				}
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/CiscoBIB");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("IncomingTrunk");

                        elem.InnerText = tbBIBIncomingTrunkName.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
			catch (Exception ex)
			{
				MessageBox.Show(ex.ToString(), "Error");
			}

			try
			{
				tmpNode = root.SelectSingleNode("//VoiceRecorder/CiscoBIB/OutgoingTrunk");
				if (tmpNode != null)
				{
					tmpNode.InnerText = tbBIBOutgoingTrunkName.Text.Trim();
				}
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/CiscoBIB");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("OutgoingTrunk");

                        elem.InnerText = tbBIBIncomingTrunkName.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
			catch (Exception ex)
			{
				MessageBox.Show(ex.ToString(), "Error");
			}				

            //DATABASE
            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Enabled");
                if (tmpNode != null)
                {
                    if (cbDBEnabled.Checked)
                        tmpNode.InnerText = "true";
                    else
                        tmpNode.InnerText = "false";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Enabled");

                        if (cbDBEnabled.Checked)
                            elem.InnerText = "true";
                        else
                            elem.InnerText = "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBType");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = cbDBType.SelectedIndex.ToString();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("DBType");
                        elem.InnerText = cbDBType.SelectedIndex.ToString();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBServer");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbDBServer.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("DBServer");
                        elem.InnerText = tbDBServer.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/DBName");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbDBName.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("DBName");
                        elem.InnerText = tbDBName.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/AuthType");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = cbDBAuthType.SelectedIndex.ToString();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("AuthType");
                        elem.InnerText = cbDBAuthType.SelectedIndex.ToString();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/UserName");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbDBUserName.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("UserName");
                        elem.InnerText = tbDBUserName.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/Password");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbDBPassword.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Password");
                        elem.InnerText = tbDBPassword.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            /*
                            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/CallLogTableName");
                            if (tmpNode != null)
                            {
                                if (tmpNode.InnerText.Length > 0)
                                    db_set.CallLogTableName = tmpNode.InnerText;
                            }

                            tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/ChannelStatusTableName");
                            if (tmpNode != null)
                            {
                                if (tmpNode.InnerText.Length > 0)
                                    db_set.ChannelStatusTableName = tmpNode.InnerText;
                            }*/

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/Database/UpdateChannelStatusToDB");
                if (tmpNode != null)
                {
                    if (cbUpdateChanToDB.Checked)
                        tmpNode.InnerText = "true";
                    else
                        tmpNode.InnerText = "false";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/Database");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("UpdateChannelStatusToDB");

                        if (cbUpdateChanToDB.Checked)
                            elem.InnerText = "true";
                        else
                            elem.InnerText = "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            //VoIP related options
            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Protocol");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = cbProtocol.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Protocol");
                        elem.InnerText = cbProtocol.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Port");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbPort.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Port");
                        elem.InnerText = tbPort.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/PromiscuousMode");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = cbPromiscuousMode.Checked ? "1" : "0";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("PromiscuousMode");
                        elem.InnerText = cbPromiscuousMode.Checked ? "1" : "0";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/NIC");
                if (tmpNode != null)
                {
                    if (cbUsePcapFile.Checked)
                    {
                        if (tbPcapFile.Text.Trim().Length == 0)
                            tmpNode.InnerText = "0";
                        else
                            tmpNode.InnerText = tbPcapFile.Text;
                    }
                    else
                    {
                        tmpNode.InnerText = cbNICs.SelectedIndex.ToString();
                    }
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("NIC");

                        if (cbUsePcapFile.Checked)
                        {
                            if (tbPcapFile.Text.Trim().Length == 0)
                                elem.InnerText = "0";
                            else
                                elem.InnerText = tbPcapFile.Text;
                        }
                        else
                        {
                            elem.InnerText = cbNICs.SelectedIndex.ToString();
                        }

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/DumpFile");
                if (tmpNode != null)
                {
                    if (cbDumpToFile.Checked)
                    {
                        if (tbDumpFileName.Text.Trim().Length == 0)
                            tmpNode.InnerText = "";
                        else
                            tmpNode.InnerText = tbDumpFileName.Text;
                    }
                    else
                    {
                        tmpNode.InnerText = "";
                    }
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("DumpFile");

                        if (cbDumpToFile.Checked)
                        {
                            if (tbDumpFileName.Text.Trim().Length == 0)
                                elem.InnerText = "";
                            else
                                elem.InnerText = tbDumpFileName.Text;
                        }
                        else
                        {
                            elem.InnerText = "";
                        }

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RTP/PBXAddr");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbPBXAddr.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RTP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("PBXAddr");
                        elem.InnerText = tbPBXAddr.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RTP/ExtenAddr");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbExtensionList.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RTP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("ExtenAddr");
                        elem.InnerText = tbExtensionList.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/IgnorePossibleSameCall");
                if (tmpNode != null)
                {
                    if (cbIgnorePossibleSameCall.Checked)
                        tmpNode.InnerText = "true";
                    else
                        tmpNode.InnerText = "false";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("IgnorePossibleSameCall");
                        elem.InnerText = cbIgnorePossibleSameCall.Checked ? "true" : "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/Recording");
                if (tmpNode != null)
                {
                    if (cbRecordingCalls.Checked)
                        tmpNode.InnerText = "true";
                    else
                        tmpNode.InnerText = "false";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Recording");
                        elem.InnerText = cbRecordingCalls.Checked ? "true" : "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordCallLegs");
                if (tmpNode != null)
                {
                    if (cbCallLegs.Checked)
                        tmpNode.InnerText = "true";
                    else
                        tmpNode.InnerText = "false";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Recording");
                        elem.InnerText = cbCallLegs.Checked ? "true" : "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordStereo");
                if (tmpNode != null)
                {
                    if (cbRecordStereo.Checked)
                        tmpNode.InnerText = "true";
                    else
                        tmpNode.InnerText = "false";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("RecordStereo");
                        elem.InnerText = cbRecordStereo.Checked ? "true" : "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/XMLCallInfo");
                if (tmpNode != null)
                {
                    if (cbXMLCallInfo.Checked)
                        tmpNode.InnerText = "true";
                    else
                        tmpNode.InnerText = "false";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("XMLCallInfo");
                        elem.InnerText = cbXMLCallInfo.Checked ? "true" : "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/UsePacketTime");
                if (tmpNode != null)
                {
                    if (cbPacketTime.Checked)
                        tmpNode.InnerText = "true";
                    else
                        tmpNode.InnerText = "false";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("UsePacketTime");
                        elem.InnerText = cbPacketTime.Checked ? "true" : "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordPauseDTMFKey");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbPauseDTMF.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("RecordPauseDTMFKey");
                        elem.InnerText = tbPauseDTMF.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordPauseOption");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbPauseSet.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("RecordPauseOption");
                        elem.InnerText = tbPauseSet.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/SIPHeadersInXML");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbSIPHeaders.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("SIPHeadersInXML");
                        elem.InnerText = tbSIPHeaders.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/ExtenPattern");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbExtenPattern.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("ExtenPattern");
                        elem.InnerText = tbExtenPattern.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/RecordOnlyAfterAnswer");
                if (tmpNode != null)
                {
                    if (cbRecordAfterAnswer.Checked)
                        tmpNode.InnerText = "true";
                    else
                        tmpNode.InnerText = "false";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("RecordOnlyAfterAnswer");
                        elem.InnerText = cbRecordAfterAnswer.Checked ? "true" : "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/NoAudioSeconds");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbNoAudioSec.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("NoAudioSeconds");
                        elem.InnerText = tbNoAudioSec.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/WriteCallPcapFile");
                if (tmpNode != null)
                {
                    if(cbWriteCallPcap.Checked)
                        tmpNode.InnerText = "1";
                    else
                        tmpNode.InnerText = "0";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("WriteCallPcapFile");
                        elem.InnerText = cbWriteCallPcap.Checked ? "true" : "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }


            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/AddDateTimeAnnouncement");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = cbAddWavDateTime.SelectedIndex.ToString();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("AddDateTimeAnnouncement");
                        elem.InnerText = cbAddWavDateTime.SelectedIndex.ToString();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP/AddDateTimeAnnouncementFmt");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbAddWavDateTimeFmt.Text;
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/VoIP");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("AddDateTimeAnnouncementFmt");
                        elem.InnerText = tbAddWavDateTimeFmt.Text;

                        tmpNode.AppendChild(elem);
                    }
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }


            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/IDMaps");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbIDMaps.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("IDMaps");
                        elem.InnerText = tbIDMaps.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/NotifyEmails");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbNotifyEmailAddr.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("NotifyEmails");
                        elem.InnerText = tbNotifyEmailAddr.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/NotifyRecordingEmails");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbRecordingEmails.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("NotifyRecordingEmails");
                        elem.InnerText = tbRecordingEmails.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/NotifyRecordingScript");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbRecordingScript.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("NotifyRecordingScript");
                        elem.InnerText = tbRecordingScript.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/NotifyXMLServiceURI");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbXMLServiceURI.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("NotifyXMLServiceURI");
                        elem.InnerText = tbXMLServiceURI.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Server");
                if (tmpNode != null)
                    tmpNode.InnerText = tbSMTPSrv.Text.Trim();
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Server");
                        elem.InnerText = tbSMTPSrv.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Port");
                if (tmpNode != null)
                    tmpNode.InnerText = tbSMTPPort.Text.Trim();
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Port");
                        elem.InnerText = tbSMTPPort.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/EmailAddr");
                if (tmpNode != null)
                    tmpNode.InnerText = tbEmailAddr.Text.Trim();
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("EmailAddr");
                        elem.InnerText = tbEmailAddr.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/Password");
                if (tmpNode != null)
                    tmpNode.InnerText = tbEmailPassword.Text.Trim();
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("Password");
                        elem.InnerText = tbEmailPassword.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer/SSL");
                if (tmpNode != null)
                {
                    if (cbSSL.Checked)
                        tmpNode.InnerText = "true";
                    else
                        tmpNode.InnerText = "false";
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SMTPServer");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("SSL");
                        elem.InnerText = cbSSL.Checked ? "true" : "false";

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                string sLines = "";
                tmpNode = root.SelectSingleNode("//VoiceRecorder/TAPI/MonitorLines");
                if (tmpNode != null)
                {
                    foreach (object obj in TAPILines.CheckedItems)
                    {
                        //TapiLine line = (TapiLine) obj;
                        sLines += obj.ToString() + ";";
                    }

                    tmpNode.InnerText = sLines;
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/TAPI");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("MonitorLines");

                        foreach (object obj in TAPILines.CheckedItems)
                        {
                            //TapiLine line = (TapiLine) obj;
                            sLines += obj.ToString() + ";";
                        }

                        elem.InnerText = sLines;

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/TAPI/RestartHours");
                if (tmpNode != null)
                {
                    tmpNode.InnerText = tbTAPIRestartHours.Text.Trim();
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/TAPI");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("RestartHours");
                        elem.InnerText = tbTAPIRestartHours.Text.Trim();

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            try
            {
                tmpNode = root.SelectSingleNode("//VoiceRecorder/SamsungCDR/ServerIPAddr");
                if (tmpNode != null)
                {
                    if (cbEnableSamsung.Checked && tbSamsungIP.Text.Trim().Length > 0 && tbSamsungPort.Text.Length > 0)
                    {
                        tmpNode.InnerText = tbSamsungIP.Text.Trim();
                        tmpNode = root.SelectSingleNode("//VoiceRecorder/SamsungCDR/ServerPort");
                        tmpNode.InnerText = tbSamsungPort.Text;
                    }
                    else
                    {
                        tmpNode.InnerText = "";
                        tmpNode = root.SelectSingleNode("//VoiceRecorder/SamsungCDR/ServerPort");
                        tmpNode.InnerText = "";
                    }
                }
                else
                {
                    tmpNode = root.SelectSingleNode("//VoiceRecorder/SamsungCDR");

                    if (tmpNode != null)
                    {
                        //Create a new node.
                        XmlElement elem = xmlCfg.CreateElement("ServerIPAddr");

                        if (cbEnableSamsung.Checked && tbSamsungIP.Text.Trim().Length > 0 && tbSamsungPort.Text.Length > 0)
                        {
                            elem.InnerText = tbSamsungIP.Text.Trim();
                            tmpNode = root.SelectSingleNode("//VoiceRecorder/SamsungCDR/ServerPort");
                            if(tmpNode != null)
                                tmpNode.InnerText = tbSamsungPort.Text;
                        }
                        else
                        {
                            elem.InnerText = "";
                            tmpNode = root.SelectSingleNode("//VoiceRecorder/SamsungCDR/ServerPort");
                            if (tmpNode != null)
                                tmpNode.InnerText = "";
                        }

                        tmpNode.AppendChild(elem);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error");
            }

            if (cbStartRecordingOnBoot.Checked)
                StartRecordingOnBoot = 1;
            else
                StartRecordingOnBoot = 0;

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        public static string AddFolderDashForDir(string sDir)
        {
            string ret = sDir;
            if (sDir[sDir.Length - 1] != '\\')
                ret += '\\';
            return ret;
        }

        private void btnRootFolderBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folderBrowserDialog1 = new FolderBrowserDialog();
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                tbRootFolder.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void cbUsePcapFile_CheckedChanged(object sender, EventArgs e)
        {
            if (cbUsePcapFile.Checked)
            {
                tbPcapFile.Enabled = true;
                btnPcapBrowse.Enabled = true;
                cbNICs.Enabled = false;
                cbPromiscuousMode.Enabled = false;

                //cbDumpToFile.Enabled = false;
                //tbDumpFileName.Enabled = false;
            }
            else
            {
                tbPcapFile.Enabled = false;
                btnPcapBrowse.Enabled = false;
                cbNICs.Enabled = true;
                cbPromiscuousMode.Enabled = true;

                //cbDumpToFile.Enabled = true;
                //tbDumpFileName.Enabled = true;
            }
        }

        private void btnPcapBrowse_Click(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "WinPcap Files (.pcap)|*.pcap|All Files (*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;
            if (openFileDialog1.ShowDialog() == DialogResult.OK) // Test result.
            {
                tbPcapFile.Text = openFileDialog1.FileName;
            }


        }

        private void cbProtocol_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cbProtocol.Text == "SIP" || cbProtocol.Text == "RTP")
            {
                tbPort.Enabled = false;
            }
            else
            {
                tbPort.Enabled = true;
            }
        }

        private void VR2Options_FormClosed(object sender, FormClosedEventArgs e)
        {
            try
            {
                TapiApp.Shutdown();
            }
            catch (TapiException exc)
            {
                MessageBox.Show(exc.Message, "TapiException!", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message, "Exception!", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnSetAdminPassword_Click(object sender, EventArgs e)
        {
            SetAdminPassword dlg = new SetAdminPassword();
            if(dlg.ShowDialog() == DialogResult.OK)
            {
                AdminPassword = dlg.passwd;
            }
            if (AdminPassword.Length > 0)
                lbAdminPassword.Text = "Password Set";
            else
                lbAdminPassword.Text = "No Password";

        }

        private void cbDumpToFile_CheckedChanged(object sender, EventArgs e)
        {
            if (cbDumpToFile.Checked)
            {
                //cbUsePcapFile.Enabled = false;
                //cbUsePcapFile.Checked = false;

                //tbPcapFile.Enabled = false;
                //btnPcapBrowse.Enabled = false;

                //cbNICs.Enabled = true;
                //cbPromiscuousMode.Enabled = true;

                tbDumpFileName.Enabled = true;
            }
            else
            {
                //cbUsePcapFile.Enabled = true;
                //cbUsePcapFile.Checked = false;

                //tbPcapFile.Enabled = false;
                //btnPcapBrowse.Enabled = false;

                //cbNICs.Enabled = true;
                //cbPromiscuousMode.Enabled = true;

                tbDumpFileName.Enabled = false;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            DBServerSetting db_set = new DBServerSetting();

            db_set.dbType = cbDBType.SelectedIndex;
            db_set.sDBServer = tbDBServer.Text.Trim();
            db_set.sDBName = tbDBName.Text.Trim();
            db_set.authType = cbDBAuthType.SelectedIndex;
            db_set.sUserName = tbDBUserName.Text.Trim();
            db_set.sPassword = tbDBPassword.Text.Trim();

            if (db_set.ConnectDB())
            {
                MessageBox.Show("Successfully connected to DB");
                db_set.DisconnectDB();
            }
            else
            {
                MessageBox.Show("Failed to connect");
            }
        }

        private void btnImportFolder_Click(object sender, EventArgs e)
        {
            ImportFolder dlg = new ImportFolder();
            DBServerSetting db_set = new DBServerSetting();

            db_set.dbType = cbDBType.SelectedIndex;
            db_set.sDBServer = tbDBServer.Text.Trim();
            db_set.sDBName = tbDBName.Text.Trim();
            db_set.authType = cbDBAuthType.SelectedIndex;
            db_set.sUserName = tbDBUserName.Text.Trim();
            db_set.sPassword = tbDBPassword.Text.Trim();

            if (db_set.ConnectDB())
            {
                dlg.db_set = db_set;

                if (dlg.ShowDialog() == DialogResult.OK)
                {
                }

                db_set.DisconnectDB();
            }
            else
            {
                MessageBox.Show("Can't connect to DB");
            }
        }

        private void cbBIB_CheckedChanged(object sender, EventArgs e)
        {
            if (cbBIB.Checked)
            {
                cbRTSrv.Checked = true;
                cbRTSrv.Enabled = false;
            }
            else
            {
                cbRTSrv.Checked = false;
                cbRTSrv.Enabled = true;
            }
        }

        private void cbAddWavDateTime_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cbAddWavDateTime.SelectedIndex > 0)
            {
                tbAddWavDateTimeFmt.Enabled = true;
            }
            else
            {
                tbAddWavDateTimeFmt.Enabled = false;
            }
        }

        private void btnScriptBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = "Python files (*.py)|*.py|Perl files (*.pl)|*.pl|Ruby files (*.rb)|*.rb|PHP files (*.php)|*.php|JavaCript files (*.js)|*.js|EXE files (*.exe)|*.exe|Batch files (*.bat)|*.bat|VSScript files (*.vbs)|*.vbs|Lua files (*.lua)|*.lua|Tool Command Language (*.tcl)|*.tcl|PowerShell (*.ps1)|*.ps1|All files (*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbRecordingScript.Text = openFileDialog1.FileName;
            }
        }
    }
}