import sys

def write_strings_to_file(filename, strings):
    #"""
    #Writes a list of strings to a file, each string on a new line.
    
    #Parameters:
    #filename (str): The name of the file to write to.
    #strings (list): A list of strings to write to the file.
    #"""
    try:
        with open(filename, 'w') as file:
            for string in strings:
                file.write(string + '\n')
        print(f"Successfully wrote to {filename}")
    except Exception as e:
        print(f"An error occurred: {e}")

def main():
    # Check if there are any command-line arguments
    if len(sys.argv) > 1:
        # Print each argument
        #for i, arg in enumerate(sys.argv):
        #    print(f"Argument {i}: {arg}")
        
        caller = sys.argv[1];
        called = sys.argv[2];
        connectTime = sys.argv[3];
        endTime = sys.argv[4];
        audioFile = sys.argv[5];
        xmlFile = sys.argv[6];
        
        write_strings_to_file("c:\\temp\\VR2\\python-shell-output.txt", sys.argv)
        
        print(caller + " " + called + " " + connectTime + " " + audioFile)
        
    else:
        print("No command-line arguments provided.")

if __name__ == "__main__":
    main()